/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configdataprovider;

import com.linkedin.feathr.core.configdataprovider.BaseConfigDataProvider;
import com.linkedin.feathr.core.configdataprovider.ConfigDataProviderException;
import com.linkedin.feathr.core.utils.Utils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourceConfigDataProvider
extends BaseConfigDataProvider {
    private static final Logger logger = LogManager.getLogger(ResourceConfigDataProvider.class);
    private final List<String> _resourceNames;
    private final ClassLoader _classLoader;

    public ResourceConfigDataProvider(String resourceName) {
        this(Collections.singletonList(resourceName), null);
    }

    public ResourceConfigDataProvider(String resourceName, ClassLoader classLoader) {
        this(Collections.singletonList(resourceName), classLoader);
    }

    public ResourceConfigDataProvider(List<String> resourceNames) {
        this(resourceNames, null);
    }

    public ResourceConfigDataProvider(List<String> resourceNames, ClassLoader classLoader) {
        Objects.requireNonNull(resourceNames, "List of resource names can't be null");
        for (String resName : resourceNames) {
            Objects.requireNonNull(resName, "Resource name can't be null");
        }
        this._resourceNames = resourceNames;
        this._classLoader = classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
    }

    @Override
    public List<Reader> getConfigDataReaders() {
        for (String resName : this._resourceNames) {
            InputStream in = this._classLoader.getResourceAsStream(resName);
            if (in == null) {
                throw new ConfigDataProviderException("Resource " + resName + " can't be obtained as an input stream");
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            logger.debug("Created Reader object for resource " + resName);
            this._readers.add(reader);
        }
        return this._readers;
    }

    @Override
    public String getConfigDataInfo() {
        return "Resources: " + Utils.string(this._resourceNames) + " Classloader: " + this._classLoader;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceConfigDataProvider that = (ResourceConfigDataProvider)o;
        return this._resourceNames.equals(that._resourceNames) && this._classLoader.equals(that._classLoader);
    }

    public int hashCode() {
        return Objects.hash(this._resourceNames, this._classLoader);
    }
}

