/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configvalidator;

import com.linkedin.feathr.core.config.ConfigType;
import com.linkedin.feathr.core.configdataprovider.ConfigDataProvider;
import com.linkedin.feathr.core.configvalidator.ClientType;
import com.linkedin.feathr.core.configvalidator.ValidationResult;
import com.linkedin.feathr.core.configvalidator.ValidationType;
import com.linkedin.feathr.core.configvalidator.typesafe.FeatureConsumerConfValidator;
import com.linkedin.feathr.core.configvalidator.typesafe.FeatureProducerConfValidator;
import com.linkedin.feathr.core.configvalidator.typesafe.TypesafeConfigValidator;
import java.util.Map;

public interface ConfigValidator {
    public ValidationResult validate(ConfigType var1, ValidationType var2, ConfigDataProvider var3);

    public Map<ConfigType, ValidationResult> validate(Map<ConfigType, ConfigDataProvider> var1, ValidationType var2);

    @Deprecated
    public static ConfigValidator getInstance() {
        return new TypesafeConfigValidator();
    }

    public static ConfigValidator getInstance(ClientType clientType) {
        switch (clientType) {
            case FEATURE_PRODUCER: {
                return new FeatureProducerConfValidator();
            }
            case FEATURE_CONSUMER: {
                return new FeatureConsumerConfValidator();
            }
        }
        throw new UnsupportedOperationException("Frame client type not support: " + clientType.toString());
    }
}

