/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configvalidator;

import com.linkedin.feathr.core.configvalidator.ClientType;
import com.linkedin.feathr.core.configvalidator.ConfigValidator;
import com.linkedin.feathr.core.configvalidator.typesafe.FeatureConsumerConfValidator;
import com.linkedin.feathr.core.configvalidator.typesafe.FeatureProducerConfValidator;

public class ConfigValidatorFactory {
    private static ConfigValidatorFactory _instance = new ConfigValidatorFactory();

    private ConfigValidatorFactory() {
    }

    public static ConfigValidatorFactory getFactoryInstance() {
        return _instance;
    }

    public ConfigValidator getValidatorInstance(ClientType clientType) {
        switch (clientType) {
            case FEATURE_PRODUCER: {
                return new FeatureProducerConfValidator();
            }
            case FEATURE_CONSUMER: {
                return new FeatureConsumerConfValidator();
            }
        }
        throw new UnsupportedOperationException("Frame client type not support: " + clientType.toString());
    }
}

