/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configvalidator.typesafe;

import com.google.common.collect.ImmutableSet;
import com.linkedin.feathr.core.config.producer.FeatureDefConfig;
import com.linkedin.feathr.core.config.producer.anchors.AnchorConfig;
import com.linkedin.feathr.core.config.producer.anchors.AnchorConfigWithExtractor;
import com.linkedin.feathr.core.config.producer.anchors.ExtractorBasedFeatureConfig;
import com.linkedin.feathr.core.config.producer.anchors.FeatureConfig;
import com.linkedin.feathr.core.config.producer.derivations.DerivationConfig;
import com.linkedin.feathr.core.config.producer.derivations.DerivationConfigWithExpr;
import com.linkedin.feathr.core.config.producer.derivations.DerivationConfigWithExtractor;
import com.linkedin.feathr.core.config.producer.derivations.DerivationsConfig;
import com.linkedin.feathr.core.config.producer.derivations.KeyedFeature;
import com.linkedin.feathr.core.config.producer.derivations.SequentialJoinConfig;
import com.linkedin.feathr.core.config.producer.derivations.SimpleDerivationConfig;
import com.linkedin.feathr.core.configvalidator.ValidationResult;
import com.linkedin.feathr.core.configvalidator.ValidationStatus;
import com.linkedin.feathr.core.configvalidator.ValidationType;
import com.linkedin.feathr.core.configvalidator.typesafe.FeatureReachType;
import com.linkedin.feathr.core.configvalidator.typesafe.HdfsSourceValidator;
import com.linkedin.feathr.core.configvalidator.typesafe.MvelValidator;
import com.linkedin.feathr.exception.ErrorLabel;
import com.linkedin.feathr.exception.FeathrConfigException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class FeatureDefConfigSemanticValidator {
    private static final String FEATURE_NAME_REGEX = "([a-zA-Z][.:\\w]*)";
    public static final Pattern FEATURE_NAME_PATTERN = Pattern.compile("([a-zA-Z][.:\\w]*)");
    private boolean _withFeatureReachableValidation;
    private boolean _withUndefinedSourceValidation;
    private static final Set<String> ALLOWED_EXTRACTOR_WITH_PARAMETERS = ImmutableSet.of((Object)"com.linkedin.feathr.SampleExtractorWithParams", (Object)"com.linkedin.followfeed.feathr.extractor.KeyTagFeatureExtractor");

    FeatureDefConfigSemanticValidator(boolean withFeatureReachableValidation, boolean withUndefinedSourceValidation) {
        this._withFeatureReachableValidation = withFeatureReachableValidation;
        this._withUndefinedSourceValidation = withUndefinedSourceValidation;
    }

    FeatureDefConfigSemanticValidator() {
        this._withFeatureReachableValidation = false;
        this._withUndefinedSourceValidation = false;
    }

    ValidationResult validate(FeatureDefConfig featureDefConfig) {
        this.validateApprovedExtractorWithParameters(featureDefConfig);
        StringJoiner warnMsgSj = new StringJoiner("\n");
        int warnMsgSjInitLength = warnMsgSj.length();
        try {
            HdfsSourceValidator hdfsSourceValidator;
            ValidationResult hdfsSourceValidationResult;
            MvelValidator mvelValidator;
            ValidationResult mvelValidationResult;
            Map<FeatureReachType, Set<String>> featureAccessInfo;
            Set unreachableFeatures;
            Map<String, String> undefinedAnchorSources;
            Set<String> duplicateFeatures = this.getDuplicateFeatureNames(featureDefConfig);
            if (!duplicateFeatures.isEmpty()) {
                String warnMsg = String.join((CharSequence)"\n", "The following features' definitions are duplicate: ", String.join((CharSequence)"\n", duplicateFeatures));
                warnMsgSj.add(warnMsg);
            }
            if (this._withUndefinedSourceValidation && !(undefinedAnchorSources = this.getUndefinedAnchorSources(featureDefConfig)).isEmpty()) {
                StringJoiner sj = new StringJoiner("\n");
                for (Map.Entry<String, String> entry : undefinedAnchorSources.entrySet()) {
                    sj.add(String.join((CharSequence)" ", "Source", entry.getValue(), "used in anchor", entry.getKey(), "is not defined."));
                }
                return new ValidationResult(ValidationType.SEMANTIC, ValidationStatus.INVALID, sj.toString());
            }
            if (this._withFeatureReachableValidation && !(unreachableFeatures = (featureAccessInfo = this.getFeatureAccessInfo(featureDefConfig)).getOrDefault((Object)FeatureReachType.UNREACHABLE, Collections.emptySet())).isEmpty()) {
                String warnMsg = String.join((CharSequence)"", "The following derived features cannot be computed as ", "one or more of their ancestor features cannot be found:\n", String.join((CharSequence)"\n", unreachableFeatures));
                warnMsgSj.add(warnMsg);
            }
            if ((mvelValidationResult = (mvelValidator = MvelValidator.getInstance()).validate(featureDefConfig)).getValidationStatus() == ValidationStatus.WARN) {
                warnMsgSj.add(mvelValidationResult.getDetails().orElse(""));
            }
            if ((hdfsSourceValidationResult = (hdfsSourceValidator = HdfsSourceValidator.getInstance()).validate(featureDefConfig)).getValidationStatus() == ValidationStatus.WARN) {
                warnMsgSj.add(hdfsSourceValidationResult.getDetails().orElse(""));
            } else if (hdfsSourceValidationResult.getValidationStatus() == ValidationStatus.INVALID) {
                return hdfsSourceValidationResult;
            }
        }
        catch (Throwable e) {
            return new ValidationResult(ValidationType.SEMANTIC, ValidationStatus.PROCESSING_ERROR, e.getMessage(), e);
        }
        return warnMsgSj.length() > warnMsgSjInitLength ? new ValidationResult(ValidationType.SEMANTIC, ValidationStatus.WARN, warnMsgSj.toString()) : new ValidationResult(ValidationType.SEMANTIC, ValidationStatus.VALID);
    }

    void validateApprovedExtractorWithParameters(FeatureDefConfig featureDefConfig) {
        for (Map.Entry<String, AnchorConfig> entry : featureDefConfig.getAnchorsConfig().get().getAnchors().entrySet()) {
            AnchorConfig anchorConfig = entry.getValue();
            for (Map.Entry<String, FeatureConfig> featureEntry : anchorConfig.getFeatures().entrySet()) {
                FeatureConfig featureConfig = featureEntry.getValue();
                if (!(featureConfig instanceof ExtractorBasedFeatureConfig) || featureConfig.getParameters().isEmpty()) continue;
                if (anchorConfig instanceof AnchorConfigWithExtractor) {
                    String extractor = ((AnchorConfigWithExtractor)anchorConfig).getExtractor();
                    if (ALLOWED_EXTRACTOR_WITH_PARAMETERS.contains(extractor)) continue;
                    throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, "anchorConfig: " + anchorConfig + " has parameters. Parameters are only approved to be used by the following extractors: " + ALLOWED_EXTRACTOR_WITH_PARAMETERS);
                }
                throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, "Parameters are only to be used by AnchorConfigWithExtractor. The anchor config is: " + anchorConfig);
            }
        }
    }

    Map<String, String> getUndefinedAnchorSources(FeatureDefConfig featureDefConfig) {
        HashMap<String, String> undefinedAnchorSource = new HashMap<String, String>();
        Set<String> definedSourceNames = this.getDefinedSourceNames(featureDefConfig);
        BiConsumer<String, AnchorConfig> consumeAnchor = (anchorName, anchorConfig) -> {
            String sourceName = anchorConfig.getSource();
            if (!(sourceName.contains("/") || sourceName.contains(".") || definedSourceNames.contains(sourceName))) {
                undefinedAnchorSource.put((String)anchorName, sourceName);
            }
        };
        featureDefConfig.getAnchorsConfig().ifPresent(anchorsConfig -> anchorsConfig.getAnchors().forEach(consumeAnchor));
        return undefinedAnchorSource;
    }

    private Set<String> getDefinedSourceNames(FeatureDefConfig featureDefConfig) {
        HashSet<String> definedSourceNames = new HashSet<String>();
        featureDefConfig.getSourcesConfig().ifPresent(sourcesConfig -> definedSourceNames.addAll(sourcesConfig.getSources().keySet()));
        return definedSourceNames;
    }

    Set<String> getDuplicateFeatureNames(FeatureDefConfig featureDefConfig) {
        HashSet definedFeatures = new HashSet();
        HashSet<String> duplicateFeatures = new HashSet<String>();
        BiConsumer<String, AnchorConfig> checkAnchor = (anchorName, anchorConfig) -> {
            Set<String> features = anchorConfig.getFeatures().keySet();
            for (String feature : features) {
                if (definedFeatures.contains(feature)) {
                    duplicateFeatures.add(feature);
                }
                definedFeatures.add(feature);
            }
        };
        featureDefConfig.getAnchorsConfig().ifPresent(anchorsConfig -> anchorsConfig.getAnchors().forEach(checkAnchor));
        BiConsumer<String, DerivationConfig> checkDerivation = (featureName, derivationConfig) -> {
            if (definedFeatures.contains(featureName)) {
                duplicateFeatures.add((String)featureName);
            }
            definedFeatures.add(featureName);
        };
        featureDefConfig.getDerivationsConfig().ifPresent(derivationsConfig -> derivationsConfig.getDerivations().forEach(checkDerivation));
        return duplicateFeatures;
    }

    static Set<String> getRequiredFeatureNames(FeatureDefConfig featureDefConfig, Set<String> requestedFeatureNames) {
        HashSet<String> requiredFeatureNames = new HashSet<String>();
        LinkedList<String> featuresToResolve = new LinkedList<String>(requestedFeatureNames);
        Map<String, Set<String>> dependencyGraph = FeatureDefConfigSemanticValidator.getDependencyGraph(featureDefConfig);
        while (!featuresToResolve.isEmpty()) {
            String feature = (String)featuresToResolve.poll();
            requiredFeatureNames.add(feature);
            dependencyGraph.getOrDefault(feature, Collections.emptySet()).forEach(featuresToResolve::offer);
        }
        return requiredFeatureNames;
    }

    private static Set<String> getAnchoredFeatureNames(FeatureDefConfig featureDefConfig) {
        HashSet<String> anchoredFeatures = new HashSet<String>();
        featureDefConfig.getAnchorsConfig().ifPresent(anchorsConfig -> {
            Set features = anchorsConfig.getAnchors().entrySet().stream().flatMap(x -> ((AnchorConfig)x.getValue()).getFeatures().keySet().stream()).collect(Collectors.toSet());
            anchoredFeatures.addAll(features);
        });
        return anchoredFeatures;
    }

    Map<FeatureReachType, Set<String>> getFeatureAccessInfo(FeatureDefConfig featureDefConfig) {
        Set<String> reachableFeatures = FeatureDefConfigSemanticValidator.getAnchoredFeatureNames(featureDefConfig);
        Map<String, DerivationConfig> derivations = featureDefConfig.getDerivationsConfig().orElse(new DerivationsConfig(Collections.emptyMap())).getDerivations();
        Set<String> allDerivedFeatures = derivations.keySet();
        HashSet<String> allDefinedFeatures = new HashSet<String>(reachableFeatures);
        allDefinedFeatures.addAll(allDerivedFeatures);
        HashSet<String> unreachableFeatures = new HashSet<String>();
        for (String derivedFeature : derivations.keySet()) {
            this.checkFeatureReachable(reachableFeatures, unreachableFeatures, derivations, allDefinedFeatures, derivedFeature);
        }
        HashMap<FeatureReachType, Set<String>> features = new HashMap<FeatureReachType, Set<String>>();
        features.put(FeatureReachType.REACHABLE, reachableFeatures);
        features.put(FeatureReachType.UNREACHABLE, unreachableFeatures);
        return features;
    }

    private boolean checkFeatureReachable(Set<String> reachableFeatures, Set<String> unreachableFeatures, Map<String, DerivationConfig> derivations, Set<String> allDefinedFeatures, String queryFeature) {
        boolean featureReachable = true;
        if (reachableFeatures.contains(queryFeature)) {
            return true;
        }
        if (unreachableFeatures.contains(queryFeature)) {
            return false;
        }
        if (!derivations.containsKey(queryFeature)) {
            featureReachable = false;
        } else {
            for (String baseFeature : FeatureDefConfigSemanticValidator.getInputFeatures(queryFeature, derivations.get(queryFeature), allDefinedFeatures)) {
                if (this.checkFeatureReachable(reachableFeatures, unreachableFeatures, derivations, allDefinedFeatures, baseFeature)) continue;
                featureReachable = false;
            }
        }
        if (featureReachable) {
            reachableFeatures.add(queryFeature);
        } else {
            unreachableFeatures.add(queryFeature);
        }
        return featureReachable;
    }

    private static Map<String, Set<String>> getDependencyGraph(FeatureDefConfig featureDefConfig) {
        HashMap<String, Set<String>> dependencyGraph = new HashMap<String, Set<String>>();
        Set<String> anchoredFeatures = FeatureDefConfigSemanticValidator.getAnchoredFeatureNames(featureDefConfig);
        anchoredFeatures.forEach(f -> dependencyGraph.put((String)f, Collections.emptySet()));
        Map<String, DerivationConfig> derivations = featureDefConfig.getDerivationsConfig().orElse(new DerivationsConfig(Collections.emptyMap())).getDerivations();
        Set<String> allDerivedFeatures = derivations.keySet();
        HashSet<String> allDefinedFeatures = new HashSet<String>(anchoredFeatures);
        allDefinedFeatures.addAll(allDerivedFeatures);
        derivations.forEach((k, v) -> dependencyGraph.put((String)k, FeatureDefConfigSemanticValidator.getInputFeatures(k, v, allDefinedFeatures)));
        return dependencyGraph;
    }

    private static Set<String> getInputFeatures(String derivedFeature, DerivationConfig derivationConfig, Set<String> allDefinedFeatureNames) {
        Set<String> inputs;
        if (derivationConfig instanceof DerivationConfigWithExpr) {
            DerivationConfigWithExpr derivationConfigWithExpr = (DerivationConfigWithExpr)derivationConfig;
            inputs = derivationConfigWithExpr.getInputs().values().stream().map(KeyedFeature::getFeature).collect(Collectors.toSet());
        } else if (derivationConfig instanceof DerivationConfigWithExtractor) {
            DerivationConfigWithExtractor derivationConfigWithExtractor = (DerivationConfigWithExtractor)derivationConfig;
            inputs = derivationConfigWithExtractor.getInputs().stream().map(KeyedFeature::getFeature).collect(Collectors.toSet());
        } else if (derivationConfig instanceof SimpleDerivationConfig) {
            SimpleDerivationConfig simpleDerivationConfig = (SimpleDerivationConfig)derivationConfig;
            String featureExpr = simpleDerivationConfig.getFeatureExpr();
            Matcher matcher = FEATURE_NAME_PATTERN.matcher(featureExpr);
            inputs = new HashSet<String>();
            while (matcher.find()) {
                String word = matcher.group(1);
                if (!allDefinedFeatureNames.contains(word)) continue;
                inputs.add(word);
            }
        } else if (derivationConfig instanceof SequentialJoinConfig) {
            SequentialJoinConfig sequentialJoinConfig = (SequentialJoinConfig)derivationConfig;
            inputs = Stream.of(sequentialJoinConfig.getBase().getFeature(), sequentialJoinConfig.getExpansion().getFeature()).collect(Collectors.toSet());
        } else {
            throw new RuntimeException("The DerivationConfig type of " + derivedFeature + " is not supported.");
        }
        return inputs;
    }
}

