/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configvalidator.typesafe;

import com.linkedin.feathr.core.config.consumer.FeatureBagConfig;
import com.linkedin.feathr.core.config.consumer.JoinConfig;
import com.linkedin.feathr.core.configvalidator.ValidationResult;
import com.linkedin.feathr.core.configvalidator.ValidationStatus;
import com.linkedin.feathr.core.configvalidator.ValidationType;
import com.linkedin.feathr.core.configvalidator.typesafe.FeatureReachType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;

class JoinConfSemanticValidator {
    JoinConfSemanticValidator() {
    }

    ValidationResult validate(JoinConfig joinConfig, Map<FeatureReachType, Set<String>> featureReachableInfo) {
        Set<String> requestedFeatureNames = JoinConfSemanticValidator.getRequestedFeatureNames(joinConfig);
        Set reachableFeatureNames = featureReachableInfo.getOrDefault((Object)FeatureReachType.REACHABLE, Collections.emptySet());
        Set unreachableFeatureNames = featureReachableInfo.getOrDefault((Object)FeatureReachType.UNREACHABLE, Collections.emptySet());
        HashSet<String> undefinedRequestedFeatures = new HashSet<String>();
        HashSet<String> unreachableRequestedFeatures = new HashSet<String>();
        requestedFeatureNames.stream().filter(f -> !reachableFeatureNames.contains(f)).forEach(f -> {
            if (unreachableFeatureNames.contains(f)) {
                unreachableRequestedFeatures.add((String)f);
            } else {
                undefinedRequestedFeatures.add((String)f);
            }
        });
        return this.constructRequestedFeaturesValidationResult(undefinedRequestedFeatures, unreachableRequestedFeatures);
    }

    private ValidationResult constructRequestedFeaturesValidationResult(Set<String> undefinedRequestedFeatures, Set<String> unreachableRequestedFeatures) {
        String tipMsg;
        if (undefinedRequestedFeatures.isEmpty() && unreachableRequestedFeatures.isEmpty()) {
            return ValidationResult.VALID_SEMANTICS;
        }
        StringJoiner errMsgJoiner = new StringJoiner("\n");
        if (!undefinedRequestedFeatures.isEmpty()) {
            tipMsg = String.join((CharSequence)"", "The following requested features are not defined.", " It could be possible that 1) typos in feature name, 2) feature definition is not included: ");
            errMsgJoiner.add(tipMsg);
            undefinedRequestedFeatures.forEach(errMsgJoiner::add);
        }
        if (!unreachableRequestedFeatures.isEmpty()) {
            tipMsg = String.join((CharSequence)"", "The following requested features are unreachable", " features defined in FeatureDef. This is usually due to incorrect feature definition: ");
            errMsgJoiner.add(tipMsg);
            unreachableRequestedFeatures.forEach(errMsgJoiner::add);
        }
        return new ValidationResult(ValidationType.SEMANTIC, ValidationStatus.INVALID, errMsgJoiner.toString());
    }

    static Set<String> getRequestedFeatureNames(JoinConfig joinConfig) {
        return joinConfig.getFeatureBagConfigs().entrySet().stream().flatMap(entry -> ((FeatureBagConfig)entry.getValue()).getKeyedFeatures().stream().flatMap(f -> f.getFeatures().stream())).collect(Collectors.toSet());
    }
}

