/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configvalidator.typesafe;

import com.google.common.annotations.VisibleForTesting;
import com.linkedin.feathr.core.config.producer.ExprType;
import com.linkedin.feathr.core.config.producer.FeatureDefConfig;
import com.linkedin.feathr.core.config.producer.anchors.AnchorConfig;
import com.linkedin.feathr.core.config.producer.anchors.AnchorConfigWithKey;
import com.linkedin.feathr.core.config.producer.anchors.ExpressionBasedFeatureConfig;
import com.linkedin.feathr.core.config.producer.anchors.ExtractorBasedFeatureConfig;
import com.linkedin.feathr.core.config.producer.anchors.FeatureConfig;
import com.linkedin.feathr.core.config.producer.anchors.TimeWindowFeatureConfig;
import com.linkedin.feathr.core.config.producer.derivations.DerivationConfig;
import com.linkedin.feathr.core.config.producer.derivations.DerivationConfigWithExpr;
import com.linkedin.feathr.core.config.producer.derivations.SimpleDerivationConfig;
import com.linkedin.feathr.core.configvalidator.ValidationResult;
import com.linkedin.feathr.core.configvalidator.ValidationStatus;
import com.linkedin.feathr.core.configvalidator.ValidationType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class MvelValidator {
    private static final MvelValidator MVEL_VALIDATOR = new MvelValidator();

    private MvelValidator() {
    }

    static MvelValidator getInstance() {
        return MVEL_VALIDATOR;
    }

    ValidationResult validate(FeatureDefConfig featureDefConfig) {
        Map<String, List<String>> invalidMvels = this.getPossibleInvalidMvelsUsingIn(featureDefConfig);
        if (!invalidMvels.isEmpty()) {
            Set invalidMvelInfoSet = invalidMvels.entrySet().stream().map(e -> String.join((CharSequence)": ", (CharSequence)e.getKey(), "[", String.join((CharSequence)", ", (Iterable)e.getValue()), "]")).collect(Collectors.toSet());
            String warnMsg = String.join((CharSequence)"", "For MVEL expression, if you are using `in` expression, ", "there should be parenthesis around it. Based on a heuristic check, the following anchors/features have invalid MVEL ", "definitions containing `in` keyword: \n", String.join((CharSequence)"\n", invalidMvelInfoSet));
            return new ValidationResult(ValidationType.SEMANTIC, ValidationStatus.WARN, warnMsg);
        }
        return new ValidationResult(ValidationType.SEMANTIC, ValidationStatus.VALID);
    }

    Map<String, List<String>> getPossibleInvalidMvelsUsingIn(FeatureDefConfig featureDefConfig) {
        Map<String, List> invalidFeatureMvels = this.getFeatureMvels(featureDefConfig).entrySet().stream().filter(e -> !this.heuristicProjectionExprCheck((String)e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, entry -> Collections.singletonList(entry.getValue())));
        Map<String, List> invalidAnchorKeyMvels = this.getAnchorKeyMvels(featureDefConfig).entrySet().stream().filter(e -> !((List)e.getValue()).stream().allMatch(this::heuristicProjectionExprCheck)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return Stream.concat(invalidFeatureMvels.entrySet().stream(), invalidAnchorKeyMvels.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @VisibleForTesting
    Map<String, String> getFeatureMvels(FeatureDefConfig featureDefConfig) {
        HashMap<String, String> featureNameToMvel = new HashMap<String, String>();
        BiConsumer<String, AnchorConfig> consumeAnchor = (anchorName, anchorConfig) -> {
            for (Map.Entry<String, FeatureConfig> entry : anchorConfig.getFeatures().entrySet()) {
                TimeWindowFeatureConfig timeWindowFeatureConfig;
                FeatureConfig featureConfig = entry.getValue();
                String featureName = entry.getKey();
                if (featureConfig instanceof ExtractorBasedFeatureConfig) {
                    featureNameToMvel.put(featureName, ((ExtractorBasedFeatureConfig)featureConfig).getFeatureName());
                    continue;
                }
                if (featureConfig instanceof ExpressionBasedFeatureConfig) {
                    ExpressionBasedFeatureConfig expressionBasedFeatureConfig = (ExpressionBasedFeatureConfig)featureConfig;
                    if (expressionBasedFeatureConfig.getExprType() != ExprType.MVEL) continue;
                    featureNameToMvel.put(featureName, expressionBasedFeatureConfig.getFeatureExpr());
                    continue;
                }
                if (!(featureConfig instanceof TimeWindowFeatureConfig) || (timeWindowFeatureConfig = (TimeWindowFeatureConfig)featureConfig).getColumnExprType() != ExprType.MVEL) continue;
                featureNameToMvel.put(featureName, timeWindowFeatureConfig.getColumnExpr());
            }
        };
        featureDefConfig.getAnchorsConfig().ifPresent(anchorsConfig -> anchorsConfig.getAnchors().forEach(consumeAnchor));
        BiConsumer<String, DerivationConfig> consumeDerivation = (featureName, derivationConfig) -> {
            DerivationConfigWithExpr derivationConfigWithExpr;
            if (derivationConfig instanceof SimpleDerivationConfig) {
                SimpleDerivationConfig simpleDerivationConfig = (SimpleDerivationConfig)derivationConfig;
                if (simpleDerivationConfig.getFeatureTypedExpr().getExprType() == ExprType.MVEL) {
                    featureNameToMvel.put((String)featureName, simpleDerivationConfig.getFeatureTypedExpr().getExpr());
                }
            } else if (derivationConfig instanceof DerivationConfigWithExpr && (derivationConfigWithExpr = (DerivationConfigWithExpr)derivationConfig).getTypedDefinition().getExprType() == ExprType.MVEL) {
                featureNameToMvel.put((String)featureName, derivationConfigWithExpr.getTypedDefinition().getExpr());
            }
        };
        featureDefConfig.getDerivationsConfig().ifPresent(derivationsConfig -> derivationsConfig.getDerivations().forEach(consumeDerivation));
        return featureNameToMvel;
    }

    Map<String, List<String>> getAnchorKeyMvels(FeatureDefConfig featureDefConfig) {
        HashMap<String, List<String>> anchorNameToMvel = new HashMap<String, List<String>>();
        BiConsumer<String, AnchorConfig> consumeAnchor = (anchorName, anchorConfig) -> {
            AnchorConfigWithKey anchorConfigWithKey;
            if (anchorConfig instanceof AnchorConfigWithKey && (anchorConfigWithKey = (AnchorConfigWithKey)anchorConfig).getTypedKey().getKeyExprType() == ExprType.MVEL) {
                anchorNameToMvel.put((String)anchorName, anchorConfigWithKey.getKey());
            }
        };
        featureDefConfig.getAnchorsConfig().ifPresent(anchorsConfig -> anchorsConfig.getAnchors().forEach(consumeAnchor));
        return anchorNameToMvel;
    }

    boolean heuristicProjectionExprCheck(String mvelExpr) {
        String inKeyword = " in ";
        ArrayList<Integer> reversedInPosList = new ArrayList<Integer>();
        int index = mvelExpr.lastIndexOf(inKeyword);
        while (index >= 0) {
            reversedInPosList.add(index);
            index = mvelExpr.lastIndexOf(inKeyword, index - 1);
        }
        if (reversedInPosList.isEmpty()) {
            return true;
        }
        LinkedList<Integer> sortedLeftParenthesis = new LinkedList<Integer>();
        Stack<Integer> stack = new Stack<Integer>();
        for (int pos = 0; pos < mvelExpr.length(); ++pos) {
            if (mvelExpr.charAt(pos) == '(') {
                stack.push(pos);
                continue;
            }
            if (mvelExpr.charAt(pos) != ')') continue;
            if (stack.isEmpty()) {
                return false;
            }
            int leftPos = (Integer)stack.pop();
            if (pos < (Integer)reversedInPosList.get(reversedInPosList.size() - 1) || leftPos > (Integer)reversedInPosList.get(0)) continue;
            sortedLeftParenthesis.add(leftPos);
        }
        return reversedInPosList.size() <= sortedLeftParenthesis.size();
    }
}

