/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.utils;

import com.linkedin.feathr.core.configbuilder.ConfigBuilderException;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.time.Duration;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ConfigUtils {
    public static final String TIMESTAMP_FORMAT_EPOCH = "epoch";
    public static final String TIMESTAMP_FORMAT_EPOCH_MILLIS = "epoch_millis";

    private ConfigUtils() {
    }

    public static String getStringWithDefault(Config config, String path, String defaultValue) {
        return config.hasPath(path) ? config.getString(path) : defaultValue;
    }

    public static int getIntWithDefault(Config config, String path, int defaultValue) {
        return config.hasPath(path) ? config.getInt(path) : defaultValue;
    }

    public static Number getNumberWithDefault(Config config, String path, Number defaultValue) {
        return config.hasPath(path) ? (Number)config.getNumber(path) : (Number)defaultValue;
    }

    public static Duration getDurationWithDefault(Config config, String path, Duration defaultValue) {
        return config.hasPath(path) ? config.getDuration(path) : defaultValue;
    }

    public static long getLongWithDefault(Config config, String path, long defaultValue) {
        return config.hasPath(path) ? config.getLong(path) : defaultValue;
    }

    public static boolean getBooleanWithDefault(Config config, String path, Boolean defaultValue) {
        return config.hasPath(path) ? config.getBoolean(path) : defaultValue.booleanValue();
    }

    public static Map<String, String> getStringMap(Config config) {
        return config.root().keySet().stream().collect(Collectors.toMap(k -> k, arg_0 -> ((Config)config).getString(arg_0)));
    }

    public static ChronoUnit getChronoUnit(String timeResolutionStr) {
        ChronoUnit timeResolution;
        switch (timeResolutionStr.toUpperCase()) {
            case "DAILY": {
                timeResolution = ChronoUnit.DAYS;
                break;
            }
            case "HOURLY": {
                timeResolution = ChronoUnit.HOURS;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported time resolution unit " + timeResolutionStr);
            }
        }
        return timeResolution;
    }

    public static void validateTimestampPatternWithEpoch(String fieldName, String fieldValue, String timestampPattern) {
        if (timestampPattern.equalsIgnoreCase(TIMESTAMP_FORMAT_EPOCH) || timestampPattern.equalsIgnoreCase(TIMESTAMP_FORMAT_EPOCH_MILLIS)) {
            return;
        }
        ConfigUtils.validateTimestampPattern(fieldName, fieldValue, timestampPattern);
    }

    public static void validateTimestampPattern(String fieldName, String fieldValue, String timestampPattern) {
        try {
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(timestampPattern);
            LocalDate.parse(fieldValue, dateTimeFormatter);
        }
        catch (Throwable e) {
            throw new ConfigBuilderException(String.format("Parsing settings configuration failed for timestamp_format=%s for field name %s.", timestampPattern, fieldName), e);
        }
    }

    public static List<String> getStringList(Config config, String path) {
        List<String> valueList;
        if (!config.hasPath(path)) {
            return null;
        }
        ConfigValueType valueType = config.getValue(path).valueType();
        switch (valueType) {
            case STRING: {
                valueList = Collections.singletonList(config.getString(path));
                break;
            }
            case LIST: {
                valueList = config.getStringList(path);
                break;
            }
            default: {
                throw new ConfigBuilderException("Expected value type String or List, got " + valueType);
            }
        }
        return valueList;
    }

    public static String getHoconString(Config config, String path) {
        ConfigRenderOptions renderOptions = ConfigRenderOptions.concise();
        if (!config.hasPath(path)) {
            return null;
        }
        ConfigValue configValue = config.getValue(path);
        return configValue.render(renderOptions);
    }
}

