/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class TaggedFeatureName
implements Serializable {
    private final String _featureName;
    private final List<String> _keyTag;
    private int _hash;

    @JsonCreator
    public TaggedFeatureName(@JsonProperty(value="key") List<String> keyTag, @JsonProperty(value="feature") String featureName) {
        this._keyTag = keyTag;
        this._featureName = featureName;
    }

    public TaggedFeatureName(String keyTag, String featureName) {
        this(Collections.singletonList(keyTag), featureName);
    }

    public List<String> getKeyTag() {
        return this._keyTag;
    }

    public String getFeatureName() {
        return this._featureName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaggedFeatureName that = (TaggedFeatureName)o;
        return Objects.equals(this._featureName, that._featureName) && Objects.equals(this._keyTag, that._keyTag);
    }

    public int hashCode() {
        int h = this._hash;
        if (h == 0) {
            h = Objects.hashCode(this._featureName);
            this._hash = h = 31 * h + Objects.hashCode(this._keyTag);
        }
        return h;
    }

    public String toString() {
        return "(" + this._keyTag.stream().collect(Collectors.joining(",")) + "):" + this._featureName;
    }
}

