/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common.configObj.configbuilder;

import com.linkedin.feathr.common.configObj.DateTimeConfig;
import com.linkedin.feathr.common.configObj.configbuilder.ConfigUtils;
import com.linkedin.feathr.common.configObj.configbuilder.DateTimeConfigBuilder;
import com.linkedin.feathr.common.configObj.configbuilder.OutputProcessorBuilder;
import com.linkedin.feathr.common.configObj.generation.OfflineOperationalConfig;
import com.linkedin.feathr.common.configObj.generation.OperationalConfig;
import com.linkedin.feathr.common.configObj.generation.OutputProcessorConfig;
import com.typesafe.config.Config;
import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class OperationalConfigBuilder {
    private static final Logger logger = Logger.getLogger(OperationalConfigBuilder.class);
    private static final String NAME = "name";
    private static final String RETENTION = "retention";
    private static final String OUTPUT = "output";
    private static final String SIMULATE_TIME_DELAY = "timeDelay";
    private static final String ENABLE_INCREMENTAL = "enableIncremental";
    private static final String ENV = "env";

    private OperationalConfigBuilder() {
    }

    public static OperationalConfig build(Config config) {
        String name = config.getString(NAME);
        List outputConfigs = config.getConfigList(OUTPUT);
        List<OutputProcessorConfig> outputProcessorConfigs = outputConfigs.stream().map(cfg -> OutputProcessorBuilder.build(cfg)).collect(Collectors.toList());
        OfflineOperationalConfig operationalConfig = null;
        DateTimeConfig dateTimeConfig = DateTimeConfigBuilder.build(config);
        Duration timeResolution = dateTimeConfig.getTimeResolution().getDuration();
        Duration retention = ConfigUtils.getDurationWithDefault(config, RETENTION, timeResolution);
        Duration simulateTimeDelay = ConfigUtils.getDurationWithDefault(config, SIMULATE_TIME_DELAY, Duration.ofSeconds(0L));
        Boolean enableIncremental = ConfigUtils.getBooleanWithDefault(config, ENABLE_INCREMENTAL, false);
        operationalConfig = new OfflineOperationalConfig(outputProcessorConfigs, name, dateTimeConfig, retention, simulateTimeDelay, enableIncremental);
        logger.trace((Object)"Built OperationalConfig object for offline feature");
        return operationalConfig;
    }
}

