/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common.featurizeddataset;

import com.linkedin.feathr.common.featurizeddataset.BaseDenseTensorIterator;
import com.linkedin.feathr.common.tensor.DenseTensor;
import java.util.AbstractList;

public class DenseTensorList
extends AbstractList<Object> {
    private final DenseTensor _denseTensor;
    private final BaseDenseTensorIterator _iterator;

    public DenseTensorList(DenseTensor denseTensor) {
        this._denseTensor = denseTensor;
        this._iterator = (BaseDenseTensorIterator)this._denseTensor.iterator();
        this._iterator.start();
    }

    @Override
    public synchronized Object get(int index) {
        if (index < this._iterator.getFlatIndex()) {
            this._iterator.start();
        }
        while (index > this._iterator.getFlatIndex()) {
            if (!this._iterator.isValid()) {
                throw new IndexOutOfBoundsException(index + " is out of bounds, cardinality is " + this._denseTensor.cardinality());
            }
            this._iterator.next();
        }
        return this._iterator.getValue(this._denseTensor.getArity() - 1);
    }

    @Override
    public int size() {
        return this._denseTensor.cardinality();
    }
}

