/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common.tensor.dense;

import com.linkedin.feathr.common.tensor.Primitive;
import com.linkedin.feathr.common.tensor.Representable;
import com.linkedin.feathr.common.tensor.TensorIterator;
import com.linkedin.feathr.common.tensor.dense.ByteBufferDenseTensor;
import com.linkedin.feathr.common.tensorbuilder.BufferUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class DenseStringTensor
extends ByteBufferDenseTensor {
    private final int _endOfOffsets;

    public DenseStringTensor(ByteBuffer byteBuffer, long[] shape) {
        super(byteBuffer, shape, Primitive.STRING, 8);
        this._endOfOffsets = this._cardinality * 8;
    }

    public DenseStringTensor(ByteBuffer byteBuffer, long[] shape, Representable[] types, int cardinality) {
        super(byteBuffer, shape, types, cardinality, 8);
        this._endOfOffsets = this._cardinality * 8;
    }

    @Override
    public TensorIterator iterator() {
        return new MyIterator();
    }

    @Override
    public List<?> asList() {
        ByteBuffer view = this._byteBuffer.asReadOnlyBuffer();
        ArrayList<ByteBuffer> list = new ArrayList<ByteBuffer>(this._cardinality);
        for (int i = 0; i < this._cardinality; ++i) {
            int offset = (int)view.getLong(i * 8);
            view.position(offset);
            int length = BufferUtils.decodeVarint(view);
            view.limit(view.position() + length);
            ByteBuffer slice = view.slice();
            view.limit(this._byteBuffer.limit());
            list.add(slice);
        }
        return list;
    }

    private class MyIterator
    extends ByteBufferDenseTensor.ByteBufferDenseTensorIterator {
        MyIterator() {
        }

        MyIterator(ByteBufferDenseTensor.ByteBufferDenseTensorIterator other) {
            super(other);
        }

        @Override
        public boolean isValid() {
            return this._position < DenseStringTensor.this._endOfOffsets;
        }

        @Override
        public Object getValue() {
            return this.getString(this._indices.length);
        }

        @Override
        public String getString(int index) {
            ByteBuffer view = DenseStringTensor.this._byteBuffer.asReadOnlyBuffer();
            int offset = (int)DenseStringTensor.this._byteBuffer.getLong(this._position);
            view.position(offset);
            int length = BufferUtils.decodeVarint(view);
            view.limit(view.position() + length);
            return BufferUtils.decodeString(view);
        }

        @Override
        public TensorIterator getCopy() {
            return new MyIterator((ByteBufferDenseTensor.ByteBufferDenseTensorIterator)this);
        }
    }
}

