/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common.util;

import com.linkedin.feathr.common.FeatureTypes;
import com.linkedin.feathr.common.FeatureValue;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class CoercionUtils {
    private static final float TOLERANCE = 1.0E-5f;

    private CoercionUtils() {
    }

    public static Map<String, Float> coerceToVector(Object item, FeatureTypes featureType) {
        switch (featureType) {
            case BOOLEAN: {
                if (!(item instanceof Boolean)) break;
                return (Boolean)item != false ? Collections.singletonMap("", Float.valueOf(1.0f)) : Collections.emptyMap();
            }
            case NUMERIC: {
                return Collections.singletonMap("", Float.valueOf(CoercionUtils.safeToFloat(item)));
            }
            case DENSE_VECTOR: {
                if (!(item instanceof List)) break;
                return CoercionUtils.toDenseVector((List)item);
            }
            case CATEGORICAL: {
                return Collections.singletonMap(CoercionUtils.safeToString(item), Float.valueOf(1.0f));
            }
            case CATEGORICAL_SET: {
                if (item instanceof Collection) {
                    return ((Collection)item).stream().distinct().collect(Collectors.toMap(CoercionUtils::safeToString, x -> Float.valueOf(1.0f)));
                }
                return Collections.singletonMap(CoercionUtils.safeToString(item), Float.valueOf(1.0f));
            }
            case TERM_VECTOR: {
                if (item instanceof Map) {
                    return CoercionUtils.toTermVector((Map)item);
                }
                if (!(item instanceof Collection)) break;
                Collection list = (Collection)item;
                if (list.isEmpty()) {
                    return Collections.emptyMap();
                }
                Object head = list.iterator().next();
                if (!(head instanceof Map)) break;
                try {
                    return list.stream().flatMap(x -> ((Map)x).entrySet().stream()).distinct().collect(Collectors.toMap(e -> CoercionUtils.safeToString(e.getKey()), e -> Float.valueOf(CoercionUtils.safeToFloat(e.getValue()))));
                }
                catch (Exception ex) {
                    throw new RuntimeException("Input item " + item + " cannot be converted to feature type " + (Object)((Object)featureType) + " due to error: " + ex.getMessage());
                }
            }
            default: {
                return CoercionUtils.coerceToVector(item);
            }
        }
        throw new RuntimeException("Input item " + item + " cannot be converted to feature type " + (Object)((Object)featureType));
    }

    public static Map<String, Float> coerceToVector(Object item) {
        Collection collection;
        CoercionUtils.checkNotNull(item);
        if (item instanceof FeatureValue) {
            return ((FeatureValue)item).getAsTermVector();
        }
        if (item instanceof Collection && (collection = (Collection)item).isEmpty()) {
            return Collections.emptyMap();
        }
        FeatureTypes coercedFeatureType = CoercionUtils.getCoercedFeatureType(item);
        if (coercedFeatureType != FeatureTypes.UNSPECIFIED) {
            return CoercionUtils.coerceToVector(item, coercedFeatureType);
        }
        throw new RuntimeException("Input item " + item + " cannot be converted to feature value.");
    }

    public static FeatureTypes getCoercedFeatureType(Object item) {
        FeatureTypes coercedFeatureType = FeatureTypes.UNSPECIFIED;
        if (item instanceof Number) {
            coercedFeatureType = FeatureTypes.NUMERIC;
        } else if (item instanceof Boolean) {
            coercedFeatureType = FeatureTypes.BOOLEAN;
        } else if (item instanceof CharSequence || item instanceof Character) {
            coercedFeatureType = FeatureTypes.CATEGORICAL;
        } else if (item instanceof Collection) {
            Collection collection = (Collection)item;
            if (!collection.isEmpty()) {
                Object head = collection.iterator().next();
                coercedFeatureType = head instanceof Number ? FeatureTypes.DENSE_VECTOR : (head instanceof CharSequence || head instanceof Character ? FeatureTypes.CATEGORICAL_SET : FeatureTypes.TERM_VECTOR);
            }
        } else if (item instanceof Map) {
            coercedFeatureType = FeatureTypes.TERM_VECTOR;
        }
        return coercedFeatureType;
    }

    public static boolean isNumeric(FeatureValue featureValue) {
        Map<String, Float> featureVector = featureValue.getAsTermVector();
        return featureVector.size() == 1 && featureVector.containsKey("");
    }

    public static boolean isBoolean(FeatureValue featureValue) {
        Map<String, Float> featureVector = featureValue.getAsTermVector();
        return featureVector.isEmpty() || featureVector.size() == 1 && CoercionUtils.equalsWithEpsilon(featureVector.get(""), Float.valueOf(1.0f), Float.valueOf(1.0E-5f));
    }

    public static boolean isCategorical(FeatureValue featureValue) {
        Map<String, Float> featureVector = featureValue.getAsTermVector();
        return featureVector.size() == 1 && CoercionUtils.equalsWithEpsilon(featureVector.entrySet().iterator().next().getValue(), Float.valueOf(1.0f), Float.valueOf(1.0E-5f)) && !featureVector.entrySet().iterator().next().getKey().equals("");
    }

    public static String safeToString(Object item) {
        CoercionUtils.checkNotNull(item);
        if (item instanceof CharSequence || item instanceof Character) {
            return item.toString();
        }
        if (item instanceof Number) {
            double numDouble = ((Number)item).doubleValue();
            if (numDouble - (double)Math.round(numDouble) <= (double)1.0E-5f) {
                return String.valueOf(((Number)item).longValue());
            }
            throw new RuntimeException(String.format("Input: %f was not within %f of an integral value", numDouble, Float.valueOf(1.0E-5f)));
        }
        throw new RuntimeException("Couldn't safely coerce to String, only {String, Character and Number} are allowed but got unexpected type " + item.getClass().getName() + " (value = " + item + ")");
    }

    public static float safeToFloat(Object item) {
        CoercionUtils.checkNotNull(item);
        if (item instanceof Number) {
            return ((Number)item).floatValue();
        }
        throw new RuntimeException("Couldn't safely coerce to Float, expecting input to be a Number but got " + item.getClass() + " instead. (Input = " + item + ")");
    }

    private static <T> void checkNotNull(T item) {
        if (null == item) {
            throw new RuntimeException("Unexpected null");
        }
    }

    private static Map<String, Float> toTermVector(Map<?, ?> inputMap) {
        return inputMap.entrySet().stream().collect(Collectors.toMap(e -> CoercionUtils.safeToString(e.getKey()), e -> Float.valueOf(CoercionUtils.safeToFloat(e.getValue()))));
    }

    private static Map<String, Float> toDenseVector(List<?> list) {
        if (list.isEmpty()) {
            return Collections.emptyMap();
        }
        return IntStream.range(0, list.size()).boxed().collect(Collectors.toMap(CoercionUtils::safeToString, i -> Float.valueOf(CoercionUtils.safeToFloat(list.get((int)i)))));
    }

    private static boolean equalsWithEpsilon(Float f1, Float f2, Float epsilon) {
        return Math.abs(f1.floatValue() - f2.floatValue()) <= epsilon.floatValue();
    }
}

