/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common.value;

import com.linkedin.feathr.common.CoercingTensorData;
import com.linkedin.feathr.common.tensor.Primitive;
import com.linkedin.feathr.common.tensor.TensorData;
import com.linkedin.feathr.common.tensor.TensorIterator;
import com.linkedin.feathr.common.types.BooleanFeatureType;
import com.linkedin.feathr.common.types.CategoricalFeatureType;
import com.linkedin.feathr.common.types.CategoricalSetFeatureType;
import com.linkedin.feathr.common.types.DenseVectorFeatureType;
import com.linkedin.feathr.common.types.NumericFeatureType;
import com.linkedin.feathr.common.types.TensorFeatureType;
import com.linkedin.feathr.common.types.TermVectorFeatureType;
import com.linkedin.feathr.common.value.AbstractFeatureFormatMapper;
import com.linkedin.feathr.common.value.BooleanFeatureValue;
import com.linkedin.feathr.common.value.CategoricalFeatureValue;
import com.linkedin.feathr.common.value.CategoricalSetFeatureValue;
import com.linkedin.feathr.common.value.DenseVectorFeatureValue;
import com.linkedin.feathr.common.value.NumericFeatureValue;
import com.linkedin.feathr.common.value.TensorFeatureValue;
import com.linkedin.feathr.common.value.TermVectorFeatureValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class NTVFeatureFormatMapper
extends AbstractFeatureFormatMapper<Map<String, Float>> {
    private static final String EMPTY_TERM = "";
    private static final float UNIT = 1.0f;
    public static final NTVFeatureFormatMapper INSTANCE = new NTVFeatureFormatMapper();
    private static final Map<String, Float> NTV_BOOLEAN_FALSE = Collections.emptyMap();
    private static final Map<String, Float> NTV_BOOLEAN_TRUE = Collections.singletonMap("", Float.valueOf(1.0f));
    private static final Map<String, Float> NTV_EMPTY = Collections.emptyMap();

    private NTVFeatureFormatMapper() {
    }

    @Override
    protected Map<String, Float> fromNumericFeatureValue(NumericFeatureValue featureValue) {
        return Collections.singletonMap(EMPTY_TERM, Float.valueOf(featureValue.getFloatValue()));
    }

    @Override
    protected Map<String, Float> fromBooleanFeatureValue(BooleanFeatureValue featureValue) {
        return featureValue.getBooleanValue() ? NTV_BOOLEAN_TRUE : NTV_BOOLEAN_FALSE;
    }

    @Override
    protected Map<String, Float> fromCategoricalFeatureValue(CategoricalFeatureValue featureValue) {
        return Collections.singletonMap(featureValue.getStringValue(), Float.valueOf(1.0f));
    }

    @Override
    protected Map<String, Float> fromCategoricalSetFeatureValue(CategoricalSetFeatureValue featureValue) {
        return Collections.unmodifiableMap(featureValue.getStringSet().stream().collect(Collectors.toMap(Function.identity(), x -> Float.valueOf(1.0f))));
    }

    @Override
    protected Map<String, Float> fromTermVectorFeatureValue(TermVectorFeatureValue featureValue) {
        return featureValue.getTermVector();
    }

    @Override
    protected Map<String, Float> fromDenseVectorFeatureValue(DenseVectorFeatureValue featureValue) {
        float[] floatArray = featureValue.getFloatArray();
        return Collections.unmodifiableMap(IntStream.range(0, floatArray.length).boxed().collect(Collectors.toMap(String::valueOf, i -> Float.valueOf(floatArray[i]))));
    }

    @Override
    protected Map<String, Float> fromTensorFeatureValue(TensorFeatureValue featureValue) {
        TensorData tensorData = featureValue.getAsTensor();
        if (tensorData == null) {
            return NTV_EMPTY;
        }
        switch (NTVFeatureFormatMapper.tensorRank(tensorData)) {
            case 0: {
                Primitive scalarRepresentation = tensorData.getTypes()[0].getRepresentation();
                switch (scalarRepresentation) {
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        float floatValue = scalarRepresentation.toFloat(tensorData.iterator(), 0);
                        return Collections.singletonMap(EMPTY_TERM, Float.valueOf(floatValue));
                    }
                    case BOOLEAN: {
                        boolean booleanValue = tensorData.iterator().getBoolean(0);
                        return booleanValue ? NTV_BOOLEAN_TRUE : NTV_BOOLEAN_FALSE;
                    }
                    case STRING: {
                        String stringValue = tensorData.iterator().getString(0);
                        return Collections.singletonMap(stringValue, Float.valueOf(1.0f));
                    }
                }
                throw new IllegalArgumentException("Unhandled scalar type " + scalarRepresentation + " in " + tensorData);
            }
            case 1: {
                CoercingTensorData coercingTensor = new CoercingTensorData(tensorData);
                HashMap<String, Float> termVector = new HashMap<String, Float>(tensorData.cardinality());
                TensorIterator iterator = coercingTensor.iterator();
                while (iterator.isValid()) {
                    termVector.put(iterator.getString(0), Float.valueOf(iterator.getFloat(1)));
                    iterator.next();
                }
                return Collections.unmodifiableMap(termVector);
            }
        }
        throw new IllegalArgumentException("Cannot convert a tensor of rank > 1 to NTV for feature value " + featureValue);
    }

    @Override
    protected NumericFeatureValue toNumericFeatureValue(NumericFeatureType featureType, Map<String, Float> ntv) {
        Float floatValue;
        if (ntv.size() == 1 && (floatValue = ntv.get(EMPTY_TERM)) != null) {
            return NumericFeatureValue.fromFloat(floatValue.floatValue());
        }
        throw this.cannotConvertToFeatureValue(featureType, ntv);
    }

    @Override
    protected BooleanFeatureValue toBooleanFeatureValue(BooleanFeatureType featureType, Map<String, Float> ntv) {
        if (ntv.isEmpty()) {
            return BooleanFeatureValue.FALSE;
        }
        if (ntv.equals(NTV_BOOLEAN_TRUE)) {
            return BooleanFeatureValue.TRUE;
        }
        throw this.cannotConvertToFeatureValue(featureType, ntv);
    }

    @Override
    protected CategoricalFeatureValue toCategoricalFeatureValue(CategoricalFeatureType featureType, Map<String, Float> ntv) {
        Map.Entry<String, Float> onlyEntry;
        Iterator<Map.Entry<String, Float>> iterator = ntv.entrySet().iterator();
        if (iterator.hasNext() && (onlyEntry = iterator.next()).getValue().floatValue() == 1.0f && !iterator.hasNext()) {
            String stringValue = onlyEntry.getKey();
            return CategoricalFeatureValue.fromString(stringValue);
        }
        throw this.cannotConvertToFeatureValue(featureType, ntv);
    }

    @Override
    protected CategoricalSetFeatureValue toCategoricalSetFeatureValue(CategoricalSetFeatureType featureType, Map<String, Float> ntv) {
        if (ntv.values().stream().allMatch(x -> x.floatValue() == 1.0f)) {
            return CategoricalSetFeatureValue.fromStrings(ntv.keySet());
        }
        throw this.cannotConvertToFeatureValue(featureType, ntv);
    }

    @Override
    protected TermVectorFeatureValue toTermVectorFeatureValue(TermVectorFeatureType featureType, Map<String, Float> ntv) {
        return TermVectorFeatureValue.fromMap(ntv);
    }

    @Override
    protected DenseVectorFeatureValue toDenseVectorFeatureValue(DenseVectorFeatureType featureType, Map<String, Float> ntv) {
        RuntimeException exception = null;
        int n = ntv.size();
        if (n == 0) {
            return DenseVectorFeatureValue.fromFloatArray(new float[0]);
        }
        int[] indices = new int[n];
        float[] values = new float[n];
        int i = 0;
        try {
            for (Map.Entry<String, Float> entry : ntv.entrySet()) {
                indices[i] = Integer.parseInt(entry.getKey());
                values[i] = entry.getValue().floatValue();
                ++i;
            }
            int denseSize = Arrays.stream(indices).max().getAsInt() + 1;
            float[] denseArray = new float[denseSize];
            for (i = 0; i < n; ++i) {
                denseArray[indices[i]] = values[i];
            }
            return DenseVectorFeatureValue.fromFloatArray(denseArray);
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            exception = e;
            throw this.cannotConvertToFeatureValue(featureType, ntv, exception);
        }
    }

    @Override
    protected TensorFeatureValue toTensorFeatureValue(TensorFeatureType featureType, Map<String, Float> ntv) {
        throw this.cannotConvertToFeatureValue(featureType, ntv, new UnsupportedOperationException());
    }

    private static int tensorRank(TensorData tensorData) {
        return tensorData.getArity() - 1;
    }
}

