/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.anchored.anchorExtractor;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrConfigException;
import com.linkedin.feathr.offline.anchored.anchorExtractor.SQLKeys;
import com.linkedin.feathr.offline.config.SQLFeatureDefinition;
import com.linkedin.feathr.offline.transformation.FeatureColumnFormat$;
import com.linkedin.feathr.sparkcommon.SimpleAnchorExtractorSpark;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ud!\u0002\b\u0010\u0001MY\u0002\u0002\u0003\u0012\u0001\u0005\u000b\u0007I\u0011\u0001\u0013\t\u0011%\u0002!\u0011!Q\u0001\n\u0015B\u0001B\u000b\u0001\u0003\u0006\u0004%\ta\u000b\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005Y!)1\t\u0001C\u0001\t\"Aq\u000b\u0001EC\u0002\u0013%\u0001\fC\u0004i\u0001\t\u0007I\u0011B\u0016\t\r%\u0004\u0001\u0015!\u0003-\u0011\u001dQ\u0007A1A\u0005\n-Daa\u001d\u0001!\u0002\u0013a\u0007\"\u0002;\u0001\t\u0003)\bBB@\u0001\t\u0003\n\t\u0001C\u0004\u0002<\u0001!\t!!\u0010\u0003=M\u000bFjQ8oM&<WO]1cY\u0016\fen\u00195pe\u0016CHO]1di>\u0014(B\u0001\t\u0012\u0003=\tgn\u00195pe\u0016CHO]1di>\u0014(B\u0001\n\u0014\u0003!\tgn\u00195pe\u0016$'B\u0001\u000b\u0016\u0003\u001dygM\u001a7j]\u0016T!AF\f\u0002\r\u0019,\u0017\r\u001e5s\u0015\tA\u0012$\u0001\u0005mS:\\W\rZ5o\u0015\u0005Q\u0012aA2p[N\u0011\u0001\u0001\b\t\u0003;\u0001j\u0011A\b\u0006\u0003?U\t1b\u001d9be.\u001cw.\\7p]&\u0011\u0011E\b\u0002\u001b'&l\u0007\u000f\\3B]\u000eDwN]#yiJ\f7\r^8s'B\f'o[\u0001\u0004W\u0016L8\u0001A\u000b\u0002KA\u0011aeJ\u0007\u0002\u001f%\u0011\u0001f\u0004\u0002\b'Fc5*Z=t\u0003\u0011YW-\u001f\u0011\u0002\u0011\u0019,\u0017\r^;sKN,\u0012\u0001\f\t\u0005[YJDH\u0004\u0002/iA\u0011qFM\u0007\u0002a)\u0011\u0011gI\u0001\u0007yI|w\u000e\u001e \u000b\u0003M\nQa]2bY\u0006L!!\u000e\u001a\u0002\rA\u0013X\rZ3g\u0013\t9\u0004HA\u0002NCBT!!\u000e\u001a\u0011\u00055R\u0014BA\u001e9\u0005\u0019\u0019FO]5oOB\u0011Q\bQ\u0007\u0002})\u0011qhE\u0001\u0007G>tg-[4\n\u0005\u0005s$\u0001F*R\u0019\u001a+\u0017\r^;sK\u0012+g-\u001b8ji&|g.A\u0005gK\u0006$XO]3tA\u00051A(\u001b8jiz\"2!\u0012$U!\t1\u0003\u0001C\u0003#\u000b\u0001\u0007Q\u0005\u000b\u0003G\u0011J\u001b\u0006CA%Q\u001b\u0005Q%BA&M\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u001b:\u000bqA[1dWN|gN\u0003\u0002P3\u0005Ia-Y:uKJDX\u000e\\\u0005\u0003#*\u0013ABS:p]B\u0013x\u000e]3sif\fQA^1mk\u0016\f\u0013A\t\u0005\u0006U\u0015\u0001\r\u0001\f\u0015\u0005)\"\u0013f+I\u0001+\u0003\rawnZ\u000b\u00023B\u0011!,Y\u0007\u00027*\u0011A,X\u0001\u0006Y><GG\u001b\u0006\u0003=~\u000ba!\u00199bG\",'\"\u00011\u0002\u0007=\u0014x-\u0003\u0002c7\n1Aj\\4hKJD#A\u00023\u0011\u0005\u00154W\"\u0001\u001a\n\u0005\u001d\u0014$!\u0003;sC:\u001c\u0018.\u001a8u\u000351W-\u0019;ve\u0016$v\u000eR3gg\u0006qa-Z1ukJ,Gk\u001c#fMN\u0004\u0013aF2pYVlgNT1nKR{g)Z1ukJ,G)\u001a4t+\u0005a\u0007\u0003B7ssej\u0011A\u001c\u0006\u0003_B\f\u0011\"[7nkR\f'\r\\3\u000b\u0005E\u0014\u0014AC2pY2,7\r^5p]&\u0011qG\\\u0001\u0019G>dW/\u001c8OC6,Gk\u001c$fCR,(/\u001a#fMN\u0004\u0013aF4fiB\u0013xN^5eK\u00124U-\u0019;ve\u0016t\u0015-\\3t+\u00051\bcA<}s9\u0011\u0001P\u001f\b\u0003_eL\u0011aM\u0005\u0003wJ\nq\u0001]1dW\u0006<W-\u0003\u0002~}\n\u00191+Z9\u000b\u0005m\u0014\u0014A\u0005;sC:\u001chm\u001c:n\u0003N\u001cu\u000e\\;n]N$B!a\u0001\u0002\u001cA!q\u000f`A\u0003!\u0019)\u0017qA\u001d\u0002\f%\u0019\u0011\u0011\u0002\u001a\u0003\rQ+\b\u000f\\33!\u0011\ti!a\u0006\u000e\u0005\u0005=!\u0002BA\t\u0003'\t1a]9m\u0015\r\t)\"X\u0001\u0006gB\f'o[\u0005\u0005\u00033\tyA\u0001\u0004D_2,XN\u001c\u0005\b\u0003;a\u0001\u0019AA\u0010\u0003\u001dIg\u000e];u\t\u001a\u0003B!!\t\u000269!\u00111EA\u001a\u001d\u0011\t)#!\r\u000f\t\u0005\u001d\u0012q\u0006\b\u0005\u0003S\tiCD\u00020\u0003WI\u0011\u0001Y\u0005\u0003=~K1!!\u0006^\u0013\u0011\t\t\"a\u0005\n\u0007m\fy!\u0003\u0003\u00028\u0005e\"!\u0003#bi\u00064%/Y7f\u0015\rY\u0018qB\u0001\u0012O\u0016$H+\u001a8t_J4U-\u0019;ve\u0016\u001cHCBA \u0003O\nY\u0007\u0005\u0004.m\u0005\u0015\u0011\u0011\t\t\u0005\u0003\u0007\n\tG\u0004\u0003\u0002F\u0005mc\u0002BA$\u0003/rA!!\u0013\u0002V9!\u00111JA*\u001d\u0011\ti%!\u0015\u000f\u0007=\ny%C\u0001\u001b\u0013\tA\u0012$\u0003\u0002\u0017/%\u0011A#F\u0005\u0004\u00033\u001a\u0012A\u0004;sC:\u001chm\u001c:nCRLwN\\\u0005\u0005\u0003;\ny&A\nGK\u0006$XO]3D_2,XN\u001c$pe6\fGOC\u0002\u0002ZMIA!a\u0019\u0002f\t\u0019b)Z1ukJ,7i\u001c7v[:4uN]7bi*!\u0011QLA0\u0011\u001d\tI'\u0004a\u0001\u0003?\tq\u0003Z1uC\u001a\u0013\u0018-\\3XSRD7*Z=D_2,XN\\:\t\u000f\u00055T\u00021\u0001\u0002p\u0005\u0011R\r\u001f9fGR,GmQ8m'\u000eDW-\\1t!\u0015ic'OA9!\u0011\t\u0019(!\u001f\u000e\u0005\u0005U$\u0002BA<\u0003\u001f\tQ\u0001^=qKNLA!a\u001f\u0002v\tAA)\u0019;b)f\u0004X\r")
public class SQLConfigurableAnchorExtractor
extends SimpleAnchorExtractorSpark {
    private transient Logger log;
    private final SQLKeys key;
    private final Map<String, SQLFeatureDefinition> features;
    private final Map<String, SQLFeatureDefinition> featureToDefs;
    private final Map<String, String> columnNameToFeatureDefs;
    private volatile transient boolean bitmap$trans$0;

    public SQLKeys key() {
        return this.key;
    }

    public Map<String, SQLFeatureDefinition> features() {
        return this.features;
    }

    private Logger log$lzycompute() {
        SQLConfigurableAnchorExtractor sQLConfigurableAnchorExtractor = this;
        synchronized (sQLConfigurableAnchorExtractor) {
            if (!this.bitmap$trans$0) {
                this.log = Logger.getLogger(this.getClass());
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    private Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    private Map<String, SQLFeatureDefinition> featureToDefs() {
        return this.featureToDefs;
    }

    private Map<String, String> columnNameToFeatureDefs() {
        return this.columnNameToFeatureDefs;
    }

    @Override
    public Seq<String> getProvidedFeatureNames() {
        return this.features().keys().toIndexedSeq();
    }

    @Override
    public Seq<Tuple2<String, Column>> transformAsColumns(Dataset<Row> inputDF) {
        Set featureNames = ((TraversableOnce)this.featureToDefs().map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1._1(), Iterable$.MODULE$.canBuildFrom())).toSet();
        return ((MapLike)this.columnNameToFeatureDefs().map((Function1 & Serializable & scala.Serializable)featureNameAndDef -> {
            if (featureNames.contains(featureNameAndDef._2()) && !BoxesRunTime.equals((Object)featureNameAndDef._1(), (Object)featureNameAndDef._2())) {
                throw new FeathrConfigException(ErrorLabel.FEATHR_ERROR, new StringBuilder(94).append("Feature ").append(featureNameAndDef._1()).append(" should not be defined as ").append(featureNameAndDef._2()).append(", ").append("as there's another feature named ").append(featureNameAndDef._2()).append(" already, thus ambiguous.").toString());
            }
            return new Tuple2(featureNameAndDef._1(), (Object)functions$.MODULE$.expr((String)featureNameAndDef._2()));
        }, Map$.MODULE$.canBuildFrom())).toSeq();
    }

    public Map<Tuple2<String, Column>, Enumeration.Value> getTensorFeatures(Dataset<Row> dataFrameWithKeyColumns, Map<String, DataType> expectedColSchemas) {
        return (Map)this.columnNameToFeatureDefs().collect((PartialFunction)new scala.Serializable(null, expectedColSchemas){
            public static final long serialVersionUID = 0L;
            private final Map expectedColSchemas$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    String featureName = (String)A1._1();
                    String featureDef = (String)A1._2();
                    if (this.expectedColSchemas$1.keySet().contains((Object)featureName)) {
                        Tuple2 tuple2 = new Tuple2((Object)featureDef, (Object)FeatureColumnFormat$.MODULE$.RAW());
                        if (tuple2 == null) throw new MatchError((Object)tuple2);
                        String rewrittenDef = (String)tuple2._1();
                        Enumeration.Value featureColumnFormat = (Enumeration.Value)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)rewrittenDef, (Object)featureColumnFormat);
                        Tuple2 tuple23 = tuple22;
                        String rewrittenDef2 = (String)tuple23._1();
                        Enumeration.Value featureColumnFormat2 = (Enumeration.Value)tuple23._2();
                        object = new Tuple2((Object)new Tuple2((Object)featureName, (Object)functions$.MODULE$.expr(rewrittenDef2)), (Object)featureColumnFormat2);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<String, String> x1) {
                Tuple2<String, String> tuple2 = x1;
                if (tuple2 == null) return false;
                String featureName = (String)tuple2._1();
                if (!this.expectedColSchemas$1.keySet().contains((Object)featureName)) return false;
                return true;
            }
            {
                this.expectedColSchemas$1 = expectedColSchemas$1;
            }
        }, Map$.MODULE$.canBuildFrom());
    }

    public SQLConfigurableAnchorExtractor(@JsonProperty(value="key") SQLKeys key, @JsonProperty(value="features") Map<String, SQLFeatureDefinition> features) {
        this.key = key;
        this.features = features;
        this.featureToDefs = features;
        this.columnNameToFeatureDefs = (Map)this.featureToDefs().map((Function1 & Serializable & scala.Serializable)f -> new Tuple2(f._1(), (Object)((SQLFeatureDefinition)f._2()).featureExpr()), Map$.MODULE$.canBuildFrom());
    }
}

