/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.client;

import com.linkedin.feathr.common.ErasedEntityTaggedFeature;
import com.linkedin.feathr.common.FeatureInfo;
import com.linkedin.feathr.common.Header;
import com.linkedin.feathr.common.JoiningFeatureParams;
import com.linkedin.feathr.common.TaggedFeatureName;
import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrConfigException;
import com.linkedin.feathr.common.exception.FeathrException;
import com.linkedin.feathr.common.exception.FeathrInputDataException;
import com.linkedin.feathr.common.package$;
import com.linkedin.feathr.offline.anchored.feature.FeatureAnchorWithSource;
import com.linkedin.feathr.offline.client.DataFrameColName$;
import com.linkedin.feathr.offline.client.FeathrClient$;
import com.linkedin.feathr.offline.config.FeathrConfig;
import com.linkedin.feathr.offline.config.FeathrConfigLoader$;
import com.linkedin.feathr.offline.config.FeatureGroupsGenerator$;
import com.linkedin.feathr.offline.config.FeatureJoinConfig;
import com.linkedin.feathr.offline.config.sources.FeatureGroupsUpdater;
import com.linkedin.feathr.offline.config.sources.FeatureGroupsUpdater$;
import com.linkedin.feathr.offline.derived.DerivedFeature;
import com.linkedin.feathr.offline.generation.DataFrameFeatureGenerator;
import com.linkedin.feathr.offline.generation.FeatureGenKeyTagAnalyzer$;
import com.linkedin.feathr.offline.generation.StreamingFeatureGenerator;
import com.linkedin.feathr.offline.job.FeatureGenSpec;
import com.linkedin.feathr.offline.job.JoinJobContext;
import com.linkedin.feathr.offline.job.JoinJobContext$;
import com.linkedin.feathr.offline.join.DataFrameFeatureJoiner;
import com.linkedin.feathr.offline.logical.FeatureGroups;
import com.linkedin.feathr.offline.logical.LogicalPlan;
import com.linkedin.feathr.offline.logical.MultiStageJoinPlan;
import com.linkedin.feathr.offline.logical.MultiStageJoinPlanner;
import com.linkedin.feathr.offline.logical.MultiStageJoinPlanner$;
import com.linkedin.feathr.offline.mvel.plugins.FeathrExpressionExecutionContext;
import com.linkedin.feathr.offline.source.DataSource;
import com.linkedin.feathr.offline.source.accessor.DataPathHandler;
import com.linkedin.feathr.offline.util.AclCheckUtils$;
import com.linkedin.feathr.offline.util.AnchorUtils$;
import com.linkedin.feathr.offline.util.FeathrUtils$;
import com.linkedin.feathr.offline.util.FeaturizedDatasetMetadata;
import com.linkedin.feathr.offline.util.FeaturizedDatasetMetadata$;
import com.linkedin.feathr.offline.util.HdfsUtils$;
import com.linkedin.feathr.offline.util.SparkFeaturizedDataset;
import com.linkedin.feathr.sparkcommon.OutputProcessor;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\rMf\u0001B)S\u0001uC\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006I!\u001a\u0005\tc\u0002\u0011\t\u0011)A\u0005e\"A\u0001\u0010\u0001B\u0001B\u0003%\u0011\u0010\u0003\u0005}\u0001\t\u0005\t\u0015!\u0003~\u0011)\tY\u0001\u0001B\u0001B\u0003%\u0011Q\u0002\u0005\u000b\u0003k\u0001!\u0011!Q\u0001\n\u0005]\u0002\u0002CA'\u0001\u0011\u0005A+a\u0014\t\u0013\u0005\u0005\u0004A1A\u0005\n\u0005\r\u0004\u0002CA9\u0001\u0001\u0006I!!\u001a\u0006\r\u0005M\u0004\u0001AA;\u0011)\tY\t\u0001b\u0001\n\u0003!\u0016Q\u0012\u0005\t\u0003K\u0003\u0001\u0015!\u0003\u0002\u0010\"Q\u0011q\u0015\u0001C\u0002\u0013\u0005A+!+\t\u0011\u0005e\u0006\u0001)A\u0005\u0003WC!\"a/\u0001\u0005\u0004%\t\u0001VAG\u0011!\ti\f\u0001Q\u0001\n\u0005=\u0005BCA`\u0001\t\u0007I\u0011\u0001+\u0002\u000e\"A\u0011\u0011\u0019\u0001!\u0002\u0013\ty\t\u0003\u0006\u0002D\u0002\u0011\r\u0011\"\u0001U\u0003SC\u0001\"!2\u0001A\u0003%\u00111\u0016\u0005\b\u0003\u000f\u0004A\u0011AAe\u0011%\u0011)\u0001AI\u0001\n\u0003\u00119\u0001C\u0004\u0003\u001e\u0001!\tAa\b\t\u000f\tU\u0002\u0001\"\u0003\u00038!9!\u0011\t\u0001\u0005\n\t\r\u0003\u0002\u0003B&\u0001\u0011\u0005AK!\u0014\t\u0011\t\u0015\u0004\u0001\"\u0001U\u0005OBqAa&\u0001\t\u0013\u0011I\n\u0003\u0005\u0003$\u0002!\t\u0001\u0016BS\u0011)\u0011Y\fAI\u0001\n\u0003!&Q\u0018\u0005\t\u0005\u0003\u0004A\u0011\u0001+\u0003D\"A!Q\u0019\u0001\u0005\u0002Q\u00139\rC\u0004\u0003J\u0002!IAa3\t\u000f\t]\u0007\u0001\"\u0003\u0003Z\u001e9!\u0011\u001d*\t\u0002\t\rhAB)S\u0011\u0003\u0011)\u000fC\u0004\u0002N\u0011\"\tAa:\t\u000f\t%H\u0005\"\u0001\u0003l\u001a1!\u0011\u001f\u0013\u0001\u0005gD\u0001\u0002Z\u0014\u0003\u0002\u0003\u0006I!\u001a\u0005\t\u0003\u001b:C\u0011\u0001\u0013\u0003v\"I!\u0011`\u0014C\u0002\u0013%!1 \u0005\t\u0007\u00079\u0003\u0015!\u0003\u0003~\"I1QA\u0014A\u0002\u0013%1q\u0001\u0005\n\u0007\u00139\u0003\u0019!C\u0005\u0007\u0017A\u0001b!\u0005(A\u0003&!1\u001c\u0005\n\u0007'9\u0003\u0019!C\u0005\u0007\u000fA\u0011b!\u0006(\u0001\u0004%Iaa\u0006\t\u0011\rmq\u0005)Q\u0005\u00057D\u0011b!\b(\u0001\u0004%Iaa\u0002\t\u0013\r}q\u00051A\u0005\n\r\u0005\u0002\u0002CB\u0013O\u0001\u0006KAa7\t\u0013\r\u001dr\u00051A\u0005\n\r\u001d\u0001\"CB\u0015O\u0001\u0007I\u0011BB\u0016\u0011!\u0019yc\nQ!\n\tm\u0007\"CB\u0019O\u0001\u0007I\u0011BB\u001a\u0011%\u00199d\na\u0001\n\u0013\u0019I\u0004\u0003\u0005\u0004>\u001d\u0002\u000b\u0015BB\u001b\u0011%\tYa\na\u0001\n\u0013\u0019y\u0004C\u0005\u0004B\u001d\u0002\r\u0011\"\u0003\u0004D!A1qI\u0014!B\u0013\ti\u0001C\u0005\u00026\u001d\u0002\r\u0011\"\u0003\u0004J!I11J\u0014A\u0002\u0013%1Q\n\u0005\t\u0007#:\u0003\u0015)\u0003\u00028!911K\u0014\u0005\u0002\rU\u0003bBB-O\u0011\u000511\f\u0005\b\u00073:C\u0011AB1\u0011\u001d\u00199g\nC\u0001\u0007SBqaa\u001a(\t\u0003\u0019i\u0007C\u0004\u0004t\u001d\"\ta!\u001e\t\u000f\rMt\u0005\"\u0001\u0004z!91QP\u0014\u0005\u0002\r}\u0004bBB?O\u0011\u000511\u0011\u0005\b\u0007\u000f;C\u0011ABE\u0011\u001d\u00199i\nC\u0001\u0007\u001bC\u0001b!%(\t\u0003!61\u0013\u0005\t\u0007#;C\u0011\u0001+\u0004\u001a\"91QT\u0014\u0005\u0002\r}\u0005bBBSO\u0011\u00051q\u0015\u0005\t\u0007S;C\u0011\u0001+\u0004,\naa)Z1uQJ\u001cE.[3oi*\u00111\u000bV\u0001\u0007G2LWM\u001c;\u000b\u0005U3\u0016aB8gM2Lg.\u001a\u0006\u0003/b\u000baAZ3bi\"\u0014(BA-[\u0003!a\u0017N\\6fI&t'\"A.\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001q\u0006CA0c\u001b\u0005\u0001'\"A1\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0004'AB!osJ+g-\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0002g_6\tqM\u0003\u0002iS\u0006\u00191/\u001d7\u000b\u0005)\\\u0017!B:qCJ\\'B\u00017n\u0003\u0019\t\u0007/Y2iK*\ta.A\u0002pe\u001eL!\u0001]4\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\u001b\u0019,\u0017\r^;sK\u001e\u0013x.\u001e9t!\t\u0019h/D\u0001u\u0015\t)H+A\u0004m_\u001eL7-\u00197\n\u0005]$(!\u0004$fCR,(/Z$s_V\u00048/\u0001\bm_\u001eL7-\u00197QY\u0006tg.\u001a:\u0011\u0005MT\u0018BA>u\u0005UiU\u000f\u001c;j'R\fw-\u001a&pS:\u0004F.\u00198oKJ\fACZ3biV\u0014Xm\u0012:pkB\u001cX\u000b\u001d3bi\u0016\u0014\bc\u0001@\u0002\b5\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011aB:pkJ\u001cWm\u001d\u0006\u0004\u0003\u000b!\u0016AB2p]\u001aLw-C\u0002\u0002\n}\u0014ACR3biV\u0014Xm\u0012:pkB\u001cX\u000b\u001d3bi\u0016\u0014\u0018\u0001\u00053bi\u0006\u0004\u0016\r\u001e5IC:$G.\u001a:t!\u0019\ty!a\b\u0002&9!\u0011\u0011CA\u000e\u001d\u0011\t\u0019\"!\u0007\u000e\u0005\u0005U!bAA\f9\u00061AH]8pizJ\u0011!Y\u0005\u0004\u0003;\u0001\u0017a\u00029bG.\fw-Z\u0005\u0005\u0003C\t\u0019C\u0001\u0003MSN$(bAA\u000fAB!\u0011qEA\u0019\u001b\t\tIC\u0003\u0003\u0002,\u00055\u0012\u0001C1dG\u0016\u001c8o\u001c:\u000b\u0007\u0005=B+\u0001\u0004t_V\u00148-Z\u0005\u0005\u0003g\tICA\bECR\f\u0007+\u0019;i\u0011\u0006tG\r\\3s\u0003-ig/\u001a7D_:$X\r\u001f;\u0011\u000b}\u000bI$!\u0010\n\u0007\u0005m\u0002M\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u007f\tI%\u0004\u0002\u0002B)!\u00111IA#\u0003\u001d\u0001H.^4j]NT1!a\u0012U\u0003\u0011ig/\u001a7\n\t\u0005-\u0013\u0011\t\u0002!\r\u0016\fG\u000f\u001b:FqB\u0014Xm]:j_:,\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u000f\u0003#\n)&a\u0016\u0002Z\u0005m\u0013QLA0!\r\t\u0019\u0006A\u0007\u0002%\")Am\u0002a\u0001K\")\u0011o\u0002a\u0001e\")\u0001p\u0002a\u0001s\")Ap\u0002a\u0001{\"9\u00111B\u0004A\u0002\u00055\u0001bBA\u001b\u000f\u0001\u0007\u0011qG\u0001\u0004Y><WCAA3!\u0011\t9'!\u001c\u000e\u0005\u0005%$bAA6W\u0006)An\\45U&!\u0011qNA5\u0005\u0019aunZ4fe\u0006!An\\4!\u0005EYU-\u001f+bON#(/\u001b8h)V\u0004H.\u001a\t\u0007\u0003\u001f\t9(a\u001f\n\t\u0005e\u00141\u0005\u0002\u0004'\u0016\f\b\u0003BA?\u0003\u000bsA!a \u0002\u0002B\u0019\u00111\u00031\n\u0007\u0005\r\u0005-\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u000f\u000bII\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0007\u0003\u0017aE1mY\u0006s7\r[8sK\u00124U-\u0019;ve\u0016\u001cXCAAH!!\ti(!%\u0002|\u0005U\u0015\u0002BAJ\u0003\u0013\u00131!T1q!\u0011\t9*!)\u000e\u0005\u0005e%\u0002BAN\u0003;\u000bqAZ3biV\u0014XMC\u0002\u0002 R\u000b\u0001\"\u00198dQ>\u0014X\rZ\u0005\u0005\u0003G\u000bIJA\fGK\u0006$XO]3B]\u000eDwN],ji\"\u001cv.\u001e:dK\u0006!\u0012\r\u001c7B]\u000eDwN]3e\r\u0016\fG/\u001e:fg\u0002\n!#\u00197m\t\u0016\u0014\u0018N^3e\r\u0016\fG/\u001e:fgV\u0011\u00111\u0016\t\t\u0003{\n\t*a\u001f\u0002.B!\u0011qVA[\u001b\t\t\tLC\u0002\u00024R\u000bq\u0001Z3sSZ,G-\u0003\u0003\u00028\u0006E&A\u0004#fe&4X\r\u001a$fCR,(/Z\u0001\u0014C2dG)\u001a:jm\u0016$g)Z1ukJ,7\u000fI\u0001\u0017C2d\u0007+Y:ti\"\u0014x.^4i\r\u0016\fG/\u001e:fg\u00069\u0012\r\u001c7QCN\u001cH\u000f\u001b:pk\u001eDg)Z1ukJ,7\u000fI\u0001\u0015C2dw+\u001b8e_^\fum\u001a$fCR,(/Z:\u0002+\u0005dGnV5oI><\u0018iZ4GK\u0006$XO]3tA\u0005\u0011\u0012\r\u001c7TKFTu.\u001b8GK\u0006$XO]3t\u0003M\tG\u000e\\*fc*{\u0017N\u001c$fCR,(/Z:!\u00031Qw.\u001b8GK\u0006$XO]3t)!\tY-a6\u0002d\u0006\u001d\b\u0003BAg\u0003'l!!a4\u000b\u0007\u0005EG+\u0001\u0003vi&d\u0017\u0002BAk\u0003\u001f\u0014ac\u00159be.4U-\u0019;ve&TX\r\u001a#bi\u0006\u001cX\r\u001e\u0005\b\u00033,\u0002\u0019AAn\u0003)Qw.\u001b8D_:4\u0017n\u001a\t\u0005\u0003;\fy.\u0004\u0002\u0002\u0004%!\u0011\u0011]A\u0002\u0005E1U-\u0019;ve\u0016Tu.\u001b8D_:4\u0017n\u001a\u0005\b\u0003K,\u0002\u0019AAf\u0003\u001dy'm\u001d#bi\u0006D\u0011\"!;\u0016!\u0003\u0005\r!a;\u0002\u0015)|'mQ8oi\u0016DH\u000f\u0005\u0003\u0002n\u0006MXBAAx\u0015\r\t\t\u0010V\u0001\u0004U>\u0014\u0017\u0002BA{\u0003_\u0014aBS8j]*{'mQ8oi\u0016DH\u000fK\u0002\u0016\u0003s\u0004B!a?\u0003\u00025\u0011\u0011Q \u0006\u0004\u0003\u007f4\u0016AB2p[6|g.\u0003\u0003\u0003\u0004\u0005u(aC%oi\u0016\u0014h.\u00197Ba&\faC[8j]\u001a+\u0017\r^;sKN$C-\u001a4bk2$HeM\u000b\u0003\u0005\u0013QC!a;\u0003\f-\u0012!Q\u0002\t\u0005\u0005\u001f\u0011I\"\u0004\u0002\u0003\u0012)!!1\u0003B\u000b\u0003%)hn\u00195fG.,GMC\u0002\u0003\u0018\u0001\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0011YB!\u0005\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\thK:,'/\u0019;f\r\u0016\fG/\u001e:fgR!!\u0011\u0005B\u0015!!\ti(!%\u0003$\u0005-\u0007\u0003BA~\u0005KIAAa\n\u0002~\n\tB+Y4hK\u00124U-\u0019;ve\u0016t\u0015-\\3\t\u000f\t-r\u00031\u0001\u0003.\u0005qa-Z1ukJ,w)\u001a8Ta\u0016\u001c\u0007\u0003BAw\u0005_IAA!\r\u0002p\nqa)Z1ukJ,w)\u001a8Ta\u0016\u001c\u0007fA\f\u0002z\u0006Y\u0011n]*ue\u0016\fW.\u001b8h)\u0011\u0011IDa\u0010\u0011\u0007}\u0013Y$C\u0002\u0003>\u0001\u0014qAQ8pY\u0016\fg\u000eC\u0004\u0003,a\u0001\rA!\f\u0002#A\u0014X\r]1sK\u0016CXmY;uK\u0016sg\u000f\u0006\u0002\u0003FA\u0019qLa\u0012\n\u0007\t%\u0003M\u0001\u0003V]&$\u0018\u0001F4fi\u0006cGNR3biV\u0014XmU8ve\u000e,7\u000f\u0006\u0003\u0003P\te\u0003CBA\b\u0003?\u0011\t\u0006\u0005\u0003\u0003T\tUSBAA\u0017\u0013\u0011\u00119&!\f\u0003\u0015\u0011\u000bG/Y*pkJ\u001cW\rC\u0004\u0003\\i\u0001\rA!\u0018\u0002#I,\u0017/^3ti\u0016$g)Z1ukJ,7\u000f\u0005\u0004\u0002\u0010\u0005]$q\f\t\u0005\u0003w\u0014\t'\u0003\u0003\u0003d\u0005u(\u0001\u0006&pS:Lgn\u001a$fCR,(/\u001a)be\u0006l7/\u0001\u000be_*{\u0017N\\(cg\u0006sGMR3biV\u0014Xm\u001d\u000b\t\u0005S\u0012\tJa%\u0003\u0016B9qLa\u001b\u0003p\t-\u0015b\u0001B7A\n1A+\u001e9mKJ\u0002BA!\u001d\u0003\u0006:!!1\u000fBB\u001d\u0011\u0011)H!!\u000f\t\t]$q\u0010\b\u0005\u0005s\u0012iH\u0004\u0003\u0002\u0014\tm\u0014\"\u00018\n\u00051l\u0017B\u00016l\u0013\tA\u0017.C\u0002\u0002\u001e\u001dLAAa\"\u0003\n\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0004\u0003;9\u0007\u0003BA~\u0005\u001bKAAa$\u0002~\n1\u0001*Z1eKJDq!!7\u001c\u0001\u0004\tY\u000eC\u0004\u0002jn\u0001\r!a;\t\u000f\u0005\u00158\u00041\u0001\u0003p\u0005Ab-\u001b8e\u0007>tg\r\\5di\u001a+\u0017\r^;sK:\u000bW.Z:\u0015\r\u0005U$1\u0014BP\u0011\u001d\u0011i\n\ba\u0001\u0005;\n\u0011c[3z)\u0006<w-\u001a3GK\u0006$XO]3t\u0011\u001d\u0011\t\u000b\ba\u0001\u0003k\n!BZ5fY\u0012t\u0015-\\3t\u0003AQw.\u001b8GK\u0006$XO]3t\u0003N$e\t\u0006\u0006\u0003j\t\u001d&\u0011\u0016BV\u0005_Cq!!7\u001e\u0001\u0004\tY\u000eC\u0004\u0003\u001ev\u0001\rA!\u0018\t\u000f\t5V\u00041\u0001\u0003p\u0005!A.\u001a4u\u0011%\u0011\t,\bI\u0001\u0002\u0004\u0011\u0019,A\fs_^\u0014En\\8n\r&dG/\u001a:UQJ,7\u000f[8mIB)q,!\u000f\u00036B\u0019qLa.\n\u0007\te\u0006MA\u0002J]R\f!D[8j]\u001a+\u0017\r^;sKN\f5\u000f\u0012$%I\u00164\u0017-\u001e7uIQ*\"Aa0+\t\tM&1B\u0001\u0011O\u0016$h)Z1ukJ,wI]8vaN$\u0012A]\u0001\u0012O\u0016$Hj\\4jG\u0006d\u0007\u000b\\1o]\u0016\u0014H#A=\u0002+M$(/\u001b8hS\u001aLh)Z1ukJ,g*Y7fgR!\u00111\u0010Bg\u0011\u001d\u0011y-\ta\u0001\u0005#\fqA\\1nKN+G\u000f\u0005\u0004\u0002~\tM\u00171P\u0005\u0005\u0005+\fIIA\u0002TKR\faCZ5oI&sg/\u00197jI\u001a+\u0017\r^;sKJ+gm\u001d\u000b\u0005\u00057\u0014i\u000e\u0005\u0004\u0002\u0010\u0005}\u00111\u0010\u0005\b\u0005?\u0014\u0003\u0019\u0001B/\u0003!1W-\u0019;ve\u0016\u001c\u0018\u0001\u0004$fCRD'o\u00117jK:$\bcAA*IM\u0011AE\u0018\u000b\u0003\u0005G\fqAY;jY\u0012,'\u000f\u0006\u0003\u0003n\u000eE\u0006c\u0001BxO5\tAEA\u0004Ck&dG-\u001a:\u0014\u0005\u001drF\u0003\u0002Bw\u0005oDQ\u0001Z\u0015A\u0002\u0015\f!CZ3bi\"\u00148i\u001c8gS\u001edu.\u00193feV\u0011!Q \t\u0005\u0003;\u0014y0\u0003\u0003\u0004\u0002\u0005\r!\u0001\u0004$fCRD'oQ8oM&<\u0017a\u00054fCRD'oQ8oM&<Gj\\1eKJ\u0004\u0013A\u00034fCR,(/\u001a#fMV\u0011!1\\\u0001\u000fM\u0016\fG/\u001e:f\t\u00164w\fJ3r)\u0011\u0011)e!\u0004\t\u0013\r=Q&!AA\u0002\tm\u0017a\u0001=%c\u0005Ya-Z1ukJ,G)\u001a4!\u0003AawnY1m\u001fZ,'O]5eK\u0012+g-\u0001\u000bm_\u000e\fGn\u0014<feJLG-\u001a#fM~#S-\u001d\u000b\u0005\u0005\u000b\u001aI\u0002C\u0005\u0004\u0010A\n\t\u00111\u0001\u0003\\\u0006\tBn\\2bY>3XM\u001d:jI\u0016$UM\u001a\u0011\u0002\u001d\u0019,\u0017\r^;sK\u0012+g\rU1uQ\u0006\u0011b-Z1ukJ,G)\u001a4QCRDw\fJ3r)\u0011\u0011)ea\t\t\u0013\r=1'!AA\u0002\tm\u0017a\u00044fCR,(/\u001a#fMB\u000bG\u000f\u001b\u0011\u0002)1|7-\u00197Pm\u0016\u0014(/\u001b3f\t\u00164\u0007+\u0019;i\u0003aawnY1m\u001fZ,'O]5eK\u0012+g\rU1uQ~#S-\u001d\u000b\u0005\u0005\u000b\u001ai\u0003C\u0005\u0004\u0010Y\n\t\u00111\u0001\u0003\\\u0006)Bn\\2bY>3XM\u001d:jI\u0016$UM\u001a)bi\"\u0004\u0013a\u00044fCR,(/\u001a#fM\u000e{gNZ:\u0016\u0005\rU\u0002CBA\b\u0003?\u0011i0A\ngK\u0006$XO]3EK\u001a\u001cuN\u001c4t?\u0012*\u0017\u000f\u0006\u0003\u0003F\rm\u0002\"CB\bs\u0005\u0005\t\u0019AB\u001b\u0003A1W-\u0019;ve\u0016$UMZ\"p]\u001a\u001c\b%\u0006\u0002\u0002\u000e\u0005!B-\u0019;b!\u0006$\b\u000eS1oI2,'o]0%KF$BA!\u0012\u0004F!I1q\u0002\u001f\u0002\u0002\u0003\u0007\u0011QB\u0001\u0012I\u0006$\u0018\rU1uQ\"\u000bg\u000e\u001a7feN\u0004SCAA\u001c\u0003=ig/\u001a7D_:$X\r\u001f;`I\u0015\fH\u0003\u0002B#\u0007\u001fB\u0011ba\u0004@\u0003\u0003\u0005\r!a\u000e\u0002\u001954X\r\\\"p]R,\u0007\u0010\u001e\u0011\u0002'\u0005$G\rR1uCB\u000bG\u000f\u001b%b]\u0012dWM]:\u0015\t\t58q\u000b\u0005\b\u0003\u0017\t\u0005\u0019AA\u0007\u0003I\tG\r\u001a#bi\u0006\u0004\u0016\r\u001e5IC:$G.\u001a:\u0015\t\t58Q\f\u0005\b\u0007?\u0012\u0005\u0019AA\u0013\u0003=!\u0017\r^1QCRD\u0007*\u00198eY\u0016\u0014H\u0003\u0002Bw\u0007GBqaa\u0018D\u0001\u0004\u0019)\u0007E\u0003`\u0003s\t)#A\u0007bI\u00124U-\u0019;ve\u0016$UM\u001a\u000b\u0005\u0005[\u001cY\u0007C\u0004\u0004\u0006\u0011\u0003\r!a\u001f\u0015\t\t58q\u000e\u0005\b\u0007\u000b)\u0005\u0019AB9!\u0015y\u0016\u0011HA>\u0003M\tG\r\u001a'pG\u0006dwJ^3se&$W\rR3g)\u0011\u0011ioa\u001e\t\u000f\rMa\t1\u0001\u0002|Q!!Q^B>\u0011\u001d\u0019\u0019b\u0012a\u0001\u0007c\n\u0011#\u00193e\r\u0016\fG/\u001e:f\t\u00164\u0007+\u0019;i)\u0011\u0011io!!\t\u000f\ru\u0001\n1\u0001\u0002|Q!!Q^BC\u0011\u001d\u0019i\"\u0013a\u0001\u0007c\nq#\u00193e\u0019>\u001c\u0017\r\\(wKJ\u0014\u0018\u000eZ3EK\u001a\u0004\u0016\r\u001e5\u0015\t\t581\u0012\u0005\b\u0007OQ\u0005\u0019AA>)\u0011\u0011ioa$\t\u000f\r\u001d2\n1\u0001\u0004r\u0005\u0011\u0012\r\u001a3GK\u0006$XO]3EK\u001a\u001cuN\u001c4t)\u0011\u0011io!&\t\u000f\rEB\n1\u0001\u0004\u0018B)q,!\u000f\u00046Q!!Q^BN\u0011\u001d\u0019\t$\u0014a\u0001\u0007k\t!$\u00193e\r\u0016\fG\u000f\u001b:FqB\u0014Xm]:j_:\u001cuN\u001c;fqR$BA!<\u0004\"\"911\u0015(A\u0002\u0005]\u0012\u0001D0nm\u0016d7i\u001c8uKb$\u0018!\u00022vS2$GCAA)\u00031\u0011X-\u00193II\u001a\u001ch)\u001b7f)\u0011\u0019\th!,\t\u000f\r=\u0006\u000b1\u0001\u0004r\u0005!\u0001/\u0019;i\u0011\u0015!g\u00051\u0001f\u0001")
public class FeathrClient {
    private final SparkSession sparkSession;
    private final FeatureGroups featureGroups;
    private final MultiStageJoinPlanner logicalPlanner;
    private final FeatureGroupsUpdater featureGroupsUpdater;
    private final List<DataPathHandler> dataPathHandlers;
    private final Option<FeathrExpressionExecutionContext> mvelContext;
    private final Logger log;
    private final Map<String, FeatureAnchorWithSource> allAnchoredFeatures;
    private final Map<String, DerivedFeature> allDerivedFeatures;
    private final Map<String, FeatureAnchorWithSource> allPassthroughFeatures;
    private final Map<String, FeatureAnchorWithSource> allWindowAggFeatures;
    private final Map<String, DerivedFeature> allSeqJoinFeatures;

    public static Builder builder(SparkSession sparkSession) {
        return FeathrClient$.MODULE$.builder(sparkSession);
    }

    private Logger log() {
        return this.log;
    }

    public Map<String, FeatureAnchorWithSource> allAnchoredFeatures() {
        return this.allAnchoredFeatures;
    }

    public Map<String, DerivedFeature> allDerivedFeatures() {
        return this.allDerivedFeatures;
    }

    public Map<String, FeatureAnchorWithSource> allPassthroughFeatures() {
        return this.allPassthroughFeatures;
    }

    public Map<String, FeatureAnchorWithSource> allWindowAggFeatures() {
        return this.allWindowAggFeatures;
    }

    public Map<String, DerivedFeature> allSeqJoinFeatures() {
        return this.allSeqJoinFeatures;
    }

    public SparkFeaturizedDataset joinFeatures(FeatureJoinConfig joinConfig, SparkFeaturizedDataset obsData, JoinJobContext jobContext) {
        SparkConf sparkConf = this.sparkSession.sparkContext().getConf();
        FeathrUtils$.MODULE$.enableDebugLogging(sparkConf);
        Tuple2<Dataset<Row>, Header> tuple2 = this.doJoinObsAndFeatures(joinConfig, jobContext, obsData.data());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Dataset joinedDF = (Dataset)tuple2._1();
        Header header = (Header)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)joinedDF, (Object)header);
        Tuple2 tuple23 = tuple22;
        Dataset joinedDF2 = (Dataset)tuple23._1();
        Header header2 = (Header)tuple23._2();
        Some x$1 = new Some((Object)header2);
        Map<String, String> x$2 = FeaturizedDatasetMetadata$.MODULE$.apply$default$1();
        return new SparkFeaturizedDataset((Dataset<Row>)joinedDF2, new FeaturizedDatasetMetadata(x$2, (Option<Header>)x$1));
    }

    public JoinJobContext joinFeatures$default$3() {
        return new JoinJobContext(JoinJobContext$.MODULE$.apply$default$1(), JoinJobContext$.MODULE$.apply$default$2(), JoinJobContext$.MODULE$.apply$default$3(), JoinJobContext$.MODULE$.apply$default$4(), JoinJobContext$.MODULE$.apply$default$5());
    }

    public Map<TaggedFeatureName, SparkFeaturizedDataset> generateFeatures(FeatureGenSpec featureGenSpec) {
        Map map;
        this.prepareExecuteEnv();
        Seq<JoiningFeatureParams> keyTaggedAnchoredFeatures = FeatureGenKeyTagAnalyzer$.MODULE$.inferKeyTagsForAnchoredFeatures(featureGenSpec, this.featureGroups);
        Seq<JoiningFeatureParams> keyTaggedDerivedFeatures = FeatureGenKeyTagAnalyzer$.MODULE$.inferKeyTagsForDerivedFeatures(featureGenSpec, this.featureGroups, keyTaggedAnchoredFeatures);
        Seq keyTaggedRequiredFeatures = (Seq)keyTaggedAnchoredFeatures.$plus$plus(keyTaggedDerivedFeatures, Seq$.MODULE$.canBuildFrom());
        if (this.isStreaming(featureGenSpec)) {
            StreamingFeatureGenerator streamingFeatureGenerator = new StreamingFeatureGenerator(this.dataPathHandlers);
            streamingFeatureGenerator.generateFeatures(this.sparkSession, featureGenSpec, this.featureGroups, (Seq<JoiningFeatureParams>)keyTaggedRequiredFeatures);
            map = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        } else {
            LogicalPlan logicalPlan = this.logicalPlanner.getLogicalPlan(this.featureGroups, keyTaggedRequiredFeatures);
            DataFrameFeatureGenerator dataFrameFeatureGenerator = new DataFrameFeatureGenerator((MultiStageJoinPlan)logicalPlan, this.dataPathHandlers, this.mvelContext);
            Map<TaggedFeatureName, Tuple2<Dataset<Row>, Header>> featureMap = dataFrameFeatureGenerator.generateFeaturesAsDF(this.sparkSession, featureGenSpec, this.featureGroups, (Seq<JoiningFeatureParams>)keyTaggedRequiredFeatures);
            map = (Map)featureMap.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2;
                TaggedFeatureName taggedFeatureName;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$1;
                        if (tuple22 == null) break block2;
                        taggedFeatureName = (TaggedFeatureName)tuple22._1();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                Dataset df = (Dataset)tuple2._1();
                SparkFeaturizedDataset fds = new SparkFeaturizedDataset((Dataset<Row>)df, new FeaturizedDatasetMetadata(FeaturizedDatasetMetadata$.MODULE$.apply$default$1(), FeaturizedDatasetMetadata$.MODULE$.apply$default$2()));
                Tuple2 tuple23 = new Tuple2((Object)taggedFeatureName, (Object)fds);
                return tuple23;
            }, Map$.MODULE$.canBuildFrom());
        }
        return map;
    }

    private boolean isStreaming(FeatureGenSpec featureGenSpec) {
        Seq<OutputProcessor> outputProcessors = featureGenSpec.getProcessorList();
        return !outputProcessors.isEmpty() ? BoxesRunTime.unboxToBoolean((Object)((TraversableOnce)outputProcessors.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)FeathrClient.$anonfun$isStreaming$1(p)), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$2, x$3) -> BoxesRunTime.boxToBoolean((boolean)FeathrClient.$anonfun$isStreaming$2(BoxesRunTime.unboxToBoolean((Object)x$2), BoxesRunTime.unboxToBoolean((Object)x$3))))) : false;
    }

    private void prepareExecuteEnv() {
        SQLConf$.MODULE$.get().setConfString("spark.sql.legacy.allowUntypedScalaUDF", "true");
    }

    public List<DataSource> getAllFeatureSources(Seq<JoiningFeatureParams> requestedFeatures) {
        LogicalPlan logicalPlan = this.logicalPlanner.getLogicalPlan(this.featureGroups, (Seq)requestedFeatures);
        Seq<ErasedEntityTaggedFeature> allRequiredFeatures = ((MultiStageJoinPlan)logicalPlan).allRequiredFeatures();
        Seq sources = (Seq)((SeqLike)allRequiredFeatures.collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FeathrClient $outer;

            public final <A1 extends ErasedEntityTaggedFeature, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (this.$outer.allAnchoredFeatures().contains((Object)A1.getFeatureName())) {
                    String featureName = A1.getFeatureName();
                    object = ((FeatureAnchorWithSource)this.$outer.allAnchoredFeatures().apply((Object)featureName)).source();
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(ErasedEntityTaggedFeature x1) {
                ErasedEntityTaggedFeature erasedEntityTaggedFeature = x1;
                boolean bl = this.$outer.allAnchoredFeatures().contains((Object)erasedEntityTaggedFeature.getFeatureName());
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).distinct();
        return sources.toList();
    }

    public Tuple2<Dataset<Row>, Header> doJoinObsAndFeatures(FeatureJoinConfig joinConfig, JoinJobContext jobContext, Dataset<Row> obsData) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        this.log().info((Object)new StringBuilder(38).append("All anchored feature names (sorted):\n\t").append(this.stringifyFeatureNames((Set<String>)this.allAnchoredFeatures().keySet())).toString());
        this.log().info((Object)new StringBuilder(37).append("All derived feature names (sorted):\n\t").append(this.stringifyFeatureNames((Set<String>)this.allDerivedFeatures().keySet())).toString());
        this.prepareExecuteEnv();
        boolean enableCheckPoint = new StringOps(Predef$.MODULE$.augmentString(FeathrUtils$.MODULE$.getFeathrJobParam(this.sparkSession, FeathrUtils$.MODULE$.ENABLE_CHECKPOINT()))).toBoolean();
        String checkpointDir = FeathrUtils$.MODULE$.getFeathrJobParam(this.sparkSession, FeathrUtils$.MODULE$.CHECKPOINT_OUTPUT_PATH());
        if (enableCheckPoint) {
            if (checkpointDir.equals("")) {
                throw new FeathrException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(46).append("Please set ").append(FeathrUtils$.MODULE$.FEATHR_PARAMS_PREFIX()).append(FeathrUtils$.MODULE$.CHECKPOINT_OUTPUT_PATH()).append(" to a folder with write permission.").toString());
            }
            HdfsUtils$.MODULE$.deletePath(checkpointDir, true, HdfsUtils$.MODULE$.deletePath$default$3());
            this.sparkSession.sparkContext().setCheckpointDir(checkpointDir);
        }
        Map<String, Seq<JoiningFeatureParams>> featureGroupings = joinConfig.featureGroupings();
        this.log().info((Object)new StringBuilder(19).append("Join job context: ").append(jobContext).append(")").toString());
        this.log().info((Object)new StringBuilder(12).append("joinConfig: ").append(joinConfig).toString());
        this.log().info((Object)new StringBuilder(28).append("featureGroupings passed in: ").append(featureGroupings).toString());
        int rowBloomFilterThreshold = new StringOps(Predef$.MODULE$.augmentString(FeathrUtils$.MODULE$.getFeathrJobParam(this.sparkSession, FeathrUtils$.MODULE$.ROW_BLOOMFILTER_MAX_THRESHOLD()))).toInt();
        Seq joinFeatures = (Seq)((TraversableOnce)featureGroupings.values().flatten((Function1)Predef$.MODULE$.$conforms())).toSeq().distinct();
        if (featureGroupings.isEmpty()) {
            this.log().warn((Object)"Feature groupings from the join config is empty, returning the obs data without joining any features.");
            tuple22 = new Tuple2(obsData, (Object)new Header((Map<TaggedFeatureName, FeatureInfo>)Predef$.MODULE$.Map().empty()));
        } else {
            tuple22 = tuple2 = this.joinFeaturesAsDF(joinConfig, (Seq<JoiningFeatureParams>)joinFeatures, obsData, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)rowBloomFilterThreshold)));
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Dataset joinedDF = (Dataset)tuple2._1();
        Header header = (Header)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)joinedDF, (Object)header);
        Tuple2 tuple24 = tuple23;
        Dataset joinedDF2 = (Dataset)tuple24._1();
        Header header2 = (Header)tuple24._2();
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)"joinedDF:");
            joinedDF2.show(false);
            this.log().debug((Object)new StringBuilder(23).append("header featureInfoMap: ").append(header2.featureInfoMap()).toString());
        }
        return new Tuple2((Object)joinedDF2, (Object)header2);
    }

    private Seq<String> findConflictFeatureNames(Seq<JoiningFeatureParams> keyTaggedFeatures, Seq<String> fieldNames) {
        return (Seq)((SeqLike)keyTaggedFeatures.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.featureName(), Seq$.MODULE$.canBuildFrom())).intersect(fieldNames);
    }

    public Tuple2<Dataset<Row>, Header> joinFeaturesAsDF(FeatureJoinConfig joinConfig, Seq<JoiningFeatureParams> keyTaggedFeatures, Dataset<Row> left, Option<Object> rowBloomFilterThreshold) {
        List<String> invalidFeatureNames;
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])left.head(1))).isEmpty()) {
            this.log().info((Object)"Observation is empty");
            return new Tuple2(left, (Object)new Header((Map<TaggedFeatureName, FeatureInfo>)Predef$.MODULE$.Map().empty()));
        }
        FeatureGroups updatedFeatureGroups = this.featureGroupsUpdater.updateFeatureGroups(this.featureGroups, keyTaggedFeatures);
        LogicalPlan logicalPlan = this.logicalPlanner.getLogicalPlan(updatedFeatureGroups, (Seq)keyTaggedFeatures);
        if (!this.sparkSession.sparkContext().isLocal()) {
            Try<BoxedUnit> try_ = AclCheckUtils$.MODULE$.checkReadAuthorization(this.sparkSession, ((MultiStageJoinPlan)logicalPlan).allRequiredFeatures(), this.allAnchoredFeatures());
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                throw new FeathrInputDataException(ErrorLabel.FEATHR_USER_ERROR, "Unable to verify read authorization on feature data, it can be due to the following reasons: 1) input not exist, 2) no permission.", exception);
            }
            if (try_ instanceof Success) {
                this.log().debug((Object)"Checked read authorization on all feature data");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(try_);
            }
        }
        if ((invalidFeatureNames = this.findInvalidFeatureRefs(keyTaggedFeatures)).nonEmpty()) {
            throw new FeathrInputDataException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(77).append("Feature names must conform to ").append("regular expression: ").append(AnchorUtils$.MODULE$.featureNamePattern()).append(", but found feature names: ").append(invalidFeatureNames).toString());
        }
        Seq<String> conflictFeatureNames = this.findConflictFeatureNames(keyTaggedFeatures, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])left.schema().fieldNames()));
        if (conflictFeatureNames.nonEmpty()) {
            throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(152).append("Feature names must be different from field names in the observation data. ").append("Please rename feature ").append(conflictFeatureNames).append(" or rename the same field names in the observation data.").toString());
        }
        DataFrameFeatureJoiner joiner = new DataFrameFeatureJoiner((MultiStageJoinPlan)logicalPlan, this.dataPathHandlers, this.mvelContext);
        return joiner.joinFeaturesAsDF(this.sparkSession, joinConfig, updatedFeatureGroups, keyTaggedFeatures, left, rowBloomFilterThreshold);
    }

    public Option<Object> joinFeaturesAsDF$default$4() {
        return None$.MODULE$;
    }

    public FeatureGroups getFeatureGroups() {
        return this.featureGroups;
    }

    public MultiStageJoinPlanner getLogicalPlanner() {
        return this.logicalPlanner;
    }

    private String stringifyFeatureNames(Set<String> nameSet) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)nameSet.toSeq().sorted((Ordering)Ordering.String$.MODULE$)).toArray(ClassTag$.MODULE$.apply(String.class)))).mkString("\n\t");
    }

    private List<String> findInvalidFeatureRefs(Seq<JoiningFeatureParams> features) {
        return (List)features.foldLeft((Object)List$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(acc, f) -> {
            List list;
            String featureRefStr = f.featureName().toString();
            String featureRefStrInDF = DataFrameColName$.MODULE$.getEncodedFeatureRefStrForColName(featureRefStr);
            boolean isValidSyntax = AnchorUtils$.MODULE$.featureNamePattern().matcher(featureRefStrInDF).matches();
            if (isValidSyntax) {
                list = acc;
            } else {
                String string = featureRefStr;
                list = acc.$colon$colon((Object)string);
            }
            return list;
        });
    }

    public static final /* synthetic */ boolean $anonfun$isStreaming$1(OutputProcessor p) {
        return package$.MODULE$.RichConfig(p.outputProcessorConfig().getParams()).getBooleanWithDefault("streaming", false);
    }

    public static final /* synthetic */ boolean $anonfun$isStreaming$2(boolean x$2, boolean x$3) {
        return x$2 || x$3;
    }

    public FeathrClient(SparkSession sparkSession, FeatureGroups featureGroups, MultiStageJoinPlanner logicalPlanner, FeatureGroupsUpdater featureGroupsUpdater, List<DataPathHandler> dataPathHandlers, Option<FeathrExpressionExecutionContext> mvelContext) {
        this.sparkSession = sparkSession;
        this.featureGroups = featureGroups;
        this.logicalPlanner = logicalPlanner;
        this.featureGroupsUpdater = featureGroupsUpdater;
        this.dataPathHandlers = dataPathHandlers;
        this.mvelContext = mvelContext;
        this.log = Logger.getLogger(this.getClass());
        this.allAnchoredFeatures = featureGroups.allAnchoredFeatures();
        this.allDerivedFeatures = featureGroups.allDerivedFeatures();
        this.allPassthroughFeatures = featureGroups.allPassthroughFeatures();
        this.allWindowAggFeatures = featureGroups.allWindowAggFeatures();
        this.allSeqJoinFeatures = featureGroups.allSeqJoinFeatures();
    }

    public static class Builder {
        private final SparkSession sparkSession;
        private final FeathrConfig feathrConfigLoader;
        private List<String> featureDef;
        private List<String> localOverrideDef;
        private List<String> featureDefPath;
        private List<String> localOverrideDefPath;
        private List<FeathrConfig> featureDefConfs;
        private List<DataPathHandler> dataPathHandlers;
        private Option<FeathrExpressionExecutionContext> mvelContext;

        private FeathrConfig feathrConfigLoader() {
            return this.feathrConfigLoader;
        }

        private List<String> featureDef() {
            return this.featureDef;
        }

        private void featureDef_$eq(List<String> x$1) {
            this.featureDef = x$1;
        }

        private List<String> localOverrideDef() {
            return this.localOverrideDef;
        }

        private void localOverrideDef_$eq(List<String> x$1) {
            this.localOverrideDef = x$1;
        }

        private List<String> featureDefPath() {
            return this.featureDefPath;
        }

        private void featureDefPath_$eq(List<String> x$1) {
            this.featureDefPath = x$1;
        }

        private List<String> localOverrideDefPath() {
            return this.localOverrideDefPath;
        }

        private void localOverrideDefPath_$eq(List<String> x$1) {
            this.localOverrideDefPath = x$1;
        }

        private List<FeathrConfig> featureDefConfs() {
            return this.featureDefConfs;
        }

        private void featureDefConfs_$eq(List<FeathrConfig> x$1) {
            this.featureDefConfs = x$1;
        }

        private List<DataPathHandler> dataPathHandlers() {
            return this.dataPathHandlers;
        }

        private void dataPathHandlers_$eq(List<DataPathHandler> x$1) {
            this.dataPathHandlers = x$1;
        }

        private Option<FeathrExpressionExecutionContext> mvelContext() {
            return this.mvelContext;
        }

        private void mvelContext_$eq(Option<FeathrExpressionExecutionContext> x$1) {
            this.mvelContext = x$1;
        }

        public Builder addDataPathHandlers(List<DataPathHandler> dataPathHandlers) {
            this.dataPathHandlers_$eq((List<DataPathHandler>)((List)dataPathHandlers.$plus$plus(this.dataPathHandlers(), List$.MODULE$.canBuildFrom())));
            return this;
        }

        public Builder addDataPathHandler(DataPathHandler dataPathHandler) {
            DataPathHandler dataPathHandler2 = dataPathHandler;
            this.dataPathHandlers_$eq((List<DataPathHandler>)this.dataPathHandlers().$colon$colon((Object)dataPathHandler2));
            return this;
        }

        public Builder addDataPathHandler(Option<DataPathHandler> dataPathHandler) {
            return dataPathHandler.isDefined() ? this.addDataPathHandler((DataPathHandler)dataPathHandler.get()) : this;
        }

        public Builder addFeatureDef(String featureDef) {
            String string = featureDef;
            this.featureDef_$eq((List<String>)this.featureDef().$colon$colon((Object)string));
            return this;
        }

        public Builder addFeatureDef(Option<String> featureDef) {
            return featureDef.isDefined() ? this.addFeatureDef((String)featureDef.get()) : this;
        }

        public Builder addLocalOverrideDef(String localOverrideDef) {
            String string = localOverrideDef;
            this.localOverrideDef_$eq((List<String>)this.localOverrideDef().$colon$colon((Object)string));
            return this;
        }

        public Builder addLocalOverrideDef(Option<String> localOverrideDef) {
            return localOverrideDef.isDefined() ? this.addFeatureDef((String)localOverrideDef.get()) : this;
        }

        public Builder addFeatureDefPath(String featureDefPath) {
            String string = featureDefPath;
            this.featureDefPath_$eq((List<String>)this.featureDefPath().$colon$colon((Object)string));
            return this;
        }

        public Builder addFeatureDefPath(Option<String> featureDefPath) {
            return featureDefPath.isDefined() ? this.addFeatureDefPath((String)featureDefPath.get()) : this;
        }

        public Builder addLocalOverrideDefPath(String localOverrideDefPath) {
            String string = localOverrideDefPath;
            this.localOverrideDefPath_$eq((List<String>)this.localOverrideDefPath().$colon$colon((Object)string));
            return this;
        }

        public Builder addLocalOverrideDefPath(Option<String> localOverrideDefPath) {
            return localOverrideDefPath.isDefined() ? this.addLocalOverrideDefPath((String)localOverrideDefPath.get()) : this;
        }

        public Builder addFeatureDefConfs(Option<List<FeathrConfig>> featureDefConfs) {
            return featureDefConfs.isDefined() ? this.addFeatureDefConfs((List<FeathrConfig>)((List)featureDefConfs.get())) : this;
        }

        public Builder addFeatureDefConfs(List<FeathrConfig> featureDefConfs) {
            this.featureDefConfs_$eq(featureDefConfs);
            return this;
        }

        public Builder addFeathrExpressionContext(Option<FeathrExpressionExecutionContext> _mvelContext) {
            this.mvelContext_$eq(_mvelContext);
            return this;
        }

        public FeathrClient build() {
            Predef$.MODULE$.require(!this.localOverrideDefPath().isEmpty() || !this.localOverrideDef().isEmpty() || !this.featureDefPath().isEmpty() || !this.featureDef().isEmpty() || !this.featureDefConfs().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Cannot build feathrClient without a feature def conf file/string or local override def conf file/string");
            ObjectRef featureDefConfigs = ObjectRef.create((Object)List$.MODULE$.empty());
            ObjectRef localDefConfigs = ObjectRef.create((Object)List$.MODULE$.empty());
            Object object = this.featureDefPath().nonEmpty() ? this.featureDefPath().map((Function1 & Serializable & scala.Serializable)path -> {
                Builder.$anonfun$build$2(this, featureDefConfigs, path);
                return BoxedUnit.UNIT;
            }, List$.MODULE$.canBuildFrom()) : BoxedUnit.UNIT;
            Object object2 = this.featureDef().nonEmpty() ? this.featureDef().map((Function1 & Serializable & scala.Serializable)confStr -> {
                Builder.$anonfun$build$4(this, featureDefConfigs, confStr);
                return BoxedUnit.UNIT;
            }, List$.MODULE$.canBuildFrom()) : BoxedUnit.UNIT;
            Object object3 = this.localOverrideDefPath().nonEmpty() ? this.localOverrideDefPath().map((Function1 & Serializable & scala.Serializable)path -> {
                Builder.$anonfun$build$5(this, localDefConfigs, path);
                return BoxedUnit.UNIT;
            }, List$.MODULE$.canBuildFrom()) : BoxedUnit.UNIT;
            Object object4 = this.localOverrideDef().nonEmpty() ? this.localOverrideDef().map((Function1 & Serializable & scala.Serializable)confStr -> {
                Builder.$anonfun$build$7(this, localDefConfigs, confStr);
                return BoxedUnit.UNIT;
            }, List$.MODULE$.canBuildFrom()) : BoxedUnit.UNIT;
            featureDefConfigs.elem = (List)((List)featureDefConfigs.elem).$plus$plus(this.featureDefConfs(), List$.MODULE$.canBuildFrom());
            FeatureGroups featureGroups = FeatureGroupsGenerator$.MODULE$.apply((Seq<FeathrConfig>)((List)featureDefConfigs.elem), (Option<Seq<FeathrConfig>>)new Some((Object)((List)localDefConfigs.elem))).getFeatureGroups();
            FeathrClient feathrClient = new FeathrClient(this.sparkSession, featureGroups, MultiStageJoinPlanner$.MODULE$.apply(), FeatureGroupsUpdater$.MODULE$.apply(), this.dataPathHandlers(), this.mvelContext());
            return feathrClient;
        }

        public Option<String> readHdfsFile(Option<String> path) {
            return path.map((Function1 & Serializable & scala.Serializable)p -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.sparkSession.sparkContext().textFile(p, $this.sparkSession.sparkContext().textFile$default$2()).collect())).mkString("\n"));
        }

        public static final /* synthetic */ void $anonfun$build$3(Builder $this, ObjectRef featureDefConfigs$1, String cfg) {
            FeathrConfig feathrConfig = $this.feathrConfigLoader().load(cfg);
            featureDefConfigs$1.elem = ((List)featureDefConfigs$1.elem).$colon$colon((Object)feathrConfig);
        }

        public static final /* synthetic */ void $anonfun$build$2(Builder $this, ObjectRef featureDefConfigs$1, String path) {
            $this.readHdfsFile((Option<String>)new Some((Object)path)).foreach((Function1 & Serializable & scala.Serializable)cfg -> {
                Builder.$anonfun$build$3($this, featureDefConfigs$1, cfg);
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ void $anonfun$build$4(Builder $this, ObjectRef featureDefConfigs$1, String confStr) {
            FeathrConfig feathrConfig = $this.feathrConfigLoader().load(confStr);
            featureDefConfigs$1.elem = ((List)featureDefConfigs$1.elem).$colon$colon((Object)feathrConfig);
        }

        public static final /* synthetic */ void $anonfun$build$6(Builder $this, ObjectRef localDefConfigs$1, String cfg) {
            FeathrConfig feathrConfig = $this.feathrConfigLoader().load(cfg);
            localDefConfigs$1.elem = ((List)localDefConfigs$1.elem).$colon$colon((Object)feathrConfig);
        }

        public static final /* synthetic */ void $anonfun$build$5(Builder $this, ObjectRef localDefConfigs$1, String path) {
            $this.readHdfsFile((Option<String>)new Some((Object)path)).foreach((Function1 & Serializable & scala.Serializable)cfg -> {
                Builder.$anonfun$build$6($this, localDefConfigs$1, cfg);
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ void $anonfun$build$7(Builder $this, ObjectRef localDefConfigs$1, String confStr) {
            FeathrConfig feathrConfig = $this.feathrConfigLoader().load(confStr);
            localDefConfigs$1.elem = ((List)localDefConfigs$1.elem).$colon$colon((Object)feathrConfig);
        }

        public Builder(SparkSession sparkSession) {
            this.sparkSession = sparkSession;
            this.feathrConfigLoader = FeathrConfigLoader$.MODULE$.apply();
            this.featureDef = Nil$.MODULE$;
            this.localOverrideDef = Nil$.MODULE$;
            this.featureDefPath = Nil$.MODULE$;
            this.localOverrideDefPath = Nil$.MODULE$;
            this.featureDefConfs = Nil$.MODULE$;
            this.dataPathHandlers = Nil$.MODULE$;
            this.mvelContext = None$.MODULE$;
        }
    }
}

