/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.config;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.linkedin.feathr.common.FeatureTypes;
import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrConfigException;
import com.linkedin.feathr.offline.config.DerivedFeatureConfig;
import com.linkedin.feathr.offline.config.TaggedDependency;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001A2Qa\u0001\u0003\u0001\r9AQ!\b\u0001\u0005\u0002}AQ!\t\u0001\u0005B\t\u0012!\u0004R3sSZ,GMR3biV\u0014XmQ8oM&<Gj\\1eKJT!!\u0002\u0004\u0002\r\r|gNZ5h\u0015\t9\u0001\"A\u0004pM\u001ad\u0017N\\3\u000b\u0005%Q\u0011A\u00024fCRD'O\u0003\u0002\f\u0019\u0005AA.\u001b8lK\u0012LgNC\u0001\u000e\u0003\r\u0019w.\\\n\u0003\u0001=\u00012\u0001E\f\u001a\u001b\u0005\t\"B\u0001\n\u0014\u0003!!\u0017\r^1cS:$'B\u0001\u000b\u0016\u0003\u001dQ\u0017mY6t_:T!A\u0006\u0007\u0002\u0013\u0019\f7\u000f^3sq6d\u0017B\u0001\r\u0012\u0005AQ5o\u001c8EKN,'/[1mSj,'\u000f\u0005\u0002\u001b75\tA!\u0003\u0002\u001d\t\t!B)\u001a:jm\u0016$g)Z1ukJ,7i\u001c8gS\u001e\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002AA\u0011!\u0004A\u0001\fI\u0016\u001cXM]5bY&TX\rF\u0002\u001aG-BQ\u0001\n\u0002A\u0002\u0015\n\u0011\u0001\u001d\t\u0003M%j\u0011a\n\u0006\u0003QM\tAaY8sK&\u0011!f\n\u0002\u000b\u0015N|g\u000eU1sg\u0016\u0014\b\"\u0002\u0017\u0003\u0001\u0004i\u0013\u0001B2uqR\u0004\"\u0001\u0005\u0018\n\u0005=\n\"A\u0006#fg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8D_:$X\r\u001f;")
public class DerivedFeatureConfigLoader
extends JsonDeserializer<DerivedFeatureConfig> {
    public DerivedFeatureConfig deserialize(JsonParser p, DeserializationContext ctxt) {
        ObjectCodec codec = p.getCodec();
        ObjectNode node = (ObjectNode)codec.readTree(p);
        if (!node.has("key")) {
            throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, "Does not have key in complex derived function");
        }
        JsonNode keyNode = node.get("key");
        Seq key = keyNode.isArray() ? (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)codec.treeToValue((TreeNode)keyNode, java.util.List.class)).asScala() : (Seq)new .colon.colon((Object)keyNode.asText().trim(), (List)Nil$.MODULE$);
        JsonNode inputsNode = node.get("inputs");
        if (!inputsNode.isObject()) {
            throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(28).append("'inputs' of ").append(node).append(" should be a map").toString());
        }
        Map inputsObject = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(((ObjectNode)inputsNode).fields()).asScala()).map((Function1 & Serializable & scala.Serializable)item -> new Tuple2(item.getKey(), codec.treeToValue((TreeNode)item.getValue(), TaggedDependency.class))).toMap(Predef$.MODULE$.$conforms());
        JsonNode definitionNode = node.get("definition");
        JsonNode typeNode = node.get("type");
        None$ definition = !definitionNode.isObject() ? new Some((Object)definitionNode.textValue()) : None$.MODULE$;
        None$ sqlExpr = definitionNode.isObject() ? new Some((Object)definitionNode.get("sqlExpr").textValue()) : None$.MODULE$;
        FeatureTypes featureType = typeNode != null && !typeNode.isObject() ? FeatureTypes.valueOf(typeNode.textValue()) : FeatureTypes.UNSPECIFIED;
        return new DerivedFeatureConfig((Seq<String>)key, (Map<String, TaggedDependency>)inputsObject, (Option<String>)definition, (Option<String>)sqlExpr, featureType);
    }
}

