/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.config;

import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrConfigException;
import com.linkedin.feathr.offline.anchored.feature.FeatureAnchorWithSource;
import com.linkedin.feathr.offline.config.FeathrConfig;
import com.linkedin.feathr.offline.config.FeatureGroupsGenerator$;
import com.linkedin.feathr.offline.derived.DerivedFeature;
import com.linkedin.feathr.offline.derived.functions.SeqJoinDerivationFunction;
import com.linkedin.feathr.offline.logical.FeatureGroups;
import com.linkedin.feathr.offline.swa.SlidingWindowFeatureUtils$;
import java.io.Serializable;
import org.apache.log4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005eb!B\u000b\u0017\u0001a\u0001\u0003\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0015\t\u0011e\u0002!\u0011!Q\u0001\niBQ!\u0010\u0001\u0005\u0002yBqA\u0011\u0001C\u0002\u0013%1\t\u0003\u0004O\u0001\u0001\u0006I\u0001\u0012\u0005\b\u001f\u0002\u0011\r\u0011\"\u0003Q\u0011\u0019\t\u0006\u0001)A\u0005S!)!\u000b\u0001C\u0001'\")!\f\u0001C\u00057\")q\u000e\u0001C\u0005a\")\u0001\u0010\u0001C\u0005s\")A\u0010\u0001C\u0005{\"1q\u0010\u0001C\u0005\u0003\u00039\u0001\"a\u0002\u0017\u0011\u0003A\u0012\u0011\u0002\u0004\b+YA\t\u0001GA\u0006\u0011\u0019it\u0002\"\u0001\u0002\u000e!9\u0011qB\b\u0005\u0002\u0005E\u0001\"CA\u000e\u001fE\u0005I\u0011AA\u000f\u0011\u001d\tya\u0004C\u0001\u0003gA\u0011\"a\u000e\u0010#\u0003%\t!!\b\u0003-\u0019+\u0017\r^;sK\u001e\u0013x.\u001e9t\u000f\u0016tWM]1u_JT!a\u0006\r\u0002\r\r|gNZ5h\u0015\tI\"$A\u0004pM\u001ad\u0017N\\3\u000b\u0005ma\u0012A\u00024fCRD'O\u0003\u0002\u001e=\u0005AA.\u001b8lK\u0012LgNC\u0001 \u0003\r\u0019w.\\\n\u0003\u0001\u0005\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012a!\u00118z%\u00164\u0017!\u00054fCR,(/\u001a#fM\u000e{gNZ5hg\u000e\u0001\u0001c\u0001\u00163k9\u00111\u0006\r\b\u0003Y=j\u0011!\f\u0006\u0003]!\na\u0001\u0010:p_Rt\u0014\"\u0001\u0013\n\u0005E\u001a\u0013a\u00029bG.\fw-Z\u0005\u0003gQ\u00121aU3r\u0015\t\t4\u0005\u0005\u00027o5\ta#\u0003\u00029-\taa)Z1uQJ\u001cuN\u001c4jO\u00069Bn\\2bY>3XM\u001d:jI\u0016$UMZ\"p]\u001aLwm\u001d\t\u0004EmJ\u0013B\u0001\u001f$\u0005\u0019y\u0005\u000f^5p]\u00061A(\u001b8jiz\"2a\u0010!B!\t1\u0004\u0001C\u0003(\u0007\u0001\u0007\u0011\u0006C\u0004:\u0007A\u0005\t\u0019\u0001\u001e\u0002\u00071|w-F\u0001E!\t)E*D\u0001G\u0015\t9\u0005*A\u0003m_\u001e$$N\u0003\u0002J\u0015\u00061\u0011\r]1dQ\u0016T\u0011aS\u0001\u0004_J<\u0017BA'G\u0005\u0019aunZ4fe\u0006!An\\4!\u0003\u001d\u0019wN\u001c4jON,\u0012!K\u0001\tG>tg-[4tA\u0005\u0001r-\u001a;GK\u0006$XO]3He>,\bo\u001d\u000b\u0002)B\u0011Q\u000bW\u0007\u0002-*\u0011q\u000bG\u0001\bY><\u0017nY1m\u0013\tIfKA\u0007GK\u0006$XO]3He>,\bo]\u0001\u0017O\u0016$\u0018I\\2i_J,GMR3biV\u0014Xm]'baR\tA\f\u0005\u0003^C\u0012<gB\u00010`!\ta3%\u0003\u0002aG\u00051\u0001K]3eK\u001aL!AY2\u0003\u00075\u000b\u0007O\u0003\u0002aGA\u0011Q,Z\u0005\u0003M\u000e\u0014aa\u0015;sS:<\u0007C\u00015n\u001b\u0005I'B\u00016l\u0003\u001d1W-\u0019;ve\u0016T!\u0001\u001c\r\u0002\u0011\u0005t7\r[8sK\u0012L!A\\5\u0003/\u0019+\u0017\r^;sK\u0006s7\r[8s/&$\bnU8ve\u000e,\u0017!F4fi\u0012+'/\u001b<fI\u001a+\u0017\r^;sKNl\u0015\r\u001d\u000b\u0002cB!Q,\u00193s!\t\u0019h/D\u0001u\u0015\t)\b$A\u0004eKJLg/\u001a3\n\u0005]$(A\u0004#fe&4X\r\u001a$fCR,(/Z\u0001\u001aO\u0016$\b+Y:t)\"\u0014x.^4i\r\u0016\fG/\u001e:fg6\u000b\u0007\u000f\u0006\u0002]u\")1p\u0003a\u00019\u00061\u0012\r\u001c7B]\u000eDwN]3e\r\u0016\fG/\u001e:fg6\u000b\u0007/\u0001\u000bhKR<\u0016N\u001c3po\u001a+\u0017\r^;sKNl\u0015\r\u001d\u000b\u00039zDQa\u001f\u0007A\u0002q\u000bQcZ3u'\u0016\f(j\\5o\r\u0016\fG/\u001e:fg6\u000b\u0007\u000fF\u0002r\u0003\u0007Aa!!\u0002\u000e\u0001\u0004\t\u0018!F1mY\u0012+'/\u001b<fI\u001a+\u0017\r^;sKNl\u0015\r]\u0001\u0017\r\u0016\fG/\u001e:f\u000fJ|W\u000f]:HK:,'/\u0019;peB\u0011agD\n\u0003\u001f\u0005\"\"!!\u0003\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b}\n\u0019\"a\u0006\t\r\u0005U\u0011\u00031\u0001*\u0003E1W-\u0019;ve\u0016$UMZ2p]\u001aLwm\u001d\u0005\t\u00033\t\u0002\u0013!a\u0001u\u0005yAn\\2bY\u0012+gmQ8oM&<7/A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tyBK\u0002;\u0003CY#!a\t\u0011\t\u0005\u0015\u0012qF\u0007\u0003\u0003OQA!!\u000b\u0002,\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003[\u0019\u0013AC1o]>$\u0018\r^5p]&!\u0011\u0011GA\u0014\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u000b\u0004\u007f\u0005U\u0002BBA\u000b'\u0001\u0007\u0011&A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HE\r")
public class FeatureGroupsGenerator {
    private final Option<Seq<FeathrConfig>> localOverrideDefConfigs;
    private final Logger log;
    private final Seq<FeathrConfig> configs;

    public static Option<Seq<FeathrConfig>> $lessinit$greater$default$2() {
        return FeatureGroupsGenerator$.MODULE$.$lessinit$greater$default$2();
    }

    public static FeatureGroupsGenerator apply(Seq<FeathrConfig> seq) {
        return FeatureGroupsGenerator$.MODULE$.apply(seq);
    }

    public static Option<Seq<FeathrConfig>> apply$default$2() {
        return FeatureGroupsGenerator$.MODULE$.apply$default$2();
    }

    public static FeatureGroupsGenerator apply(Seq<FeathrConfig> seq, Option<Seq<FeathrConfig>> option) {
        return FeatureGroupsGenerator$.MODULE$.apply(seq, option);
    }

    private Logger log() {
        return this.log;
    }

    private Seq<FeathrConfig> configs() {
        return this.configs;
    }

    public FeatureGroups getFeatureGroups() {
        Map<String, FeatureAnchorWithSource> allAnchoredFeatures = this.getAnchoredFeaturesMap();
        Map<String, DerivedFeature> allDerivedFeatures = this.getDerivedFeaturesMap();
        Map<String, FeatureAnchorWithSource> allPassThroughFeatures = this.getPassThroughFeaturesMap(allAnchoredFeatures);
        Map<String, FeatureAnchorWithSource> allWindowAggFeatures = this.getWindowFeaturesMap(allAnchoredFeatures);
        Map<String, DerivedFeature> allSeqJoinFeatures = this.getSeqJoinFeaturesMap(allDerivedFeatures);
        return new FeatureGroups(allAnchoredFeatures, allDerivedFeatures, allWindowAggFeatures, allPassThroughFeatures, allSeqJoinFeatures);
    }

    private Map<String, FeatureAnchorWithSource> getAnchoredFeaturesMap() {
        HashMap result;
        block0: {
            result = HashMap$.MODULE$.empty();
            HashSet localOverrideAnchorFeatureNames = HashSet$.MODULE$.empty();
            ((IterableLike)this.configs().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.anchoredFeatures(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)m -> {
                m.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    FeatureAnchorWithSource v;
                    String k;
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        k = (String)tuple2._1();
                        v = (FeatureAnchorWithSource)tuple2._2();
                        Option exist = result$1.get((Object)k);
                        if (exist.isDefined()) {
                            throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(118).append("We detected a duplicate Anchor feature '").append(k).append("' in your feature def config. Please remove one of them or rename the feature.").toString());
                        }
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    Option option = result$1.put((Object)k, (Object)v);
                    return option;
                });
                return BoxedUnit.UNIT;
            });
            if (this.localOverrideDefConfigs.isEmpty()) break block0;
            ((IterableLike)((TraversableLike)this.localOverrideDefConfigs.get()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.anchoredFeatures(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)m -> {
                m.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    FeatureAnchorWithSource v;
                    String k;
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        k = (String)tuple2._1();
                        v = (FeatureAnchorWithSource)tuple2._2();
                        if (localOverrideAnchorFeatureNames$1.contains((Object)k)) {
                            throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(125).append("We detected a duplicate Anchor feature '").append(k).append("' in your local override def config. Please remove one of them or rename the feature.").toString());
                        }
                        localOverrideAnchorFeatureNames$1.add((Object)k);
                        Option exist = result$1.get((Object)k);
                        if (exist.isDefined()) {
                            $this.log().info((Object)new StringBuilder(43).append("Anchor feature '").append(k).append("' is being overridden by '").append(exist.get()).append("'").toString());
                        }
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    Option option = result$1.put((Object)k, (Object)v);
                    return option;
                });
                return BoxedUnit.UNIT;
            });
        }
        return result.toMap(Predef$.MODULE$.$conforms());
    }

    private Map<String, DerivedFeature> getDerivedFeaturesMap() {
        HashMap result;
        block0: {
            result = HashMap$.MODULE$.empty();
            HashSet localOverrideDerivedFeatureNames = HashSet$.MODULE$.empty();
            ((IterableLike)this.configs().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.derivedFeatures(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)m -> {
                m.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    DerivedFeature v;
                    String k;
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        k = (String)tuple2._1();
                        v = (DerivedFeature)tuple2._2();
                        Option exist = result$2.get((Object)k);
                        if (exist.isDefined()) {
                            throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(119).append("We detected a duplicate derived feature '").append(k).append("' in your feature def config. Please remove one of them or rename the feature.").toString());
                        }
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    Option option = result$2.put((Object)k, (Object)v);
                    return option;
                });
                return BoxedUnit.UNIT;
            });
            if (this.localOverrideDefConfigs.isEmpty()) break block0;
            ((IterableLike)((TraversableLike)this.localOverrideDefConfigs.get()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.derivedFeatures(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)m -> {
                m.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    DerivedFeature v;
                    String k;
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        k = (String)tuple2._1();
                        v = (DerivedFeature)tuple2._2();
                        if (localOverrideDerivedFeatureNames$1.contains((Object)k)) {
                            throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(126).append("We detected a duplicate derived feature '").append(k).append("' in your local override def config. Please remove one of them or rename the feature.").toString());
                        }
                        localOverrideDerivedFeatureNames$1.add((Object)k);
                        Option exist = result$2.get((Object)k);
                        if (exist.isDefined()) {
                            $this.log().info((Object)new StringBuilder(44).append("Derived feature '").append(k).append("' is being overridden by '").append(exist.get()).append("'").toString());
                        }
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    Option option = result$2.put((Object)k, (Object)v);
                    return option;
                });
                return BoxedUnit.UNIT;
            });
        }
        return result.toMap(Predef$.MODULE$.$conforms());
    }

    private Map<String, FeatureAnchorWithSource> getPassThroughFeaturesMap(Map<String, FeatureAnchorWithSource> allAnchoredFeaturesMap) {
        return (Map)allAnchoredFeaturesMap.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)FeatureGroupsGenerator.$anonfun$getPassThroughFeaturesMap$1(x0$1)));
    }

    private Map<String, FeatureAnchorWithSource> getWindowFeaturesMap(Map<String, FeatureAnchorWithSource> allAnchoredFeaturesMap) {
        return (Map)allAnchoredFeaturesMap.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)FeatureGroupsGenerator.$anonfun$getWindowFeaturesMap$1(x0$1)));
    }

    private Map<String, DerivedFeature> getSeqJoinFeaturesMap(Map<String, DerivedFeature> allDerivedFeaturesMap) {
        return (Map)allDerivedFeaturesMap.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)FeatureGroupsGenerator.$anonfun$getSeqJoinFeaturesMap$1(x0$1)));
    }

    public static final /* synthetic */ boolean $anonfun$getPassThroughFeaturesMap$1(Tuple2 x0$1) {
        FeatureAnchorWithSource anchorConfig;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = x0$1;
                if (tuple2 == null) break block2;
                anchorConfig = (FeatureAnchorWithSource)tuple2._2();
                if (tuple2._1() != null && anchorConfig != null) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        FeatureAnchorWithSource featureAnchorWithSource = anchorConfig;
        String string = featureAnchorWithSource.source().path();
        String string2 = "PASSTHROUGH";
        boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getWindowFeaturesMap$1(Tuple2 x0$1) {
        FeatureAnchorWithSource anchorConfig;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = x0$1;
                if (tuple2 == null) break block2;
                String featureName = (String)tuple2._1();
                anchorConfig = (FeatureAnchorWithSource)tuple2._2();
                if (featureName != null && anchorConfig != null) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        FeatureAnchorWithSource featureAnchorWithSource = anchorConfig;
        boolean bl = SlidingWindowFeatureUtils$.MODULE$.isWindowAggAnchor(featureAnchorWithSource);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getSeqJoinFeaturesMap$1(Tuple2 x0$1) {
        DerivedFeature featureObj;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null || (featureObj = (DerivedFeature)tuple2._2()) == null) {
            throw new MatchError((Object)tuple2);
        }
        DerivedFeature derivedFeature = featureObj;
        boolean bl = derivedFeature.derivation() instanceof SeqJoinDerivationFunction;
        return bl;
    }

    public FeatureGroupsGenerator(Seq<FeathrConfig> featureDefConfigs, Option<Seq<FeathrConfig>> localOverrideDefConfigs) {
        this.localOverrideDefConfigs = localOverrideDefConfigs;
        this.log = Logger.getLogger(this.getClass());
        this.configs = featureDefConfigs.isEmpty() ? (Seq)localOverrideDefConfigs.get() : featureDefConfigs;
    }
}

