/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.generation.outputProcessor;

import com.linkedin.feathr.common.Header;
import com.linkedin.feathr.common.TaggedFeatureName;
import com.linkedin.feathr.common.configObj.generation.OutputProcessorConfig;
import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrDataOutputException;
import com.linkedin.feathr.common.exception.FeathrException;
import com.linkedin.feathr.common.package$;
import com.linkedin.feathr.offline.config.location.DataLocation;
import com.linkedin.feathr.offline.config.location.DataLocation$;
import com.linkedin.feathr.offline.generation.FeatureDataHDFSProcessUtils$;
import com.linkedin.feathr.offline.generation.FeatureGenerationPathName$;
import com.linkedin.feathr.offline.generation.outputProcessor.WriteToHDFSOutputProcessor$;
import com.linkedin.feathr.offline.source.dataloader.DataLoaderHandler;
import com.linkedin.feathr.offline.util.FeatureGenConstants$;
import com.linkedin.feathr.offline.util.IncrementalAggUtils$;
import com.linkedin.feathr.offline.util.Transformations$;
import com.linkedin.feathr.sparkcommon.OutputProcessor;
import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]e!\u0002\n\u0014\u0001]y\u0002\u0002\u0003\u0014\u0001\u0005\u000b\u0007I\u0011\u0001\u0015\t\u0013I\u0002!\u0011!Q\u0001\n%\u001a\u0004\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001c\t\u0011\u001d\u0003!\u0011!Q\u0001\n!CQ!\u0017\u0001\u0005\u0002iCQ\u0001\u0019\u0001\u0005B\u0005Dq!a\u0007\u0001\t\u0013\ti\u0002C\u0004\u0002(\u0001!\t%!\u000b\t\u0013\u0005e\u0002A1A\u0005\n\u0005m\u0002\u0002CA&\u0001\u0001\u0006I!!\u0010\t\u0013\u00055\u0003A1A\u0005\n\u0005=\u0003\u0002CA0\u0001\u0001\u0006I!!\u0015\b\u0015\u0005\u00054#!A\t\u0002]\t\u0019GB\u0005\u0013'\u0005\u0005\t\u0012A\f\u0002f!1\u0011L\u0004C\u0001\u0003gB\u0011\"!\u001e\u000f#\u0003%\t!a\u001e\t\u0013\u00055e\"!A\u0005\n\u0005=%AG,sSR,Gk\u001c%E\rN{U\u000f\u001e9viB\u0013xnY3tg>\u0014(B\u0001\u000b\u0016\u0003=yW\u000f\u001e9viB\u0013xnY3tg>\u0014(B\u0001\f\u0018\u0003)9WM\\3sCRLwN\u001c\u0006\u00031e\tqa\u001c4gY&tWM\u0003\u0002\u001b7\u00051a-Z1uQJT!\u0001H\u000f\u0002\u00111Lgn[3eS:T\u0011AH\u0001\u0004G>l7C\u0001\u0001!!\t\tC%D\u0001#\u0015\t\u0019\u0013$A\u0006ta\u0006\u00148nY8n[>t\u0017BA\u0013#\u0005=yU\u000f\u001e9viB\u0013xnY3tg>\u0014\u0018AB2p]\u001aLwm\u0001\u0001\u0016\u0003%\u0002\"A\u000b\u0019\u000e\u0003-R!A\u0006\u0017\u000b\u00055r\u0013!C2p]\u001aLwm\u00142k\u0015\ty\u0013$\u0001\u0004d_6lwN\\\u0005\u0003c-\u0012QcT;uaV$\bK]8dKN\u001cxN]\"p]\u001aLw-A\u0004d_:4\u0017n\u001a\u0011\n\u0005Q\"\u0013!F8viB,H\u000f\u0015:pG\u0016\u001c8o\u001c:D_:4\u0017nZ\u0001\u000bK:$G+[7f\u001fB$\bcA\u001c;y5\t\u0001HC\u0001:\u0003\u0015\u00198-\u00197b\u0013\tY\u0004H\u0001\u0004PaRLwN\u001c\t\u0003{\u0011s!A\u0010\"\u0011\u0005}BT\"\u0001!\u000b\u0005\u0005;\u0013A\u0002\u001fs_>$h(\u0003\u0002Dq\u00051\u0001K]3eK\u001aL!!\u0012$\u0003\rM#(/\u001b8h\u0015\t\u0019\u0005(\u0001\neCR\fGj\\1eKJD\u0015M\u001c3mKJ\u001c\bcA%O#:\u0011!\n\u0014\b\u0003\u007f-K\u0011!O\u0005\u0003\u001bb\nq\u0001]1dW\u0006<W-\u0003\u0002P!\n!A*[:u\u0015\ti\u0005\b\u0005\u0002S/6\t1K\u0003\u0002U+\u0006QA-\u0019;bY>\fG-\u001a:\u000b\u0005Y;\u0012AB:pkJ\u001cW-\u0003\u0002Y'\n\tB)\u0019;b\u0019>\fG-\u001a:IC:$G.\u001a:\u0002\rqJg.\u001b;?)\u0011YVLX0\u0011\u0005q\u0003Q\"A\n\t\u000b\u0019*\u0001\u0019A\u0015\t\u000fU*\u0001\u0013!a\u0001m!)q)\u0002a\u0001\u0011\u0006Q\u0001O]8dKN\u001c\u0018\t\u001c7\u0015\u000b\t\fY!a\u0006\u0011\tu\u001aW-[\u0005\u0003I\u001a\u00131!T1q!\t1w-D\u0001/\u0013\tAgFA\tUC\u001e<W\r\u001a$fCR,(/\u001a(b[\u0016\u0004Ra\u000e6m\u0003\u000bI!a\u001b\u001d\u0003\rQ+\b\u000f\\33!\tiwP\u0004\u0002o{:\u0011qN\u001f\b\u0003a^t!!\u001d;\u000f\u0005}\u0012\u0018\"A:\u0002\u0007=\u0014x-\u0003\u0002vm\u00061\u0011\r]1dQ\u0016T\u0011a]\u0005\u0003qf\fQa\u001d9be.T!!\u001e<\n\u0005md\u0018aA:rY*\u0011\u00010_\u0005\u0003\u001bzT!a\u001f?\n\t\u0005\u0005\u00111\u0001\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T!!\u0014@\u0011\u0007\u0019\f9!C\u0002\u0002\n9\u0012a\u0001S3bI\u0016\u0014\bbBA\u0007\r\u0001\u0007\u0011qB\u0001\u0003gN\u0004B!!\u0005\u0002\u00145\ta0C\u0002\u0002\u0016y\u0014Ab\u00159be.\u001cVm]:j_:Da!!\u0007\u0007\u0001\u0004\u0011\u0017a\u00034fCR,(/\u001a#bi\u0006\f\u0001\u0003\u001d:pG\u0016\u001c8/\u00117m\u0011\u0016d\u0007/\u001a:\u0015\u000f\t\fy\"!\t\u0002$!9\u0011QB\u0004A\u0002\u0005=\u0001BBA\r\u000f\u0001\u0007!\r\u0003\u0004\u0002&\u001d\u0001\r\u0001P\u0001\u000f_V$\b/\u001e;CCN,\u0007+\u0019;i\u00035\u0001(o\\2fgN\u001c\u0016N\\4mKRI\u0011.a\u000b\u0002.\u0005E\u0012Q\u0007\u0005\b\u0003\u001bA\u0001\u0019AA\b\u0011\u0019\ty\u0003\u0003a\u0001Y\u0006\u0011AM\u001a\u0005\b\u0003gA\u0001\u0019AA\u0003\u0003\u0019AW-\u00193fe\"1\u0011q\u0007\u0005A\u0002q\n!\u0002]1sK:$\b+\u0019;i\u0003!awnY1uS>tWCAA\u001f!\u00119$(a\u0010\u0011\t\u0005\u0005\u0013qI\u0007\u0003\u0003\u0007RA!!\u000f\u0002F)\u0011aeF\u0005\u0005\u0003\u0013\n\u0019E\u0001\u0007ECR\fGj\\2bi&|g.A\u0005m_\u000e\fG/[8oA\u0005!\u0001+\u0011+I+\t\t\t\u0006\u0005\u0003\u0002T\u0005uSBAA+\u0015\u0011\t9&!\u0017\u0002\t1\fgn\u001a\u0006\u0003\u00037\nAA[1wC&\u0019Q)!\u0016\u0002\u000bA\u000bE\u000b\u0013\u0011\u00025]\u0013\u0018\u000e^3U_\"#eiU(viB,H\u000f\u0015:pG\u0016\u001c8o\u001c:\u0011\u0005qs1#\u0002\b\u0002h\u00055\u0004cA\u001c\u0002j%\u0019\u00111\u000e\u001d\u0003\r\u0005s\u0017PU3g!\r9\u0014qN\u0005\u0004\u0003cB$\u0001D*fe&\fG.\u001b>bE2,GCAA2\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u0010\u0016\u0004m\u0005m4FAA?!\u0011\ty(!#\u000e\u0005\u0005\u0005%\u0002BAB\u0003\u000b\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001d\u0005(\u0001\u0006b]:|G/\u0019;j_:LA!a#\u0002\u0002\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003#\u0003B!a\u0015\u0002\u0014&!\u0011QSA+\u0005\u0019y%M[3di\u0002")
public class WriteToHDFSOutputProcessor
extends OutputProcessor {
    private final Option<String> endTimeOpt;
    private final List<DataLoaderHandler> dataLoaderHandlers;
    private final Option<DataLocation> location;
    private final String PATH;

    public static Option<String> $lessinit$greater$default$2() {
        return WriteToHDFSOutputProcessor$.MODULE$.$lessinit$greater$default$2();
    }

    public OutputProcessorConfig config() {
        return super.outputProcessorConfig();
    }

    @Override
    public Map<TaggedFeatureName, Tuple2<Dataset<Row>, Header>> processAll(SparkSession ss, Map<TaggedFeatureName, Tuple2<Dataset<Row>, Header>> featureData) {
        String basePath = (String)package$.MODULE$.RichConfig(this.config().getParams()).getStringOpt(this.PATH()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        Map<TaggedFeatureName, Tuple2<Dataset<Row>, Header>> result = this.processAllHelper(ss, featureData, basePath);
        return result;
    }

    private Map<TaggedFeatureName, Tuple2<Dataset<Row>, Header>> processAllHelper(SparkSession ss, Map<TaggedFeatureName, Tuple2<Dataset<Row>, Header>> featureData, String outputBasePath) {
        Map map;
        Seq allFeatureList = ((SetLike)featureData.keySet().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getFeatureName(), Set$.MODULE$.canBuildFrom())).toSeq();
        Option<Seq<String>> featureListToJoin = package$.MODULE$.RichConfig(this.config().getParams()).getStringListOpt(FeatureGenerationPathName$.MODULE$.FEATURES());
        Option<String> storeName = package$.MODULE$.RichConfig(this.config().getParams()).getStringOpt(FeatureGenerationPathName$.MODULE$.STORE_NAME());
        if (featureListToJoin.isDefined()) {
            Seq selectedFeatureNames = (Seq)featureListToJoin.getOrElse((Function0 & Serializable & scala.Serializable)() -> allFeatureList);
            Map selectedFeatureData = (Map)featureData.filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)selectedFeatureNames.contains((Object)((TaggedFeatureName)f._1()).getFeatureName())));
            Map groupedFeatureData = selectedFeatureData.groupBy((Function1 & Serializable & scala.Serializable)x$2 -> (Dataset)((Tuple2)x$2._2())._1());
            if (groupedFeatureData.size() != 1) {
                throw new FeathrException(ErrorLabel.FEATHR_ERROR, "Output processing failed! Features are not grouped together. Please contact ask_feathr.");
            }
            Map joinedFeatureData = (Map)((Tuple2)groupedFeatureData.head())._2();
            Dataset df = (Dataset)((Tuple2)((Tuple2)joinedFeatureData.head())._2())._1();
            Header header = (Header)((Tuple2)((Tuple2)joinedFeatureData.head())._2())._2();
            String folderName = (String)storeName.getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            String parentPath = new StringBuilder(1).append(outputBasePath).append("/").append(folderName).toString();
            Tuple2<Dataset<Row>, Header> tuple2 = this.processSingle(ss, (Dataset<Row>)df, header, parentPath);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Dataset processedDF = (Dataset)tuple2._1();
            Header processedHeader = (Header)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)processedDF, (Object)processedHeader);
            Tuple2 tuple23 = tuple22;
            Dataset processedDF2 = (Dataset)tuple23._1();
            Header processedHeader2 = (Header)tuple23._2();
            map = selectedFeatureData.mapValues((Function1 & Serializable & scala.Serializable)x$4 -> new Tuple2((Object)processedDF2, (Object)processedHeader2));
        } else {
            Iterable result = (Iterable)((TraversableLike)featureData.groupBy((Function1 & Serializable & scala.Serializable)x$5 -> (Dataset)((Tuple2)x$5._2())._1()).zipWithIndex(Map$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Header header;
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                if (tuple22 == null) throw new MatchError((Object)tuple2);
                Map groupedFeatureToDF = (Map)tuple22._2();
                String folderName = (String)storeName.getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(2).append("df").append(idx).toString());
                String parentPath = new StringBuilder(1).append(outputBasePath).append("/").append(folderName).toString();
                Dataset df = (Dataset)((Tuple2)((Tuple2)groupedFeatureToDF.head())._2())._1();
                Tuple2<Dataset<Row>, Header> tuple23 = this.processSingle(ss, (Dataset<Row>)df, header = (Header)((Tuple2)((Tuple2)groupedFeatureToDF.head())._2())._2(), parentPath);
                if (tuple23 == null) throw new MatchError(tuple23);
                Dataset processedDF = (Dataset)tuple23._1();
                Header processedHeader = (Header)tuple23._2();
                Tuple2 tuple24 = new Tuple2((Object)processedDF, (Object)processedHeader);
                Tuple2 tuple25 = tuple24;
                Dataset processedDF2 = (Dataset)tuple25._1();
                Header processedHeader2 = (Header)tuple25._2();
                return header.featureInfoMap().mapValues((Function1 & Serializable & scala.Serializable)x$7 -> new Tuple2((Object)processedDF2, (Object)processedHeader2));
            }, Iterable$.MODULE$.canBuildFrom());
            map = (Map)result.reduceLeft((Function2 & Serializable & scala.Serializable)(x$8, x$9) -> x$8.$plus$plus((GenTraversableOnce)x$9));
        }
        return map;
    }

    @Override
    public Tuple2<Dataset<Row>, Header> processSingle(SparkSession ss, Dataset<Row> df2, Header header, String parentPath) {
        Tuple2 tuple2;
        None$ none$;
        Dataset orderedDf = df2.transform((Function1 & Serializable & scala.Serializable)df -> Transformations$.MODULE$.sortColumns("asc", (Dataset<Row>)df));
        Set taggedFeatureNames = header.featureInfoMap().keySet();
        boolean outputWithTimestamp = package$.MODULE$.RichConfig(this.config().getParams()).getBooleanWithDefault(FeatureGenConstants$.MODULE$.OUTPUT_WITH_TIMESTAMP(), false);
        String outputTimestampFormat = package$.MODULE$.RichConfig(this.config().getParams()).getStringWithDefault(FeatureGenConstants$.MODULE$.OUTPUT_TIMESTAMP_FORMAT(), FeatureGenConstants$.MODULE$.DEFAULT_OUTPUT_TIMESTAMP_FORMAT());
        if (outputWithTimestamp) {
            if (this.endTimeOpt.isEmpty()) {
                throw new FeathrDataOutputException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(73).append("endTime is not provided. endTime should be provided when ").append(FeatureGenConstants$.MODULE$.OUTPUT_WITH_TIMESTAMP()).append(" is set to true.").toString());
            }
            none$ = new Some((Object)IncrementalAggUtils$.MODULE$.transformDateString((String)this.endTimeOpt.get(), FeatureGenConstants$.MODULE$.END_TIME_FORMAT(), outputTimestampFormat));
        } else {
            none$ = None$.MODULE$;
        }
        None$ timestampOpt = none$;
        Dataset augmentedDF = outputWithTimestamp ? orderedDf.withColumn(FeatureGenConstants$.MODULE$.FEATHR_AUTO_GEN_TIMESTAMP_FIELD(), functions$.MODULE$.lit(timestampOpt.get())) : orderedDf;
        Map featuresToDF = ((TraversableOnce)taggedFeatureNames.map((Function1 & Serializable & scala.Serializable)featureToDF -> new Tuple2(featureToDF, (Object)new Tuple2((Object)augmentedDF, (Object)header)), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        boolean skipWrite = ss.sparkContext().isLocal();
        Option<DataLocation> option = this.location();
        if (option instanceof Some) {
            Some some = (Some)option;
            DataLocation l = (DataLocation)some.value();
            l.writeDf(ss, (Dataset<Row>)augmentedDF, (Option<Header>)new Some((Object)header));
            tuple2 = new Tuple2((Object)augmentedDF, (Object)header);
        } else if (None$.MODULE$.equals(option)) {
            tuple2 = FeatureDataHDFSProcessUtils$.MODULE$.processFeatureDataHDFS(ss, (Map<TaggedFeatureName, Tuple2<Dataset<Row>, Header>>)featuresToDF, parentPath, this.config(), skipWrite, this.endTimeOpt, (Option<String>)timestampOpt, this.dataLoaderHandlers);
        } else {
            throw new MatchError(option);
        }
        return tuple2;
    }

    private Option<DataLocation> location() {
        return this.location;
    }

    private String PATH() {
        return this.PATH;
    }

    public WriteToHDFSOutputProcessor(OutputProcessorConfig config, Option<String> endTimeOpt, List<DataLoaderHandler> dataLoaderHandlers) {
        this.endTimeOpt = endTimeOpt;
        this.dataLoaderHandlers = dataLoaderHandlers;
        super(config, (Option<String>)None$.MODULE$);
        this.location = !package$.MODULE$.RichConfig(config.getParams()).getStringWithDefault("type", "").isEmpty() ? new Some((Object)DataLocation$.MODULE$.apply(config.getParams())) : None$.MODULE$;
        this.PATH = "path";
    }
}

