/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.graph;

import com.linkedin.feathr.common.FeatureTypeConfig;
import com.linkedin.feathr.compute.AnyNode;
import com.linkedin.feathr.compute.ComputeGraph;
import com.linkedin.feathr.compute.Dependencies;
import com.linkedin.feathr.offline.FeatureDataFrame;
import com.linkedin.feathr.offline.client.IN_PROGRESS$;
import com.linkedin.feathr.offline.client.NOT_VISITED$;
import com.linkedin.feathr.offline.client.VISITED$;
import com.linkedin.feathr.offline.client.VisitedState;
import com.linkedin.feathr.offline.config.FeatureJoinConfig;
import com.linkedin.feathr.offline.evaluator.aggregation.AggregationNodeEvaluator$;
import com.linkedin.feathr.offline.evaluator.datasource.DataSourceNodeEvaluator$;
import com.linkedin.feathr.offline.evaluator.lookup.LookupNodeEvaluator$;
import com.linkedin.feathr.offline.evaluator.transformation.TransformationNodeEvaluator$;
import com.linkedin.feathr.offline.graph.DataframeAndColumnMetadata;
import com.linkedin.feathr.offline.graph.NodeGrouper$;
import com.linkedin.feathr.offline.graph.NodeUtils$;
import com.linkedin.feathr.offline.graph.TimeConfigSettings;
import com.linkedin.feathr.offline.job.FeatureTransformation$;
import com.linkedin.feathr.offline.mvel.plugins.FeathrExpressionExecutionContext;
import com.linkedin.feathr.offline.source.accessor.DataPathHandler;
import com.linkedin.feathr.offline.swa.SlidingWindowFeatureUtils$;
import com.linkedin.feathr.offline.transformation.FeatureColumnFormat$;
import com.linkedin.feathr.offline.util.datetime.DateTimeInterval;
import java.io.Serializable;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Stack;
import scala.collection.mutable.Stack$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005eh\u0001\u0002\u000f\u001e\u0001!B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\ty\u0001\u0011\t\u0011)A\u0005{!A1\t\u0001B\u0001B\u0003%A\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0011!i\u0006A!A!\u0002\u0013q\u0006\u0002\u00038\u0001\u0005\u0003\u0005\u000b\u0011B8\t\u000bi\u0004A\u0011A>\t\u0013\u0005%\u0001A1A\u0005\n\u0005-\u0001\u0002CA\r\u0001\u0001\u0006I!!\u0004\t\u0013\u0005m\u0001A1A\u0005\u0002\u0005u\u0001\u0002CA\u001e\u0001\u0001\u0006I!a\b\t\u0013\u0005u\u0002A1A\u0005\u0002\u0005}\u0002\u0002CA=\u0001\u0001\u0006I!!\u0011\t\u0013\u0005m\u0004A1A\u0005\u0002\u0005u\u0004\u0002CAF\u0001\u0001\u0006I!a \t\u0013\u00055\u0005A1A\u0005\u0002\u0005=\u0005\u0002CAT\u0001\u0001\u0006I!!%\t\u0013\u0005%\u0006A1A\u0005\u0002\u0005-\u0006bBAW\u0001\u0001\u0006Ia\u001c\u0005\n\u0003_\u0003!\u0019!C\u0001\u0003cC\u0001\"!/\u0001A\u0003%\u00111\u0017\u0005\n\u0003w\u0003!\u0019!C\u0001\u0003{Cq!a0\u0001A\u0003%\u0001\u0007C\u0004\u0002B\u0002!I!!-\t\u000f\u0005\r\u0007\u0001\"\u0003\u0002F\"9\u0011\u0011\u001a\u0001\u0005\n\u0005-\u0007bBAw\u0001\u0011\u0005\u0011q\u001e\u0002\u0012\r\u000ekuI]1qQR\u0013\u0018M^3sg\u0016\u0014(B\u0001\u0010 \u0003\u00159'/\u00199i\u0015\t\u0001\u0013%A\u0004pM\u001ad\u0017N\\3\u000b\u0005\t\u001a\u0013A\u00024fCRD'O\u0003\u0002%K\u0005AA.\u001b8lK\u0012LgNC\u0001'\u0003\r\u0019w.\\\u0002\u0001'\t\u0001\u0011\u0006\u0005\u0002+[5\t1FC\u0001-\u0003\u0015\u00198-\u00197b\u0013\tq3F\u0001\u0004B]f\u0014VMZ\u0001\u0012S:\u0004X\u000f^*qCJ\\7+Z:tS>t\u0007CA\u0019;\u001b\u0005\u0011$BA\u001a5\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003kY\nQa\u001d9be.T!a\u000e\u001d\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0014aA8sO&\u00111H\r\u0002\r'B\f'o[*fgNLwN\\\u0001\u0012M\u0016\fG/\u001e:f\u0015>LgnQ8oM&<\u0007C\u0001 B\u001b\u0005y$B\u0001! \u0003\u0019\u0019wN\u001c4jO&\u0011!i\u0010\u0002\u0012\r\u0016\fG/\u001e:f\u0015>LgnQ8oM&<\u0017!\u0004:fg>dg/\u001a3He\u0006\u0004\b\u000e\u0005\u0002F\u00116\taI\u0003\u0002HC\u000591m\\7qkR,\u0017BA%G\u00051\u0019u.\u001c9vi\u0016<%/\u00199i\u00035y'm]3sm\u0006$\u0018n\u001c8EMB\u0011AJ\u0017\b\u0003\u001bbs!AT,\u000f\u0005=3fB\u0001)V\u001d\t\tF+D\u0001S\u0015\t\u0019v%\u0001\u0004=e>|GOP\u0005\u0002s%\u0011q\u0007O\u0005\u0003kYJ!a\r\u001b\n\u0005e\u0013\u0014a\u00029bG.\fw-Z\u0005\u00037r\u0013\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005e\u0013\u0014\u0001\u00053bi\u0006\u0004\u0016\r\u001e5IC:$G.\u001a:t!\ry6M\u001a\b\u0003A\nt!!U1\n\u00031J!!W\u0016\n\u0005\u0011,'\u0001\u0002'jgRT!!W\u0016\u0011\u0005\u001ddW\"\u00015\u000b\u0005%T\u0017\u0001C1dG\u0016\u001c8o\u001c:\u000b\u0005-|\u0012AB:pkJ\u001cW-\u0003\u0002nQ\nyA)\u0019;b!\u0006$\b\u000eS1oI2,'/A\u0006nm\u0016d7i\u001c8uKb$\bc\u0001\u0016qe&\u0011\u0011o\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005MDX\"\u0001;\u000b\u0005U4\u0018a\u00029mk\u001eLgn\u001d\u0006\u0003o~\tA!\u001c<fY&\u0011\u0011\u0010\u001e\u0002!\r\u0016\fG\u000f\u001b:FqB\u0014Xm]:j_:,\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\fyz|\u0018\u0011AA\u0002\u0003\u000b\t9\u0001\u0005\u0002~\u00015\tQ\u0004C\u00030\u000f\u0001\u0007\u0001\u0007C\u0003=\u000f\u0001\u0007Q\bC\u0003D\u000f\u0001\u0007A\tC\u0003K\u000f\u0001\u00071\nC\u0003^\u000f\u0001\u0007a\fC\u0003o\u000f\u0001\u0007q.A\u0002m_\u001e,\"!!\u0004\u0011\t\u0005=\u0011QC\u0007\u0003\u0003#Q1!a\u00057\u0003\u0015awn\u001a\u001bk\u0013\u0011\t9\"!\u0005\u0003\r1{wmZ3s\u0003\u0011awn\u001a\u0011\u0002K9|G-Z%e)>$\u0015\r^1ge\u0006lW-\u00118e\u0007>dW/\u001c8NKR\fG-\u0019;b\u001b\u0006\u0004XCAA\u0010!!\t\t#a\u000b\u00020\u0005URBAA\u0012\u0015\u0011\t)#a\n\u0002\u000f5,H/\u00192mK*\u0019\u0011\u0011F\u0016\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002.\u0005\r\"a\u0002%bg\"l\u0015\r\u001d\t\u0004U\u0005E\u0012bAA\u001aW\t\u0019\u0011J\u001c;\u0011\u0007u\f9$C\u0002\u0002:u\u0011!\u0004R1uC\u001a\u0014\u0018-\\3B]\u0012\u001cu\u000e\\;n]6+G/\u00193bi\u0006\faE\\8eK&#Gk\u001c#bi\u00064'/Y7f\u0003:$7i\u001c7v[:lU\r^1eCR\fW*\u00199!\u0003]1W-\u0019;ve\u0016\u001cu\u000e\\;n]\u001a{'/\\1ug6\u000b\u0007/\u0006\u0002\u0002BAA\u0011\u0011EA\u0016\u0003\u0007\n\u0019\u0006\u0005\u0003\u0002F\u00055c\u0002BA$\u0003\u0013\u0002\"!U\u0016\n\u0007\u0005-3&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001f\n\tF\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0017Z\u0003\u0003BA+\u0003grA!a\u0016\u0002n9!\u0011\u0011LA5\u001d\u0011\tY&a\u001a\u000f\t\u0005u\u0013Q\r\b\u0005\u0003?\n\u0019GD\u0002R\u0003CJ\u0011AJ\u0005\u0003I\u0015J!AI\u0012\n\u0005\u0001\n\u0013bAA6?\u0005qAO]1og\u001a|'/\\1uS>t\u0017\u0002BA8\u0003c\n1CR3biV\u0014XmQ8mk6tgi\u001c:nCRT1!a\u001b \u0013\u0011\t)(a\u001e\u0003'\u0019+\u0017\r^;sK\u000e{G.^7o\r>\u0014X.\u0019;\u000b\t\u0005=\u0014\u0011O\u0001\u0019M\u0016\fG/\u001e:f\u0007>dW/\u001c8G_Jl\u0017\r^:NCB\u0004\u0013!\u00028pI\u0016\u001cXCAA@!\u0019\t\t#!!\u0002\u0006&!\u00111QA\u0012\u0005\u0019\u0011UO\u001a4feB\u0019Q)a\"\n\u0007\u0005%eIA\u0004B]ftu\u000eZ3\u0002\r9|G-Z:!\u0003Mqw\u000eZ3JIR{g)Z1ukJ,g*Y7f+\t\t\t\n\u0005\u0005\u0002F\u0005M\u0015qSA\"\u0013\u0011\t)*!\u0015\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002\u001a\u0006\rVBAAN\u0015\u0011\ti*a(\u0002\t1\fgn\u001a\u0006\u0003\u0003C\u000bAA[1wC&!\u0011QUAN\u0005\u001dIe\u000e^3hKJ\fAC\\8eK&#Gk\u001c$fCR,(/\u001a(b[\u0016\u0004\u0013!F7wK2,\u0005\u0010\u001d:fgNLwN\\\"p]R,\u0007\u0010^\u000b\u0002_\u00061RN^3m\u000bb\u0004(/Z:tS>t7i\u001c8uKb$\b%\u0001\nuS6,7i\u001c8gS\u001e\u001cV\r\u001e;j]\u001e\u001cXCAAZ!\ri\u0018QW\u0005\u0004\u0003ok\"A\u0005+j[\u0016\u001cuN\u001c4jON+G\u000f^5oON\f1\u0003^5nK\u000e{gNZ5h'\u0016$H/\u001b8hg\u0002\n!a]:\u0016\u0003A\n1a]:!\u0003=9W\r\u001e&pS:\u001cV\r\u001e;j]\u001e\u001c\u0018!G4fi:{G-Z%e)>4U-\u0019;ve\u0016t\u0015-\\3NCB$B!!%\u0002H\"9\u00111P\rA\u0002\u0005}\u0014!G4fiVsg-\u001b8jg\",G\rR3qK:$WM\\2jKN$b!!4\u0002T\u0006]\u0007CBA#\u0003\u001f\f9*\u0003\u0003\u0002R\u0006E#aA*fi\"9\u0011Q\u001b\u000eA\u0002\u0005\u0015\u0015\u0001\u00028pI\u0016Dq!!7\u001b\u0001\u0004\tY.\u0001\u0007wSNLG/\u001a3Ti\u0006$X\rE\u0003+\u0003;\f\t/C\u0002\u0002`.\u0012Q!\u0011:sCf\u0004B!a9\u0002j6\u0011\u0011Q\u001d\u0006\u0004\u0003O|\u0012AB2mS\u0016tG/\u0003\u0003\u0002l\u0006\u0015(\u0001\u0004,jg&$X\rZ*uCR,\u0017!\u0004;sCZ,'o]3He\u0006\u0004\b\u000e\u0006\u0002\u0002rB!\u00111_A{\u001b\u0005y\u0012bAA|?\t\u0001b)Z1ukJ,G)\u0019;b\rJ\fW.\u001a")
public class FCMGraphTraverser {
    private final FeatureJoinConfig featureJoinConfig;
    private final ComputeGraph resolvedGraph;
    private final Dataset<Row> observationDf;
    private final List<DataPathHandler> dataPathHandlers;
    private final Logger log;
    private final HashMap<Object, DataframeAndColumnMetadata> nodeIdToDataframeAndColumnMetadataMap;
    private final HashMap<String, Enumeration.Value> featureColumnFormatsMap;
    private final Buffer<AnyNode> nodes;
    private final scala.collection.immutable.Map<Integer, String> nodeIdToFeatureName;
    private final Option<FeathrExpressionExecutionContext> mvelExpressionContext;
    private final TimeConfigSettings timeConfigSettings;
    private final SparkSession ss;

    private Logger log() {
        return this.log;
    }

    public HashMap<Object, DataframeAndColumnMetadata> nodeIdToDataframeAndColumnMetadataMap() {
        return this.nodeIdToDataframeAndColumnMetadataMap;
    }

    public HashMap<String, Enumeration.Value> featureColumnFormatsMap() {
        return this.featureColumnFormatsMap;
    }

    public Buffer<AnyNode> nodes() {
        return this.nodes;
    }

    public scala.collection.immutable.Map<Integer, String> nodeIdToFeatureName() {
        return this.nodeIdToFeatureName;
    }

    public Option<FeathrExpressionExecutionContext> mvelExpressionContext() {
        return this.mvelExpressionContext;
    }

    public TimeConfigSettings timeConfigSettings() {
        return this.timeConfigSettings;
    }

    public SparkSession ss() {
        return this.ss;
    }

    private TimeConfigSettings getJoinSettings() {
        DateTimeInterval obsTimeRange = this.featureJoinConfig.settings().isDefined() ? (DateTimeInterval)((Option)SlidingWindowFeatureUtils$.MODULE$.getObsSwaDataTimeRange(this.observationDf, this.featureJoinConfig.settings())._1()).get() : null;
        return new TimeConfigSettings(this.featureJoinConfig.settings(), this.featureJoinConfig.featuresToTimeDelayMap(), obsTimeRange);
    }

    private scala.collection.immutable.Map<Integer, String> getNodeIdToFeatureNameMap(Buffer<AnyNode> nodes) {
        scala.collection.immutable.Map derivedFeatureAliasMap = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)this.resolvedGraph.getFeatureNames()).asScala()).map((Function1 & Serializable & scala.Serializable)x -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x._2()), x._1()), Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return ((TraversableOnce)((TraversableLike)nodes.filter((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)FCMGraphTraverser.$anonfun$getNodeIdToFeatureNameMap$2(node)))).map((Function1 & Serializable & scala.Serializable)node -> node.isLookup() ? (derivedFeatureAliasMap.contains((Object)node.getLookup().getId()) ? new Tuple2((Object)node.getLookup().getId(), derivedFeatureAliasMap.apply((Object)node.getLookup().getId())) : new Tuple2((Object)node.getLookup().getId(), (Object)node.getLookup().getFeatureName())) : (node.isAggregation() ? (derivedFeatureAliasMap.contains((Object)node.getAggregation().getId()) ? new Tuple2((Object)node.getAggregation().getId(), derivedFeatureAliasMap.apply((Object)node.getAggregation().getId())) : new Tuple2((Object)node.getAggregation().getId(), (Object)node.getAggregation().getFeatureName())) : (derivedFeatureAliasMap.contains((Object)node.getTransformation().getId()) ? new Tuple2((Object)node.getTransformation().getId(), derivedFeatureAliasMap.apply((Object)node.getTransformation().getId())) : (node.getTransformation().hasFeatureName() ? new Tuple2((Object)node.getTransformation().getId(), (Object)node.getTransformation().getFeatureName()) : new Tuple2((Object)node.getTransformation().getId(), (Object)"__seq__join__feature")))), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private scala.collection.immutable.Set<Integer> getUnfinishedDependencies(AnyNode node, VisitedState[] visitedState) {
        Set dependencies = (Set)JavaConverters$.MODULE$.asScalaSetConverter(new Dependencies().getDependencies(node)).asScala();
        return ((TraversableOnce)dependencies.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FCMGraphTraverser.$anonfun$getUnfinishedDependencies$1(visitedState, x$1)))).toSet();
    }

    public FeatureDataFrame traverseGraph() {
        Stack stack = (Stack)Stack$.MODULE$.apply((Seq)Nil$.MODULE$);
        Dataset<Row> contextDf = this.observationDf;
        scala.collection.immutable.Map optimizedGroupingMap = NodeGrouper$.MODULE$.groupTransformationNodes(this.nodes()).$plus$plus(NodeGrouper$.MODULE$.groupAllSWANodes(this.nodes()));
        scala.collection.immutable.Map nodeRankingMap = ((TraversableOnce)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)this.resolvedGraph.getFeatureNames()).asScala()).values().map((Function1 & Serializable & scala.Serializable)x -> ((AnyNode)this.nodes().apply(Predef$.MODULE$.Integer2int(x))).isAggregation() ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x), (Object)BoxesRunTime.boxToInteger((int)1)) : Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x), (Object)BoxesRunTime.boxToInteger((int)2)), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        VisitedState[] visitedState = (VisitedState[])Array$.MODULE$.fill(this.nodes().length(), (Function0 & Serializable & scala.Serializable)() -> NOT_VISITED$.MODULE$, ClassTag$.MODULE$.apply(VisitedState.class));
        ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)this.resolvedGraph.getFeatureNames()).asScala()).values().foreach((Function1 & Serializable & scala.Serializable)x -> stack.push((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x))));
        while (stack.nonEmpty()) {
            Dataset<Row> dataset;
            stack.sortBy((Function1 & Serializable & scala.Serializable)x0$1 -> FCMGraphTraverser.$anonfun$traverseGraph$4(nodeRankingMap, BoxesRunTime.unboxToInt((Object)x0$1)), Ordering$.MODULE$.Option((Ordering)Ordering.Int$.MODULE$));
            int nodeId = BoxesRunTime.unboxToInt((Object)stack.pop());
            VisitedState visitedState2 = visitedState[nodeId];
            VISITED$ vISITED$ = VISITED$.MODULE$;
            if (!(visitedState2 == null ? vISITED$ != null : !visitedState2.equals(vISITED$))) continue;
            AnyNode node = (AnyNode)this.nodes().apply(nodeId);
            scala.collection.immutable.Set unfinishedDependencies = (scala.collection.immutable.Set)((TraversableOnce)optimizedGroupingMap.getOrElse((Object)Predef$.MODULE$.int2Integer(nodeId), (Function0 & Serializable & scala.Serializable)() -> (Seq)new .colon.colon((Object)new Integer(nodeId), (List)Nil$.MODULE$))).foldLeft((Object)Predef$.MODULE$.Set().empty(), (Function2 & Serializable & scala.Serializable)(unfinishedSet, currNodeId) -> (scala.collection.immutable.Set)unfinishedSet.$plus$plus(this.getUnfinishedDependencies((AnyNode)this.nodes().apply(Predef$.MODULE$.Integer2int(currNodeId)), visitedState)));
            if (unfinishedDependencies.nonEmpty()) {
                VisitedState visitedState3 = visitedState[nodeId];
                IN_PROGRESS$ iN_PROGRESS$ = IN_PROGRESS$.MODULE$;
                if (!(visitedState3 != null ? !visitedState3.equals(iN_PROGRESS$) : iN_PROGRESS$ != null)) {
                    throw new RuntimeException(new StringBuilder(44).append("Encountered dependency cycle involving node ").append(nodeId).toString());
                }
                stack.push((Object)BoxesRunTime.boxToInteger((int)nodeId));
                unfinishedDependencies.foreach((Function1 & Serializable & scala.Serializable)x$2 -> stack.push((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$2))));
                visitedState[nodeId] = IN_PROGRESS$.MODULE$;
                continue;
            }
            Predef$.MODULE$.assert(!this.nodeIdToDataframeAndColumnMetadataMap().contains((Object)BoxesRunTime.boxToInteger((int)nodeId)));
            if (optimizedGroupingMap.contains((Object)Predef$.MODULE$.int2Integer(nodeId))) {
                Dataset<Row> dataset2;
                AnyNode anyNode = node;
                if (anyNode.isDataSource()) {
                    dataset2 = DataSourceNodeEvaluator$.MODULE$.batchEvaluate((Seq<AnyNode>)((Seq)((TraversableLike)optimizedGroupingMap.apply((Object)Predef$.MODULE$.int2Integer(nodeId))).map((Function1 & Serializable & scala.Serializable)x$3 -> (AnyNode)this.nodes().apply(Predef$.MODULE$.Integer2int(x$3)), Seq$.MODULE$.canBuildFrom())), this, contextDf, this.dataPathHandlers);
                } else if (anyNode.isLookup()) {
                    dataset2 = LookupNodeEvaluator$.MODULE$.batchEvaluate((Seq<AnyNode>)((Seq)((TraversableLike)optimizedGroupingMap.apply((Object)Predef$.MODULE$.int2Integer(nodeId))).map((Function1 & Serializable & scala.Serializable)x$4 -> (AnyNode)this.nodes().apply(Predef$.MODULE$.Integer2int(x$4)), Seq$.MODULE$.canBuildFrom())), this, contextDf, this.dataPathHandlers);
                } else if (anyNode.isTransformation()) {
                    dataset2 = TransformationNodeEvaluator$.MODULE$.batchEvaluate((Seq<AnyNode>)((Seq)((TraversableLike)optimizedGroupingMap.apply((Object)Predef$.MODULE$.int2Integer(nodeId))).map((Function1 & Serializable & scala.Serializable)x$5 -> (AnyNode)this.nodes().apply(Predef$.MODULE$.Integer2int(x$5)), Seq$.MODULE$.canBuildFrom())), this, contextDf, this.dataPathHandlers);
                } else if (anyNode.isAggregation()) {
                    dataset2 = AggregationNodeEvaluator$.MODULE$.batchEvaluate((Seq<AnyNode>)((Seq)((TraversableLike)optimizedGroupingMap.apply((Object)Predef$.MODULE$.int2Integer(nodeId))).map((Function1 & Serializable & scala.Serializable)x$6 -> (AnyNode)this.nodes().apply(Predef$.MODULE$.Integer2int(x$6)), Seq$.MODULE$.canBuildFrom())), this, contextDf, this.dataPathHandlers);
                } else {
                    if (anyNode.isExternal()) {
                        throw new RuntimeException(new StringBuilder(67).append("External node found in resolved graph traversal. Node information: ").append(anyNode).toString());
                    }
                    throw new MatchError((Object)anyNode);
                }
                dataset = dataset2;
            } else {
                Dataset<Row> dataset3;
                AnyNode anyNode = node;
                if (anyNode.isDataSource()) {
                    dataset3 = DataSourceNodeEvaluator$.MODULE$.evaluate(anyNode, this, contextDf, this.dataPathHandlers);
                } else if (anyNode.isLookup()) {
                    dataset3 = LookupNodeEvaluator$.MODULE$.evaluate(anyNode, this, contextDf, this.dataPathHandlers);
                } else if (anyNode.isTransformation()) {
                    dataset3 = TransformationNodeEvaluator$.MODULE$.evaluate(anyNode, this, contextDf, this.dataPathHandlers);
                } else if (anyNode.isAggregation()) {
                    dataset3 = AggregationNodeEvaluator$.MODULE$.evaluate(anyNode, this, contextDf, this.dataPathHandlers);
                } else {
                    if (anyNode.isExternal()) {
                        throw new RuntimeException(new StringBuilder(67).append("External node found in resolved graph traversal. Node information: ").append(anyNode).toString());
                    }
                    throw new MatchError((Object)anyNode);
                }
                dataset = contextDf = dataset3;
            }
            if (optimizedGroupingMap.contains((Object)Predef$.MODULE$.int2Integer(nodeId))) {
                ((IterableLike)optimizedGroupingMap.apply((Object)Predef$.MODULE$.int2Integer(nodeId))).foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                    visitedState[Predef$.MODULE$.Integer2int((Integer)x$7)] = VISITED$.MODULE$;
                    return BoxedUnit.UNIT;
                });
                continue;
            }
            visitedState[nodeId] = VISITED$.MODULE$;
        }
        scala.collection.immutable.Map<String, FeatureTypeConfig> featureTypeConfigs = NodeUtils$.MODULE$.getFeatureTypeConfigsMap((Seq<AnyNode>)this.nodes());
        Iterable necessaryColumns = (Iterable)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)this.resolvedGraph.getFeatureNames()).asScala()).keys().$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.observationDf.columns())), Iterable$.MODULE$.canBuildFrom());
        String[] toDropCols = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])contextDf.columns())).diff((GenSeq)necessaryColumns.toSeq());
        contextDf = contextDf.drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])toDropCols));
        return FeatureTransformation$.MODULE$.convertFCMResultDFToFDS((Seq<String>)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)this.resolvedGraph.getFeatureNames()).asScala()).keys().toSeq(), (scala.collection.immutable.Map<String, Enumeration.Value>)this.featureColumnFormatsMap().toMap(Predef$.MODULE$.$conforms()), contextDf, featureTypeConfigs);
    }

    public static final /* synthetic */ boolean $anonfun$getNodeIdToFeatureNameMap$2(AnyNode node) {
        return node.isLookup() || node.isAggregation() || node.isTransformation();
    }

    public static final /* synthetic */ boolean $anonfun$getUnfinishedDependencies$1(VisitedState[] visitedState$1, Integer x$1) {
        VisitedState visitedState = visitedState$1[Predef$.MODULE$.Integer2int(x$1)];
        VISITED$ vISITED$ = VISITED$.MODULE$;
        return visitedState == null ? vISITED$ != null : !visitedState.equals(vISITED$);
    }

    public static final /* synthetic */ Option $anonfun$traverseGraph$4(scala.collection.immutable.Map nodeRankingMap$1, int x0$1) {
        int n = x0$1;
        Option option = nodeRankingMap$1.get((Object)Predef$.MODULE$.int2Integer(n));
        return option;
    }

    public FCMGraphTraverser(SparkSession inputSparkSession, FeatureJoinConfig featureJoinConfig, ComputeGraph resolvedGraph, Dataset<Row> observationDf, List<DataPathHandler> dataPathHandlers, Option<FeathrExpressionExecutionContext> mvelContext) {
        this.featureJoinConfig = featureJoinConfig;
        this.resolvedGraph = resolvedGraph;
        this.observationDf = observationDf;
        this.dataPathHandlers = dataPathHandlers;
        this.log = Logger.getLogger((String)this.getClass().getName());
        this.nodeIdToDataframeAndColumnMetadataMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.featureColumnFormatsMap = (HashMap)HashMap$.MODULE$.apply((Seq)featureJoinConfig.joinFeatures().map((Function1 & Serializable & scala.Serializable)joinFeature -> new Tuple2((Object)joinFeature.featureName(), (Object)FeatureColumnFormat$.MODULE$.RAW()), Seq$.MODULE$.canBuildFrom()));
        this.nodes = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)resolvedGraph.getNodes()).asScala();
        this.nodeIdToFeatureName = this.getNodeIdToFeatureNameMap(this.nodes());
        this.mvelExpressionContext = mvelContext;
        this.timeConfigSettings = this.getJoinSettings();
        this.ss = inputSparkSession;
    }
}

