/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.job;

import com.linkedin.feathr.common.AnchorExtractor;
import com.linkedin.feathr.common.AnchorExtractorBase;
import com.linkedin.feathr.common.CanConvertToAvroRDD;
import com.linkedin.feathr.common.DateParam;
import com.linkedin.feathr.common.FeatureTypeConfig;
import com.linkedin.feathr.common.FeatureTypes;
import com.linkedin.feathr.common.FeatureValue;
import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrException;
import com.linkedin.feathr.common.exception.FeathrFeatureTransformationException;
import com.linkedin.feathr.common.package$;
import com.linkedin.feathr.common.tensor.TensorData;
import com.linkedin.feathr.common.tensor.TensorType;
import com.linkedin.feathr.common.types.FeatureType;
import com.linkedin.feathr.offline.FeatureDataFrame;
import com.linkedin.feathr.offline.anchored.anchorExtractor.SQLConfigurableAnchorExtractor;
import com.linkedin.feathr.offline.anchored.anchorExtractor.SimpleConfigurableAnchorExtractor;
import com.linkedin.feathr.offline.anchored.anchorExtractor.TimeWindowConfigurableAnchorExtractor;
import com.linkedin.feathr.offline.anchored.feature.FeatureAnchor;
import com.linkedin.feathr.offline.anchored.feature.FeatureAnchorWithSource;
import com.linkedin.feathr.offline.anchored.keyExtractor.MVELSourceKeyExtractor;
import com.linkedin.feathr.offline.anchored.keyExtractor.SpecificRecordSourceKeyExtractor;
import com.linkedin.feathr.offline.client.DataFrameColName$;
import com.linkedin.feathr.offline.config.MVELFeatureDefinition;
import com.linkedin.feathr.offline.config.TimeWindowFeatureDefinition;
import com.linkedin.feathr.offline.generation.IncrementalAggContext;
import com.linkedin.feathr.offline.job.AnchorFeatureGroups;
import com.linkedin.feathr.offline.job.FeatureTransformation;
import com.linkedin.feathr.offline.job.FeatureTransformation$;
import com.linkedin.feathr.offline.job.FeatureTypeInferenceContext;
import com.linkedin.feathr.offline.job.KeyedTransformedResult;
import com.linkedin.feathr.offline.job.PreprocessedDataFrameManager$;
import com.linkedin.feathr.offline.job.TransformInfo;
import com.linkedin.feathr.offline.job.TransformedResult;
import com.linkedin.feathr.offline.join.DataFrameKeyCombiner;
import com.linkedin.feathr.offline.join.DataFrameKeyCombiner$;
import com.linkedin.feathr.offline.mvel.plugins.FeathrExpressionExecutionContext;
import com.linkedin.feathr.offline.source.DataSource;
import com.linkedin.feathr.offline.source.accessor.DataSourceAccessor;
import com.linkedin.feathr.offline.source.accessor.NonTimeBasedDataSourceAccessor;
import com.linkedin.feathr.offline.source.accessor.TimeBasedDataSourceAccessor;
import com.linkedin.feathr.offline.swa.SlidingWindowFeatureUtils$;
import com.linkedin.feathr.offline.transformation.DataFrameBasedRowEvaluator$;
import com.linkedin.feathr.offline.transformation.DataFrameBasedSqlEvaluator$;
import com.linkedin.feathr.offline.transformation.FeatureColumnFormat$;
import com.linkedin.feathr.offline.transformation.FeatureTypeAccumulator;
import com.linkedin.feathr.offline.transformation.WindowAggregationEvaluator$;
import com.linkedin.feathr.offline.util.AnchorUtils$;
import com.linkedin.feathr.offline.util.FeatureValueTypeValidator$;
import com.linkedin.feathr.offline.util.FeaturizedDatasetUtils$;
import com.linkedin.feathr.offline.util.IncrementalAggUtils$;
import com.linkedin.feathr.offline.util.SourceUtils$;
import com.linkedin.feathr.offline.util.datetime.DateTimeInterval;
import com.linkedin.feathr.offline.util.datetime.OfflineDateTimeUtils$;
import com.linkedin.feathr.sparkcommon.SimpleAnchorExtractorSpark;
import com.linkedin.feathr.sparkcommon.SourceKeyExtractor;
import com.linkedin.feathr.swj.aggregate.AggregationType$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.avro.generic.IndexedRecord;
import org.apache.log4j.Logger;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.RelationalGroupedDataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.AccumulatorV2;
import org.apache.spark.util.sketch.BloomFilter;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.parallel.immutable.ParSeq$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;

public final class FeatureTransformation$ {
    public static FeatureTransformation$ MODULE$;
    private final Logger logger;
    private final String FEATURE_DATA_JOIN_KEY_COL_PREFIX;
    private final String FEATURE_NAME_PREFIX;
    private final String FEATURE_TAGS_PREFIX;
    private final String JOIN_KEY_OBSERVATION_PREFIX;
    private final String USER_FACING_MULTI_DIM_FDS_TENSOR_UDF_NAME;
    private final int MAX_PARALLEL_FEATURE_GROUP;

    static {
        new FeatureTransformation$();
    }

    private Logger logger() {
        return this.logger;
    }

    public String FEATURE_DATA_JOIN_KEY_COL_PREFIX() {
        return this.FEATURE_DATA_JOIN_KEY_COL_PREFIX;
    }

    public String FEATURE_NAME_PREFIX() {
        return this.FEATURE_NAME_PREFIX;
    }

    public String FEATURE_TAGS_PREFIX() {
        return this.FEATURE_TAGS_PREFIX;
    }

    public String JOIN_KEY_OBSERVATION_PREFIX() {
        return this.JOIN_KEY_OBSERVATION_PREFIX;
    }

    public String USER_FACING_MULTI_DIM_FDS_TENSOR_UDF_NAME() {
        return this.USER_FACING_MULTI_DIM_FDS_TENSOR_UDF_NAME;
    }

    public Seq<String> getFeatureKeyColumnNamesRdd(SourceKeyExtractor sourceKeyExtractor, RDD<?> withKeyColumnRDD) {
        return withKeyColumnRDD.isEmpty() ? sourceKeyExtractor.getKeyColumnNames((Option<Object>)None$.MODULE$) : sourceKeyExtractor.getKeyColumnNames((Option<Object>)new Some(withKeyColumnRDD.first()));
    }

    public Seq<String> getFeatureKeyColumnNames(SourceKeyExtractor sourceKeyExtractor, Dataset<Row> withKeyColumnDF) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])withKeyColumnDF.head(1))).isEmpty() ? sourceKeyExtractor.getKeyColumnNames((Option<Object>)None$.MODULE$) : sourceKeyExtractor.getKeyColumnNames((Option<Object>)new Some(withKeyColumnDF.first()));
    }

    public String getFeatureNamePrefix(Object transformer) {
        return new StringBuilder(1).append(transformer.getClass().getSimpleName()).append("_").toString();
    }

    public KeyedTransformedResult applyAggregate(Seq<FeatureAnchorWithSource> featureAnchorWithSources, KeyedTransformedResult transformedResultWithKey) {
        Dataset dataset;
        Seq aggColumns = (Seq)featureAnchorWithSources.flatMap((Function1 & Serializable & scala.Serializable)featureAnchorWithSource -> {
            Seq seq;
            Object object = featureAnchorWithSource.featureAnchor().extractor();
            if (object instanceof SimpleAnchorExtractorSpark) {
                Seq aggColumns;
                SimpleAnchorExtractorSpark simpleAnchorExtractorSpark = (SimpleAnchorExtractorSpark)object;
                Dataset<Row> df = transformedResultWithKey.transformedResult().df();
                seq = aggColumns = (Seq)simpleAnchorExtractorSpark.aggregateAsColumns(df).collect((PartialFunction)new scala.Serializable((FeatureAnchorWithSource)featureAnchorWithSource){
                    public static final long serialVersionUID = 0L;
                    private final FeatureAnchorWithSource featureAnchorWithSource$1;

                    public final <A1 extends Tuple2<String, Column>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        Object object = this.featureAnchorWithSource$1.selectedFeatures().contains(A1._1()) ? ((Column)A1._2()).as((String)A1._1()) : function1.apply(x1);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Tuple2<String, Column> x1) {
                        Tuple2<String, Column> tuple2 = x1;
                        boolean bl = this.featureAnchorWithSource$1.selectedFeatures().contains(tuple2._1());
                        return bl;
                    }
                    {
                        this.featureAnchorWithSource$1 = featureAnchorWithSource$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            } else {
                seq = (Seq)Nil$.MODULE$;
            }
            return seq;
        }, Seq$.MODULE$.canBuildFrom());
        Dataset df = transformedResultWithKey.transformedResult().df();
        if (!aggColumns.isEmpty()) {
            Seq<String> groupColumns = transformedResultWithKey.joinKey();
            RelationalGroupedDataset grouped = df.groupBy((Seq)groupColumns.map((Function1 & Serializable & scala.Serializable)expr -> functions$.MODULE$.expr(expr), Seq$.MODULE$.canBuildFrom()));
            dataset = grouped.agg((Column)aggColumns.head(), (Seq)aggColumns.tail());
        } else {
            dataset = df;
        }
        Dataset aggedDF = dataset;
        Seq postProcessingColumns = (Seq)featureAnchorWithSources.flatMap((Function1 & Serializable & scala.Serializable)featureAnchorWithSource -> {
            Seq<Tuple2<String, Column>> seq;
            Object object = featureAnchorWithSource.featureAnchor().extractor();
            if (object instanceof SimpleAnchorExtractorSpark) {
                SimpleAnchorExtractorSpark simpleAnchorExtractorSpark = (SimpleAnchorExtractorSpark)object;
                simpleAnchorExtractorSpark.setInternalParams(package$.MODULE$.SELECTED_FEATURES(), new StringBuilder(2).append("[").append(featureAnchorWithSource.selectedFeatures().mkString(",")).append("]").toString());
                seq = simpleAnchorExtractorSpark.postProcessing((Dataset<Row>)aggedDF);
            } else {
                seq = (Seq<Tuple2<String, Column>>)Nil$.MODULE$;
            }
            return seq;
        }, Seq$.MODULE$.canBuildFrom());
        Dataset postProcessedDF = (Dataset)postProcessingColumns.foldLeft(aggedDF, (Function2 & Serializable & scala.Serializable)(inputDF, pr) -> {
            String tempFeatureColumnName = new StringBuilder(31).append("_temp_column_for_default_value_").append(pr._1()).toString();
            return inputDF.withColumn(tempFeatureColumnName, (Column)pr._2()).drop((String)pr._1()).withColumnRenamed(tempFeatureColumnName, (String)pr._1());
        });
        Seq<Tuple2<String, String>> columnNamePairs = transformedResultWithKey.transformedResult().featureNameAndPrefixPairs();
        TransformedResult resultWithoutKey = new TransformedResult(columnNamePairs, (Dataset<Row>)postProcessedDF, transformedResultWithKey.transformedResult().featureColumnFormats(), transformedResultWithKey.transformedResult().inferredFeatureTypes());
        return new KeyedTransformedResult(transformedResultWithKey.joinKey(), resultWithoutKey);
    }

    public TransformedResult transformSingleAnchorDF(FeatureAnchorWithSource featureAnchorWithSource, Dataset<Row> df, Seq<String> requestedFeatureRefString, Option<DateTimeInterval> inputDateInterval, Option<FeathrExpressionExecutionContext> mvelContext) {
        TransformedResult transformedResult;
        String featureNamePrefix = this.getFeatureNamePrefix(featureAnchorWithSource.featureAnchor().extractor());
        Seq featureNamePrefixPairs = (Seq)requestedFeatureRefString.map((Function1 & Serializable & scala.Serializable)x$1 -> new Tuple2(x$1, (Object)featureNamePrefix), Seq$.MODULE$.canBuildFrom());
        Map<String, FeatureTypeConfig> featureTypeConfigs = featureAnchorWithSource.featureAnchor().featureTypeConfigs();
        Object object = featureAnchorWithSource.featureAnchor().extractor();
        if (object instanceof TimeWindowConfigurableAnchorExtractor) {
            TimeWindowConfigurableAnchorExtractor timeWindowConfigurableAnchorExtractor = (TimeWindowConfigurableAnchorExtractor)object;
            transformedResult = WindowAggregationEvaluator$.MODULE$.transform(timeWindowConfigurableAnchorExtractor, df, (Seq<Tuple2<String, String>>)featureNamePrefixPairs, featureAnchorWithSource, inputDateInterval);
        } else if (object instanceof SimpleAnchorExtractorSpark) {
            SimpleAnchorExtractorSpark simpleAnchorExtractorSpark = (SimpleAnchorExtractorSpark)object;
            transformedResult = DataFrameBasedSqlEvaluator$.MODULE$.transform(simpleAnchorExtractorSpark, df, (Seq<Tuple2<String, String>>)featureNamePrefixPairs, featureTypeConfigs);
        } else if (object instanceof AnchorExtractor) {
            AnchorExtractor anchorExtractor = (AnchorExtractor)object;
            transformedResult = DataFrameBasedRowEvaluator$.MODULE$.transform(anchorExtractor, df, (Seq<Tuple2<String, String>>)featureNamePrefixPairs, featureTypeConfigs, mvelContext);
        } else {
            throw new FeathrFeatureTransformationException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(34).append("cannot find valid Transformer for ").append(featureAnchorWithSource).toString());
        }
        TransformedResult transformedFeatureData = transformedResult;
        Dataset<Row> withFeatureDF = transformedFeatureData.df();
        if (((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])withFeatureDF.columns())).distinct()).length != withFeatureDF.columns().length) {
            throw new FeathrException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(170).append("Found duplicate column names in the transformed feature ").append("DataFrame, all columns are ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])withFeatureDF.columns())).mkString(",")).append(". Please make sure your feature names are different from field ").append("names in the source data").toString());
        }
        return transformedFeatureData;
    }

    public Map<String, TimeWindowFeatureDefinition> getFeatureDefinitions(Object featureAnchorExtractor) {
        Object object = featureAnchorExtractor;
        if (!(object instanceof TimeWindowConfigurableAnchorExtractor)) {
            throw new FeathrFeatureTransformationException(ErrorLabel.FEATHR_USER_ERROR, "Only TimeWindowConfigurableAnchorExtractor is supported for this function for now");
        }
        TimeWindowConfigurableAnchorExtractor timeWindowConfigurableAnchorExtractor = (TimeWindowConfigurableAnchorExtractor)object;
        Map<String, TimeWindowFeatureDefinition> map = timeWindowConfigurableAnchorExtractor.features();
        return map;
    }

    public int getFeatureAggWindow(AnchorFeatureGroups anchorFeatureGroups) {
        Seq<String> requestedFeatureNames = anchorFeatureGroups.requestedFeatures();
        Map<String, TimeWindowFeatureDefinition> features = this.getFeatureDefinitions(((FeatureAnchorWithSource)anchorFeatureGroups.anchorsWithSameSource().head()).featureAnchor().extractor());
        Map requestedFeatures = (Map)features.filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)requestedFeatureNames.contains(x._1())));
        return (int)((TimeWindowFeatureDefinition)((Tuple2)requestedFeatures.head())._2()).window().toDays();
    }

    public Dataset<Row> mergeDeltaDF(Dataset<Row> oldDeltaDF, Dataset<Row> newDeltaDF, Seq<String> oldDeltaJoinKeys, Seq<String> newDeltaJoinKeys, Seq<String> requestedFeatureColumnNames, boolean add) {
        String tmpPostfix = "_tmp";
        String oldDelta = "oldDelta";
        String newDelta = "newDelta";
        Dataset oldDeltaRenamed = (Dataset)((TraversableOnce)oldDeltaJoinKeys.zip(newDeltaJoinKeys, Seq$.MODULE$.canBuildFrom())).foldLeft(oldDeltaDF, (Function2 & Serializable & scala.Serializable)(baseDF, renamePair) -> baseDF.withColumnRenamed((String)renamePair._1(), (String)renamePair._2()));
        Dataset joinedWithNewDelta = oldDeltaRenamed.as(oldDelta).join(newDeltaDF.as(newDelta), newDeltaJoinKeys, "outer");
        return (Dataset)requestedFeatureColumnNames.foldLeft((Object)joinedWithNewDelta, (Function2 & Serializable & scala.Serializable)(baseDf, columnName) -> {
            Column column = add ? baseDf.apply(new StringBuilder(1).append(oldDelta).append(".").append((String)columnName).toString()).$plus((Object)baseDf.apply(new StringBuilder(1).append(newDelta).append(".").append((String)columnName).toString())) : baseDf.apply(new StringBuilder(1).append(oldDelta).append(".").append((String)columnName).toString()).$minus((Object)baseDf.apply(new StringBuilder(1).append(newDelta).append(".").append((String)columnName).toString()));
            Dataset mergedWithNewDelta = baseDf.withColumn(new StringBuilder(0).append((String)columnName).append(tmpPostfix).toString(), functions$.MODULE$.when(baseDf.apply(new StringBuilder(1).append(oldDelta).append(".").append((String)columnName).toString()).isNull(), (Object)baseDf.apply(new StringBuilder(1).append(newDelta).append(".").append((String)columnName).toString())).when(baseDf.apply(new StringBuilder(1).append(newDelta).append(".").append((String)columnName).toString()).isNull(), (Object)baseDf.apply(new StringBuilder(1).append(oldDelta).append(".").append((String)columnName).toString())).otherwise((Object)column)).drop(baseDf.apply(new StringBuilder(1).append(oldDelta).append(".").append((String)columnName).toString())).drop(baseDf.apply(new StringBuilder(1).append(newDelta).append(".").append((String)columnName).toString()));
            return mergedWithNewDelta.withColumnRenamed(new StringBuilder(0).append((String)columnName).append(tmpPostfix).toString(), columnName);
        });
    }

    public boolean mergeDeltaDF$default$6() {
        return true;
    }

    public KeyedTransformedResult directCalculate(AnchorFeatureGroups anchorFeatureGroup, DataSourceAccessor source, SourceKeyExtractor keyExtractor, Option<BloomFilter> bloomFilter, Option<DateTimeInterval> inputDateInterval, Option<Dataset<Row>> preprocessedDf, Option<FeathrExpressionExecutionContext> mvelContext) {
        Enumeration.Value featureFormat;
        FeatureDataFrame featureDataFrame;
        KeyedTransformedResult aggResults;
        block12: {
            Tuple2 tuple2;
            block11: {
                Dataset<Row> dataset;
                Predef$.MODULE$.assert(((SeqLike)((SeqLike)anchorFeatureGroup.anchorsWithSameSource().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.dateParam(), Seq$.MODULE$.canBuildFrom())).distinct()).size() == 1);
                Option defaultInterval = ((FeatureAnchorWithSource)anchorFeatureGroup.anchorsWithSameSource().head()).dateParam().map((Function1 & Serializable & scala.Serializable)dateParam -> OfflineDateTimeUtils$.MODULE$.createIntervalFromFeatureGenDateParam((DateParam)dateParam));
                Option interval = inputDateInterval.orElse((Function0 & Serializable & scala.Serializable)() -> defaultInterval);
                Option<Dataset<Row>> option = preprocessedDf;
                if (option instanceof Some) {
                    Dataset<Row> existDf;
                    Some some = (Some)option;
                    dataset = existDf = (Dataset<Row>)some.value();
                } else if (None$.MODULE$.equals(option)) {
                    Dataset<Row> dataset2;
                    DataSourceAccessor dataSourceAccessor = source;
                    if (dataSourceAccessor instanceof TimeBasedDataSourceAccessor) {
                        TimeBasedDataSourceAccessor timeBasedDataSourceAccessor = (TimeBasedDataSourceAccessor)dataSourceAccessor;
                        dataset2 = timeBasedDataSourceAccessor.get((Option<DateTimeInterval>)interval);
                    } else if (dataSourceAccessor instanceof NonTimeBasedDataSourceAccessor) {
                        NonTimeBasedDataSourceAccessor nonTimeBasedDataSourceAccessor = (NonTimeBasedDataSourceAccessor)dataSourceAccessor;
                        dataset2 = nonTimeBasedDataSourceAccessor.get();
                    } else {
                        throw new MatchError((Object)dataSourceAccessor);
                    }
                    dataset = dataset2;
                } else {
                    throw new MatchError(option);
                }
                Dataset<Row> sourceDF = dataset;
                Dataset<Row> withKeyColumnDF = keyExtractor.appendKeyColumns(sourceDF);
                Seq<String> outputJoinKeyColumnNames = this.getFeatureKeyColumnNames(keyExtractor, withKeyColumnDF);
                Dataset<Row> filteredFactData = this.applyBloomFilter((Tuple2<SourceKeyExtractor, Dataset<Row>>)new Tuple2((Object)keyExtractor, withKeyColumnDF), bloomFilter);
                TransformedResult transformedInfoWithoutKey = (TransformedResult)anchorFeatureGroup.anchorsWithSameSource().foldLeft((Object)new TransformedResult((Seq<Tuple2<String, String>>)((Seq)Nil$.MODULE$), filteredFactData, (Map<String, Enumeration.Value>)Predef$.MODULE$.Map().empty(), (Map<String, FeatureTypeConfig>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$))), (Function2 & Serializable & scala.Serializable)(prevTransformedResult, featureAnchorWithSource) -> {
                    Seq<String> requestedFeatures = featureAnchorWithSource.selectedFeatures();
                    TransformedResult transformedResultWithoutKey = MODULE$.transformSingleAnchorDF((FeatureAnchorWithSource)featureAnchorWithSource, prevTransformedResult.df(), requestedFeatures, inputDateInterval, mvelContext);
                    Seq namePrefixPairs = (Seq)prevTransformedResult.featureNameAndPrefixPairs().$plus$plus(transformedResultWithoutKey.featureNameAndPrefixPairs(), Seq$.MODULE$.canBuildFrom());
                    Map columnNameToFeatureNameAndType = prevTransformedResult.inferredFeatureTypes().$plus$plus(transformedResultWithoutKey.inferredFeatureTypes());
                    Map featureColumnFormats = prevTransformedResult.featureColumnFormats().$plus$plus(transformedResultWithoutKey.featureColumnFormats());
                    return new TransformedResult((Seq<Tuple2<String, String>>)namePrefixPairs, transformedResultWithoutKey.df(), (Map<String, Enumeration.Value>)featureColumnFormats, (Map<String, FeatureTypeConfig>)columnNameToFeatureNameAndType);
                });
                KeyedTransformedResult transformedInfoWithKey = new KeyedTransformedResult(outputJoinKeyColumnNames, transformedInfoWithoutKey);
                aggResults = this.applyAggregate(anchorFeatureGroup.anchorsWithSameSource(), transformedInfoWithKey);
                Dataset<Row> aggedDF = aggResults.transformedResult().df();
                Seq allRequestedFeatures = (Seq)((TraversableOnce)anchorFeatureGroup.anchorsWithSameSource().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.selectedFeatures(), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$4, x$5) -> (Seq)x$4.$plus$plus((GenTraversableOnce)x$5, Seq$.MODULE$.canBuildFrom()));
                Map userProvidedFeatureTypeConfigs = (Map)((TraversableOnce)anchorFeatureGroup.anchorsWithSameSource().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.featureAnchor().featureTypeConfigs(), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$7, x$8) -> x$7.$plus$plus((GenTraversableOnce)x$8));
                tuple2 = new Tuple2((Object)this.convertTransformedDFToFDS((Seq<String>)allRequestedFeatures, transformedInfoWithoutKey, aggedDF, (Map<String, FeatureTypeConfig>)userProvidedFeatureTypeConfigs), (Object)FeatureColumnFormat$.MODULE$.FDS_TENSOR());
                if (tuple2 == null) break block11;
                featureDataFrame = (FeatureDataFrame)tuple2._1();
                featureFormat = (Enumeration.Value)tuple2._2();
                if (featureDataFrame != null) break block12;
            }
            throw new MatchError((Object)tuple2);
        }
        Dataset<Row> convertedDF = featureDataFrame.df();
        Map<String, FeatureTypeConfig> inferredFeatureTypes = featureDataFrame.inferredFeatureType();
        Tuple3 tuple3 = new Tuple3(convertedDF, inferredFeatureTypes, (Object)featureFormat);
        Tuple3 tuple32 = tuple3;
        Dataset convertedDF2 = (Dataset)tuple32._1();
        Map inferredFeatureTypes2 = (Map)tuple32._2();
        Enumeration.Value featureFormat2 = (Enumeration.Value)tuple32._3();
        Dataset renamedDF = (Dataset)aggResults.transformedResult().featureNameAndPrefixPairs().foldLeft((Object)convertedDF2, (Function2 & Serializable & scala.Serializable)(baseDF, columnWithName) -> {
            String origFeatureColumnName = (String)columnWithName._1();
            return baseDF.withColumnRenamed(origFeatureColumnName, new StringBuilder(0).append((String)columnWithName._2()).append(DataFrameColName$.MODULE$.getEncodedFeatureRefStrForColName((String)columnWithName._1())).toString());
        });
        anchorFeatureGroup.anchorsWithSameSource().foreach((Function1 & Serializable & scala.Serializable)featureAnchorWithSource -> {
            FeatureTransformation$.$anonfun$directCalculate$10(aggResults, anchorFeatureGroup, featureAnchorWithSource);
            return BoxedUnit.UNIT;
        });
        Seq featureColumnNames = (Seq)aggResults.transformedResult().featureNameAndPrefixPairs().map((Function1 & Serializable & scala.Serializable)x$11 -> (String)x$11._1(), Seq$.MODULE$.canBuildFrom());
        Map featureColumnFormats = ((TraversableOnce)featureColumnNames.map((Function1 & Serializable & scala.Serializable)name -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), (Object)featureFormat2), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        TransformedResult result = new TransformedResult(aggResults.transformedResult().featureNameAndPrefixPairs(), (Dataset<Row>)renamedDF, (Map<String, Enumeration.Value>)featureColumnFormats, (Map<String, FeatureTypeConfig>)inferredFeatureTypes2);
        return new KeyedTransformedResult(aggResults.joinKey(), result);
    }

    public Option<Dataset<Row>> directCalculate$default$6() {
        return None$.MODULE$;
    }

    public FeatureDataFrame convertTransformedDFToFDS(Seq<String> allFeaturesToConvert, TransformedResult transformedResult, Dataset<Row> withFeatureDF, Map<String, FeatureTypeConfig> userProvidedFeatureTypeConfigs) {
        Map<String, FeatureTypeConfig> defaultInferredFeatureTypes = this.inferFeatureTypesFromRawDF(withFeatureDF, allFeaturesToConvert);
        Map transformedInferredFeatureTypes = defaultInferredFeatureTypes.$plus$plus(transformedResult.inferredFeatureTypes());
        Map featureColNameToFeatureNameAndType = ((TraversableOnce)allFeaturesToConvert.map((Function1 & Serializable & scala.Serializable)featureName -> {
            FeatureTypes userProvidedFeatureType;
            FeatureTypeConfig userProvidedConfig = (FeatureTypeConfig)userProvidedFeatureTypeConfigs.getOrElse(featureName, (Function0 & Serializable & scala.Serializable)() -> FeatureTypeConfig.UNDEFINED_TYPE_CONFIG);
            FeatureTypes featureTypes = userProvidedFeatureType = userProvidedConfig.getFeatureType();
            FeatureTypes featureTypes2 = FeatureTypes.UNSPECIFIED;
            FeatureTypeConfig processedFeatureTypeConfig = !(featureTypes != null ? !((Object)((Object)featureTypes)).equals((Object)featureTypes2) : featureTypes2 != null) ? (FeatureTypeConfig)transformedInferredFeatureTypes.getOrElse(featureName, (Function0 & Serializable & scala.Serializable)() -> FeatureTypeConfig.UNDEFINED_TYPE_CONFIG) : userProvidedConfig;
            String colName = featureName;
            return new Tuple2((Object)colName, (Object)new Tuple2(featureName, (Object)processedFeatureTypeConfig));
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map inferredFeatureTypes = (Map)featureColNameToFeatureNameAndType.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$1;
            if (tuple22 == null || (tuple2 = (Tuple2)tuple22._2()) == null) {
                throw new MatchError((Object)tuple22);
            }
            String featureName = (String)tuple2._1();
            FeatureTypeConfig featureType = (FeatureTypeConfig)tuple2._2();
            Tuple2 tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)featureName), (Object)featureType);
            return tuple23;
        }, Map$.MODULE$.canBuildFrom());
        Dataset convertedDF = (Dataset)featureColNameToFeatureNameAndType.groupBy((Function1 & Serializable & scala.Serializable)pair -> (Enumeration.Value)transformedResult.featureColumnFormats().apply(pair._1())).foldLeft(withFeatureDF, (Function2 & Serializable & scala.Serializable)(inputDF, featureColNameToFeatureNameAndTypeWithFormat) -> {
            Dataset<Row> dataset;
            Enumeration.Value value = (Enumeration.Value)featureColNameToFeatureNameAndTypeWithFormat._1();
            Enumeration.Value value2 = FeatureColumnFormat$.MODULE$.FDS_TENSOR();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                dataset = inputDF;
            } else {
                Enumeration.Value value4 = FeatureColumnFormat$.MODULE$.RAW();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    Dataset<Row> convertedDF;
                    dataset = convertedDF = FeaturizedDatasetUtils$.MODULE$.convertRawDFtoQuinceFDS((Dataset<Row>)inputDF, (Map<String, Tuple2<String, FeatureTypeConfig>>)featureColNameToFeatureNameAndType);
                } else {
                    throw new MatchError((Object)value);
                }
            }
            Dataset<Row> fdsDF = dataset;
            return fdsDF;
        });
        return new FeatureDataFrame((Dataset<Row>)convertedDF, (Map<String, FeatureTypeConfig>)inferredFeatureTypes.$plus$plus(transformedResult.inferredFeatureTypes()));
    }

    public Map<String, FeatureTypeConfig> convertTransformedDFToFDS$default$4() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public Map<String, KeyedTransformedResult> transformFeatures(Map<FeatureAnchorWithSource, DataSourceAccessor> anchorToSourceDFThisStage, Seq<String> requestedFeatureNames, Option<BloomFilter> bloomFilter, Option<IncrementalAggContext> incrementalAggContext, Option<FeathrExpressionExecutionContext> mvelContext) {
        ExecutorService executionService = Executors.newFixedThreadPool(this.MAX_PARALLEL_FEATURE_GROUP());
        ExecutionContextExecutorService executionContext = ExecutionContext$.MODULE$.fromExecutorService(executionService);
        Map<FeatureTransformation.FeatureGroupingCriteria, Map<FeatureAnchorWithSource, FeatureTransformation.FeatureGroupWithSameTimeWindow>> groupedAnchorToFeatureGroups = this.groupFeatures(anchorToSourceDFThisStage, (Set<String>)requestedFeatureNames.toSet());
        Iterable futures = (Iterable)groupedAnchorToFeatureGroups.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            FeatureTransformation.FeatureGroupingCriteria featureGroupingFactors = (FeatureTransformation.FeatureGroupingCriteria)tuple2._1();
            Map anchorsWithSameSource = (Map)tuple2._2();
            Future future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                Seq seq;
                SourceKeyExtractor keyExtractor = ((FeatureAnchorWithSource)((Tuple2)anchorsWithSameSource.head())._1()).featureAnchor().sourceKeyExtractor();
                Seq featureAnchorWithSource = anchorsWithSameSource.keys().toSeq();
                Seq selectedFeatures = ((TraversableOnce)anchorsWithSameSource.flatMap((Function1 & Serializable & scala.Serializable)x$12 -> ((FeatureTransformation.FeatureGroupWithSameTimeWindow)x$12._2()).featureNames(), Iterable$.MODULE$.canBuildFrom())).toSeq();
                boolean isAvroRddBasedExtractor = ((TraversableOnce)((TraversableLike)featureAnchorWithSource.map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.featureAnchor().extractor(), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)extractor -> BoxesRunTime.boxToBoolean((boolean)FeatureTransformation$.$anonfun$transformFeatures$5(extractor)))).nonEmpty();
                if (isAvroRddBasedExtractor) {
                    DataSourceAccessor sourceAccessor = featureGroupingFactors.source();
                    Dataset<Row> sourceRdd = ((NonTimeBasedDataSourceAccessor)sourceAccessor).get();
                    Map featureTypeConfigs = ((TraversableOnce)featureAnchorWithSource.flatMap((Function1 & Serializable & scala.Serializable)featureAnchor -> featureAnchor.featureAnchor().featureTypeConfigs(), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    seq = (Seq)new .colon.colon((Object)MODULE$.transformFeaturesOnAvroRecord(sourceRdd, keyExtractor, (Seq<FeatureAnchorWithSource>)featureAnchorWithSource, bloomFilter, (Seq<String>)selectedFeatures, (Map<String, FeatureTypeConfig>)featureTypeConfigs), (List)Nil$.MODULE$);
                } else {
                    DataSourceAccessor sourceDF = featureGroupingFactors.source();
                    seq = MODULE$.transformFeaturesOnDataFrameRow(sourceDF, keyExtractor, (Seq<FeatureAnchorWithSource>)featureAnchorWithSource, bloomFilter, (Seq<String>)selectedFeatures, incrementalAggContext, mvelContext);
                }
                Seq transformedResults = seq;
                Seq res = (Seq)((TraversableOnce)transformedResults.map((Function1 & Serializable & scala.Serializable)transformedResultWithKey -> {
                    Dataset selectedDF;
                    Dataset<Row> transformedDF = transformedResultWithKey.transformedResult().df();
                    Seq<String> outputJoinKeyColumnNames = transformedResultWithKey.joinKey();
                    Seq<Tuple2<String, String>> featureNamePrefixPair = transformedResultWithKey.transformedResult().featureNameAndPrefixPairs();
                    String rightJoinKeyPrefix = new StringBuilder(1).append(featureGroupingFactors.sourceKeyExtry().replaceAll("[^\\w]", "")).append("_").toString();
                    Seq joinKeyColumnToNewColName = (Seq)outputJoinKeyColumnNames.map((Function1 & Serializable & scala.Serializable)keyCol -> {
                        String cleanedJoinKeyColumn = new StringBuilder(0).append(rightJoinKeyPrefix).append((String)keyCol).toString().replaceAll("[^\\w]", "_");
                        return new Tuple2((Object)transformedDF.apply(keyCol), (Object)cleanedJoinKeyColumn);
                    }, Seq$.MODULE$.canBuildFrom());
                    Seq joinKeyColumnNames = (Seq)joinKeyColumnToNewColName.map((Function1 & Serializable & scala.Serializable)x$14 -> (String)x$14._2(), Seq$.MODULE$.canBuildFrom());
                    Seq featureColumnToNewColumnName = (Seq)featureNamePrefixPair.map((Function1 & Serializable & scala.Serializable)featurePair -> {
                        String featureRefStrInDF = DataFrameColName$.MODULE$.getEncodedFeatureRefStrForColName((String)featurePair._1());
                        return new Tuple2((Object)transformedDF.apply(new StringBuilder(0).append((String)featurePair._2()).append(featureRefStrInDF).toString()), (Object)DataFrameColName$.MODULE$.genFeatureColumnName(featureRefStrInDF, DataFrameColName$.MODULE$.genFeatureColumnName$default$2()));
                    }, Seq$.MODULE$.canBuildFrom());
                    Seq featureNames = (Seq)featureNamePrefixPair.map((Function1 & Serializable & scala.Serializable)x$15 -> (String)x$15._1(), Seq$.MODULE$.canBuildFrom());
                    if (((SeqLike)((SeqLike)featureColumnToNewColumnName.map((Function1 & Serializable & scala.Serializable)x$16 -> (String)x$16._2(), Seq$.MODULE$.canBuildFrom())).distinct()).size() != ((SeqLike)featureColumnToNewColumnName.map((Function1 & Serializable & scala.Serializable)x$17 -> (String)x$17._2(), Seq$.MODULE$.canBuildFrom())).size()) {
                        throw new FeathrFeatureTransformationException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(42).append("Fatal internal error, ").append(featureColumnToNewColumnName).append(" should be distinct!").toString());
                    }
                    Dataset x$1 = selectedDF = transformedDF.select((Seq)((TraversableLike)joinKeyColumnToNewColName.$plus$plus((GenTraversableOnce)featureColumnToNewColumnName, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Column column = (Column)tuple2._1();
                        String newColumnName = (String)tuple2._2();
                        Column column2 = column.alias(newColumnName);
                        return column2;
                    }, Seq$.MODULE$.canBuildFrom()));
                    Seq<Tuple2<String, String>> x$2 = transformedResultWithKey.transformedResult().copy$default$1();
                    Map<String, Enumeration.Value> x$3 = transformedResultWithKey.transformedResult().copy$default$3();
                    Map<String, FeatureTypeConfig> x$4 = transformedResultWithKey.transformedResult().copy$default$4();
                    TransformedResult updatedTransformedResult = transformedResultWithKey.transformedResult().copy(x$2, (Dataset<Row>)x$1, x$3, x$4);
                    KeyedTransformedResult updatedKeyedTransformedResult = new KeyedTransformedResult((Seq<String>)joinKeyColumnNames, updatedTransformedResult);
                    return (Seq)featureNames.map((Function1 & Serializable & scala.Serializable)featureName -> new Tuple2(featureName, (Object)updatedKeyedTransformedResult), Seq$.MODULE$.canBuildFrom());
                }, Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$18, x$19) -> (Seq)x$18.$plus$plus((GenTraversableOnce)x$19, Seq$.MODULE$.canBuildFrom()));
                Seq computedFeatures = (Seq)res.map((Function1 & Serializable & scala.Serializable)x$20 -> (String)x$20._1(), Seq$.MODULE$.canBuildFrom());
                if (((SeqLike)computedFeatures.distinct()).size() != computedFeatures.size()) {
                    throw new FeathrFeatureTransformationException(ErrorLabel.FEATHR_ERROR, new StringBuilder(127).append("Internal error: ").append(computedFeatures).append(" should be not have duplicate features, ").append("this means some features are computed multiple times, current anchors: ").append(featureAnchorWithSource).toString());
                }
                return res.toMap(Predef$.MODULE$.$conforms());
            }, (ExecutionContext)executionContext);
            return future;
        }, Iterable$.MODULE$.canBuildFrom());
        return (Map)((TraversableOnce)futures.map((Function1 & Serializable & scala.Serializable)k -> (Map)Await$.MODULE$.result((Awaitable)k, (Duration)Duration$.MODULE$.Inf()), Iterable$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$21, x$22) -> x$21.$plus$plus((GenTraversableOnce)x$22));
    }

    public Option<IncrementalAggContext> transformFeatures$default$4() {
        return None$.MODULE$;
    }

    public Dataset<Row> pruneAndRenameColumnWithTags(Dataset<Row> contextDF, Seq<String> columnsToKeep, Seq<String> featuresToRename, Seq<String> columnsToProcess, List<String> tagsInfo) {
        Set featureColumnsToRename = ((TraversableOnce)featuresToRename.map((Function1 & Serializable & scala.Serializable)x$23 -> DataFrameColName$.MODULE$.genFeatureColumnName((String)x$23, DataFrameColName$.MODULE$.genFeatureColumnName$default$2()), Seq$.MODULE$.canBuildFrom())).toSet();
        this.logger().trace((Object)new StringBuilder(25).append("featureColumnsToRename = ").append(featureColumnsToRename).toString());
        Seq featureColumnsRenameMap = (Seq)((TraversableLike)columnsToProcess.filter((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)featureColumnsToRename.contains((Object)x$24)))).map((Function1 & Serializable & scala.Serializable)featureName -> new Tuple2((Object)contextDF.col(featureName), (Object)DataFrameColName$.MODULE$.genFeatureColumnName((String)featureName, (Option<Seq<String>>)new Some((Object)tagsInfo))), Seq$.MODULE$.canBuildFrom());
        this.logger().trace((Object)new StringBuilder(26).append("featureColumnsRenameMap = ").append(featureColumnsRenameMap).toString());
        Seq columnsToKeepRenameMap = (Seq)columnsToKeep.map((Function1 & Serializable & scala.Serializable)colName -> new Tuple2((Object)contextDF.col(colName), colName), Seq$.MODULE$.canBuildFrom());
        this.logger().trace((Object)new StringBuilder(25).append("columnsToKeepRenameMap = ").append(columnsToKeepRenameMap).toString());
        Seq reservedColumnPairs = (Seq)columnsToKeepRenameMap.$plus$plus((GenTraversableOnce)featureColumnsRenameMap, Seq$.MODULE$.canBuildFrom());
        this.logger().trace((Object)new StringBuilder(22).append("reservedColumnPairs = ").append(reservedColumnPairs).toString());
        return contextDF.select((Seq)reservedColumnPairs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Column x = (Column)tuple2._1();
            String y = (String)tuple2._2();
            Column column = x.alias(y);
            return column;
        }, Seq$.MODULE$.canBuildFrom()));
    }

    public Dataset<Row> dropIfNullValuesForAllColumns(Dataset<Row> inputDF, Seq<String> columnNames) {
        return inputDF.na().drop("all", columnNames);
    }

    public FeatureTypeInferenceContext getTypeInferenceContext(SparkSession ss, Map<String, FeatureTypes> featureTypes, Seq<String> featureRefStrs) {
        Map featureTypeAccumulators = ((TraversableOnce)featureRefStrs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string = x0$1;
            FeatureTypes defaultType = featureTypes.contains((Object)string) ? (FeatureTypes)((Object)((Object)featureTypes.apply((Object)string))) : FeatureTypes.UNSPECIFIED;
            FeatureTypeAccumulator accumulator = new FeatureTypeAccumulator(defaultType);
            ss.sparkContext().register((AccumulatorV2)accumulator, string);
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)string), (Object)accumulator);
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return new FeatureTypeInferenceContext((Map<String, FeatureTypeAccumulator>)featureTypeAccumulators);
    }

    public Seq<StructField> getFDSSchemaFields(Seq<String> featureRefStrs, Map<String, FeatureTypeConfig> featureTypeConfigs, String colNamePrefx) {
        Seq featureTensorTypeInfo = (Seq)featureRefStrs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            StructField dType;
            String string = x0$1;
            FeatureTypeConfig featureTypeConfig = (FeatureTypeConfig)featureTypeConfigs.getOrElse((Object)string, (Function0 & Serializable & scala.Serializable)() -> FeatureTypeConfig.UNDEFINED_TYPE_CONFIG);
            TensorType tensorType = FeaturizedDatasetUtils$.MODULE$.lookupTensorTypeForFeatureRef(string, (Option<DataType>)None$.MODULE$, featureTypeConfig);
            DataType schemaType = FeaturizedDatasetUtils$.MODULE$.tensorTypeToDataFrameSchema(tensorType);
            String columnName = new StringBuilder(0).append(colNamePrefx).append(string).toString();
            StructField structField = dType = new StructField(columnName, schemaType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            return structField;
        }, Seq$.MODULE$.canBuildFrom());
        return featureTensorTypeInfo;
    }

    public Map<String, FeatureTypeConfig> getFDSSchemaFields$default$2() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public String getFDSSchemaFields$default$3() {
        return "";
    }

    public Map<String, FeatureTypes> inferFeatureTypes(Map<String, FeatureTypeAccumulator> featureTypeAccumulators, RDD<Row> transformedRdd, Seq<String> featureRefStrs) {
        int featureNum = featureTypeAccumulators.size();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), featureNum).par().map((Function1 & Serializable & scala.Serializable)idx -> FeatureTransformation$.$anonfun$inferFeatureTypes$1(transformedRdd, BoxesRunTime.unboxToInt((Object)idx)), (CanBuildFrom)ParSeq$.MODULE$.canBuildFrom());
        Map actualFeatureTypes = featureTypeAccumulators.mapValues((Function1 & Serializable & scala.Serializable)featureTypeAcc -> featureTypeAcc.value());
        return actualFeatureTypes;
    }

    private Dataset<Row> applyBloomFilter(Tuple2<SourceKeyExtractor, Dataset<Row>> sourceExtractorWithDF, Option<BloomFilter> bloomFilter) {
        Dataset dataset;
        Option<BloomFilter> option = bloomFilter;
        if (None$.MODULE$.equals(option)) {
            dataset = (Dataset)sourceExtractorWithDF._2();
        } else if (option instanceof Some) {
            Dataset dataset2;
            Seq<String> seq;
            Some some = (Some)option;
            BloomFilter filter = (BloomFilter)some.value();
            SourceKeyExtractor sourceKeyExtractor = (SourceKeyExtractor)sourceExtractorWithDF._1();
            if (sourceKeyExtractor instanceof MVELSourceKeyExtractor) {
                MVELSourceKeyExtractor mvelSourceKeyExtractor = (MVELSourceKeyExtractor)sourceKeyExtractor;
                seq = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Dataset)sourceExtractorWithDF._2()).head(1))).isEmpty() ? mvelSourceKeyExtractor.getKeyColumnNames((Option<Object>)None$.MODULE$) : mvelSourceKeyExtractor.getKeyColumnNames((Option<Object>)new Some(((Dataset)sourceExtractorWithDF._2()).first()));
            } else if (sourceKeyExtractor != null) {
                SourceKeyExtractor sourceKeyExtractor2 = sourceKeyExtractor;
                seq = sourceKeyExtractor2.getKeyColumnNames(sourceKeyExtractor2.getKeyColumnNames$default$1());
            } else {
                throw new FeathrFeatureTransformationException(ErrorLabel.FEATHR_USER_ERROR, "No source key extractor found");
            }
            Seq<String> keyColumnsList = seq;
            if (!keyColumnsList.isEmpty()) {
                boolean x$3;
                Seq<String> x$2;
                Dataset x$1;
                DataFrameKeyCombiner qual$1 = DataFrameKeyCombiner$.MODULE$.apply();
                Tuple2<String, Dataset<Row>> tuple2 = qual$1.combine((Dataset<Row>)(x$1 = (Dataset)sourceExtractorWithDF._2()), x$2 = keyColumnsList, x$3 = qual$1.combine$default$3());
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String bfFactKeyColName = (String)tuple2._1();
                Dataset factDataWithKeys = (Dataset)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)bfFactKeyColName, (Object)factDataWithKeys);
                Tuple2 tuple23 = tuple22;
                String bfFactKeyColName2 = (String)tuple23._1();
                Dataset factDataWithKeys2 = (Dataset)tuple23._2();
                Dataset filtered = factDataWithKeys2.filter(SlidingWindowFeatureUtils$.MODULE$.mightContain(filter).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(bfFactKeyColName2)})));
                dataset2 = filtered.drop(functions$.MODULE$.col(bfFactKeyColName2));
            } else {
                dataset2 = (Dataset)sourceExtractorWithDF._2();
            }
            dataset = dataset2;
        } else {
            throw new MatchError(option);
        }
        return dataset;
    }

    private RDD<IndexedRecord> applyBloomFilterRdd(SourceKeyExtractor keyExtractor, RDD<IndexedRecord> rdd, Option<BloomFilter> bloomFilter) {
        RDD rDD;
        Option<BloomFilter> option = bloomFilter;
        if (None$.MODULE$.equals(option)) {
            rDD = rdd;
        } else if (option instanceof Some) {
            RDD filtered;
            Some some = (Some)option;
            BloomFilter filter = (BloomFilter)some.value();
            SourceKeyExtractor sourceKeyExtractor = keyExtractor;
            if (!(sourceKeyExtractor instanceof MVELSourceKeyExtractor)) {
                throw new FeathrFeatureTransformationException(ErrorLabel.FEATHR_USER_ERROR, "No source key extractor found");
            }
            MVELSourceKeyExtractor mVELSourceKeyExtractor = (MVELSourceKeyExtractor)sourceKeyExtractor;
            Seq<String> keyColumnsList = rdd.isEmpty() ? mVELSourceKeyExtractor.getKeyColumnNames((Option<Object>)None$.MODULE$) : mVELSourceKeyExtractor.getKeyColumnNames((Option<Object>)new Some(rdd.first()));
            RDD rDD2 = !keyColumnsList.isEmpty() ? (filtered = rdd.filter((Function1 & Serializable & scala.Serializable)record -> BoxesRunTime.boxToBoolean((boolean)FeatureTransformation$.$anonfun$applyBloomFilterRdd$1(mVELSourceKeyExtractor, filter, record)))) : rdd;
            rDD = rDD2;
        } else {
            throw new MatchError(option);
        }
        return rDD;
    }

    private KeyedTransformedResult transformFeaturesOnAvroRecord(Dataset<Row> df, SourceKeyExtractor keyExtractor, Seq<FeatureAnchorWithSource> featureAnchorWithSources, Option<BloomFilter> bloomFilter, Seq<String> requestedFeatureNames, Map<String, FeatureTypeConfig> featureTypeConfigs) {
        Map<String, FeatureTypeAccumulator> featureTypeAccumulators;
        if (!(keyExtractor instanceof MVELSourceKeyExtractor)) {
            throw new FeathrException(ErrorLabel.FEATHR_ERROR, new StringBuilder(89).append("Error processing requested Feature :").append(requestedFeatureNames).append(". ").append("Key extractor ").append(keyExtractor).append(" must extends MVELSourceKeyExtractor.").toString());
        }
        MVELSourceKeyExtractor extractor = (MVELSourceKeyExtractor)keyExtractor;
        if (!(extractor.anchorExtractorV1() instanceof CanConvertToAvroRDD)) {
            throw new FeathrException(ErrorLabel.FEATHR_ERROR, new StringBuilder(125).append("Error processing requested Feature :").append(requestedFeatureNames).append(". ").append("isLowLevelRddExtractor() should return true and convertToAvroRdd should be implemented.").toString());
        }
        RDD<IndexedRecord> rdd = ((CanConvertToAvroRDD)((Object)extractor.anchorExtractorV1())).convertToAvroRdd(df);
        RDD<IndexedRecord> filteredFactData = this.applyBloomFilterRdd(keyExtractor, rdd, bloomFilter);
        Seq transformInfo = (Seq)featureAnchorWithSources.map((Function1 & Serializable & scala.Serializable)featureAnchorWithSource -> {
            Object extractor = featureAnchorWithSource.featureAnchor().extractor();
            Object object = extractor;
            if (!(object instanceof AnchorExtractorBase)) {
                throw new FeathrFeatureTransformationException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(39).append("Unsupported transformer ").append(extractor).append(" for features: ").append(requestedFeatureNames).toString());
            }
            AnchorExtractorBase anchorExtractorBase = (AnchorExtractorBase)object;
            String featureNamePrefix = "";
            Seq featureNames = (Seq)featureAnchorWithSource.selectedFeatures().filter((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)requestedFeatureNames.contains(elem)));
            Seq featureNamePrefixPairs = (Seq)featureNames.map((Function1 & Serializable & scala.Serializable)x$27 -> new Tuple2(x$27, (Object)featureNamePrefix), Seq$.MODULE$.canBuildFrom());
            TransformInfo transformInfo = new TransformInfo((FeatureAnchorWithSource)featureAnchorWithSource, (Seq<Tuple2<String, String>>)featureNamePrefixPairs, anchorExtractorBase);
            return transformInfo;
        }, Seq$.MODULE$.canBuildFrom());
        Seq sourceKeyExtractors = (Seq)transformInfo.map((Function1 & Serializable & scala.Serializable)x$28 -> x$28.featureAnchorWithSource().featureAnchor().sourceKeyExtractor(), Seq$.MODULE$.canBuildFrom());
        Predef$.MODULE$.assert(((SeqLike)((SeqLike)sourceKeyExtractors.map((Function1 & Serializable & scala.Serializable)x$29 -> x$29.toString(), Seq$.MODULE$.canBuildFrom())).distinct()).size() == 1);
        Seq transformers = (Seq)transformInfo.map((Function1 & Serializable & scala.Serializable)x$30 -> x$30.transformer(), Seq$.MODULE$.canBuildFrom());
        SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
        Map userProvidedFeatureTypes = ((TraversableOnce)transformInfo.flatMap((Function1 & Serializable & scala.Serializable)x$31 -> (Map)x$31.featureAnchorWithSource().featureAnchor().getFeatureTypes().getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        FeatureTypeInferenceContext featureTypeInferenceContext = this.getTypeInferenceContext(spark, (Map<String, FeatureTypes>)userProvidedFeatureTypes, requestedFeatureNames);
        if (featureTypeInferenceContext == null) {
            throw new MatchError((Object)featureTypeInferenceContext);
        }
        Map<String, FeatureTypeAccumulator> map = featureTypeAccumulators = featureTypeInferenceContext.featureTypeAccumulators();
        Map<String, FeatureTypeAccumulator> featureTypeAccumulators2 = map;
        RDD transformedRdd = filteredFactData.map((Function1 & Serializable & scala.Serializable)record -> {
            Tuple2<Seq<String>, Seq<Tuple2<Object, FeatureType>>> tuple2 = MODULE$.transformAvroRecord(requestedFeatureNames, (Seq<SourceKeyExtractor>)sourceKeyExtractors, (Seq<AnchorExtractorBase<IndexedRecord>>)transformers, (IndexedRecord)record, featureTypeConfigs);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Seq keys = (Seq)tuple2._1();
            Seq featureValuesWithType = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)keys, (Object)featureValuesWithType);
            Tuple2 tuple23 = tuple22;
            Seq keys2 = (Seq)tuple23._1();
            Seq featureValuesWithType2 = (Seq)tuple23._2();
            ((IterableLike)requestedFeatureNames.zip((GenIterable)featureValuesWithType2, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                FeatureTransformation$.$anonfun$transformFeaturesOnAvroRecord$10(featureTypeAccumulators2, x0$1);
                return BoxedUnit.UNIT;
            });
            return Row$.MODULE$.merge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.fromSeq(keys2), Row$.MODULE$.fromSeq((Seq)featureValuesWithType2.map((Function1 & Serializable & scala.Serializable)x$33 -> x$33._1(), Seq$.MODULE$.canBuildFrom()))}));
        }, ClassTag$.MODULE$.apply(Row.class));
        Seq<String> keyNames = this.getFeatureKeyColumnNamesRdd((SourceKeyExtractor)sourceKeyExtractors.head(), filteredFactData);
        Map allFeatureTypeConfigs = ((TraversableOnce)featureAnchorWithSources.flatMap((Function1 & Serializable & scala.Serializable)featureAnchorWithSource -> featureAnchorWithSource.featureAnchor().featureTypeConfigs(), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map<String, FeatureTypes> inferredFeatureTypes = this.inferFeatureTypes(featureTypeAccumulators2, (RDD<Row>)transformedRdd, requestedFeatureNames);
        Map inferredFeatureTypeConfigs = (Map)inferredFeatureTypes.map((Function1 & Serializable & scala.Serializable)x -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x._1()), (Object)new FeatureTypeConfig((FeatureTypes)((Object)((Object)x._2())))), Map$.MODULE$.canBuildFrom());
        Map mergedFeatureTypeConfig = inferredFeatureTypeConfigs.$plus$plus((GenTraversableOnce)allFeatureTypeConfigs);
        String colPrefix = "";
        Seq<StructField> featureTensorTypeInfo = this.getFDSSchemaFields(requestedFeatureNames, (Map<String, FeatureTypeConfig>)mergedFeatureTypeConfig, colPrefix);
        List structFields = (List)keyNames.foldRight((Object)List$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(x0$2, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$2, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String colName = (String)tuple2._1();
            List acc = (List)tuple2._2();
            StructField structField = new StructField(colName, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            List list = acc.$colon$colon((Object)structField);
            return list;
        });
        StructType outputSchema = StructType$.MODULE$.apply((Seq)StructType$.MODULE$.apply((Seq)structFields.$plus$plus(featureTensorTypeInfo, List$.MODULE$.canBuildFrom())));
        Tuple2 tuple2 = new Tuple2((Object)outputSchema, (Object)mergedFeatureTypeConfig);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        StructType outputSchema2 = (StructType)tuple2._1();
        Map inferredFeatureTypeConfigs2 = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)outputSchema2, (Object)inferredFeatureTypeConfigs2);
        Tuple2 tuple23 = tuple22;
        StructType outputSchema3 = (StructType)tuple23._1();
        Map inferredFeatureTypeConfigs3 = (Map)tuple23._2();
        Dataset transformedDF = spark.createDataFrame(transformedRdd, outputSchema3);
        Enumeration.Value featureFormat = FeatureColumnFormat$.MODULE$.FDS_TENSOR();
        Map featureColumnFormats = ((TraversableOnce)requestedFeatureNames.map((Function1 & Serializable & scala.Serializable)name -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), (Object)featureFormat), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        TransformedResult transformedInfo = new TransformedResult((Seq<Tuple2<String, String>>)((Seq)transformInfo.flatMap((Function1 & Serializable & scala.Serializable)x$36 -> x$36.featureNamePrefixPairs(), Seq$.MODULE$.canBuildFrom())), (Dataset<Row>)transformedDF, (Map<String, Enumeration.Value>)featureColumnFormats, (Map<String, FeatureTypeConfig>)inferredFeatureTypeConfigs3);
        return new KeyedTransformedResult(keyNames, transformedInfo);
    }

    private Map<String, FeatureTypeConfig> transformFeaturesOnAvroRecord$default$6() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    private Tuple2<Seq<String>, Seq<Tuple2<Object, FeatureType>>> transformAvroRecord(Seq<String> requestedFeatureNames, Seq<SourceKeyExtractor> sourceKeyExtractors, Seq<AnchorExtractorBase<IndexedRecord>> transformers, IndexedRecord record, Map<String, FeatureTypeConfig> featureTypeConfigs) {
        SourceKeyExtractor sourceKeyExtractor = (SourceKeyExtractor)sourceKeyExtractors.head();
        if (!(sourceKeyExtractor instanceof MVELSourceKeyExtractor)) {
            throw new FeathrFeatureTransformationException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(32).append(sourceKeyExtractors.head()).append(" is not a valid extractor on RDD").toString());
        }
        MVELSourceKeyExtractor mVELSourceKeyExtractor = (MVELSourceKeyExtractor)sourceKeyExtractor;
        Seq<String> seq = mVELSourceKeyExtractor.getKey(record);
        Seq<String> keys = seq;
        Map features = (Map)((TraversableOnce)transformers.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AnchorExtractorBase anchorExtractorBase = x0$1;
            if (!(anchorExtractorBase instanceof AnchorExtractor)) {
                throw new FeathrFeatureTransformationException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(53).append("Invalid extractor ").append(anchorExtractorBase).append(" for features:").append(requestedFeatureNames).append(" requested as tensors").toString());
            }
            AnchorExtractor anchorExtractor = (AnchorExtractor)anchorExtractorBase;
            Map<String, FeatureValue> features = anchorExtractor.getFeatures(record);
            Predef$.MODULE$.print(features);
            FeatureValueTypeValidator$.MODULE$.validate(features, featureTypeConfigs);
            Map<String, FeatureValue> map = features;
            return map;
        }, Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$37, x$38) -> x$37.$plus$plus((GenTraversableOnce)x$38));
        if (this.logger().isTraceEnabled()) {
            this.logger().trace((Object)new StringBuilder(20).append("Extracted features: ").append(features).toString());
        }
        Seq featureValuesWithType = (Seq)requestedFeatureNames.map((Function1 & Serializable & scala.Serializable)name -> (Tuple2)features.get(name).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            FeatureValue featureValue = x0$2;
            TensorData tensorData = featureValue.getAsTensorData();
            FeatureType featureType = featureValue.getFeatureType();
            Object row = FeaturizedDatasetUtils$.MODULE$.tensorToFDSDataFrameRow(tensorData, FeaturizedDatasetUtils$.MODULE$.tensorToFDSDataFrameRow$default$2());
            Tuple2 tuple2 = new Tuple2(row, (Object)featureType);
            return tuple2;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Tuple2(null, null)), Seq$.MODULE$.canBuildFrom());
        return new Tuple2(keys, (Object)featureValuesWithType);
    }

    private Map<String, FeatureTypeConfig> transformAvroRecord$default$5() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    private Map<FeatureTransformation.FeatureGroupingCriteria, Map<FeatureAnchorWithSource, FeatureTransformation.FeatureGroupWithSameTimeWindow>> groupAndMergeAnchors(List<FeatureTransformation.AnchorFeaturesWithGroupingCriteriaAndExtractorClass> anchorsWithGroupingCriteria) {
        Map groupedByCriteriaAndExtractorType = anchorsWithGroupingCriteria.groupBy((Function1 & Serializable & scala.Serializable)record -> new Tuple2((Object)record.groupingCriteria(), record.extractorClass())).mapValues((Function1 & Serializable & scala.Serializable)groupedValues -> {
            Map map;
            FeatureAnchorWithSource representativeFeatureAnchorWithSource = (FeatureAnchorWithSource)((Tuple2)((FeatureTransformation.AnchorFeaturesWithGroupingCriteriaAndExtractorClass)groupedValues.head()).anchor()._1())._1();
            FeatureAnchor representativeAnchor = representativeFeatureAnchorWithSource.featureAnchor();
            FeatureTransformation.FeatureGroupWithSameTimeWindow representativeFeatureGroup = (FeatureTransformation.FeatureGroupWithSameTimeWindow)((FeatureTransformation.AnchorFeaturesWithGroupingCriteriaAndExtractorClass)groupedValues.head()).anchor()._2();
            Object object = representativeAnchor.extractor();
            if (object instanceof SimpleConfigurableAnchorExtractor) {
                Map combinedAnchorDefinitions = (Map)groupedValues.foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable & scala.Serializable)(result, kv) -> result.$plus$plus(((SimpleConfigurableAnchorExtractor)((FeatureAnchorWithSource)((Tuple2)kv.anchor()._1())._1()).featureAnchor().getAsAnchorExtractor()).getFeaturesDefinitions()));
                Seq<String> keyForAllFeatures = ((SimpleConfigurableAnchorExtractor)representativeAnchor.getAsAnchorExtractor()).getKeyExpression();
                SimpleConfigurableAnchorExtractor combinedAnchorExtractor = new SimpleConfigurableAnchorExtractor(keyForAllFeatures, (Map<String, MVELFeatureDefinition>)combinedAnchorDefinitions);
                Map combinedDefaults = (Map)groupedValues.foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable & scala.Serializable)(result, kv) -> result.$plus$plus(((FeatureAnchorWithSource)((Tuple2)kv.anchor()._1())._1()).featureAnchor().defaults()));
                Map combinedFeatureTypeConfigs = (Map)groupedValues.foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable & scala.Serializable)(result, kv) -> result.$plus$plus(((FeatureAnchorWithSource)((Tuple2)kv.anchor()._1())._1()).featureAnchor().featureTypeConfigs()));
                Set combinedAnchorFeatures = (Set)groupedValues.foldLeft((Object)Predef$.MODULE$.Set().empty(), (Function2 & Serializable & scala.Serializable)(result, kv) -> (Set)result.$plus$plus(((FeatureAnchorWithSource)((Tuple2)kv.anchor()._1())._1()).featureAnchor().features()));
                FeatureAnchor combinedFeatureAnchor = new FeatureAnchor(representativeAnchor.sourceIdentifier(), combinedAnchorExtractor, (Map<String, FeatureValue>)combinedDefaults, representativeAnchor.lateralViewParams(), representativeAnchor.sourceKeyExtractor(), (Set<String>)combinedAnchorFeatures, (Map<String, FeatureTypeConfig>)combinedFeatureTypeConfigs);
                Seq combinedSelectedFeatures = (Seq)((SeqLike)groupedValues.foldLeft((Object)Nil$.MODULE$, (Function2 & Serializable & scala.Serializable)(result, kv) -> (Seq)result.$plus$plus(((FeatureAnchorWithSource)((Tuple2)kv.anchor()._1())._1()).selectedFeatures(), Seq$.MODULE$.canBuildFrom()))).distinct();
                FeatureAnchorWithSource combinedFeatureAnchorWithSource = new FeatureAnchorWithSource(combinedFeatureAnchor, representativeFeatureAnchorWithSource.source(), representativeFeatureAnchorWithSource.dateParam(), (Option<Seq<String>>)new Some((Object)combinedSelectedFeatures));
                FeatureTransformation.FeatureGroupWithSameTimeWindow groupedFeatureGroup = new FeatureTransformation.FeatureGroupWithSameTimeWindow(representativeFeatureGroup.timeWindow(), (Seq<String>)combinedSelectedFeatures);
                map = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)combinedFeatureAnchorWithSource, (Object)groupedFeatureGroup)}));
            } else {
                boolean bl = object instanceof TimeWindowConfigurableAnchorExtractor ? true : (object instanceof SimpleAnchorExtractorSpark ? true : (object instanceof SQLConfigurableAnchorExtractor ? true : object instanceof AnchorExtractor));
                if (bl) {
                    map = (Map)groupedValues.foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable & scala.Serializable)(result, kv) -> result.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2(((Tuple2)kv.anchor()._1())._1(), kv.anchor()._2())}))));
                } else {
                    throw new FeathrFeatureTransformationException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(34).append("cannot find valid Transformer for ").append(representativeFeatureAnchorWithSource).toString());
                }
            }
            return map;
        });
        return groupedByCriteriaAndExtractorType.groupBy((Function1 & Serializable & scala.Serializable)x$39 -> (FeatureTransformation.FeatureGroupingCriteria)((Tuple2)x$39._1())._1()).mapValues((Function1 & Serializable & scala.Serializable)groupedByCriteria -> (Map)groupedByCriteria.foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable & scala.Serializable)(result, kv) -> result.$plus$plus((GenTraversableOnce)kv._2())));
    }

    public Map<FeatureTransformation.FeatureGroupingCriteria, Map<FeatureAnchorWithSource, FeatureTransformation.FeatureGroupWithSameTimeWindow>> groupFeatures(Map<FeatureAnchorWithSource, DataSourceAccessor> anchorToSourceDFThisStage, Set<String> requestedFeatureNames) {
        Map anchorToFeatureGroups = (Map)anchorToSourceDFThisStage.flatMap((Function1 & Serializable & scala.Serializable)anchorWithSourceDF -> {
            FeatureAnchorWithSource anchor = (FeatureAnchorWithSource)anchorWithSourceDF._1();
            Seq selectedFeatureNames = (Seq)anchor.selectedFeatures().filter((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)requestedFeatureNames.contains((Object)elem)));
            Some x$1 = new Some((Object)selectedFeatureNames);
            FeatureAnchor x$2 = anchor.copy$default$1();
            DataSource x$3 = anchor.copy$default$2();
            Option<DateParam> x$4 = anchor.copy$default$3();
            FeatureAnchorWithSource newAnchorWithSelectedFeatures = anchor.copy(x$2, x$3, x$4, (Option<Seq<String>>)x$1);
            Tuple2 anchorWithSource = new Tuple2((Object)newAnchorWithSelectedFeatures, anchorWithSourceDF._2());
            Seq windowParamToFeatureName = (Seq)selectedFeatureNames.map((Function1 & Serializable & scala.Serializable)f -> new Tuple2(anchor.dateParam(), f), Seq$.MODULE$.canBuildFrom());
            Map windowToFeatureNames = windowParamToFeatureName.groupBy((Function1 & Serializable & scala.Serializable)x$40 -> (Option)x$40._1()).mapValues((Function1 & Serializable & scala.Serializable)seq -> (Seq)((TraversableOnce)seq.map((Function1 & Serializable & scala.Serializable)f -> (Seq)new .colon.colon((Object)((String)f._2()), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(a, b) -> (Seq)a.$plus$plus((GenTraversableOnce)b, Seq$.MODULE$.canBuildFrom())));
            return (Map)windowToFeatureNames.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Option timeWindow = (Option)tuple2._1();
                Seq featureNames = (Seq)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)anchorWithSource, (Object)new FeatureTransformation.FeatureGroupWithSameTimeWindow((Option<DateParam>)timeWindow, (Seq<String>)featureNames));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
        }, Map$.MODULE$.canBuildFrom());
        List groupedByCriteriaAndExtractorType = ((TraversableOnce)((TraversableLike)anchorToFeatureGroups.flatMap((Function1 & Serializable & scala.Serializable)anchorToFeatureGroupEntry -> {
            FeatureTransformation.FeatureGroupWithSameTimeWindow featureGroupWithSameTimeWindow;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = anchorToFeatureGroupEntry;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    featureGroupWithSameTimeWindow = (FeatureTransformation.FeatureGroupWithSameTimeWindow)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            FeatureAnchorWithSource anchorWithSourceDF = (FeatureAnchorWithSource)tuple2._1();
            DataSourceAccessor timeSeriesSource = (DataSourceAccessor)tuple2._2();
            Tuple3 tuple3 = new Tuple3((Object)anchorWithSourceDF, (Object)timeSeriesSource, (Object)featureGroupWithSameTimeWindow);
            Tuple3 tuple32 = tuple3;
            FeatureAnchorWithSource anchorWithSourceDF2 = (FeatureAnchorWithSource)tuple32._1();
            DataSourceAccessor timeSeriesSource2 = (DataSourceAccessor)tuple32._2();
            FeatureTransformation.FeatureGroupWithSameTimeWindow featureGroupWithSameTimeWindow2 = (FeatureTransformation.FeatureGroupWithSameTimeWindow)tuple32._3();
            Option<DateParam> windowParam = featureGroupWithSameTimeWindow2.timeWindow();
            String timeWindowGroupByIdentifier = Option$.MODULE$.option2Iterable(windowParam).mkString("__feathr_time_window_groupby__");
            Object featureExtractor = anchorWithSourceDF2.featureAnchor().extractor();
            String sourcekeyExtractorIdentifier = featureExtractor instanceof SimpleAnchorExtractorSpark || featureExtractor instanceof AnchorExtractor ? anchorWithSourceDF2.featureAnchor().sourceKeyExtractor().toString() : UUID.randomUUID().toString();
            Map<String, Dataset<Row>> preprocessedDfMap = PreprocessedDataFrameManager$.MODULE$.preprocessedDfMap();
            List featuresInAnchor = anchorWithSourceDF2.featureAnchor().features().toList();
            String sortedMkString = ((TraversableOnce)featuresInAnchor.sorted((Ordering)Ordering.String$.MODULE$)).mkString(",");
            String featureNames = preprocessedDfMap.contains((Object)sortedMkString) ? sortedMkString : "";
            return (Seq)featureGroupWithSameTimeWindow2.featureNames().map((Function1 & Serializable & scala.Serializable)f -> new Tuple3(anchorToFeatureGroupEntry, (Object)new FeatureTransformation.FeatureGroupingCriteria(sourcekeyExtractorIdentifier, timeWindowGroupByIdentifier, timeSeriesSource2, (String)AnchorUtils$.MODULE$.getFilterFromAnchor(anchorWithSourceDF2, (String)f).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), featureNames), featureExtractor.getClass()), Seq$.MODULE$.canBuildFrom());
        }, Iterable$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)f -> new FeatureTransformation.AnchorFeaturesWithGroupingCriteriaAndExtractorClass((Tuple2<Tuple2<FeatureAnchorWithSource, DataSourceAccessor>, FeatureTransformation.FeatureGroupWithSameTimeWindow>)((Tuple2)f._1()), (FeatureTransformation.FeatureGroupingCriteria)f._2(), (Class)f._3()), Iterable$.MODULE$.canBuildFrom())).toList();
        return this.groupAndMergeAnchors((List<FeatureTransformation.AnchorFeaturesWithGroupingCriteriaAndExtractorClass>)groupedByCriteriaAndExtractorType);
    }

    private Seq<KeyedTransformedResult> transformFeaturesOnDataFrameRow(DataSourceAccessor source, SourceKeyExtractor keyExtractor, Seq<FeatureAnchorWithSource> anchorsWithSameSource, Option<BloomFilter> bloomFilter, Seq<String> allRequestedFeatures, Option<IncrementalAggContext> incrementalAggContext, Option<FeathrExpressionExecutionContext> mvelContext) {
        Tuple2<Option<AnchorFeatureGroups>, Option<AnchorFeatureGroups>> tuple2 = this.groupAggregationFeatures(source, new AnchorFeatureGroups(anchorsWithSameSource, allRequestedFeatures), incrementalAggContext);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option directTransformAnchorGroup = (Option)tuple2._1();
        Option incrementalTransformAnchorGroup = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)directTransformAnchorGroup, (Object)incrementalTransformAnchorGroup);
        Tuple2 tuple23 = tuple22;
        Option directTransformAnchorGroup2 = (Option)tuple23._1();
        Option incrementalTransformAnchorGroup2 = (Option)tuple23._2();
        Option<Dataset<Row>> preprocessedDf = PreprocessedDataFrameManager$.MODULE$.getPreprocessedDataframe(anchorsWithSameSource);
        Option directTransformedResult = directTransformAnchorGroup2.map((Function1 & Serializable & scala.Serializable)anchorGroup -> (Seq)new .colon.colon((Object)MODULE$.directCalculate((AnchorFeatureGroups)anchorGroup, source, keyExtractor, bloomFilter, (Option<DateTimeInterval>)None$.MODULE$, preprocessedDf, mvelContext), (List)Nil$.MODULE$));
        Option incrementalTransformedResult = incrementalTransformAnchorGroup2.map((Function1 & Serializable & scala.Serializable)anchorGroup -> {
            Seq<String> requestedFeatures = anchorGroup.requestedFeatures();
            IncrementalAggContext incrAggCtx = (IncrementalAggContext)incrementalAggContext.get();
            Seq preAggDFs = (Seq)((TraversableOnce)incrAggCtx.previousSnapshotMap().collect((PartialFunction)new scala.Serializable(requestedFeatures){
                public static final long serialVersionUID = 0L;
                private final Seq requestedFeatures$1;

                public final <A1 extends Tuple2<String, Dataset<Row>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Dataset df;
                    Object[] objectArray;
                    A1 A1 = x1;
                    Object object = A1 != null && this.requestedFeatures$1.exists(arg_0 -> anonfun.2.$anonfun$applyOrElse$1$adapted(objectArray = Predef$.MODULE$.refArrayOps((Object[])(df = (Dataset)A1._2()).columns()), arg_0)) ? df : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Tuple2<String, Dataset<Row>> x1) {
                    Dataset df;
                    Object[] objectArray;
                    Tuple2<String, Dataset<Row>> tuple2 = x1;
                    boolean bl = tuple2 != null && this.requestedFeatures$1.exists(arg_0 -> anonfun.2.$anonfun$isDefinedAt$1$adapted(objectArray = Predef$.MODULE$.refArrayOps((Object[])(df = (Dataset)tuple2._2()).columns()), arg_0));
                    return bl;
                }

                public static final /* synthetic */ boolean $anonfun$applyOrElse$1(Object[] eta$0$1$1, Object elem) {
                    return new ArrayOps.ofRef(eta$0$1$1).contains(elem);
                }

                public static final /* synthetic */ boolean $anonfun$isDefinedAt$1(Object[] eta$0$1$2, Object elem) {
                    return new ArrayOps.ofRef(eta$0$1$2).contains(elem);
                }
                {
                    this.requestedFeatures$1 = requestedFeatures$1;
                }

                public static final /* synthetic */ Object $anonfun$applyOrElse$1$adapted(Object[] eta$0$1$1, Object elem) {
                    return BoxesRunTime.boxToBoolean((boolean)anonfun.2.$anonfun$applyOrElse$1(eta$0$1$1, elem));
                }

                public static final /* synthetic */ Object $anonfun$isDefinedAt$1$adapted(Object[] eta$0$1$2, Object elem) {
                    return BoxesRunTime.boxToBoolean((boolean)anonfun.2.$anonfun$isDefinedAt$1(eta$0$1$2, elem));
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(java.lang.Object[] java.lang.Object ), $anonfun$isDefinedAt$1$adapted(java.lang.Object[] java.lang.Object )}, serializedLambda);
                }
            }, Iterable$.MODULE$.canBuildFrom())).toSeq().distinct();
            Seq<String> groupKeys = MODULE$.getFeatureKeyColumnNames(keyExtractor, (Dataset<Row>)((Dataset)preAggDFs.head()));
            IndexedSeq<String> keyColumnNames = MODULE$.getStandardizedKeyNames(groupKeys.size());
            Dataset firstPreAgg = (Dataset)preAggDFs.head();
            Dataset joinedPreAggDFs = (Dataset)((TraversableOnce)preAggDFs.slice(1, preAggDFs.size())).foldLeft((Object)firstPreAgg, (Function2 & Serializable & scala.Serializable)(baseDF, curDF) -> baseDF.join(curDF, (Seq)keyColumnNames));
            String preAggRootDir = (String)incrAggCtx.previousSnapshotRootDirMap().apply(((FeatureAnchorWithSource)anchorGroup.anchorsWithSameSource().head()).selectedFeatures().head());
            return (Seq)new .colon.colon((Object)MODULE$.incrementalCalculate((AnchorFeatureGroups)anchorGroup, (Dataset<Row>)joinedPreAggDFs, source, keyExtractor, bloomFilter, preAggRootDir, mvelContext), (List)Nil$.MODULE$);
        });
        return ((TraversableOnce)((GenericTraversableTemplate)Option$.MODULE$.option2Iterable(directTransformedResult).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(incrementalTransformedResult), scala.collection.Iterable$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms())).toSeq();
    }

    private Tuple2<Option<AnchorFeatureGroups>, Option<AnchorFeatureGroups>> groupAggregationFeatures(DataSourceAccessor source, AnchorFeatureGroups anchorFeatureGroups, Option<IncrementalAggContext> incrementalAggContext) {
        .colon.colon supportedIncrementalAggTypes;
        if (incrementalAggContext.isEmpty() || ((IncrementalAggContext)incrementalAggContext.get()).previousSnapshotRootDirMap().isEmpty() || !((IncrementalAggContext)incrementalAggContext.get()).isIncrementalAggEnabled()) {
            return new Tuple2((Object)new Some((Object)anchorFeatureGroups), (Object)None$.MODULE$);
        }
        Seq<String> requestedFeatureNames = anchorFeatureGroups.requestedFeatures();
        Seq directIncrementalGroups = (Seq)requestedFeatureNames.foldLeft((Object)new .colon.colon((Object)new AnchorFeatureGroups((Seq<FeatureAnchorWithSource>)((Seq)Nil$.MODULE$), (Seq<String>)((Seq)Nil$.MODULE$)), (List)new .colon.colon((Object)new AnchorFeatureGroups((Seq<FeatureAnchorWithSource>)((Seq)Nil$.MODULE$), (Seq<String>)((Seq)Nil$.MODULE$)), (List)Nil$.MODULE$)), (arg_0, arg_1) -> FeatureTransformation$.$anonfun$groupAggregationFeatures$1(anchorFeatureGroups, (List)(supportedIncrementalAggTypes = new .colon.colon((Object)AggregationType$.MODULE$.COUNT(), (List)new .colon.colon((Object)AggregationType$.MODULE$.SUM(), (List)Nil$.MODULE$))), incrementalAggContext, arg_0, arg_1));
        return new Tuple2(((AnchorFeatureGroups)directIncrementalGroups.apply(0)).requestedFeatures().isEmpty() ? None$.MODULE$ : new Some(directIncrementalGroups.apply(0)), ((AnchorFeatureGroups)directIncrementalGroups.apply(1)).requestedFeatures().isEmpty() ? None$.MODULE$ : new Some(directIncrementalGroups.apply(1)));
    }

    private Map<String, FeatureTypeConfig> inferFeatureTypesFromRawDF(Dataset<Row> df, Seq<String> featureNames) {
        return ((TraversableOnce)featureNames.map((Function1 & Serializable & scala.Serializable)featureName -> {
            DataType dataType = df.schema().fields()[df.schema().fieldIndex(featureName)].dataType();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(featureName), (Object)new FeatureTypeConfig(FeaturizedDatasetUtils$.MODULE$.inferFeatureTypeFromColumnDataType(dataType)));
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private KeyedTransformedResult incrementalCalculate(AnchorFeatureGroups featureAnchorWithSource, Dataset<Row> df, DataSourceAccessor source, SourceKeyExtractor keyExtractor, Option<BloomFilter> bloomFilter, String preAggRootDir, Option<FeathrExpressionExecutionContext> mvelContext) {
        KeyedTransformedResult keyedTransformedResult;
        String newDeltaWindowEndDateStr;
        int aggWindow = this.getFeatureAggWindow(featureAnchorWithSource);
        Tuple2<DateTimeInterval, Object> tuple2 = IncrementalAggUtils$.MODULE$.getNewDeltaWindowInterval(preAggRootDir, aggWindow, newDeltaWindowEndDateStr = (String)((DateParam)((FeatureAnchorWithSource)featureAnchorWithSource.anchorsWithSameSource().head()).dateParam().get()).endDate().get());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        DateTimeInterval dateParam = (DateTimeInterval)tuple2._1();
        long newDeltaWindowSize = tuple2._2$mcJ$sp();
        Tuple2 tuple22 = new Tuple2((Object)dateParam, (Object)BoxesRunTime.boxToLong((long)newDeltaWindowSize));
        Tuple2 tuple23 = tuple22;
        DateTimeInterval dateParam2 = (DateTimeInterval)tuple23._1();
        long newDeltaWindowSize2 = tuple23._2$mcJ$sp();
        KeyedTransformedResult newDeltaSourceAgg = this.directCalculate(featureAnchorWithSource, source, keyExtractor, bloomFilter, (Option<DateTimeInterval>)new Some((Object)dateParam2), (Option<Dataset<Row>>)None$.MODULE$, mvelContext);
        if (newDeltaWindowSize2 < (long)aggWindow) {
            Dataset<Row> dataset;
            Dataset<Row> newDeltaAgg = newDeltaSourceAgg.transformedResult().df();
            Seq<Tuple2<String, String>> newDeltaFeatureNameAndPrefixPairs = newDeltaSourceAgg.transformedResult().featureNameAndPrefixPairs();
            Seq newDeltaFeatureColumnNames = (Seq)newDeltaFeatureNameAndPrefixPairs.map((Function1 & Serializable & scala.Serializable)x -> new StringBuilder(0).append((String)x._2()).append(x._1()).toString(), Seq$.MODULE$.canBuildFrom());
            Seq<String> joinKeys = newDeltaSourceAgg.joinKey();
            Dataset<Row> renamedPreAgg = (Dataset<Row>)newDeltaFeatureNameAndPrefixPairs.foldLeft(df, (Function2 & Serializable & scala.Serializable)(baseDF, renamePair) -> baseDF.withColumnRenamed((String)renamePair._1(), new StringBuilder(0).append((String)renamePair._2()).append(renamePair._1()).toString()));
            DateTimeInterval oldDeltaWindowInterval = IncrementalAggUtils$.MODULE$.getOldDeltaWindowDateParam(preAggRootDir, aggWindow, (int)newDeltaWindowSize2, newDeltaWindowEndDateStr);
            if (!(source instanceof TimeBasedDataSourceAccessor)) {
                throw new FeathrException(ErrorLabel.FEATHR_ERROR, "overlapWithInterval should not be called if the source has no time interval.");
            }
            IndexedSeq<String> leftKeyColumnNames = this.getStandardizedKeyNames(joinKeys.size());
            if (!((TimeBasedDataSourceAccessor)source).overlapWithInterval(oldDeltaWindowInterval)) {
                dataset = renamedPreAgg;
            } else {
                KeyedTransformedResult oldDeltaSourceAgg = this.directCalculate(featureAnchorWithSource, source, keyExtractor, bloomFilter, (Option<DateTimeInterval>)new Some((Object)oldDeltaWindowInterval), (Option<Dataset<Row>>)None$.MODULE$, mvelContext);
                Dataset<Row> oldDeltaAgg = oldDeltaSourceAgg.transformedResult().df();
                dataset = this.mergeDeltaDF(renamedPreAgg, oldDeltaAgg, (Seq<String>)leftKeyColumnNames, joinKeys, (Seq<String>)newDeltaFeatureColumnNames, false);
            }
            Dataset<Row> preAggWithoutOldDelta = dataset;
            Dataset<Row> preAggWithNewDelta = this.mergeDeltaDF(preAggWithoutOldDelta, newDeltaAgg, (Seq<String>)leftKeyColumnNames, joinKeys, (Seq<String>)newDeltaFeatureColumnNames, this.mergeDeltaDF$default$6());
            Map featureColumnFormats = ((TraversableOnce)newDeltaFeatureColumnNames.map((Function1 & Serializable & scala.Serializable)name -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), (Object)FeatureColumnFormat$.MODULE$.FDS_TENSOR()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            TransformedResult resultWithoutKey = new TransformedResult(newDeltaFeatureNameAndPrefixPairs, preAggWithNewDelta, (Map<String, Enumeration.Value>)featureColumnFormats, newDeltaSourceAgg.transformedResult().inferredFeatureTypes());
            keyedTransformedResult = new KeyedTransformedResult(joinKeys, resultWithoutKey);
        } else {
            keyedTransformedResult = newDeltaSourceAgg;
        }
        return keyedTransformedResult;
    }

    public FeatureDataFrame convertFCMResultDFToFDS(Seq<String> allFeaturesToConvert, Map<String, Enumeration.Value> featureColumnFormatsMap, Dataset<Row> withFeatureDF, Map<String, FeatureTypeConfig> userProvidedFeatureTypeConfigs) {
        Map<String, FeatureTypeConfig> defaultInferredFeatureTypes;
        Map<String, FeatureTypeConfig> transformedInferredFeatureTypes = defaultInferredFeatureTypes = this.inferFeatureTypesFromRawDF(withFeatureDF, allFeaturesToConvert);
        Map featureColNameToFeatureNameAndType = ((TraversableOnce)allFeaturesToConvert.map((Function1 & Serializable & scala.Serializable)featureName -> {
            FeatureTypes userProvidedFeatureType;
            FeatureTypeConfig userProvidedConfig = (FeatureTypeConfig)userProvidedFeatureTypeConfigs.getOrElse(featureName, (Function0 & Serializable & scala.Serializable)() -> FeatureTypeConfig.UNDEFINED_TYPE_CONFIG);
            FeatureTypes featureTypes = userProvidedFeatureType = userProvidedConfig.getFeatureType();
            FeatureTypes featureTypes2 = FeatureTypes.UNSPECIFIED;
            FeatureTypeConfig processedFeatureTypeConfig = !(featureTypes != null ? !((Object)((Object)featureTypes)).equals((Object)featureTypes2) : featureTypes2 != null) ? (FeatureTypeConfig)transformedInferredFeatureTypes.getOrElse(featureName, (Function0 & Serializable & scala.Serializable)() -> FeatureTypeConfig.UNDEFINED_TYPE_CONFIG) : userProvidedConfig;
            String colName = featureName;
            return new Tuple2((Object)colName, (Object)new Tuple2(featureName, (Object)processedFeatureTypeConfig));
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map inferredFeatureTypes = (Map)featureColNameToFeatureNameAndType.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$1;
            if (tuple22 == null || (tuple2 = (Tuple2)tuple22._2()) == null) {
                throw new MatchError((Object)tuple22);
            }
            String featureName = (String)tuple2._1();
            FeatureTypeConfig featureType = (FeatureTypeConfig)tuple2._2();
            Tuple2 tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)featureName), (Object)featureType);
            return tuple23;
        }, Map$.MODULE$.canBuildFrom());
        Dataset convertedDF = (Dataset)featureColNameToFeatureNameAndType.groupBy((Function1 & Serializable & scala.Serializable)pair -> (Enumeration.Value)featureColumnFormatsMap.apply(pair._1())).foldLeft(withFeatureDF, (Function2 & Serializable & scala.Serializable)(inputDF, featureColNameToFeatureNameAndTypeWithFormat) -> {
            Dataset<Row> dataset;
            Enumeration.Value value = (Enumeration.Value)featureColNameToFeatureNameAndTypeWithFormat._1();
            Enumeration.Value value2 = FeatureColumnFormat$.MODULE$.FDS_TENSOR();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                dataset = inputDF;
            } else {
                Enumeration.Value value4 = FeatureColumnFormat$.MODULE$.RAW();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    Dataset<Row> convertedDF;
                    dataset = convertedDF = FeaturizedDatasetUtils$.MODULE$.convertRawDFtoQuinceFDS((Dataset<Row>)inputDF, (Map<String, Tuple2<String, FeatureTypeConfig>>)featureColNameToFeatureNameAndType);
                } else {
                    throw new MatchError((Object)value);
                }
            }
            Dataset<Row> fdsDF = dataset;
            return fdsDF;
        });
        return new FeatureDataFrame((Dataset<Row>)convertedDF, (Map<String, FeatureTypeConfig>)inferredFeatureTypes);
    }

    public Map<String, FeatureTypeConfig> convertFCMResultDFToFDS$default$4() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public String parseMultiDimTensorExpr(String featureDef) {
        return featureDef.substring(featureDef.indexOf("(") + 1, featureDef.indexOf(")"));
    }

    public Tuple2<Dataset<Row>, Seq<String>> applyRowBasedTransformOnRdd(Map<String, FeatureTypes> userProvidedFeatureTypes, Seq<String> requestedFeatureNames, RDD<?> inputRdd, Seq<SourceKeyExtractor> sourceKeyExtractors, Seq<AnchorExtractorBase<Object>> transformers, Map<String, FeatureTypeConfig> featureTypeConfigs) {
        Map<String, FeatureTypeAccumulator> featureTypeAccumulators;
        SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
        FeatureTypeInferenceContext featureTypeInferenceContext = this.getTypeInferenceContext(spark, userProvidedFeatureTypes, requestedFeatureNames);
        if (featureTypeInferenceContext == null) {
            throw new MatchError((Object)featureTypeInferenceContext);
        }
        Map<String, FeatureTypeAccumulator> map = featureTypeAccumulators = featureTypeInferenceContext.featureTypeAccumulators();
        Map<String, FeatureTypeAccumulator> featureTypeAccumulators2 = map;
        RDD transformedRdd = inputRdd.map((Function1 & Serializable & scala.Serializable)row -> {
            Tuple2<Seq<String>, Seq<Tuple2<Object, FeatureType>>> tuple2 = MODULE$.transformRow(requestedFeatureNames, sourceKeyExtractors, transformers, row, featureTypeConfigs);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Seq keys = (Seq)tuple2._1();
            Seq featureValuesWithType = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)keys, (Object)featureValuesWithType);
            Tuple2 tuple23 = tuple22;
            Seq keys2 = (Seq)tuple23._1();
            Seq featureValuesWithType2 = (Seq)tuple23._2();
            ((IterableLike)requestedFeatureNames.zip((GenIterable)featureValuesWithType2, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                FeatureTransformation$.$anonfun$applyRowBasedTransformOnRdd$2(featureTypeAccumulators2, x0$1);
                return BoxedUnit.UNIT;
            });
            return Row$.MODULE$.merge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.fromSeq(keys2), Row$.MODULE$.fromSeq((Seq)featureValuesWithType2.map((Function1 & Serializable & scala.Serializable)x$45 -> x$45._1(), Seq$.MODULE$.canBuildFrom()))}));
        }, ClassTag$.MODULE$.apply(Row.class));
        Seq<String> keyNames = this.getFeatureKeyColumnNamesRdd((SourceKeyExtractor)sourceKeyExtractors.head(), inputRdd);
        Map<String, FeatureTypes> inferredFeatureTypes = this.inferFeatureTypes(featureTypeAccumulators2, (RDD<Row>)transformedRdd, requestedFeatureNames);
        Map inferredFeatureTypeConfigs = (Map)inferredFeatureTypes.map((Function1 & Serializable & scala.Serializable)x -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x._1()), (Object)new FeatureTypeConfig((FeatureTypes)((Object)((Object)x._2())))), Map$.MODULE$.canBuildFrom());
        Map mergedFeatureTypeConfig = inferredFeatureTypeConfigs.$plus$plus(featureTypeConfigs);
        String colPrefix = "";
        Seq<StructField> featureTensorTypeInfo = this.getFDSSchemaFields(requestedFeatureNames, (Map<String, FeatureTypeConfig>)mergedFeatureTypeConfig, colPrefix);
        List structFields = (List)keyNames.foldRight((Object)List$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(x0$2, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$2, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String colName = (String)tuple2._1();
            List acc = (List)tuple2._2();
            StructField structField = new StructField(colName, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            List list = acc.$colon$colon((Object)structField);
            return list;
        });
        StructType outputSchema = StructType$.MODULE$.apply((Seq)StructType$.MODULE$.apply((Seq)structFields.$plus$plus(featureTensorTypeInfo, List$.MODULE$.canBuildFrom())));
        Tuple2 tuple2 = new Tuple2((Object)outputSchema, (Object)mergedFeatureTypeConfig);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        StructType outputSchema2 = (StructType)tuple2._1();
        Map inferredFeatureTypeConfigs2 = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)outputSchema2, (Object)inferredFeatureTypeConfigs2);
        Tuple2 tuple23 = tuple22;
        StructType outputSchema3 = (StructType)tuple23._1();
        Map inferredFeatureTypeConfigs3 = (Map)tuple23._2();
        return new Tuple2((Object)spark.createDataFrame(transformedRdd, outputSchema3), keyNames);
    }

    private Tuple2<Seq<String>, Seq<Tuple2<Object, FeatureType>>> transformRow(Seq<String> requestedFeatureNames, Seq<SourceKeyExtractor> sourceKeyExtractors, Seq<AnchorExtractorBase<Object>> transformers, Object row, Map<String, FeatureTypeConfig> featureTypeConfigs) {
        Seq<String> seq;
        SourceKeyExtractor sourceKeyExtractor = (SourceKeyExtractor)sourceKeyExtractors.head();
        if (sourceKeyExtractor instanceof MVELSourceKeyExtractor) {
            MVELSourceKeyExtractor mVELSourceKeyExtractor = (MVELSourceKeyExtractor)sourceKeyExtractor;
            seq = mVELSourceKeyExtractor.getKey(row);
        } else if (sourceKeyExtractor instanceof SpecificRecordSourceKeyExtractor) {
            SpecificRecordSourceKeyExtractor specificRecordSourceKeyExtractor = (SpecificRecordSourceKeyExtractor)sourceKeyExtractor;
            seq = specificRecordSourceKeyExtractor.getKey(row);
        } else {
            throw new FeathrFeatureTransformationException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(32).append(sourceKeyExtractors.head()).append(" is not a valid extractor on RDD").toString());
        }
        Seq<String> keys = seq;
        Map features = (Map)((TraversableOnce)transformers.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AnchorExtractorBase anchorExtractorBase = x0$1;
            if (!(anchorExtractorBase instanceof AnchorExtractor)) {
                throw new FeathrFeatureTransformationException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(53).append("Invalid extractor ").append(anchorExtractorBase).append(" for features:").append(requestedFeatureNames).append(" requested as tensors").toString());
            }
            AnchorExtractor anchorExtractor = (AnchorExtractor)anchorExtractorBase;
            Map<String, FeatureValue> features = anchorExtractor.getFeatures(row);
            Predef$.MODULE$.print(features);
            FeatureValueTypeValidator$.MODULE$.validate(features, featureTypeConfigs);
            Map<String, FeatureValue> map = features;
            return map;
        }, Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$48, x$49) -> x$48.$plus$plus((GenTraversableOnce)x$49));
        if (this.logger().isTraceEnabled()) {
            this.logger().trace((Object)new StringBuilder(20).append("Extracted features: ").append(features).toString());
        }
        Seq featureValuesWithType = (Seq)requestedFeatureNames.map((Function1 & Serializable & scala.Serializable)name -> (Tuple2)features.get(name).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            FeatureValue featureValue = x0$2;
            TensorData tensorData = featureValue.getAsTensorData();
            FeatureType featureType = featureValue.getFeatureType();
            Object row = FeaturizedDatasetUtils$.MODULE$.tensorToFDSDataFrameRow(tensorData, FeaturizedDatasetUtils$.MODULE$.tensorToFDSDataFrameRow$default$2());
            Tuple2 tuple2 = new Tuple2(row, (Object)featureType);
            return tuple2;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Tuple2(null, null)), Seq$.MODULE$.canBuildFrom());
        return new Tuple2(keys, (Object)featureValuesWithType);
    }

    private Map<String, FeatureTypeConfig> transformRow$default$5() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public IndexedSeq<String> getStandardizedKeyNames(int joinKeySize) {
        return (IndexedSeq)scala.package$.MODULE$.Range().apply(0, joinKeySize).map((Function1 & Serializable & scala.Serializable)x$50 -> FeatureTransformation$.$anonfun$getStandardizedKeyNames$1(BoxesRunTime.unboxToInt((Object)x$50)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    private int MAX_PARALLEL_FEATURE_GROUP() {
        return this.MAX_PARALLEL_FEATURE_GROUP;
    }

    public static final /* synthetic */ void $anonfun$directCalculate$10(KeyedTransformedResult aggResults$1, AnchorFeatureGroups anchorFeatureGroup$1, FeatureAnchorWithSource featureAnchorWithSource) {
        Seq<Tuple2<String, String>> featureColumnInfo = aggResults$1.transformedResult().featureNameAndPrefixPairs();
        Seq<String> requestedFeatureNames = anchorFeatureGroup$1.requestedFeatures();
        Seq requestFeatures = (Seq)featureAnchorWithSource.featureAnchor().getProvidedFeatureNames().filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)requestedFeatureNames.contains((Object)x$10)));
    }

    public static final /* synthetic */ boolean $anonfun$transformFeatures$5(Object extractor) {
        return extractor instanceof CanConvertToAvroRDD;
    }

    public static final /* synthetic */ boolean $anonfun$inferFeatureTypes$2(int idx$1, Row r) {
        return r.get(r.size() - idx$1) != null;
    }

    public static final /* synthetic */ Row[] $anonfun$inferFeatureTypes$1(RDD transformedRdd$1, int idx) {
        return (Row[])transformedRdd$1.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)FeatureTransformation$.$anonfun$inferFeatureTypes$2(idx, r))).take(1);
    }

    public static final /* synthetic */ boolean $anonfun$applyBloomFilterRdd$2(String x$26) {
        return x$26 == null;
    }

    public static final /* synthetic */ boolean $anonfun$applyBloomFilterRdd$1(MVELSourceKeyExtractor x2$1, BloomFilter filter$1, Object record) {
        Seq<String> keyVals = x2$1.getKey(record);
        return keyVals != null && keyVals.count((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)FeatureTransformation$.$anonfun$applyBloomFilterRdd$2(x$26))) == 0 ? filter$1.mightContainString(SourceUtils$.MODULE$.generateFilterKeyString(keyVals)) : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$transformFeaturesOnAvroRecord$10(Map featureTypeAccumulators$1, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String featureRef = (String)tuple2._1();
        Tuple2 tuple22 = (Tuple2)tuple2._2();
        if (tuple22 == null) throw new MatchError((Object)tuple2);
        FeatureType featureType = (FeatureType)tuple22._2();
        if (((FeatureTypeAccumulator)((Object)featureTypeAccumulators$1.apply((Object)featureRef))).isZero() && featureType != null) {
            ((FeatureTypeAccumulator)((Object)featureTypeAccumulators$1.apply((Object)featureRef))).add(FeatureTypes.valueOf(featureType.getBasicType().toString()));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$groupAggregationFeatures$2(String featureName$1, FeatureAnchorWithSource featureAnchorWithSource) {
        return featureAnchorWithSource.selectedFeatures().contains((Object)featureName$1);
    }

    public static final /* synthetic */ Seq $anonfun$groupAggregationFeatures$1(AnchorFeatureGroups anchorFeatureGroups$1, List supportedIncrementalAggTypes$1, Option incrementalAggContext$3, Seq aggGroupPairs, String featureName) {
        Seq selectedFeatureAnchorWithSource = (Seq)anchorFeatureGroups$1.anchorsWithSameSource().filter((Function1 & Serializable & scala.Serializable)featureAnchorWithSource -> BoxesRunTime.boxToBoolean((boolean)FeatureTransformation$.$anonfun$groupAggregationFeatures$2(featureName, featureAnchorWithSource)));
        if (selectedFeatureAnchorWithSource.size() != 1) {
            throw new FeathrFeatureTransformationException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(124).append("Multiple anchors define the same feature name. Please check the ").append("feature definitions in each anchor. Duplicated anchors are: ").append(selectedFeatureAnchorWithSource).toString());
        }
        Map<String, TimeWindowFeatureDefinition> features = MODULE$.getFeatureDefinitions(((FeatureAnchorWithSource)selectedFeatureAnchorWithSource.head()).featureAnchor().extractor());
        Enumeration.Value aggType = ((TimeWindowFeatureDefinition)features.apply((Object)featureName)).aggregationType();
        boolean isSupportedAggType = supportedIncrementalAggTypes$1.contains((Object)aggType);
        boolean isOldFeature = ((IncrementalAggContext)incrementalAggContext$3.get()).previousSnapshotMap().contains((Object)featureName);
        Seq localAggGroupPairs = isSupportedAggType && isOldFeature ? (Seq)new .colon.colon((Object)new AnchorFeatureGroups((Seq<FeatureAnchorWithSource>)((Seq)Nil$.MODULE$), (Seq<String>)((Seq)Nil$.MODULE$)), (List)new .colon.colon((Object)new AnchorFeatureGroups((Seq<FeatureAnchorWithSource>)selectedFeatureAnchorWithSource, (Seq<String>)((Seq)new .colon.colon((Object)featureName, (List)Nil$.MODULE$))), (List)Nil$.MODULE$)) : (Seq)new .colon.colon((Object)new AnchorFeatureGroups((Seq<FeatureAnchorWithSource>)selectedFeatureAnchorWithSource, (Seq<String>)((Seq)new .colon.colon((Object)featureName, (List)Nil$.MODULE$))), (List)new .colon.colon((Object)new AnchorFeatureGroups((Seq<FeatureAnchorWithSource>)((Seq)Nil$.MODULE$), (Seq<String>)((Seq)Nil$.MODULE$)), (List)Nil$.MODULE$));
        return (Seq)new .colon.colon((Object)new AnchorFeatureGroups((Seq<FeatureAnchorWithSource>)((Seq)((AnchorFeatureGroups)aggGroupPairs.apply(0)).anchorsWithSameSource().$plus$plus(((AnchorFeatureGroups)localAggGroupPairs.apply(0)).anchorsWithSameSource(), Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)((AnchorFeatureGroups)aggGroupPairs.apply(0)).requestedFeatures().$plus$plus(((AnchorFeatureGroups)localAggGroupPairs.apply(0)).requestedFeatures(), Seq$.MODULE$.canBuildFrom()))), (List)new .colon.colon((Object)new AnchorFeatureGroups((Seq<FeatureAnchorWithSource>)((Seq)((AnchorFeatureGroups)aggGroupPairs.apply(1)).anchorsWithSameSource().$plus$plus(((AnchorFeatureGroups)localAggGroupPairs.apply(1)).anchorsWithSameSource(), Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)((AnchorFeatureGroups)aggGroupPairs.apply(1)).requestedFeatures().$plus$plus(((AnchorFeatureGroups)localAggGroupPairs.apply(1)).requestedFeatures(), Seq$.MODULE$.canBuildFrom()))), (List)Nil$.MODULE$));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$applyRowBasedTransformOnRdd$2(Map featureTypeAccumulators$2, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String featureRef = (String)tuple2._1();
        Tuple2 tuple22 = (Tuple2)tuple2._2();
        if (tuple22 == null) throw new MatchError((Object)tuple2);
        FeatureType featureType = (FeatureType)tuple22._2();
        if (((FeatureTypeAccumulator)((Object)featureTypeAccumulators$2.apply((Object)featureRef))).isZero() && featureType != null) {
            ((FeatureTypeAccumulator)((Object)featureTypeAccumulators$2.apply((Object)featureRef))).add(FeatureTypes.valueOf(featureType.getBasicType().toString()));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ String $anonfun$getStandardizedKeyNames$1(int x$50) {
        return new StringBuilder(3).append("key").append(x$50).toString();
    }

    private FeatureTransformation$() {
        MODULE$ = this;
        this.logger = Logger.getLogger(this.getClass());
        this.FEATURE_DATA_JOIN_KEY_COL_PREFIX = "FeathrFeatureJoinKeyCol_";
        this.FEATURE_NAME_PREFIX = "__feathr_feature_";
        this.FEATURE_TAGS_PREFIX = "__feathr_tags_";
        this.JOIN_KEY_OBSERVATION_PREFIX = "__feathr_left_join_key_column_";
        this.USER_FACING_MULTI_DIM_FDS_TENSOR_UDF_NAME = "FDSExtract";
        this.MAX_PARALLEL_FEATURE_GROUP = 10;
    }
}

