/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.source.dataloader;

import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrInputDataException;
import com.linkedin.feathr.offline.config.location.DataLocation;
import com.linkedin.feathr.offline.generation.SparkIOUtils$;
import com.linkedin.feathr.offline.job.DataSourceUtils$;
import com.linkedin.feathr.offline.source.dataloader.DataLoader;
import com.linkedin.feathr.offline.source.dataloader.DataLoaderHandler;
import com.linkedin.feathr.offline.util.DelimiterUtils$;
import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.Breaks$;

@ScalaSignature(bytes="\u0006\u0001q4Q\u0001C\u0005\u0001\u001bUA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\t]\u0001\u0011\t\u0011)A\u0005_!Aa\u0007\u0001B\u0001B\u0003%q\u0007C\u0003G\u0001\u0011\u0005q\tC\u0003M\u0001\u0011\u0005S\nC\u0003U\u0001\u0011\u0005S\u000bC\u0003U\u0001\u0011\u0005AMA\bCCR\u001c\u0007\u000eR1uC2{\u0017\rZ3s\u0015\tQ1\"\u0001\u0006eCR\fGn\\1eKJT!\u0001D\u0007\u0002\rM|WO]2f\u0015\tqq\"A\u0004pM\u001ad\u0017N\\3\u000b\u0005A\t\u0012A\u00024fCRD'O\u0003\u0002\u0013'\u0005AA.\u001b8lK\u0012LgNC\u0001\u0015\u0003\r\u0019w.\\\n\u0004\u0001Ya\u0002CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"AB!osJ+g\r\u0005\u0002\u001e=5\t\u0011\"\u0003\u0002 \u0013\tQA)\u0019;b\u0019>\fG-\u001a:\u0002\u0005M\u001c8\u0001\u0001\t\u0003G1j\u0011\u0001\n\u0006\u0003K\u0019\n1a]9m\u0015\t9\u0003&A\u0003ta\u0006\u00148N\u0003\u0002*U\u00051\u0011\r]1dQ\u0016T\u0011aK\u0001\u0004_J<\u0017BA\u0017%\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003!awnY1uS>t\u0007C\u0001\u00195\u001b\u0005\t$B\u0001\u00183\u0015\t\u0019T\"\u0001\u0004d_:4\u0017nZ\u0005\u0003kE\u0012A\u0002R1uC2{7-\u0019;j_:\f!\u0003Z1uC2{\u0017\rZ3s\u0011\u0006tG\r\\3sgB\u0019\u0001\bQ\"\u000f\u0005erdB\u0001\u001e>\u001b\u0005Y$B\u0001\u001f\"\u0003\u0019a$o\\8u}%\t\u0011$\u0003\u0002@1\u00059\u0001/Y2lC\u001e,\u0017BA!C\u0005\u0011a\u0015n\u001d;\u000b\u0005}B\u0002CA\u000fE\u0013\t)\u0015BA\tECR\fGj\\1eKJD\u0015M\u001c3mKJ\fa\u0001P5oSRtD\u0003\u0002%J\u0015.\u0003\"!\b\u0001\t\u000b\u0001\"\u0001\u0019\u0001\u0012\t\u000b9\"\u0001\u0019A\u0018\t\u000bY\"\u0001\u0019A\u001c\u0002\u00151|\u0017\rZ*dQ\u0016l\u0017\rF\u0001O!\ty%+D\u0001Q\u0015\t\t\u0006&\u0001\u0003bmJ|\u0017BA*Q\u0005\u0019\u00196\r[3nC\u0006iAn\\1e\t\u0006$\u0018M\u0012:b[\u0016$\u0012A\u0016\t\u0003/\u0006t!\u0001\u00171\u000f\u0005e{fB\u0001._\u001d\tYVL\u0004\u0002;9&\t1&\u0003\u0002*U%\u0011q\u0005K\u0005\u0003K\u0019J!a\u0010\u0013\n\u0005\t\u001c'!\u0003#bi\u00064%/Y7f\u0015\tyD\u0005F\u0002WKJDQAZ\u0004A\u0002\u001d\f\u0001\u0003Z1uC&{\u0005+\u0019:b[\u0016$XM]:\u0011\t!dwn\u001c\b\u0003S*\u0004\"A\u000f\r\n\u0005-D\u0012A\u0002)sK\u0012,g-\u0003\u0002n]\n\u0019Q*\u00199\u000b\u0005-D\u0002C\u00015q\u0013\t\thN\u0001\u0004TiJLgn\u001a\u0005\u0006g\u001e\u0001\r\u0001^\u0001\bU>\u00147i\u001c8g!\t)(0D\u0001w\u0015\t9\b0\u0001\u0004nCB\u0014X\r\u001a\u0006\u0003s\"\na\u0001[1e_>\u0004\u0018BA>w\u0005\u001dQuNY\"p]\u001a\u0004")
public class BatchDataLoader
implements DataLoader {
    private final SparkSession ss;
    private final DataLocation location;
    private final List<DataLoaderHandler> dataLoaderHandlers;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    private Logger log$lzycompute() {
        BatchDataLoader batchDataLoader = this;
        synchronized (batchDataLoader) {
            if (!this.bitmap$trans$0) {
                this.log = DataLoader.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    @Override
    public Schema loadSchema() {
        Configuration conf = this.ss.sparkContext().hadoopConfiguration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        FileStatus[] status = fs.listStatus(new Path(this.location.getPath()));
        FileStatus[] avroFiles = (FileStatus[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])status)).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BatchDataLoader.$anonfun$loadSchema$1(x$1)));
        if (avroFiles.length == 0) {
            throw new FeathrInputDataException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(75).append("Load the Avro schema for Avro data set in HDFS but no avro files found in ").append(this.location.getPath()).append(".").toString());
        }
        String dataFileName = avroFiles[0].getPath().getName();
        String dataFilePath = new Path(this.location.getPath(), dataFileName).toString();
        return DataSourceUtils$.MODULE$.getSchemaFromAvroDataFile(dataFilePath, new JobConf(conf));
    }

    @Override
    public Dataset<Row> loadDataFrame() {
        return this.loadDataFrame((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)), new JobConf(this.ss.sparkContext().hadoopConfiguration()));
    }

    public Dataset<Row> loadDataFrame(Map<String, String> dataIOParameters, JobConf jobConf) {
        Dataset dataset;
        SparkConf sparkConf = this.ss.sparkContext().getConf();
        String inputSplitSize = sparkConf.get("spark.feathr.input.split.size", "");
        Map dataIOParametersWithSplitSize = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SparkIOUtils$.MODULE$.SPLIT_SIZE()), (Object)inputSplitSize)}))).$plus$plus(dataIOParameters);
        String dataPath = this.location.getPath();
        this.log().info((Object)new StringBuilder(40).append("Loading ").append(this.location).append(" as DataFrame, using parameters ").append(dataIOParametersWithSplitSize).toString());
        String csvDelimiterOption = DelimiterUtils$.MODULE$.checkDelimiterOption(this.ss.sqlContext().getConf("spark.feathr.inputFormat.csvOptions.sep", ","));
        try {
            Dataset df;
            Dataset dataset2;
            ObjectRef dfOpt = ObjectRef.create((Object)None$.MODULE$);
            Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.dataLoaderHandlers.foreach((Function1 & Serializable & scala.Serializable)dataLoaderHandler -> {
                BatchDataLoader.$anonfun$loadDataFrame$2(dataPath, dfOpt, dataIOParametersWithSplitSize, jobConf, dataLoaderHandler);
                return BoxedUnit.UNIT;
            }));
            Option option = (Option)dfOpt.elem;
            if (option instanceof Some) {
                Dataset df2;
                Some some = (Some)option;
                dataset2 = df2 = (Dataset)some.value();
            } else {
                dataset2 = this.location.loadDf(this.ss, (Map<String, String>)dataIOParametersWithSplitSize);
            }
            dataset = df = dataset2;
        }
        catch (FeathrInputDataException feathrException) {
            Predef$.MODULE$.println((Object)feathrException.toString());
            throw feathrException;
        }
        catch (Throwable e) {
            Predef$.MODULE$.println((Object)e.toString());
            dataset = this.ss.read().format("csv").option("header", "true").option("delimiter", csvDelimiterOption).load(dataPath);
        }
        return dataset;
    }

    public static final /* synthetic */ boolean $anonfun$loadSchema$1(FileStatus x$1) {
        return x$1.getPath().getName().endsWith(".avro");
    }

    public static final /* synthetic */ void $anonfun$loadDataFrame$2(String dataPath$1, ObjectRef dfOpt$1, Map dataIOParametersWithSplitSize$1, JobConf jobConf$1, DataLoaderHandler dataLoaderHandler) {
        Predef$.MODULE$.println((Object)new StringBuilder(27).append("Applying dataLoaderHandler ").append(dataLoaderHandler).toString());
        if (BoxesRunTime.unboxToBoolean((Object)dataLoaderHandler.validatePath().apply((Object)dataPath$1))) {
            dfOpt$1.elem = new Some(dataLoaderHandler.createDataFrame().apply((Object)dataPath$1, (Object)dataIOParametersWithSplitSize$1, (Object)jobConf$1));
            throw Breaks$.MODULE$.break();
        }
    }

    public BatchDataLoader(SparkSession ss, DataLocation location, List<DataLoaderHandler> dataLoaderHandlers) {
        this.ss = ss;
        this.location = location;
        this.dataLoaderHandlers = dataLoaderHandlers;
        DataLoader.$init$(this);
    }
}

