/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.source.pathutil;

import com.linkedin.feathr.common.DateTimeResolution$;
import com.linkedin.feathr.offline.source.dataloader.DataLoaderHandler;
import com.linkedin.feathr.offline.source.pathutil.LocalPathChecker;
import com.linkedin.feathr.offline.source.pathutil.PathChecker;
import com.linkedin.feathr.offline.source.pathutil.PathInfo;
import com.linkedin.feathr.offline.util.datetime.OfflineDateTimeUtils$;
import java.io.Serializable;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.Breaks$;

@ScalaSignature(bytes="\u0006\u0001-3QAB\u0004\u0001\u0017MA\u0001B\u0007\u0001\u0003\u0002\u0003\u0006I\u0001\b\u0005\tA\u0001\u0011\t\u0011)A\u0005C!)1\u0007\u0001C\u0001i!)\u0001\b\u0001C\u0001s!)\u0001\b\u0001C\u0001\u000f\nIB+[7f\u0005\u0006\u001cX\r\u001a%eMN\u0004\u0016\r\u001e5B]\u0006d\u0017P_3s\u0015\tA\u0011\"\u0001\u0005qCRDW\u000f^5m\u0015\tQ1\"\u0001\u0004t_V\u00148-\u001a\u0006\u0003\u00195\tqa\u001c4gY&tWM\u0003\u0002\u000f\u001f\u00051a-Z1uQJT!\u0001E\t\u0002\u00111Lgn[3eS:T\u0011AE\u0001\u0004G>l7C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005\u0019\te.\u001f*fM\u0006Y\u0001/\u0019;i\u0007\",7m[3s\u0007\u0001\u0001\"!\b\u0010\u000e\u0003\u001dI!aH\u0004\u0003\u0017A\u000bG\u000f[\"iK\u000e\\WM]\u0001\u0013I\u0006$\u0018\rT8bI\u0016\u0014\b*\u00198eY\u0016\u00148\u000fE\u0002#U5r!a\t\u0015\u000f\u0005\u0011:S\"A\u0013\u000b\u0005\u0019Z\u0012A\u0002\u001fs_>$h(C\u0001\u0018\u0013\tIc#A\u0004qC\u000e\\\u0017mZ3\n\u0005-b#\u0001\u0002'jgRT!!\u000b\f\u0011\u00059\nT\"A\u0018\u000b\u0005AJ\u0011A\u00033bi\u0006dw.\u00193fe&\u0011!g\f\u0002\u0012\t\u0006$\u0018\rT8bI\u0016\u0014\b*\u00198eY\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u00026m]\u0002\"!\b\u0001\t\u000bi\u0019\u0001\u0019\u0001\u000f\t\u000b\u0001\u001a\u0001\u0019A\u0011\u0002\u000f\u0005t\u0017\r\\={KR\u0011!(\u0010\t\u0003;mJ!\u0001P\u0004\u0003\u0011A\u000bG\u000f[%oM>DQA\u0010\u0003A\u0002}\n\u0001BZ5mKB\u000bG\u000f\u001b\t\u0003\u0001\u0012s!!\u0011\"\u0011\u0005\u00112\u0012BA\"\u0017\u0003\u0019\u0001&/\u001a3fM&\u0011QI\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\r3Bc\u0001\u001eI\u0013\")a(\u0002a\u0001\u007f!)!*\u0002a\u0001\u007f\u0005!B/[7f!\u0006\u0014H/\u001b;j_:\u0004\u0016\r\u001e;fe:\u0004")
public class TimeBasedHdfsPathAnalyzer {
    private final PathChecker pathChecker;
    private final List<DataLoaderHandler> dataLoaderHandlers;

    public PathInfo analyze(String filePath) {
        String dailyFolder = "daily/";
        String hourlyFolder = "hourly/";
        String dailyPattern = "yyyy/MM/dd";
        String hourlyPattern = "yyyy/MM/dd/HH";
        String fileFolder = filePath.endsWith("/") ? filePath : new StringBuilder(1).append(filePath).append("/").toString();
        ObjectRef pathInfoOpt = ObjectRef.create((Object)None$.MODULE$);
        if (this.pathChecker instanceof LocalPathChecker) {
            Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.dataLoaderHandlers.foreach((Function1 & Serializable & scala.Serializable)dataLoaderHandler -> {
                TimeBasedHdfsPathAnalyzer.$anonfun$analyze$2(fileFolder, pathInfoOpt, dailyPattern, dataLoaderHandler);
                return BoxedUnit.UNIT;
            }));
        }
        return ((Option)pathInfoOpt.elem).isDefined() ? (PathInfo)((Option)pathInfoOpt.elem).get() : (fileFolder.endsWith(dailyFolder) ? new PathInfo(fileFolder, DateTimeResolution$.MODULE$.DAILY(), dailyPattern) : (fileFolder.endsWith(hourlyFolder) ? new PathInfo(fileFolder, DateTimeResolution$.MODULE$.HOURLY(), hourlyPattern) : (this.pathChecker.exists(new StringBuilder(0).append(fileFolder).append(dailyFolder).toString()) ? new PathInfo(new StringBuilder(0).append(fileFolder).append(dailyFolder).toString(), DateTimeResolution$.MODULE$.DAILY(), dailyPattern) : (this.pathChecker.exists(new StringBuilder(0).append(fileFolder).append(hourlyFolder).toString()) ? new PathInfo(new StringBuilder(0).append(fileFolder).append(hourlyFolder).toString(), DateTimeResolution$.MODULE$.HOURLY(), hourlyPattern) : new PathInfo(new StringBuilder(14).append(fileFolder).append("datepartition=").toString(), DateTimeResolution$.MODULE$.DAILY(), "yyyy-MM-dd-00")))));
    }

    public PathInfo analyze(String filePath, String timePartitionPattern) {
        String basePath = filePath.endsWith("/") || filePath.endsWith("=") ? filePath : new StringBuilder(1).append(filePath).append("/").toString();
        Enumeration.Value dateTimeResolution = OfflineDateTimeUtils$.MODULE$.getDateTimeResolutionFromPattern(timePartitionPattern);
        return new PathInfo(basePath, dateTimeResolution, timePartitionPattern);
    }

    public static final /* synthetic */ void $anonfun$analyze$2(String fileFolder$1, ObjectRef pathInfoOpt$1, String dailyPattern$1, DataLoaderHandler dataLoaderHandler) {
        block0: {
            if (!BoxesRunTime.unboxToBoolean((Object)dataLoaderHandler.validatePath().apply((Object)fileFolder$1))) break block0;
            pathInfoOpt$1.elem = new Some((Object)new PathInfo(fileFolder$1, DateTimeResolution$.MODULE$.DAILY(), dailyPattern$1));
        }
    }

    public TimeBasedHdfsPathAnalyzer(PathChecker pathChecker, List<DataLoaderHandler> dataLoaderHandlers) {
        this.pathChecker = pathChecker;
        this.dataLoaderHandlers = dataLoaderHandlers;
    }
}

