/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.swa;

import com.linkedin.feathr.common.ErasedEntityTaggedFeature;
import com.linkedin.feathr.common.FeatureTypeConfig;
import com.linkedin.feathr.common.FeatureValue;
import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrConfigException;
import com.linkedin.feathr.offline.FeatureDataFrame;
import com.linkedin.feathr.offline.anchored.WindowTimeUnit$;
import com.linkedin.feathr.offline.anchored.anchorExtractor.TimeWindowConfigurableAnchorExtractor;
import com.linkedin.feathr.offline.anchored.feature.FeatureAnchorWithSource;
import com.linkedin.feathr.offline.anchored.keyExtractor.MVELSourceKeyExtractor;
import com.linkedin.feathr.offline.anchored.keyExtractor.SQLSourceKeyExtractor;
import com.linkedin.feathr.offline.client.DataFrameColName$;
import com.linkedin.feathr.offline.config.FeatureJoinConfig;
import com.linkedin.feathr.offline.config.JoinConfigSettings;
import com.linkedin.feathr.offline.config.JoinTimeSetting;
import com.linkedin.feathr.offline.config.TimeWindowFeatureDefinition;
import com.linkedin.feathr.offline.exception.FeathrIllegalStateException;
import com.linkedin.feathr.offline.job.PreprocessedDataFrameManager$;
import com.linkedin.feathr.offline.join.DataFrameKeyCombiner;
import com.linkedin.feathr.offline.join.DataFrameKeyCombiner$;
import com.linkedin.feathr.offline.source.DataSource;
import com.linkedin.feathr.offline.swa.SlidingWindowFeatureUtils$;
import com.linkedin.feathr.offline.transformation.AnchorToDataSourceMapper;
import com.linkedin.feathr.offline.transformation.DataFrameDefaultValueSubstituter$;
import com.linkedin.feathr.offline.util.FeathrUtils$;
import com.linkedin.feathr.offline.util.datetime.DateTimeInterval;
import com.linkedin.feathr.sparkcommon.SourceKeyExtractor;
import com.linkedin.feathr.swj.FactData;
import com.linkedin.feathr.swj.LabelData;
import com.linkedin.feathr.swj.SlidingWindowJoin$;
import java.io.Serializable;
import java.time.Duration;
import org.apache.log4j.Logger;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.util.sketch.BloomFilter;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005%e!\u0002\u0005\n\u0001-\u0019\u0002\u0002\u0003\u000e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\t\u0011I\u0002!\u0011!Q\u0001\nMBQ!\u000f\u0001\u0005\u0002iBqa\u0010\u0001C\u0002\u0013%\u0001\t\u0003\u0004L\u0001\u0001\u0006I!\u0011\u0005\u0006\u0019\u0002!\t!\u0014\u0005\b\u0003k\u0002A\u0011AA<\u0005y\u0019F.\u001b3j]\u001e<\u0016N\u001c3po\u0006;wM]3hCRLwN\u001c&pS:,'O\u0003\u0002\u000b\u0017\u0005\u00191o^1\u000b\u00051i\u0011aB8gM2Lg.\u001a\u0006\u0003\u001d=\taAZ3bi\"\u0014(B\u0001\t\u0012\u0003!a\u0017N\\6fI&t'\"\u0001\n\u0002\u0007\r|Wn\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\t1\u0011I\\=SK\u001a\fA#\u00197m/&tGm\\<BO\u001e4U-\u0019;ve\u0016\u001c8\u0001\u0001\t\u0005;\u0011:#F\u0004\u0002\u001fEA\u0011qDF\u0007\u0002A)\u0011\u0011eG\u0001\u0007yI|w\u000e\u001e \n\u0005\r2\u0012A\u0002)sK\u0012,g-\u0003\u0002&M\t\u0019Q*\u00199\u000b\u0005\r2\u0002CA\u000f)\u0013\tIcE\u0001\u0004TiJLgn\u001a\t\u0003WAj\u0011\u0001\f\u0006\u0003[9\nqAZ3biV\u0014XM\u0003\u00020\u0017\u0005A\u0011M\\2i_J,G-\u0003\u00022Y\t9b)Z1ukJ,\u0017I\\2i_J<\u0016\u000e\u001e5T_V\u00148-Z\u0001\u0019C:\u001c\u0007n\u001c:U_\u0012\u000bG/Y*pkJ\u001cW-T1qa\u0016\u0014\bC\u0001\u001b8\u001b\u0005)$B\u0001\u001c\f\u00039!(/\u00198tM>\u0014X.\u0019;j_:L!\u0001O\u001b\u00031\u0005s7\r[8s)>$\u0015\r^1T_V\u00148-Z'baB,'/\u0001\u0004=S:LGO\u0010\u000b\u0004wur\u0004C\u0001\u001f\u0001\u001b\u0005I\u0001\"\u0002\u000e\u0004\u0001\u0004a\u0002\"\u0002\u001a\u0004\u0001\u0004\u0019\u0014a\u00017pOV\t\u0011\t\u0005\u0002C\u00136\t1I\u0003\u0002E\u000b\u0006)An\\45U*\u0011aiR\u0001\u0007CB\f7\r[3\u000b\u0003!\u000b1a\u001c:h\u0013\tQ5I\u0001\u0004M_\u001e<WM]\u0001\u0005Y><\u0007%A\rk_&tw+\u001b8e_^\fum\u001a$fCR,(/Z:Bg\u00123EC\u0004(S96,x0!\t\u00024\u0005]\u00131\u000e\t\u0003\u001fBk\u0011aC\u0005\u0003#.\u0011\u0001CR3biV\u0014X\rR1uC\u001a\u0013\u0018-\\3\t\u000bM3\u0001\u0019\u0001+\u0002\u0005M\u001c\bCA+[\u001b\u00051&BA,Y\u0003\r\u0019\u0018\u000f\u001c\u0006\u00033\u0016\u000bQa\u001d9be.L!a\u0017,\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\u000bu3\u0001\u0019\u00010\u0002\u000b=\u00147\u000f\u0012$\u0011\u0005}SgB\u00011i\u001d\t\twM\u0004\u0002cM:\u00111-\u001a\b\u0003?\u0011L\u0011\u0001S\u0005\u0003\r\u001eK!!W#\n\u0005]C\u0016BA5W\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001b7\u0003\u0013\u0011\u000bG/\u0019$sC6,'BA5W\u0011\u0015qg\u00011\u0001p\u0003)Qw.\u001b8D_:4\u0017n\u001a\t\u0003aNl\u0011!\u001d\u0006\u0003e.\taaY8oM&<\u0017B\u0001;r\u0005E1U-\u0019;ve\u0016Tu.\u001b8D_:4\u0017n\u001a\u0005\u0006m\u001a\u0001\ra^\u0001\u000bW\u0016LH+Y4MSN$\bc\u0001=}O9\u0011\u0011p\u001f\b\u0003?iL\u0011aF\u0005\u0003SZI!! @\u0003\u0007M+\u0017O\u0003\u0002j-!9\u0011\u0011\u0001\u0004A\u0002\u0005\r\u0011AF<j]\u0012|w/Q4h\r\u0016\fG/\u001e:f'R\fw-Z:\u0011\tad\u0018Q\u0001\t\u0005\u0003\u000f\tYB\u0004\u0003\u0002\n\u0005ea\u0002BA\u0006\u0003/qA!!\u0004\u0002\u00169!\u0011qBA\n\u001d\ry\u0012\u0011C\u0005\u0002%%\u0011\u0001#E\u0005\u0003\u001d=I!\u0001D\u0007\n\u0005%\\\u0011\u0002BA\u000f\u0003?\u0011\u0011BS8j]N#\u0018mZ3\u000b\u0005%\\\u0001bBA\u0012\r\u0001\u0007\u0011QE\u0001\u001ae\u0016\fX/\u001b:fI^Kg\u000eZ8x\u0003\u001e<g)Z1ukJ,7\u000f\u0005\u0003yy\u0006\u001d\u0002\u0003BA\u0015\u0003_i!!a\u000b\u000b\u0007\u00055R\"\u0001\u0004d_6lwN\\\u0005\u0005\u0003c\tYCA\rFe\u0006\u001cX\rZ#oi&$\u0018\u0010V1hO\u0016$g)Z1ukJ,\u0007bBA\u001b\r\u0001\u0007\u0011qG\u0001\rE2|w.\u001c$jYR,'o\u001d\t\u0006+\u0005e\u0012QH\u0005\u0004\u0003w1\"AB(qi&|g\u000e\u0005\u0004\u001eI\u0005}\u0012q\t\t\u0005qr\f\t\u0005E\u0002\u0016\u0003\u0007J1!!\u0012\u0017\u0005\rIe\u000e\u001e\t\u0005\u0003\u0013\n\u0019&\u0004\u0002\u0002L)!\u0011QJA(\u0003\u0019\u00198.\u001a;dQ*\u0019\u0011\u0011\u000b-\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003+\nYEA\u0006CY>|WNR5mi\u0016\u0014\bbBA-\r\u0001\u0007\u00111L\u0001\u000eg^\fwJY:US6,w\n\u001d;\u0011\u000bU\tI$!\u0018\u0011\t\u0005}\u0013qM\u0007\u0003\u0003CRA!a\u0019\u0002f\u0005AA-\u0019;fi&lWMC\u0002\u0002R-IA!!\u001b\u0002b\t\u0001B)\u0019;f)&lW-\u00138uKJ4\u0018\r\u001c\u0005\b\u0003[2\u0001\u0019AA8\u0003Y1\u0017-\u001b7P]6K7o]5oOB\u000b'\u000f^5uS>t\u0007cA\u000b\u0002r%\u0019\u00111\u000f\f\u0003\u000f\t{w\u000e\\3b]\u0006i2\u000f^1oI\u0006\u0014H-\u001b>f\r\u0016\fG/\u001e:f\u0007>dW/\u001c8OC6,7\u000fF\u0005_\u0003s\ni(!!\u0002\u0006\"1\u00111P\u0004A\u0002]\fQc\u001c:jO\u000e{g\u000e^3yi>\u00137oQ8mk6t7\u000f\u0003\u0004\u0002\u0000\u001d\u0001\rAX\u0001\u0011o&$\bnU,B\r\u0016\fG/\u001e:f\t\u001aCa!a!\b\u0001\u00049\u0018\u0001\u00044fCR,(/\u001a(b[\u0016\u001c\bBBAD\u000f\u0001\u0007q/A\u0004lKf$\u0016mZ:")
public class SlidingWindowAggregationJoiner {
    private final Map<String, FeatureAnchorWithSource> allWindowAggFeatures;
    private final AnchorToDataSourceMapper anchorToDataSourceMapper;
    private final Logger log;

    private Logger log() {
        return this.log;
    }

    public FeatureDataFrame joinWindowAggFeaturesAsDF(SparkSession ss, Dataset<Row> obsDF, FeatureJoinConfig joinConfig, Seq<String> keyTagList, Seq<Tuple2<Seq<Object>, Seq<String>>> windowAggFeatureStages, Seq<ErasedEntityTaggedFeature> requiredWindowAggFeatures, Option<Map<Seq<Object>, BloomFilter>> bloomFilters, Option<DateTimeInterval> swaObsTimeOpt, boolean failOnMissingPartition) {
        Option<JoinConfigSettings> joinConfigSettings = joinConfig.settings();
        if (joinConfigSettings.isEmpty()) {
            throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, "settings section are not defined in join config, cannot extract observation data time range");
        }
        if (((JoinConfigSettings)joinConfigSettings.get()).joinTimeSetting().isEmpty()) {
            throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, "joinTimeSettings section is not defined in join config, cannot perform window aggregation operation");
        }
        boolean enableCheckPoint = new StringOps(Predef$.MODULE$.augmentString(FeathrUtils$.MODULE$.getFeathrJobParam(ss, FeathrUtils$.MODULE$.ENABLE_CHECKPOINT()))).toBoolean();
        JoinTimeSetting timeWindowJoinSettings = (JoinTimeSetting)((JoinConfigSettings)joinConfigSettings.get()).joinTimeSetting().get();
        Option<Duration> simulatedDelay = timeWindowJoinSettings.simulateTimeDelay();
        if (simulatedDelay.isEmpty() && !joinConfig.featuresToTimeDelayMap().isEmpty()) {
            throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, "overrideTimeDelay cannot be defined without setting a simulateTimeDelay in the joinTimeSettings");
        }
        Map featuresToDelayImmutableMap = joinConfig.featuresToTimeDelayMap().mapValues((Function1 & Serializable & scala.Serializable)timeWindowStr -> WindowTimeUnit$.MODULE$.parseWindowTime((String)timeWindowStr)).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(simulatedDelay.map((Function1 & Serializable & scala.Serializable)x$1 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SlidingWindowFeatureUtils$.MODULE$.DEFAULT_TIME_DELAY()), x$1))).toMap(Predef$.MODULE$.$conforms()));
        scala.collection.immutable.IndexedSeq windowAggFeatureNames = ((TraversableOnce)requiredWindowAggFeatures.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getFeatureName(), Seq$.MODULE$.canBuildFrom())).toIndexedSeq();
        scala.collection.immutable.IndexedSeq windowAggAnchors = (scala.collection.immutable.IndexedSeq)windowAggFeatureNames.map(this.allWindowAggFeatures, IndexedSeq$.MODULE$.canBuildFrom());
        ObjectRef contextDF = ObjectRef.create(obsDF);
        DateTimeInterval swaObsTimeRange = (DateTimeInterval)swaObsTimeOpt.get();
        Map windowAggSourceToAnchor = (Map)((TraversableLike)windowAggAnchors.map((Function1 & Serializable & scala.Serializable)anchor -> {
            String featureNames = PreprocessedDataFrameManager$.MODULE$.getPreprocessingUniquenessForAnchor((FeatureAnchorWithSource)anchor);
            return new Tuple2((Object)new Tuple3((Object)anchor.source(), (Object)anchor.featureAnchor().sourceKeyExtractor().toString(), (Object)featureNames), anchor);
        }, IndexedSeq$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$3 -> (Tuple3)x$3._1()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Tuple3 source = (Tuple3)tuple2._1();
            scala.collection.immutable.IndexedSeq grouped = (scala.collection.immutable.IndexedSeq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)source, grouped.map((Function1 & Serializable & scala.Serializable)x$4 -> (FeatureAnchorWithSource)x$4._2(), IndexedSeq$.MODULE$.canBuildFrom()));
            return tuple22;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        Map windowAggAnchorDFMap = (Map)windowAggSourceToAnchor.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Dataset<Row> dataset;
            scala.collection.immutable.IndexedSeq anchors;
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Dataset dataset2;
                Tuple3 sourceWithKeyExtractor = (Tuple3)tuple2._1();
                anchors = (scala.collection.immutable.IndexedSeq)tuple2._2();
                Duration maxDurationPerSource = (Duration)((TraversableOnce)anchors.map((Function1 & Serializable & scala.Serializable)x$5 -> SlidingWindowFeatureUtils$.MODULE$.getMaxWindowDurationInAnchor((FeatureAnchorWithSource)x$5, (IndexedSeq<String>)windowAggFeatureNames), IndexedSeq$.MODULE$.canBuildFrom())).max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
                this.log().info((Object)new StringBuilder(60).append("Selected max window duration ").append(maxDurationPerSource).append(" across all anchors for source ").append(((DataSource)sourceWithKeyExtractor._1()).path()).toString());
                scala.collection.immutable.IndexedSeq res = (scala.collection.immutable.IndexedSeq)anchors.flatMap((Function1 & Serializable & scala.Serializable)x -> x.featureAnchor().features(), IndexedSeq$.MODULE$.canBuildFrom());
                String featureNames = ((TraversableOnce)res.toSet().toSeq().sorted((Ordering)Ordering.String$.MODULE$)).mkString(",");
                Option preprocessedDf = PreprocessedDataFrameManager$.MODULE$.preprocessedDfMap().get((Object)featureNames);
                Dataset originalSourceDf = $this.anchorToDataSourceMapper.getWindowAggAnchorDFMapForJoin(ss, (DataSource)sourceWithKeyExtractor._1(), swaObsTimeRange, maxDurationPerSource, (Duration[])featuresToDelayImmutableMap.values().toArray(ClassTag$.MODULE$.apply(Duration.class)), failOnMissingPartition);
                Option option = preprocessedDf;
                if (option instanceof Some) {
                    Dataset existDf;
                    Some some = (Some)option;
                    dataset2 = existDf = (Dataset)some.value();
                } else if (None$.MODULE$.equals(option)) {
                    dataset2 = originalSourceDf;
                } else {
                    throw new MatchError((Object)option);
                }
                Dataset sourceDF = dataset2;
                SourceKeyExtractor sourceKeyExtractor = ((FeatureAnchorWithSource)anchors.head()).featureAnchor().sourceKeyExtractor();
                if (sourceKeyExtractor instanceof SQLSourceKeyExtractor) {
                    SQLSourceKeyExtractor sQLSourceKeyExtractor = (SQLSourceKeyExtractor)sourceKeyExtractor;
                    dataset = sQLSourceKeyExtractor.appendKeyColumns((Dataset<Row>)sourceDF, false);
                } else {
                    dataset = sourceKeyExtractor.appendKeyColumns((Dataset<Row>)sourceDF);
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Dataset<Row> withKeyDF = dataset;
            scala.collection.immutable.IndexedSeq indexedSeq = (scala.collection.immutable.IndexedSeq)anchors.map((Function1 & Serializable & scala.Serializable)anchor -> new Tuple2(anchor, (Object)withKeyDF), IndexedSeq$.MODULE$.canBuildFrom());
            return indexedSeq;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        scala.collection.mutable.Map allInferredFeatureTypes = Map$.MODULE$.empty();
        windowAggFeatureStages.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            SlidingWindowAggregationJoiner.$anonfun$joinWindowAggFeaturesAsDF$12(this, keyTagList, bloomFilters, timeWindowJoinSettings, contextDF, ss, windowAggAnchorDFMap, featuresToDelayImmutableMap, allInferredFeatureTypes, enableCheckPoint, x0$3);
            return BoxedUnit.UNIT;
        });
        return new FeatureDataFrame((Dataset<Row>)((Dataset)contextDF.elem), (Map<String, FeatureTypeConfig>)allInferredFeatureTypes.toMap(Predef$.MODULE$.$conforms()));
    }

    public Dataset<Row> standardizeFeatureColumnNames(Seq<String> origContextObsColumns, Dataset<Row> withSWAFeatureDF, Seq<String> featureNames, Seq<String> keyTags) {
        int inputColumnSize = origContextObsColumns.size();
        int outputColumnNum = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])withSWAFeatureDF.columns())).size();
        if (outputColumnNum != inputColumnSize + featureNames.size()) {
            throw new FeathrIllegalStateException(new StringBuilder(238).append("Number of columns (").append(outputColumnNum).append(") in the dataframe returned by ").append("sliding window aggregation does not equal to number of columns in the observation data (").append(inputColumnSize).append(") ").append("+ number of features (").append(featureNames.size()).append("). Columns in returned dataframe are ").append(withSWAFeatureDF.columns()).append(",").append(" columns in observation dataframe are ").append(origContextObsColumns).toString());
        }
        Seq renamingPairs = (Seq)featureNames.map((Function1 & Serializable & scala.Serializable)feature -> {
            String columnName = DataFrameColName$.MODULE$.genFeatureColumnName((String)feature, (Option<Seq<String>>)new Some((Object)keyTags));
            return new Tuple2(feature, (Object)columnName);
        }, Seq$.MODULE$.canBuildFrom());
        return (Dataset)renamingPairs.foldLeft(withSWAFeatureDF, (Function2 & Serializable & scala.Serializable)(baseDF, renamePair) -> baseDF.withColumnRenamed((String)renamePair._1(), (String)renamePair._2()));
    }

    public static final /* synthetic */ FactData $anonfun$joinWindowAggFeaturesAsDF$15(Seq x3$1, Option bloomFilter$1, Map featuresToDelayImmutableMap$1, Map anchorWithSourceToDFMap) {
        Dataset dataset;
        Set selectedFeatures = (Set)((TraversableLike)anchorWithSourceToDFMap.keySet().flatMap((Function1 & Serializable & scala.Serializable)x$7 -> x$7.selectedFeatures(), Set$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x3$1.contains((Object)x$8)));
        Dataset factData = (Dataset)((Tuple2)anchorWithSourceToDFMap.head())._2();
        FeatureAnchorWithSource anchor = (FeatureAnchorWithSource)((Tuple2)anchorWithSourceToDFMap.head())._1();
        Option option = bloomFilter$1;
        if (None$.MODULE$.equals(option)) {
            dataset = factData;
        } else if (option instanceof Some) {
            boolean x$3;
            Seq<String> x$2;
            Dataset x$1;
            Some some = (Some)option;
            BloomFilter filter = (BloomFilter)some.value();
            if (anchor.featureAnchor().sourceKeyExtractor() instanceof MVELSourceKeyExtractor) {
                throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, "MVELSourceKeyExtractor is not supported in sliding window aggregation");
            }
            Seq<String> keyColumnsList = anchor.featureAnchor().sourceKeyExtractor().getKeyColumnNames((Option<Object>)None$.MODULE$);
            DataFrameKeyCombiner qual$1 = DataFrameKeyCombiner$.MODULE$.apply();
            Tuple2<String, Dataset<Row>> tuple2 = qual$1.combine((Dataset<Row>)(x$1 = factData), x$2 = keyColumnsList, x$3 = qual$1.combine$default$3());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String bfFactKeyColName = (String)tuple2._1();
            Dataset factDataWithKeys = (Dataset)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)bfFactKeyColName, (Object)factDataWithKeys);
            Tuple2 tuple23 = tuple22;
            String bfFactKeyColName2 = (String)tuple23._1();
            Dataset factDataWithKeys2 = (Dataset)tuple23._2();
            Dataset filtered = factDataWithKeys2.filter(SlidingWindowFeatureUtils$.MODULE$.mightContain(filter).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(bfFactKeyColName2)})));
            dataset = filtered.drop(functions$.MODULE$.col(bfFactKeyColName2));
        } else {
            throw new MatchError((Object)option);
        }
        Dataset filteredFactData = dataset;
        return SlidingWindowFeatureUtils$.MODULE$.getFactDataDef((Dataset<Row>)filteredFactData, (Seq<FeatureAnchorWithSource>)anchorWithSourceToDFMap.keySet().toSeq(), (Map<String, Duration>)featuresToDelayImmutableMap$1, (Set<String>)selectedFeatures);
    }

    public static final /* synthetic */ void $anonfun$joinWindowAggFeaturesAsDF$22(SlidingWindowAggregationJoiner $this, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        FactData factDataDef = (FactData)tuple2._1();
        int idx = tuple2._2$mcI$sp();
        $this.log().debug((Object)new StringBuilder(35).append("First 3 rows in feature dataset ").append(idx).append(":\n ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])factDataDef.dataSource().collect())).take(3))).map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("\n ")).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$joinWindowAggFeaturesAsDF$12(SlidingWindowAggregationJoiner $this, Seq keyTagList$1, Option bloomFilters$1, JoinTimeSetting timeWindowJoinSettings$1, ObjectRef contextDF$1, SparkSession ss$1, Map windowAggAnchorDFMap$1, Map featuresToDelayImmutableMap$1, scala.collection.mutable.Map allInferredFeatureTypes$1, boolean enableCheckPoint$1, Tuple2 x0$3) {
        BoxedUnit boxedUnit;
        None$ none$;
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Seq keyTags = (Seq)tuple2._1();
        Seq featureNames = (Seq)tuple2._2();
        if (keyTags == null) throw new MatchError((Object)tuple2);
        Seq seq = keyTags;
        if (featureNames == null) throw new MatchError((Object)tuple2);
        Seq seq2 = featureNames;
        Seq stringKeyTags = (Seq)((TraversableLike)seq.map((Function1)keyTagList$1, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)k -> new StringBuilder(17).append("CAST (").append((String)k).append(" AS string)").toString(), Seq$.MODULE$.canBuildFrom());
        Option option = bloomFilters$1;
        if (option instanceof Some) {
            Some some = (Some)option;
            Map filters = (Map)some.value();
            none$ = Option$.MODULE$.apply(filters.apply((Object)seq));
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            none$ = None$.MODULE$;
        }
        None$ bloomFilter = none$;
        String timeStampExpr = !timeWindowJoinSettings$1.useLatestFeatureData() ? SlidingWindowFeatureUtils$.MODULE$.constructTimeStampExpr(timeWindowJoinSettings$1.timestampColumn().name(), timeWindowJoinSettings$1.timestampColumn().format(), SlidingWindowFeatureUtils$.MODULE$.constructTimeStampExpr$default$3()) : "unix_timestamp()";
        LabelData labelDataDef = new LabelData((Dataset<Row>)((Dataset)contextDF$1.elem), (Seq<String>)stringKeyTags, timeStampExpr);
        if (ss$1.sparkContext().isLocal() && $this.log().isDebugEnabled()) {
            $this.log().debug((Object)new StringBuilder(87).append("*********Sliding window aggregation feature join stage with key: ").append(stringKeyTags).append(" for feature ").append(seq2.mkString(",")).append("*********").toString());
            $this.log().debug((Object)new StringBuilder(39).append("First 3 rows in observation dataset :\n ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])labelDataDef.dataSource().collect())).take(3))).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("\n ")).toString());
        }
        Seq windowAggAnchorsThisStage = (Seq)seq2.map($this.allWindowAggFeatures, Seq$.MODULE$.canBuildFrom());
        Map windowAggAnchorDFThisStage = windowAggAnchorDFMap$1.filterKeys((Function1)windowAggAnchorsThisStage.toSet());
        Seq factDataDefs = (Seq)SlidingWindowFeatureUtils$.MODULE$.getSWAAnchorGroups((Map<FeatureAnchorWithSource, Dataset<Row>>)windowAggAnchorDFThisStage).map(arg_0 -> SlidingWindowAggregationJoiner.$anonfun$joinWindowAggFeaturesAsDF$15(seq2, (Option)bloomFilter, featuresToDelayImmutableMap$1, arg_0), Seq$.MODULE$.canBuildFrom());
        String[] origContextObsColumns = labelDataDef.dataSource().columns();
        contextDF$1.elem = SlidingWindowJoin$.MODULE$.join(labelDataDef, (List<FactData>)factDataDefs.toList(), SlidingWindowJoin$.MODULE$.join$default$3());
        Map defaults = (Map)windowAggAnchorDFThisStage.flatMap((Function1 & Serializable & scala.Serializable)s -> ((FeatureAnchorWithSource)s._1()).featureAnchor().defaults(), scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        Map userSpecifiedTypesConfig = (Map)windowAggAnchorDFThisStage.flatMap((Function1 & Serializable & scala.Serializable)x$10 -> ((FeatureAnchorWithSource)x$10._1()).featureAnchor().featureTypeConfigs(), scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        Map featureNameToColumnFormat = (Map)$this.allWindowAggFeatures.map((Function1 & Serializable & scala.Serializable)nameToFeatureAnchor -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(nameToFeatureAnchor._1()), (Object)((TimeWindowFeatureDefinition)((TimeWindowConfigurableAnchorExtractor)((FeatureAnchorWithSource)nameToFeatureAnchor._2()).featureAnchor().extractor()).features().apply(nameToFeatureAnchor._1())).columnFormat()), scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        FeatureDataFrame featureDataFrame = SlidingWindowFeatureUtils$.MODULE$.convertSWADFToFDS((Dataset<Row>)((Dataset)contextDF$1.elem), (Set<String>)seq2.toSet(), (Map<String, Enumeration.Value>)featureNameToColumnFormat, (Map<String, FeatureTypeConfig>)userSpecifiedTypesConfig);
        if (featureDataFrame == null) {
            throw new MatchError((Object)featureDataFrame);
        }
        Dataset<Row> withFDSFeatureDF = featureDataFrame.df();
        Map<String, FeatureTypeConfig> inferredTypes = featureDataFrame.inferredFeatureType();
        Tuple2 tuple22 = new Tuple2(withFDSFeatureDF, inferredTypes);
        Tuple2 tuple23 = tuple22;
        Dataset withFDSFeatureDF2 = (Dataset)tuple23._1();
        Map inferredTypes2 = (Map)tuple23._2();
        Dataset<Row> withFeatureContextDF = DataFrameDefaultValueSubstituter$.MODULE$.substituteDefaults((Dataset<Row>)withFDSFeatureDF2, (Seq<String>)((TraversableOnce)defaults.keys().filter((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)seq2.contains(elem)))).toSeq(), (Map<String, FeatureValue>)defaults, (Map<String, FeatureTypeConfig>)userSpecifiedTypesConfig, ss$1, DataFrameDefaultValueSubstituter$.MODULE$.substituteDefaults$default$6());
        allInferredFeatureTypes$1.$plus$plus$eq((TraversableOnce)inferredTypes2);
        contextDF$1.elem = $this.standardizeFeatureColumnNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])origContextObsColumns), withFeatureContextDF, (Seq<String>)seq2, (Seq<String>)((Seq)seq.map((Function1)keyTagList$1, Seq$.MODULE$.canBuildFrom())));
        if (enableCheckPoint$1) {
            contextDF$1.elem = ((Dataset)contextDF$1.elem).checkpoint(true);
        }
        if (ss$1.sparkContext().isLocal() && $this.log().isDebugEnabled()) {
            ((IterableLike)factDataDefs.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                SlidingWindowAggregationJoiner.$anonfun$joinWindowAggFeaturesAsDF$22($this, x0$4);
                return BoxedUnit.UNIT;
            });
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public SlidingWindowAggregationJoiner(Map<String, FeatureAnchorWithSource> allWindowAggFeatures, AnchorToDataSourceMapper anchorToDataSourceMapper) {
        this.allWindowAggFeatures = allWindowAggFeatures;
        this.anchorToDataSourceMapper = anchorToDataSourceMapper;
        this.log = Logger.getLogger(this.getClass());
    }
}

