/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.swa;

import com.linkedin.feathr.common.DateTimeResolution$;
import com.linkedin.feathr.common.FeatureTypeConfig;
import com.linkedin.feathr.common.FeatureTypes;
import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrConfigException;
import com.linkedin.feathr.offline.FeatureDataFrame;
import com.linkedin.feathr.offline.anchored.anchorExtractor.TimeWindowConfigurableAnchorExtractor;
import com.linkedin.feathr.offline.anchored.feature.FeatureAnchorWithSource;
import com.linkedin.feathr.offline.config.JoinConfigSettings;
import com.linkedin.feathr.offline.config.JoinTimeSetting;
import com.linkedin.feathr.offline.config.ObservationDataTimeSetting;
import com.linkedin.feathr.offline.config.TimeWindowFeatureDefinition;
import com.linkedin.feathr.offline.job.PreprocessedDataFrameManager$;
import com.linkedin.feathr.offline.source.DataSource;
import com.linkedin.feathr.offline.source.TimeWindowParams;
import com.linkedin.feathr.offline.swa.SlidingWindowFeatureUtils$;
import com.linkedin.feathr.offline.transformation.FeatureColumnFormat$;
import com.linkedin.feathr.offline.util.FeaturizedDatasetUtils$;
import com.linkedin.feathr.offline.util.datetime.DateTimeInterval;
import com.linkedin.feathr.offline.util.datetime.DateTimeInterval$;
import com.linkedin.feathr.offline.util.datetime.OfflineDateTimeUtils$;
import com.linkedin.feathr.sparkcommon.SourceKeyExtractor;
import com.linkedin.feathr.swj.FactData;
import com.linkedin.feathr.swj.GroupBySpec;
import com.linkedin.feathr.swj.LateralViewParams;
import com.linkedin.feathr.swj.SlidingWindowFeature;
import com.linkedin.feathr.swj.WindowSpec;
import com.linkedin.feathr.swj.aggregate.AggregationSpec;
import com.linkedin.feathr.swj.aggregate.AggregationType$;
import com.linkedin.feathr.swj.aggregate.AvgAggregate;
import com.linkedin.feathr.swj.aggregate.AvgAggregate$;
import com.linkedin.feathr.swj.aggregate.AvgPoolingAggregate;
import com.linkedin.feathr.swj.aggregate.AvgPoolingAggregate$;
import com.linkedin.feathr.swj.aggregate.CountAggregate;
import com.linkedin.feathr.swj.aggregate.CountDistinctAggregate;
import com.linkedin.feathr.swj.aggregate.LatestAggregate;
import com.linkedin.feathr.swj.aggregate.MaxAggregate;
import com.linkedin.feathr.swj.aggregate.MaxPoolingAggregate;
import com.linkedin.feathr.swj.aggregate.MinAggregate;
import com.linkedin.feathr.swj.aggregate.MinPoolingAggregate;
import com.linkedin.feathr.swj.aggregate.SumAggregate;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import org.apache.log4j.Logger;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.util.sketch.BloomFilter;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class SlidingWindowFeatureUtils$ {
    public static SlidingWindowFeatureUtils$ MODULE$;
    private final Logger log;
    private final String EPOCH;
    private final String EPOCH_MILLIS;
    private final int MILLIS_IN_SECOND;
    private final String TIMESTAMP_WITHOUT_TIMEZONE_FORMAT;
    private final String TIMESTAMP_WITH_TIMEZONE_FORMAT;
    private final String UTC_TIMEZONE_OFFSET;
    private final String DEFAULT_TIME_DELAY;
    private final String TIMESTAMP_PARTITION_COLUMN;

    static {
        new SlidingWindowFeatureUtils$();
    }

    private Logger log() {
        return this.log;
    }

    private String EPOCH() {
        return this.EPOCH;
    }

    private String EPOCH_MILLIS() {
        return this.EPOCH_MILLIS;
    }

    private int MILLIS_IN_SECOND() {
        return this.MILLIS_IN_SECOND;
    }

    public String TIMESTAMP_WITHOUT_TIMEZONE_FORMAT() {
        return this.TIMESTAMP_WITHOUT_TIMEZONE_FORMAT;
    }

    public String TIMESTAMP_WITH_TIMEZONE_FORMAT() {
        return this.TIMESTAMP_WITH_TIMEZONE_FORMAT;
    }

    public String UTC_TIMEZONE_OFFSET() {
        return this.UTC_TIMEZONE_OFFSET;
    }

    public String DEFAULT_TIME_DELAY() {
        return this.DEFAULT_TIME_DELAY;
    }

    public String TIMESTAMP_PARTITION_COLUMN() {
        return this.TIMESTAMP_PARTITION_COLUMN;
    }

    public boolean isWindowAggAnchor(FeatureAnchorWithSource anchor) {
        return anchor.featureAnchor().extractor() instanceof TimeWindowConfigurableAnchorExtractor;
    }

    public Tuple2<Option<DateTimeInterval>, Option<String>> getObsSwaDataTimeRange(Dataset<Row> contextDF, Option<JoinConfigSettings> joinConfigSettingsOpt) {
        Tuple2 tuple2;
        Option<JoinConfigSettings> option = joinConfigSettingsOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            JoinConfigSettings joinConfigSettings = (JoinConfigSettings)some.value();
            String timestampCol = joinConfigSettings.joinTimeSetting().isDefined() ? ((JoinTimeSetting)joinConfigSettings.joinTimeSetting().get()).timestampColumn().name() : "";
            tuple2 = new Tuple2((Object)new Some((Object)this.getObsDataTimeRange(contextDF, joinConfigSettings.observationDataTimeSetting(), joinConfigSettings.joinTimeSetting())), (Object)new Some((Object)timestampCol));
        } else {
            tuple2 = new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
        }
        return tuple2;
    }

    public DateTimeInterval getObsDataTimeRange(Dataset<Row> contextDF, Option<ObservationDataTimeSetting> observationDataTimeSetting, Option<JoinTimeSetting> joinTimeSetting) {
        DateTimeInterval dateTimeInterval;
        if (observationDataTimeSetting.isDefined()) {
            dateTimeInterval = OfflineDateTimeUtils$.MODULE$.createTimeIntervalFromDateTimeRange((ObservationDataTimeSetting)observationDataTimeSetting.get());
        } else if (joinTimeSetting.isDefined() && !((JoinTimeSetting)joinTimeSetting.get()).useLatestFeatureData()) {
            String timestampExpr = this.constructTimeStampExpr(((JoinTimeSetting)joinTimeSetting.get()).timestampColumn().name(), ((JoinTimeSetting)joinTimeSetting.get()).timestampColumn().format(), this.constructTimeStampExpr$default$3());
            Row minMax = (Row)contextDF.agg(functions$.MODULE$.min(functions$.MODULE$.expr(timestampExpr)), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.max(functions$.MODULE$.expr(timestampExpr))})).head();
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(minMax.getLong(0), minMax.getLong(1));
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            long minEpoch = sp2._1$mcJ$sp();
            long maxEpoch = sp2._2$mcJ$sp();
            Tuple2.mcJJ.sp sp3 = new Tuple2.mcJJ.sp(minEpoch, maxEpoch);
            Tuple2.mcJJ.sp sp4 = sp3;
            long minEpoch2 = sp4._1$mcJ$sp();
            long maxEpoch2 = sp4._2$mcJ$sp();
            dateTimeInterval = DateTimeInterval$.MODULE$.createFromInclusive(Instant.ofEpochSecond(minEpoch2), Instant.ofEpochSecond(maxEpoch2), DateTimeResolution$.MODULE$.HOURLY());
        } else {
            dateTimeInterval = DateTimeInterval$.MODULE$.createFromInclusive(Instant.now(), Instant.now(), DateTimeResolution$.MODULE$.HOURLY());
        }
        return dateTimeInterval;
    }

    public FactData getFactDataDef(Dataset<Row> factDF, Seq<FeatureAnchorWithSource> anchorConfigs, Map<String, Duration> delay, Set<String> selectedFeatureNames) {
        Seq timeWindowExtractor = (Seq)anchorConfigs.map((Function1 & Serializable & scala.Serializable)x$2 -> (TimeWindowConfigurableAnchorExtractor)x$2.featureAnchor().extractor(), Seq$.MODULE$.canBuildFrom());
        Map feathrFeatureConfigs = ((TraversableOnce)timeWindowExtractor.flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.features(), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        SourceKeyExtractor qual$1 = ((FeatureAnchorWithSource)anchorConfigs.head()).featureAnchor().sourceKeyExtractor();
        Option<Object> x$1 = qual$1.getKeyColumnNames$default$1();
        Seq keys = (Seq)qual$1.getKeyColumnNames(x$1).map((Function1 & Serializable & scala.Serializable)sk -> new StringBuilder(17).append("CAST (").append((String)sk).append(" as string)").toString(), Seq$.MODULE$.canBuildFrom());
        TimeWindowParams timeWindowParam = this.getTimeWindowParam(((FeatureAnchorWithSource)anchorConfigs.head()).source());
        String timeStampExpr = this.constructTimeStampExpr(timeWindowParam.timestampColumn(), timeWindowParam.timestampColumnFormat(), this.constructTimeStampExpr$default$3());
        List sparkWindowFeatureConfigs = ((TraversableOnce)feathrFeatureConfigs.collect((PartialFunction)new scala.Serializable(selectedFeatureNames, delay, anchorConfigs){
            public static final long serialVersionUID = 0L;
            private final Set selectedFeatureNames$1;
            private final Map delay$1;
            private final Seq anchorConfigs$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<String, TimeWindowFeatureDefinition>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    String featureName = (String)A1._1();
                    TimeWindowFeatureDefinition featureDef = (TimeWindowFeatureDefinition)A1._2();
                    if (featureName != null) {
                        String string = featureName;
                        if (featureDef != null) {
                            TimeWindowFeatureDefinition timeWindowFeatureDefinition = featureDef;
                            if (this.selectedFeatureNames$1.contains((Object)string)) {
                                Duration duration;
                                Option option = this.delay$1.get((Object)string);
                                if (option instanceof Some) {
                                    Duration delay;
                                    Some some = (Some)option;
                                    duration = delay = (Duration)some.value();
                                } else {
                                    Duration duration2;
                                    if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                                    Option option2 = this.delay$1.get((Object)SlidingWindowFeatureUtils$.MODULE$.DEFAULT_TIME_DELAY());
                                    if (option2 instanceof Some) {
                                        Duration delay;
                                        Some some = (Some)option2;
                                        duration2 = delay = (Duration)some.value();
                                    } else {
                                        if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)option2);
                                        duration2 = Duration.ZERO;
                                    }
                                    duration = duration2;
                                }
                                Duration timeDelay = duration;
                                object = SlidingWindowFeatureUtils$.MODULE$.convertFeathrDefToSwjDef(string, timeWindowFeatureDefinition, timeDelay, ((FeatureAnchorWithSource)this.anchorConfigs$1.head()).featureAnchor().lateralViewParams());
                                return (B1)object;
                            }
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<String, TimeWindowFeatureDefinition> x1) {
                Tuple2<String, TimeWindowFeatureDefinition> tuple2 = x1;
                if (tuple2 == null) return false;
                String featureName = (String)tuple2._1();
                TimeWindowFeatureDefinition featureDef = (TimeWindowFeatureDefinition)tuple2._2();
                if (featureName == null) return false;
                String string = featureName;
                if (featureDef == null) return false;
                if (!this.selectedFeatureNames$1.contains((Object)string)) return false;
                return true;
            }
            {
                this.selectedFeatureNames$1 = selectedFeatureNames$1;
                this.delay$1 = delay$1;
                this.anchorConfigs$1 = anchorConfigs$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toList();
        return new FactData(factDF, (Seq<String>)keys, timeStampExpr, (List<SlidingWindowFeature>)sparkWindowFeatureConfigs);
    }

    public Duration getMaxWindowDurationInAnchor(FeatureAnchorWithSource anchorConfig, IndexedSeq<String> requiredFeatures) {
        TimeWindowConfigurableAnchorExtractor timeWindowExtractor = (TimeWindowConfigurableAnchorExtractor)anchorConfig.featureAnchor().extractor();
        Map<String, TimeWindowFeatureDefinition> feathrFeatureConfigs = timeWindowExtractor.features();
        Duration maxDuration = (Duration)((TraversableOnce)feathrFeatureConfigs.filterKeys((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)requiredFeatures.contains((Object)x$4))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TimeWindowFeatureDefinition featureDef;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null || (featureDef = (TimeWindowFeatureDefinition)tuple2._2()) == null) {
                throw new MatchError((Object)tuple2);
            }
            TimeWindowFeatureDefinition timeWindowFeatureDefinition = featureDef;
            Duration duration = timeWindowFeatureDefinition.window();
            return duration;
        }, Iterable$.MODULE$.canBuildFrom())).max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        this.log().info((Object)new StringBuilder(54).append("Selected max window duration ").append(maxDuration).append(" among required features ").append(feathrFeatureConfigs.keySet().filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)requiredFeatures.contains((Object)x$5)))).toString());
        return maxDuration;
    }

    public SlidingWindowFeature convertFeathrDefToSwjDef(String featureName, TimeWindowFeatureDefinition feathrDef, Duration delay, Option<LateralViewParams> lateralViewParams) {
        AggregationSpec aggregationSpec;
        Enumeration.Value aggType = AggregationType$.MODULE$.withName(feathrDef.aggregationType().toString());
        String featureDef = feathrDef.def();
        WindowSpec windowSpec = new WindowSpec(feathrDef.window(), delay);
        Option<String> groupByCol = feathrDef.groupBy();
        Option<Object> limit = feathrDef.limit();
        None$ groupBySpec = groupByCol.isDefined() ? new Some((Object)new GroupBySpec((String)groupByCol.get(), BoxesRunTime.unboxToInt((Object)limit.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)))) : None$.MODULE$;
        Option<String> filter = feathrDef.filter();
        Enumeration.Value value = aggType;
        Enumeration.Value value2 = AggregationType$.MODULE$.SUM();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            aggregationSpec = new SumAggregate(featureDef);
        } else {
            Enumeration.Value value4 = AggregationType$.MODULE$.COUNT();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                String rewrittenDef = new StringBuilder(40).append("CASE WHEN ").append(featureDef).append(" IS NOT NULL THEN 1 ELSE 0 END").toString();
                aggregationSpec = new CountAggregate(rewrittenDef);
            } else {
                Enumeration.Value value6 = AggregationType$.MODULE$.COUNT_DISTINCT();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    aggregationSpec = new CountDistinctAggregate(featureDef);
                } else {
                    Enumeration.Value value8 = AggregationType$.MODULE$.AVG();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        aggregationSpec = new AvgAggregate(featureDef, AvgAggregate$.MODULE$.$lessinit$greater$default$2());
                    } else {
                        Enumeration.Value value10 = AggregationType$.MODULE$.MAX();
                        Enumeration.Value value11 = value;
                        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                            aggregationSpec = new MaxAggregate(featureDef);
                        } else {
                            Enumeration.Value value12 = AggregationType$.MODULE$.MIN();
                            Enumeration.Value value13 = value;
                            if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                                aggregationSpec = new MinAggregate(featureDef);
                            } else {
                                Enumeration.Value value14 = AggregationType$.MODULE$.LATEST();
                                Enumeration.Value value15 = value;
                                if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
                                    aggregationSpec = new LatestAggregate(featureDef);
                                } else {
                                    Enumeration.Value value16 = AggregationType$.MODULE$.MAX_POOLING();
                                    Enumeration.Value value17 = value;
                                    if (!(value16 != null ? !value16.equals(value17) : value17 != null)) {
                                        aggregationSpec = new MaxPoolingAggregate(featureDef);
                                    } else {
                                        Enumeration.Value value18 = AggregationType$.MODULE$.MIN_POOLING();
                                        Enumeration.Value value19 = value;
                                        if (!(value18 != null ? !value18.equals(value19) : value19 != null)) {
                                            aggregationSpec = new MinPoolingAggregate(featureDef);
                                        } else {
                                            Enumeration.Value value20 = AggregationType$.MODULE$.AVG_POOLING();
                                            Enumeration.Value value21 = value;
                                            if (!(value20 != null ? !value20.equals(value21) : value21 != null)) {
                                                aggregationSpec = new AvgPoolingAggregate(featureDef, AvgPoolingAggregate$.MODULE$.$lessinit$greater$default$2());
                                            } else {
                                                throw new MatchError((Object)value);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        SumAggregate aggregationSpec2 = aggregationSpec;
        return new SlidingWindowFeature(featureName, aggregationSpec2, windowSpec, filter, (Option<GroupBySpec>)groupBySpec, lateralViewParams);
    }

    public String constructTimeStampExpr(String timeStampCol, String timeStampFormat, Option<String> timeZone) {
        String string;
        if (this.EPOCH().equalsIgnoreCase(timeStampFormat)) {
            string = new StringBuilder(14).append("CAST(").append(timeStampCol).append(" AS long)").toString();
        } else if (this.EPOCH_MILLIS().equalsIgnoreCase(timeStampFormat)) {
            string = new StringBuilder(33).append("CAST((CAST(").append(timeStampCol).append(" AS long) / ").append(this.MILLIS_IN_SECOND()).append(") AS long)").toString();
        } else {
            new SimpleDateFormat(timeStampFormat);
            String timestampTimeZone = (String)timeZone.getOrElse((Function0 & Serializable & scala.Serializable)() -> OfflineDateTimeUtils$.MODULE$.DEFAULT_TIMEZONE());
            String parsedTimeZone = ZoneId.of(timestampTimeZone).toString();
            string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(283).append("to_unix_timestamp(\n         |  concat(\n         |    date_format(\n         |      to_utc_timestamp(\n         |        to_timestamp(").append(timeStampCol).append(", \"").append(timeStampFormat).append("\"),\n         |        \"").append(parsedTimeZone).append("\"\n         |      ),\n         |      \"").append(this.TIMESTAMP_WITHOUT_TIMEZONE_FORMAT()).append("\"\n         |    ),\n         |    \"").append(this.UTC_TIMEZONE_OFFSET()).append("\"\n         |  ),\n         |  \"").append(this.TIMESTAMP_WITH_TIMEZONE_FORMAT()).append("\"\n         |)\n         |").toString())).stripMargin();
        }
        return string;
    }

    public Option<String> constructTimeStampExpr$default$3() {
        return None$.MODULE$;
    }

    public UserDefinedFunction mightContain(BloomFilter bf) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Com_linkedin_feathr_offline_swa_SlidingWindowFeatureUtils$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Com_linkedin_feathr_offline_swa_SlidingWindowFeatureUtils$$typecreator1$1() {
            }
        }
        return functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)SlidingWindowFeatureUtils$.$anonfun$mightContain$1(bf, x)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Boolean(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Com_linkedin_feathr_offline_swa_SlidingWindowFeatureUtils$$typecreator1$1()));
    }

    public FeatureDataFrame convertSWADFToFDS(Dataset<Row> swaRAWDf, Set<String> allSWAFeatures, Map<String, Enumeration.Value> featureNamesToColumnFormat, Map<String, FeatureTypeConfig> featureTypeConfigs) {
        Map featureColNameToFeatureNameAndType = ((TraversableOnce)allSWAFeatures.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string;
            String colName = string = x0$1;
            DataType colType = swaRAWDf.schema().fields()[swaRAWDf.schema().fieldIndex(colName)].dataType();
            FeatureTypeConfig featureTypeConfig = (FeatureTypeConfig)featureTypeConfigs.getOrElse((Object)string, (Function0 & Serializable & scala.Serializable)() -> FeatureTypeConfig.UNDEFINED_TYPE_CONFIG);
            FeatureTypes featureTypes = featureTypeConfig.getFeatureType();
            FeatureTypes featureTypes2 = FeatureTypes.UNSPECIFIED;
            FeatureTypeConfig withInferredFeatureTypeConfig = !(featureTypes != null ? !((Object)((Object)featureTypes)).equals((Object)featureTypes2) : featureTypes2 != null) ? new FeatureTypeConfig(FeaturizedDatasetUtils$.MODULE$.inferFeatureTypeFromColumnDataType(colType)) : featureTypeConfig;
            Tuple2 tuple2 = new Tuple2((Object)colName, (Object)new Tuple2((Object)string, (Object)withInferredFeatureTypeConfig));
            return tuple2;
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Dataset convertedDF = (Dataset)featureColNameToFeatureNameAndType.groupBy((Function1 & Serializable & scala.Serializable)pair -> (Enumeration.Value)featureNamesToColumnFormat.apply(pair._1())).foldLeft(swaRAWDf, (Function2 & Serializable & scala.Serializable)(inputDF, featureColNameToFeatureNameAndTypeWithFormat) -> {
            Dataset<Row> dataset;
            Enumeration.Value value = (Enumeration.Value)featureColNameToFeatureNameAndTypeWithFormat._1();
            Enumeration.Value value2 = FeatureColumnFormat$.MODULE$.FDS_TENSOR();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                dataset = inputDF;
            } else {
                Enumeration.Value value4 = FeatureColumnFormat$.MODULE$.RAW();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    Dataset<Row> convertedDF;
                    dataset = convertedDF = FeaturizedDatasetUtils$.MODULE$.convertRawDFtoQuinceFDS((Dataset<Row>)inputDF, (Map<String, Tuple2<String, FeatureTypeConfig>>)featureColNameToFeatureNameAndType);
                } else {
                    throw new MatchError((Object)value);
                }
            }
            Dataset<Row> fdsDF = dataset;
            return fdsDF;
        });
        Map inferredFeatureTypes = (Map)featureColNameToFeatureNameAndType.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$2;
            if (tuple22 == null || (tuple2 = (Tuple2)tuple22._2()) == null) {
                throw new MatchError((Object)tuple22);
            }
            String featureName = (String)tuple2._1();
            FeatureTypeConfig featureType = (FeatureTypeConfig)tuple2._2();
            Tuple2 tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)featureName), (Object)featureType);
            return tuple23;
        }, Map$.MODULE$.canBuildFrom());
        return new FeatureDataFrame((Dataset<Row>)convertedDF, (Map<String, FeatureTypeConfig>)inferredFeatureTypes);
    }

    public TimeWindowParams getTimeWindowParam(DataSource source) {
        return (TimeWindowParams)source.timeWindowParams().getOrElse((Function0 & Serializable & scala.Serializable)() -> new TimeWindowParams(MODULE$.TIMESTAMP_PARTITION_COLUMN(), MODULE$.EPOCH()));
    }

    /*
     * WARNING - void declaration
     */
    public boolean needCreateTimestampColumnFromPartition(DataSource source) {
        void var2_2;
        boolean needCreateTimestampColumn = source.timeWindowParams().isEmpty();
        if (needCreateTimestampColumn && source.timePartitionPattern().isEmpty()) {
            throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(115).append("The source ").append(source.path()).append(" is used in sliding window aggregation, but neither timeWindowParams or timePartitionPattern is defined.").toString());
        }
        return (boolean)var2_2;
    }

    public Seq<Map<FeatureAnchorWithSource, Dataset<Row>>> getSWAAnchorGroups(Map<FeatureAnchorWithSource, Dataset<Row>> windowAggAnchorDFThisStage) {
        return windowAggAnchorDFThisStage.groupBy((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            FeatureAnchorWithSource anchor = (FeatureAnchorWithSource)tuple2._1();
            if (anchor == null) throw new MatchError((Object)tuple2);
            FeatureAnchorWithSource featureAnchorWithSource = anchor;
            boolean bl = PreprocessedDataFrameManager$.MODULE$.preprocessedDfMap().nonEmpty();
            if (bl) {
                string = PreprocessedDataFrameManager$.MODULE$.getPreprocessingUniquenessForAnchor(featureAnchorWithSource);
            } else {
                if (false != bl) throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                string = "";
            }
            String featureNames = string;
            return new Tuple4((Object)featureAnchorWithSource.featureAnchor().sourceKeyExtractor().toString(), (Object)featureNames, featureAnchorWithSource.featureAnchor().lateralViewParams(), (Object)featureAnchorWithSource.source());
        }).values().toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$mightContain$1(BloomFilter bf$1, String x) {
        return x != null ? bf$1.mightContain((Object)x) : false;
    }

    private SlidingWindowFeatureUtils$() {
        MODULE$ = this;
        this.log = Logger.getLogger(this.getClass());
        this.EPOCH = "epoch";
        this.EPOCH_MILLIS = "epoch_millis";
        this.MILLIS_IN_SECOND = 1000;
        this.TIMESTAMP_WITHOUT_TIMEZONE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
        this.TIMESTAMP_WITH_TIMEZONE_FORMAT = new StringBuilder(1).append(this.TIMESTAMP_WITHOUT_TIMEZONE_FORMAT()).append("Z").toString();
        this.UTC_TIMEZONE_OFFSET = "-0000";
        this.DEFAULT_TIME_DELAY = "Default-time-delay";
        this.TIMESTAMP_PARTITION_COLUMN = "__feathr_timestamp_column_from_partition";
    }
}

