/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.testfwk;

import com.linkedin.feathr.offline.source.DataSource;
import com.linkedin.feathr.offline.source.SourceFormatType$;
import com.linkedin.feathr.offline.testfwk.SourceMockParam;
import com.linkedin.feathr.offline.util.AclCheckUtils$;
import com.linkedin.feathr.offline.util.IncrementalAggUtils$;
import com.linkedin.feathr.offline.util.LocalFeatureJoinUtils$;
import com.linkedin.feathr.offline.util.SourceUtils$;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class TestFwkUtils$ {
    public static TestFwkUtils$ MODULE$;
    private final Configuration conf;
    private final String EMPTY_STRING;
    private final String DATE_PARTITION;
    private final String LOCATION;
    private final String EXCEPTION;
    private final String SOURCES;
    private final String PATH;
    private final String HDFS_PATH;
    private final String AVRO_SCHEMA;
    private final String JSON_DATA;
    private final String DATA;
    private final String EXPECT_OUTPUT;
    private final String FEATURE_DEF;
    private final String DESCRIPTION;
    private final String JOIN_CONFIG;
    private final String JOB_PARAMETER;
    private final String PASSTHROUGH;
    private boolean IS_DEBUGGER_ENABLED;
    private int DERIVED_FEATURE_COUNTER;
    private final String NULLABLE_SUFFIX;
    private final String FIELD;
    private final String FEATURE;
    private final String SAVETO;
    private final String FIELD_SEPARATOR;

    static {
        new TestFwkUtils$();
    }

    private Configuration conf() {
        return this.conf;
    }

    public String EMPTY_STRING() {
        return this.EMPTY_STRING;
    }

    public String DATE_PARTITION() {
        return this.DATE_PARTITION;
    }

    public String LOCATION() {
        return this.LOCATION;
    }

    public String EXCEPTION() {
        return this.EXCEPTION;
    }

    public String SOURCES() {
        return this.SOURCES;
    }

    public String PATH() {
        return this.PATH;
    }

    public String HDFS_PATH() {
        return this.HDFS_PATH;
    }

    public String AVRO_SCHEMA() {
        return this.AVRO_SCHEMA;
    }

    public String JSON_DATA() {
        return this.JSON_DATA;
    }

    public String DATA() {
        return this.DATA;
    }

    public String EXPECT_OUTPUT() {
        return this.EXPECT_OUTPUT;
    }

    public String FEATURE_DEF() {
        return this.FEATURE_DEF;
    }

    public String DESCRIPTION() {
        return this.DESCRIPTION;
    }

    public String JOIN_CONFIG() {
        return this.JOIN_CONFIG;
    }

    public String JOB_PARAMETER() {
        return this.JOB_PARAMETER;
    }

    public String PASSTHROUGH() {
        return this.PASSTHROUGH;
    }

    public boolean IS_DEBUGGER_ENABLED() {
        return this.IS_DEBUGGER_ENABLED;
    }

    public void IS_DEBUGGER_ENABLED_$eq(boolean x$1) {
        this.IS_DEBUGGER_ENABLED = x$1;
    }

    public int DERIVED_FEATURE_COUNTER() {
        return this.DERIVED_FEATURE_COUNTER;
    }

    public void DERIVED_FEATURE_COUNTER_$eq(int x$1) {
        this.DERIVED_FEATURE_COUNTER = x$1;
    }

    private String rewriteTimePath(String path, Option<String> mockDataBaseDir) {
        String string;
        if (path.contains(AclCheckUtils$.MODULE$.LATEST_PATTERN())) {
            String targetPath = LocalFeatureJoinUtils$.MODULE$.getMockPath(path.replaceAll(AclCheckUtils$.MODULE$.LATEST_PATTERN(), ""), mockDataBaseDir);
            if (!Files.exists(Paths.get(targetPath, new String[0]), new LinkOption[0]) || !Files.isDirectory(Paths.get(targetPath, new String[0]), new LinkOption[0])) {
                int occurrence = AclCheckUtils$.MODULE$.countOccurrences(path, AclCheckUtils$.MODULE$.LATEST_PATTERN());
                DateTime localDate = new DateTime();
                int n = occurrence;
                switch (n) {
                    case 0: {
                        string = path;
                        break;
                    }
                    case 1: {
                        DateTimeFormatter dtfOut = DateTimeFormat.forPattern((String)"yyyyMMdd");
                        String latestDateTimeString = new StringBuilder(1).append("/").append(dtfOut.print((ReadablePartial)localDate.toLocalDate())).toString();
                        string = path.replace(AclCheckUtils$.MODULE$.LATEST_PATTERN(), latestDateTimeString);
                        break;
                    }
                    case 3: {
                        DateTimeFormatter dtfOut = DateTimeFormat.forPattern((String)"yyyy/MM/dd");
                        String latestDateTimeString = new StringBuilder(1).append("/").append(dtfOut.print((ReadablePartial)localDate.toLocalDate())).toString();
                        String pattern = new StringBuilder(3).append("/").append(AclCheckUtils$.MODULE$.LATEST_PATTERN()).append("/").append(AclCheckUtils$.MODULE$.LATEST_PATTERN()).append("/").append(AclCheckUtils$.MODULE$.LATEST_PATTERN()).toString();
                        string = path.replace(pattern, latestDateTimeString);
                        break;
                    }
                    default: {
                        throw new RuntimeException(new StringBuilder(20).append("cannot rewrite path ").append(path).toString());
                    }
                }
            } else {
                Seq<String> subPaths = IncrementalAggUtils$.MODULE$.getSubfolderPaths(targetPath, IncrementalAggUtils$.MODULE$.getSubfolderPaths$default$2(), IncrementalAggUtils$.MODULE$.getSubfolderPaths$default$3());
                if (subPaths.nonEmpty()) {
                    string = LocalFeatureJoinUtils$.MODULE$.getOriginalFromMockPath(targetPath, mockDataBaseDir);
                } else {
                    if (new StringOps(Predef$.MODULE$.augmentString(path)).stripSuffix("/").endsWith("/daily")) {
                        throw new RuntimeException(new StringBuilder(59).append("Seems folder ").append(targetPath).append(" is incomplete, please delete it and try again").toString());
                    }
                    string = path;
                }
            }
        } else {
            string = path;
        }
        return string;
    }

    private Option<Interval> getMockDataTimeInterval(Enumeration.Value sourceType, DateTime end) {
        None$ none$;
        Enumeration.Value value = sourceType;
        Enumeration.Value value2 = SourceFormatType$.MODULE$.TIME_SERIES_PATH();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            DateTime start = end.minusDays(1);
            Interval interval = new Interval((ReadableInstant)start, (ReadableInstant)end);
            none$ = new Some((Object)interval);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public SourceMockParam createMockParam(DataSource source, DateTime date, Option<String> mockDataBaseDir) {
        String rewritePath = this.rewriteTimePath(source.path(), mockDataBaseDir);
        Option mockBasePath = mockDataBaseDir.map((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(1).append((String)x$1).append("/").toString());
        String mockPath = LocalFeatureJoinUtils$.MODULE$.getMockPath(rewritePath, (Option<String>)mockBasePath);
        Option<Interval> dateParamInterval = this.getMockDataTimeInterval(source.sourceType(), date);
        return new SourceMockParam(mockPath, dateParamInterval);
    }

    public DateTime createMockParam$default$2() {
        return new DateTime();
    }

    public Seq<String> getFileNamesInSubFolder(String basePath, Seq<String> includeSuffixList, Configuration conf) {
        FileSystem fs = FileSystem.get((Configuration)conf);
        Seq filesNames = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(new Path(basePath)))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isFile())))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getPath().getName(), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        Seq filteredFilenames = (Seq)filesNames.filter((Function1 & Serializable & scala.Serializable)dirName -> BoxesRunTime.boxToBoolean((boolean)TestFwkUtils$.$anonfun$getFileNamesInSubFolder$3(includeSuffixList, dirName)));
        return filteredFilenames;
    }

    public Seq<String> getFileNamesInSubFolder$default$2() {
        return Nil$.MODULE$;
    }

    public Configuration getFileNamesInSubFolder$default$3() {
        return this.conf();
    }

    public Option<String> getFeathrConfFromFeatureRepo() {
        None$ none$;
        block3: {
            try {
                Seq featureMPDefConfigPaths = (Seq)this.getFileNamesInSubFolder(SourceUtils$.MODULE$.FEATURE_MP_DEF_CONFIG_BASE_PATH(), (Seq<String>)((Seq)new .colon.colon((Object)SourceUtils$.MODULE$.FEATURE_MP_DEF_CONFIG_SUFFIX(), (List)Nil$.MODULE$)), this.getFileNamesInSubFolder$default$3()).map((Function1 & Serializable & scala.Serializable)fileName -> new StringBuilder(1).append(SourceUtils$.MODULE$.FEATURE_MP_DEF_CONFIG_BASE_PATH()).append("/").append((String)fileName).toString(), Seq$.MODULE$.canBuildFrom());
                if (featureMPDefConfigPaths.nonEmpty()) {
                    none$ = new Some((Object)this.readLocalConfFileAsString(featureMPDefConfigPaths.mkString(",")));
                    break block3;
                }
                none$ = None$.MODULE$;
            }
            catch (Exception exception) {
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    public String readLocalConfFileAsString(String paths) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])paths.split(","))).map((Function1 & Serializable & scala.Serializable)path -> {
            void var2_2;
            BufferedSource bufferedSource = Source$.MODULE$.fromFile(path, Codec$.MODULE$.fallbackSystemCodec());
            String content = bufferedSource.mkString();
            bufferedSource.close();
            return var2_2;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("\n");
    }

    public String NULLABLE_SUFFIX() {
        return this.NULLABLE_SUFFIX;
    }

    public String FIELD() {
        return this.FIELD;
    }

    public String FEATURE() {
        return this.FEATURE;
    }

    public String SAVETO() {
        return this.SAVETO;
    }

    public String FIELD_SEPARATOR() {
        return this.FIELD_SEPARATOR;
    }

    public static final /* synthetic */ boolean $anonfun$getFileNamesInSubFolder$3(Seq includeSuffixList$1, String dirName) {
        return includeSuffixList$1.isEmpty() || includeSuffixList$1.exists((Function1 & Serializable & scala.Serializable)suffix -> BoxesRunTime.boxToBoolean((boolean)dirName.endsWith(suffix)));
    }

    private TestFwkUtils$() {
        MODULE$ = this;
        this.conf = new Configuration();
        this.EMPTY_STRING = "";
        this.DATE_PARTITION = "datePartition";
        this.LOCATION = "location";
        this.EXCEPTION = "exception";
        this.SOURCES = "sources";
        this.PATH = "path";
        this.HDFS_PATH = "hdfsPath";
        this.AVRO_SCHEMA = "avroSchema";
        this.JSON_DATA = "jsonData";
        this.DATA = "data";
        this.EXPECT_OUTPUT = "expectOutput";
        this.FEATURE_DEF = "featureDef";
        this.DESCRIPTION = "description";
        this.JOIN_CONFIG = "joinConfig";
        this.JOB_PARAMETER = "jobParameter";
        this.PASSTHROUGH = "PASSTHROUGH";
        this.IS_DEBUGGER_ENABLED = false;
        this.DERIVED_FEATURE_COUNTER = 10;
        this.NULLABLE_SUFFIX = "*";
        this.FIELD = "field";
        this.FEATURE = "feature";
        this.SAVETO = "saveTo";
        this.FIELD_SEPARATOR = ":";
    }
}

