/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.transformation;

import com.linkedin.feathr.common.DateParam;
import com.linkedin.feathr.common.FeatureTypeConfig;
import com.linkedin.feathr.common.package$;
import com.linkedin.feathr.offline.anchored.anchorExtractor.TimeWindowConfigurableAnchorExtractor;
import com.linkedin.feathr.offline.anchored.feature.FeatureAnchorWithSource;
import com.linkedin.feathr.offline.job.TransformedResult;
import com.linkedin.feathr.offline.source.TimeWindowParams;
import com.linkedin.feathr.offline.swa.SlidingWindowFeatureUtils$;
import com.linkedin.feathr.offline.testfwk.TestFwkUtils$;
import com.linkedin.feathr.offline.transformation.FeatureColumnFormat$;
import com.linkedin.feathr.offline.util.datetime.DateTimeInterval;
import com.linkedin.feathr.offline.util.datetime.OfflineDateTimeUtils$;
import java.io.Serializable;
import java.time.ZonedDateTime;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;

public final class WindowAggregationEvaluator$ {
    public static WindowAggregationEvaluator$ MODULE$;

    static {
        new WindowAggregationEvaluator$();
    }

    public TransformedResult transform(TimeWindowConfigurableAnchorExtractor transformer, Dataset<Row> inputDf, Seq<Tuple2<String, String>> requestedFeatureNameAndPrefix, FeatureAnchorWithSource featureAnchorWithSource, Option<DateTimeInterval> inputDateInterval) {
        Dataset dataset;
        Seq requestedFeatureNames = (Seq)requestedFeatureNameAndPrefix.map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1._1(), Seq$.MODULE$.canBuildFrom());
        transformer.setInternalParams(package$.MODULE$.SELECTED_FEATURES(), new StringBuilder(2).append("[").append(requestedFeatureNames.mkString(",")).append("]").toString());
        TimeWindowParams timeWindowParams = SlidingWindowFeatureUtils$.MODULE$.getTimeWindowParam(featureAnchorWithSource.source());
        String timestampCol = timeWindowParams.timestampColumn();
        String timestampFormat = timeWindowParams.timestampColumnFormat();
        String timestampColExpr = SlidingWindowFeatureUtils$.MODULE$.constructTimeStampExpr(timestampCol, timestampFormat, SlidingWindowFeatureUtils$.MODULE$.constructTimeStampExpr$default$3());
        Seq<String> keyAlias = featureAnchorWithSource.featureAnchor().sourceKeyExtractor().getKeyColumnAlias((Option<Object>)None$.MODULE$);
        Option<DateParam> defaultTimeParams = featureAnchorWithSource.dateParam();
        Option intervalOpt = inputDateInterval.orElse((Function0 & Serializable & scala.Serializable)() -> defaultTimeParams.map((Function1 & Serializable & scala.Serializable)dateParam -> OfflineDateTimeUtils$.MODULE$.createIntervalFromFeatureGenDateParam((DateParam)dateParam)));
        transformer.initParams(timestampCol, keyAlias);
        if (intervalOpt.isDefined()) {
            if (TestFwkUtils$.MODULE$.IS_DEBUGGER_ENABLED()) {
                String arg$macro$1 = "\u001b[32m";
                ZonedDateTime arg$macro$2 = ((DateTimeInterval)intervalOpt.get()).getStart();
                ZonedDateTime arg$macro$3 = ((DateTimeInterval)intervalOpt.get()).getEnd();
                String arg$macro$4 = "\u001b[0m";
                Predef$.MODULE$.println((Object)new StringOps("%sDefined window is from {%s} to %s%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2, arg$macro$3, arg$macro$4})));
            }
            DateTimeInterval interval = (DateTimeInterval)intervalOpt.get();
            long epocStart = interval.getStart().toInstant().getEpochSecond();
            long epocEnd = interval.getEnd().toInstant().getEpochSecond();
            String TIMESTAMP_COLUMN_NAME = "_feathr_swa_timestamp_col";
            dataset = inputDf.withColumn(TIMESTAMP_COLUMN_NAME, functions$.MODULE$.expr(timestampColExpr)).where(functions$.MODULE$.expr(new StringBuilder(12).append(TIMESTAMP_COLUMN_NAME).append(" >= ").append(epocStart).append(" and ").append(TIMESTAMP_COLUMN_NAME).append(" < ").append(epocEnd).toString()));
        } else {
            dataset = inputDf;
        }
        Dataset filteredDF = dataset;
        Seq<Tuple2<String, Column>> transformedColumns = transformer.transformAsColumns(filteredDF);
        Dataset transformedDF = (Dataset)transformedColumns.foldLeft(filteredDF, (Function2 & Serializable & scala.Serializable)(baseDF, columnWithName) -> baseDF.withColumn((String)columnWithName._1(), (Column)columnWithName._2()));
        if (TestFwkUtils$.MODULE$.IS_DEBUGGER_ENABLED()) {
            String arg$macro$5 = "\u001b[32m";
            String arg$macro$6 = "\u001b[0m";
            Predef$.MODULE$.println((Object)new StringOps("%sShowing the dataset in the window: %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$5, arg$macro$6})));
            if (transformedDF.isEmpty()) {
                String arg$macro$7 = "\u001b[31m";
                String arg$macro$8 = "\u001b[0m";
                Predef$.MODULE$.println((Object)new StringOps("%sThere doesnt seem to have any data in the window you defined. Please check your window configurations.%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$7, arg$macro$8})));
            }
            transformedDF.show(10);
        }
        return new TransformedResult(requestedFeatureNameAndPrefix, (Dataset<Row>)transformedDF, (Map<String, Enumeration.Value>)((TraversableOnce)requestedFeatureNames.map((Function1 & Serializable & scala.Serializable)c -> new Tuple2(c, (Object)FeatureColumnFormat$.MODULE$.RAW()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()), (Map<String, FeatureTypeConfig>)Predef$.MODULE$.Map().empty());
    }

    private WindowAggregationEvaluator$() {
        MODULE$ = this;
    }
}

