/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.util;

import com.databricks.spark.avro.SchemaConverterUtils$;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jasonclawson.jackson.dataformat.hocon.HoconFactory;
import com.linkedin.feathr.common.AnchorExtractor;
import com.linkedin.feathr.common.DateParam;
import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrConfigException;
import com.linkedin.feathr.common.exception.FeathrDataOutputException;
import com.linkedin.feathr.common.exception.FeathrException;
import com.linkedin.feathr.common.exception.FeathrInputDataException;
import com.linkedin.feathr.offline.client.InputData;
import com.linkedin.feathr.offline.config.location.DataLocation;
import com.linkedin.feathr.offline.config.location.SimplePath;
import com.linkedin.feathr.offline.generation.SparkIOUtils$;
import com.linkedin.feathr.offline.mvel.MvelContext;
import com.linkedin.feathr.offline.mvel.MvelUtils$;
import com.linkedin.feathr.offline.mvel.plugins.FeathrExpressionExecutionContext;
import com.linkedin.feathr.offline.source.SourceFormatType$;
import com.linkedin.feathr.offline.source.dataloader.DataLoaderHandler;
import com.linkedin.feathr.offline.source.dataloader.hdfs.FileFormat$;
import com.linkedin.feathr.offline.source.dataloader.jdbc.JdbcUtils$;
import com.linkedin.feathr.offline.source.dataloader.jdbc.SnowflakeUtils$;
import com.linkedin.feathr.offline.source.pathutil.PathChecker;
import com.linkedin.feathr.offline.source.pathutil.PathChecker$;
import com.linkedin.feathr.offline.source.pathutil.PathInfo;
import com.linkedin.feathr.offline.source.pathutil.TimeBasedHdfsPathAnalyzer;
import com.linkedin.feathr.offline.source.pathutil.TimeBasedHdfsPathGenerator;
import com.linkedin.feathr.offline.util.AclCheckUtils$;
import com.linkedin.feathr.offline.util.DelimiterUtils$;
import com.linkedin.feathr.offline.util.HdfsUtils$;
import com.linkedin.feathr.offline.util.LocalFeatureJoinUtils$;
import com.linkedin.feathr.offline.util.PartitionLimiter;
import com.linkedin.feathr.offline.util.datetime.OfflineDateTimeUtils$;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.JsonDecoder;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.avro.mapreduce.AvroKeyOutputFormat;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.partial.BoundedDouble;
import org.apache.spark.partial.PartialResult;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.avro.SchemaConverters$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.Hours;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichInt$;
import scala.util.Try;
import scala.util.Try$;

public final class SourceUtils$ {
    public static SourceUtils$ MODULE$;
    private final String HDFS_PREFIX;
    private final Configuration conf;
    private final Logger log;
    private final String FEATURE_MP_DEF_CONFIG_BASE_PATH;
    private final String FEATURE_MP_DEF_CONFIG_SUFFIX;
    private final String firstRecordName;

    static {
        new SourceUtils$();
    }

    public String HDFS_PREFIX() {
        return this.HDFS_PREFIX;
    }

    private final Configuration conf() {
        return this.conf;
    }

    private Logger log() {
        return this.log;
    }

    public String FEATURE_MP_DEF_CONFIG_BASE_PATH() {
        return this.FEATURE_MP_DEF_CONFIG_BASE_PATH;
    }

    public String FEATURE_MP_DEF_CONFIG_SUFFIX() {
        return this.FEATURE_MP_DEF_CONFIG_SUFFIX;
    }

    public String firstRecordName() {
        return this.firstRecordName;
    }

    /*
     * WARNING - void declaration
     */
    public Class<?> getExpectDatumType(Seq<Object> transformers) {
        void var3_4;
        Class clazz;
        Seq expectedRecordTypes = (Seq)transformers.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Class<?> clazz;
                A1 A1 = x1;
                if (A1 instanceof AnchorExtractor) {
                    AnchorExtractor anchorExtractor = (AnchorExtractor)A1;
                    clazz = anchorExtractor.getInputType();
                } else {
                    clazz = function1.apply(x1);
                }
                return (B1)clazz;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof AnchorExtractor;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (expectedRecordTypes.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SourceUtils$.$anonfun$getExpectDatumType$1(x$1)))) {
            Seq expectedSpecificTypes = (Seq)((SeqLike)expectedRecordTypes.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SourceUtils$.$anonfun$getExpectDatumType$2(x$1)))).distinct();
            Predef$.MODULE$.assert(expectedSpecificTypes.nonEmpty());
            Predef$.MODULE$.require(expectedSpecificTypes.size() == 1, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(111).append("Can't determine which SpecificRecord subclass to use; ").append("transformers ").append(transformers).append(" seem to require more than one record type: ").append(expectedSpecificTypes).toString());
            clazz = (Class)expectedSpecificTypes.head();
        } else {
            clazz = expectedRecordTypes.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SourceUtils$.$anonfun$getExpectDatumType$4(x$1))) ? GenericRecord.class : Object.class;
        }
        Class expectDatumType = clazz;
        return var3_4;
    }

    public Seq<Object> getExpectDatumType$default$1() {
        return Nil$.MODULE$;
    }

    public Seq<String> getPathList(Enumeration.Value sourceFormatType, String sourcePath, SparkSession ss, Option<DateParam> dateParam, List<DataLoaderHandler> dataLoaderHandlers, Option<String> targetDate, boolean failOnMissing) {
        Seq<String> seq;
        Enumeration.Value value = sourceFormatType;
        Enumeration.Value value2 = SourceFormatType$.MODULE$.FIXED_PATH();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            seq = (Seq<String>)new .colon.colon((Object)HdfsUtils$.MODULE$.getLatestPath(sourcePath, ss.sparkContext().hadoopConfiguration()), (List)Nil$.MODULE$);
        } else {
            Enumeration.Value value4 = SourceFormatType$.MODULE$.TIME_PATH();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                PathChecker pathChecker = PathChecker$.MODULE$.apply(ss, dataLoaderHandlers);
                TimeBasedHdfsPathGenerator pathGenerator = new TimeBasedHdfsPathGenerator(pathChecker);
                TimeBasedHdfsPathAnalyzer pathAnalyzer = new TimeBasedHdfsPathAnalyzer(pathChecker, dataLoaderHandlers);
                PathInfo pathInfo = pathAnalyzer.analyze(sourcePath);
                seq = pathGenerator.generate(pathInfo, OfflineDateTimeUtils$.MODULE$.createTimeIntervalFromDateParam(dateParam, (Option<String>)None$.MODULE$, targetDate), !failOnMissing, pathGenerator.generate$default$4());
            } else {
                Enumeration.Value value6 = SourceFormatType$.MODULE$.LIST_PATH();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    seq = Predef$.MODULE$.wrapRefArray((Object[])sourcePath.split(";"));
                } else {
                    throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, "Trying to get source path list. sourceFormatType should be either FIXED_PATH or DAILY_PATH. Please provide the correct sourceFormatType.");
                }
            }
        }
        return seq;
    }

    public Option<String> getPathList$default$6() {
        return None$.MODULE$;
    }

    public boolean getPathList$default$7() {
        return true;
    }

    public Schema getSchemaOfDF(Dataset<Row> dataframe) {
        SchemaBuilder.RecordBuilder builder = (SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)this.firstRecordName()).namespace("");
        return (Schema)com.databricks.spark.avro.SchemaConverters$.MODULE$.convertStructToAvro(dataframe.schema(), builder, this.firstRecordName());
    }

    public <L> long estimateRDDRow(RDD<L> rdd, int timeout) {
        double estimateSize = 0.0;
        PartialResult estimateSizeInterval = rdd.countApprox((long)timeout, 0.8);
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(((BoundedDouble)estimateSizeInterval.initialValue()).low(), ((BoundedDouble)estimateSizeInterval.initialValue()).high());
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        double lowCnt = sp2._1$mcD$sp();
        double highCnt = sp2._2$mcD$sp();
        Tuple2.mcDD.sp sp3 = new Tuple2.mcDD.sp(lowCnt, highCnt);
        Tuple2.mcDD.sp sp4 = sp3;
        double lowCnt2 = sp4._1$mcD$sp();
        double highCnt2 = sp4._2$mcD$sp();
        estimateSize = (lowCnt2 + highCnt2) / 2.0;
        return (long)estimateSize;
    }

    public <L> int estimateRDDRow$default$2() {
        return 30000;
    }

    public Dataset<Row> convert(SparkSession ss, RDD<GenericRecord> rdd, Schema schema) {
        StructType sqlType = (StructType)SchemaConverters$.MODULE$.toSqlType(schema).dataType();
        Function1<Object, Object> converter = SchemaConverterUtils$.MODULE$.converterSql(schema, (DataType)sqlType);
        RDD rowRdd = rdd.flatMap((Function1 & Serializable & scala.Serializable)record -> Option$.MODULE$.option2Iterable(Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Row)converter.apply(record)).toOption()), ClassTag$.MODULE$.apply(Row.class));
        return ss.createDataFrame(rowRdd, sqlType);
    }

    public void safeWriteDF(Dataset<Row> df, String dataPath, scala.collection.immutable.Map<String, String> parameters, List<DataLoaderHandler> dataLoaderHandlers) {
        String tempBasePath = new StringBuilder(6).append(new StringOps(Predef$.MODULE$.augmentString(dataPath)).stripSuffix("/")).append("_temp_").toString();
        HdfsUtils$.MODULE$.deletePath(dataPath, true, HdfsUtils$.MODULE$.deletePath$default$3());
        SparkIOUtils$.MODULE$.writeDataFrame(df, new SimplePath(tempBasePath), parameters, dataLoaderHandlers);
        if (HdfsUtils$.MODULE$.exists(tempBasePath, HdfsUtils$.MODULE$.exists$default$2()) && !HdfsUtils$.MODULE$.renamePath(tempBasePath, dataPath, HdfsUtils$.MODULE$.renamePath$default$3())) {
            throw new FeathrDataOutputException(ErrorLabel.FEATHR_ERROR, new StringBuilder(117).append("Trying to rename temp path to target path in safeWrite.").append("Rename ").append(tempBasePath).append(" to ").append(dataPath).append(" failed").append("This is likely a system error. Please retry.").toString());
        }
    }

    public void safeWriteRDD(SparkSession ss, Schema outputSchema, RDD<GenericRecord> rdd, String dataPath, Option<Number> numParts) {
        int parts = numParts.isDefined() ? ((Number)numParts.get()).intValue() : rdd.getNumPartitions();
        RDD avroOutput = new PartitionLimiter(ss).limitPartition(rdd, parts, parts).map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)new AvroKey(x), null), ClassTag$.MODULE$.apply(Tuple2.class));
        Job avroJobConf = Job.getInstance((Configuration)ss.sparkContext().hadoopConfiguration());
        AvroJob.setOutputKeySchema((Job)avroJobConf, (Schema)outputSchema);
        String tempBasePath = new StringBuilder(6).append(new StringOps(Predef$.MODULE$.augmentString(dataPath)).stripSuffix("/")).append("_temp_").toString();
        HdfsUtils$.MODULE$.deletePath(dataPath, true, HdfsUtils$.MODULE$.deletePath$default$3());
        RDD x$1 = avroOutput;
        ClassTag x$2 = ClassTag$.MODULE$.apply(AvroKey.class);
        ClassTag x$3 = ClassTag$.MODULE$.Null();
        Null$ x$4 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$1);
        RDD$.MODULE$.rddToPairRDDFunctions(x$1, x$2, x$3, null).saveAsNewAPIHadoopFile(tempBasePath, AvroKey.class, NullWritable.class, AvroKeyOutputFormat.class, avroJobConf.getConfiguration());
        if (HdfsUtils$.MODULE$.exists(tempBasePath, HdfsUtils$.MODULE$.exists$default$2()) && !HdfsUtils$.MODULE$.renamePath(tempBasePath, dataPath, HdfsUtils$.MODULE$.renamePath$default$3())) {
            throw new FeathrDataOutputException(ErrorLabel.FEATHR_ERROR, new StringBuilder(117).append("Trying to rename temp path to target path in safeWrite.").append("Rename ").append(tempBasePath).append(" to ").append(dataPath).append(" failed").append("This is likely a system error. Please retry.").toString());
        }
    }

    public Object getDefaultValueFromAvroRecord(Schema.Field field) {
        return field.defaultVal();
    }

    public Dataset<Row> getRegularAnchorDF(SparkSession ss, String factDataSourcePath, List<DataLoaderHandler> dataLoaderHandlers) {
        return ss.sparkContext().isLocal() ? this.getLocalDF(ss, factDataSourcePath, dataLoaderHandlers) : this.loadAsDataFrame(ss, new SimplePath(factDataSourcePath), dataLoaderHandlers);
    }

    public Dataset<Row> getLocalDF(SparkSession ss, String path, List<DataLoaderHandler> dataLoaderHandlers) {
        Dataset dataset;
        String format = FileFormat$.MODULE$.getType(path);
        String localPath = this.getLocalPath(path);
        String string = format;
        String string2 = FileFormat$.MODULE$.AVRO_JSON();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            dataset = (Dataset)this.loadJsonFileAsAvroToDF(ss, localPath).get();
        } else {
            String string4 = FileFormat$.MODULE$.JDBC();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                dataset = JdbcUtils$.MODULE$.loadDataFrame(ss, path);
            } else {
                Dataset dataset2;
                Option<String> option = this.getLocalMockDataPath(ss, path);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String mockData = (String)some.value();
                    dataset2 = (Dataset)this.loadSeparateJsonFileAsAvroToDF(ss, mockData).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                        throw new FeathrException(ErrorLabel.FEATHR_ERROR, new StringBuilder(27).append("Cannot load mock data path ").append(mockData).toString());
                    });
                } else if (None$.MODULE$.equals(option)) {
                    dataset2 = this.loadAsDataFrame(ss, new SimplePath(localPath), dataLoaderHandlers);
                } else {
                    throw new MatchError(option);
                }
                dataset = dataset2;
            }
        }
        return dataset;
    }

    public Option<String> getLocalMockDataPath(SparkSession ss, String sourcePath) {
        if (!ss.sparkContext().isLocal()) {
            return None$.MODULE$;
        }
        String mockSourcePath = LocalFeatureJoinUtils$.MODULE$.getMockPath(sourcePath, LocalFeatureJoinUtils$.MODULE$.getMockPath$default$2());
        Path path = new Path(mockSourcePath);
        Configuration hadoopConf = ss.sparkContext().hadoopConfiguration();
        FileSystem fs = path.getFileSystem(hadoopConf);
        String mockSourcePathWithLatest = AclCheckUtils$.MODULE$.getLatestPath(fs, mockSourcePath);
        return new Some((Object)mockSourcePathWithLatest).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)HdfsUtils$.MODULE$.exists(x$2, HdfsUtils$.MODULE$.exists$default$2())));
    }

    public Dataset<Row> getWindowAggAnchorDF(SparkSession ss, String factDataSourcePath, LocalDateTime obsDataStartTime, LocalDateTime obsDataEndTime, Duration window, scala.collection.immutable.Map<String, Duration> timeDelayMapOpt, List<DataLoaderHandler> dataLoaderHandlers) {
        Dataset<Row> dataset;
        SparkConf sparkConf = ss.sparkContext().getConf();
        String inputSplitSize = sparkConf.get("spark.feathr.input.split.size", "");
        scala.collection.immutable.Map dataIOParameters = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SparkIOUtils$.MODULE$.SPLIT_SIZE()), (Object)inputSplitSize)}));
        String fileName = new File(factDataSourcePath).getName();
        if (fileName.endsWith("daily") || fileName.endsWith("hourly")) {
            boolean isDaily = fileName.endsWith("daily");
            Tuple2<LocalDateTime, LocalDateTime> tuple2 = this.getFactDataTimeRange(obsDataStartTime, obsDataEndTime, window, isDaily, timeDelayMapOpt);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            LocalDateTime factDataStartTime = (LocalDateTime)tuple2._1();
            LocalDateTime factDataEndTime = (LocalDateTime)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)factDataStartTime, (Object)factDataEndTime);
            Tuple2 tuple23 = tuple22;
            LocalDateTime factDataStartTime2 = (LocalDateTime)tuple23._1();
            LocalDateTime factDataEndTime2 = (LocalDateTime)tuple23._2();
            Seq<String> hdfsPaths = isDaily ? HdfsUtils$.MODULE$.getPaths(factDataSourcePath, factDataStartTime2, factDataEndTime2.plusDays(1L), ChronoUnit.DAYS) : HdfsUtils$.MODULE$.getPaths(factDataSourcePath, factDataStartTime2, factDataEndTime2.plusHours(1L), ChronoUnit.HOURS);
            Seq existingHdfsPaths = (Seq)hdfsPaths.filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)HdfsUtils$.MODULE$.exists(x$4, HdfsUtils$.MODULE$.exists$default$2())));
            if (existingHdfsPaths.isEmpty()) {
                throw new FeathrInputDataException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(163).append("Trying to load feature data in HDFS. No available date partition exist in HDFS for path. ").append(factDataSourcePath).append(" between ").append(factDataStartTime2).append(" and ").append(factDataEndTime2).append(". Please make sure there is needed ").append("data for that time range.").toString());
            }
            this.log().info((Object)new StringBuilder(87).append("Loading HDFS path ").append(existingHdfsPaths).append(" as union DataFrame for sliding window aggregation, using parameters ").append(dataIOParameters).toString());
            dataset = SparkIOUtils$.MODULE$.createUnionDataFrame((Seq<String>)existingHdfsPaths, (scala.collection.immutable.Map<String, String>)dataIOParameters, new JobConf(), dataLoaderHandlers);
        } else {
            this.log().info((Object)new StringBuilder(81).append("Loading HDFS path ").append(factDataSourcePath).append(" as DataFrame for sliding window aggregation, using parameters ").append(dataIOParameters).toString());
            dataset = SparkIOUtils$.MODULE$.createDataFrame(new SimplePath(factDataSourcePath), (scala.collection.immutable.Map<String, String>)dataIOParameters, new JobConf(), dataLoaderHandlers);
        }
        return dataset;
    }

    public Tuple2<LocalDateTime, LocalDateTime> getFactDataTimeRange(LocalDateTime obsDataStartTime, LocalDateTime obsDataEndTime, Duration window, boolean isDaily, scala.collection.immutable.Map<String, Duration> timeDelayMap) {
        Tuple2 tuple2;
        Duration duration;
        Duration duration2;
        int n = timeDelayMap.values().size();
        switch (n) {
            case 0: {
                duration2 = Duration.ZERO;
                break;
            }
            default: {
                duration2 = (Duration)timeDelayMap.values().min(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
                break;
            }
        }
        Duration minTimeDelay = duration2;
        int n2 = timeDelayMap.values().size();
        switch (n2) {
            case 0: {
                duration = Duration.ZERO;
                break;
            }
            default: {
                duration = (Duration)timeDelayMap.values().max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
                break;
            }
        }
        Duration maxTimeDelay = duration;
        if (isDaily) {
            LocalDateTime start = obsDataStartTime.minus(window).minus(maxTimeDelay).truncatedTo(ChronoUnit.DAYS);
            LocalDateTime end = obsDataEndTime.minus(minTimeDelay).truncatedTo(ChronoUnit.DAYS);
            tuple2 = new Tuple2((Object)start, (Object)end);
        } else {
            LocalDateTime start = obsDataStartTime.minus(window).minus(maxTimeDelay).truncatedTo(ChronoUnit.HOURS);
            LocalDateTime end = obsDataEndTime.minus(minTimeDelay).truncatedTo(ChronoUnit.HOURS);
            tuple2 = new Tuple2((Object)start, (Object)end);
        }
        return tuple2;
    }

    private Function1<Object, scala.collection.immutable.Map<String, Object>> extractorForFieldNames(Seq<String> allFields, Option<FeathrExpressionExecutionContext> mvelContext) {
        scala.collection.immutable.Map compiledExpressionMap = ((TraversableOnce)allFields.map((Function1 & Serializable & scala.Serializable)fieldName -> new Tuple2(fieldName, (Object)MVEL.compileExpression((String)fieldName, (ParserContext)MvelContext.newParserContext())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return (Function1 & Serializable & scala.Serializable)record -> ((scala.collection.immutable.Map)compiledExpressionMap.mapValues((Function1 & Serializable & scala.Serializable)expression -> {
            MvelContext.ensureInitialized();
            return MvelUtils$.MODULE$.executeExpression(expression, record, null, "", mvelContext);
        }).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<String, Option<Object>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    String name = (String)A1._1();
                    Option option = (Option)A1._2();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Object value = some.value();
                        object = new Tuple2((Object)name, value);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<String, Option<Object>> x1) {
                Option option;
                Tuple2<String, Option<Object>> tuple2 = x1;
                boolean bl = tuple2 != null && (option = (Option)tuple2._2()) instanceof Some;
                return bl;
            }
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Seq<String> generateHDFSTimeBasedPaths(String filePath, Interval timeInterval, boolean hourlyData, boolean skipMissingFiles) {
        String dailyFormat = "yyyy/MM/dd";
        String dailyHourlyFormat = "yyyy/MM/dd/HH";
        String dailyPartitionFormat = "yyyy-MM-dd-00";
        String dailyFilePath = filePath.endsWith("/") ? new StringBuilder(6).append(filePath).append("daily/").toString() : new StringBuilder(7).append(filePath).append("/daily/").toString();
        String hourlyFilePath = filePath.endsWith("/") ? new StringBuilder(7).append(filePath).append("hourly/").toString() : new StringBuilder(8).append(filePath).append("/hourly/").toString();
        String dailyPartitionFilePath = filePath.endsWith("/") ? new StringBuilder(14).append(filePath).append("datepartition=").toString() : new StringBuilder(15).append(filePath).append("/datepartition=").toString();
        int numDays = Days.daysBetween((ReadableInstant)timeInterval.getStart(), (ReadableInstant)timeInterval.getEnd()).getDays() + 1;
        int numHours = Hours.hoursBetween((ReadableInstant)timeInterval.getStart(), (ReadableInstant)timeInterval.getEnd()).getHours() + 1;
        Try fileSystem = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> FileSystem.get((Configuration)new Configuration()));
        IndexedSeq filePaths = hourlyData ? (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numHours).map((Function1 & Serializable & scala.Serializable)curHour -> SourceUtils$.$anonfun$generateHDFSTimeBasedPaths$2(hourlyFilePath, timeInterval, dailyHourlyFormat, BoxesRunTime.unboxToInt((Object)curHour)), IndexedSeq$.MODULE$.canBuildFrom()) : (((FileSystem)fileSystem.get()).exists(new Path(dailyFilePath)) || ((FileSystem)fileSystem.get()).exists(new Path(LocalFeatureJoinUtils$.MODULE$.getMockPath(dailyFilePath, LocalFeatureJoinUtils$.MODULE$.getMockPath$default$2()))) ? (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDays).map((Function1 & Serializable & scala.Serializable)curDays -> SourceUtils$.$anonfun$generateHDFSTimeBasedPaths$3(dailyFilePath, timeInterval, dailyFormat, BoxesRunTime.unboxToInt((Object)curDays)), IndexedSeq$.MODULE$.canBuildFrom()) : (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDays).map((Function1 & Serializable & scala.Serializable)curDays -> SourceUtils$.$anonfun$generateHDFSTimeBasedPaths$4(dailyPartitionFilePath, timeInterval, dailyPartitionFormat, BoxesRunTime.unboxToInt((Object)curDays)), IndexedSeq$.MODULE$.canBuildFrom()));
        IndexedSeq returnedPaths = skipMissingFiles && fileSystem.isSuccess() ? (IndexedSeq)filePaths.filter((Function1 & Serializable & scala.Serializable)curPath -> BoxesRunTime.boxToBoolean((boolean)SourceUtils$.$anonfun$generateHDFSTimeBasedPaths$5(fileSystem, curPath))) : filePaths;
        this.log().info((Object)new StringBuilder(52).append("generateHDFSTimeBasedPaths returned ").append(returnedPaths).append(" for input path ").append(filePath).toString());
        return returnedPaths;
    }

    public boolean generateHDFSTimeBasedPaths$default$3() {
        return false;
    }

    public boolean generateHDFSTimeBasedPaths$default$4() {
        return true;
    }

    public Date createTimeFromString(String dateString, String formatString, String tz) {
        SimpleDateFormat format = new SimpleDateFormat(formatString);
        format.setTimeZone(TimeZone.getTimeZone(tz));
        return format.parse(new StringOps(Predef$.MODULE$.augmentString(dateString)).stripMargin('/').replaceAll("//", "/"));
    }

    public String createTimeFromString$default$2() {
        return "yyyyMMdd";
    }

    public String createTimeFromString$default$3() {
        return "America/Los_Angeles";
    }

    public LocalDateTime createLocalTimeTimeFromString(String dateString, String formatString, String tz) {
        Date date = this.createTimeFromString(dateString, formatString, tz);
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.of(tz));
    }

    public String createLocalTimeTimeFromString$default$2() {
        return "yyyyMMdd";
    }

    public String createLocalTimeTimeFromString$default$3() {
        return "America/Los_Angeles";
    }

    public Interval createTimeInterval(Option<String> startDateOpt, Option<String> endDateOpt, String formatString, String tz) {
        String startDate;
        Option option;
        TimeZone timeZone;
        block5: {
            Tuple2 tuple2;
            block4: {
                timeZone = TimeZone.getTimeZone(tz);
                tuple2 = new Tuple2(startDateOpt, endDateOpt);
                if (tuple2 == null) break block4;
                Option option2 = (Option)tuple2._1();
                option = (Option)tuple2._2();
                if (!(option2 instanceof Some)) break block4;
                Some some = (Some)option2;
                startDate = (String)some.value();
                if (option instanceof Some) break block5;
            }
            if (tuple2 != null) {
                throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(125).append("Trying to create TimeInterval from a start time and end time with specified format. Date is not defined. ").append("Please provide date.").toString());
            }
            throw new MatchError((Object)tuple2);
        }
        Some some = (Some)option;
        String endDate = (String)some.value();
        long startTime = this.createTimeFromString(startDate, formatString, tz).getTime();
        long endTime = this.createTimeFromString(endDate, formatString, tz).getTime();
        Interval interval = new Interval(startTime, endTime, DateTimeZone.forTimeZone((TimeZone)timeZone));
        return interval;
    }

    public Interval createTimeIntervalFromDateParam(Option<DateParam> dateParam, Option<String> targetDate) {
        Option<DateParam> option = dateParam;
        if (!(option instanceof Some)) {
            throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, "Trying to create time Interval from DateParam. Date is not defined. Please provide date.");
        }
        Some some = (Some)option;
        DateParam dp = (DateParam)some.value();
        Interval interval = this.createTimeInterval(dp, targetDate);
        return interval;
    }

    public Tuple2<Object, Object> createTimestampsFromDateParam(Option<DateParam> dateParam, Option<String> targetDate) {
        Interval interval = this.createTimeIntervalFromDateParam(dateParam, targetDate);
        DateTime utcStart = interval.getStart().toDateTime(DateTimeZone.UTC);
        long epocStart = utcStart.getMillis() / 1000L;
        DateTime utcEnd = interval.getEnd().toDateTime(DateTimeZone.UTC);
        long epocEnd = utcEnd.getMillis() / 1000L;
        return new Tuple2.mcJJ.sp(epocStart, epocEnd);
    }

    public Option<String> createTimestampsFromDateParam$default$2() {
        return None$.MODULE$;
    }

    public Interval createTimeInterval(DateParam dateParam, Option<String> targetDate) {
        Interval interval;
        boolean relativeDateSet;
        boolean absoluteDateSet = dateParam.startDate().nonEmpty() && dateParam.endDate().nonEmpty();
        boolean bl = relativeDateSet = dateParam.numDays().nonEmpty() && dateParam.dateOffset().nonEmpty();
        if (absoluteDateSet && !relativeDateSet) {
            interval = this.createTimeInterval(dateParam.startDate(), dateParam.endDate(), this.createTimeInterval$default$3(), this.createTimeInterval$default$4());
        } else if (relativeDateSet && !absoluteDateSet) {
            int offset = new StringOps(Predef$.MODULE$.augmentString((String)dateParam.dateOffset().get())).toInt();
            int numdays = new StringOps(Predef$.MODULE$.augmentString((String)dateParam.numDays().get())).toInt();
            if (offset < 0) {
                throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(116).append("Trying to create a valid time interval. ").append("dateOffset(").append(offset).append(") should be non-negative. Please provide non-negative dateOffset.").toString());
            }
            if (numdays <= 0) {
                throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(102).append("Trying to create a valid time interval.").append("numdays(").append(numdays).append(") should be positive.").append("Please provide a positive numdays.").toString());
            }
            Calendar startDate = Calendar.getInstance();
            Calendar endDate = Calendar.getInstance();
            if (targetDate.isDefined()) {
                startDate.setTime(this.createTimeFromString((String)targetDate.get(), this.createTimeFromString$default$2(), this.createTimeFromString$default$3()));
                endDate.setTime(this.createTimeFromString((String)targetDate.get(), this.createTimeFromString$default$2(), this.createTimeFromString$default$3()));
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
            TimeZone tz = TimeZone.getTimeZone("America/Los_Angeles");
            format.setTimeZone(tz);
            startDate.add(5, -offset - numdays + 1);
            endDate.add(5, -offset);
            String startDateFromOffset = format.format(startDate.getTime());
            String endDateFromOffset = format.format(endDate.getTime());
            interval = this.createTimeInterval((Option<String>)new Some((Object)startDateFromOffset), (Option<String>)new Some((Object)endDateFromOffset), this.createTimeInterval$default$3(), this.createTimeInterval$default$4());
        } else {
            throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(224).append("Trying to create a valid time interval.").append("The provided format is incorrect: dateParam - ").append(dateParam).append(", targetDate - ").append(targetDate).append("Please either set both startDate and endDate, or both numDays and dateOffset. Other parameter combinations are not accepted.").toString());
        }
        return interval;
    }

    private Interval createTimeInterval(InputData inputData) {
        return this.createTimeIntervalFromDateParam(inputData.dateParam(), this.createTimeIntervalFromDateParam$default$2());
    }

    public String createTimeInterval$default$3() {
        return "yyyyMMdd";
    }

    public String createTimeInterval$default$4() {
        return "America/Los_Angeles";
    }

    public Option<String> createTimeIntervalFromDateParam$default$2() {
        return None$.MODULE$;
    }

    public Dataset<Row> loadAsUnionDataFrame(SparkSession ss, Seq<String> inputPath, List<DataLoaderHandler> dataLoaderHandlers) {
        SparkConf sparkConf = ss.sparkContext().getConf();
        String inputSplitSize = sparkConf.get("spark.feathr.input.split.size", "");
        scala.collection.immutable.Map dataIOParameters = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SparkIOUtils$.MODULE$.SPLIT_SIZE()), (Object)inputSplitSize)}));
        Configuration hadoopConf = ss.sparkContext().hadoopConfiguration();
        this.log().info((Object)new StringBuilder(46).append("Loading ").append(inputPath).append(" as union DataFrame, using parameters ").append(dataIOParameters).toString());
        return SparkIOUtils$.MODULE$.createUnionDataFrame(inputPath, (scala.collection.immutable.Map<String, String>)dataIOParameters, new JobConf(), dataLoaderHandlers);
    }

    public Dataset<Row> loadAsDataFrame(SparkSession ss, DataLocation location, List<DataLoaderHandler> dataLoaderHandlers) {
        SparkConf sparkConf = ss.sparkContext().getConf();
        String inputSplitSize = sparkConf.get("spark.feathr.input.split.size", "");
        scala.collection.immutable.Map dataIOParameters = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SparkIOUtils$.MODULE$.SPLIT_SIZE()), (Object)inputSplitSize)}));
        this.log().info((Object)new StringBuilder(40).append("Loading ").append(location).append(" as DataFrame, using parameters ").append(dataIOParameters).toString());
        return SparkIOUtils$.MODULE$.createDataFrame(location, (scala.collection.immutable.Map<String, String>)dataIOParameters, new JobConf(), dataLoaderHandlers);
    }

    public Dataset<Row> loadObservationAsDF(SparkSession ss, Configuration conf, InputData inputData, List<DataLoaderHandler> dataLoaderHandlers, boolean failOnMissing) {
        Object object;
        String format = FileFormat$.MODULE$.getType(inputData.inputPath());
        this.log().info((Object)new StringBuilder(31).append("loading ").append(inputData.inputPath()).append(" input Path as Format: ").append(format).toString());
        String csvDelimiterOption = DelimiterUtils$.MODULE$.checkDelimiterOption(ss.sqlContext().getConf("spark.feathr.inputFormat.csvOptions.sep", ","));
        String string = format;
        String string2 = FileFormat$.MODULE$.PATHLIST();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            Dataset dataset;
            Enumeration.Value x$1 = inputData.sourceType();
            String x$2 = inputData.inputPath();
            SparkSession x$3 = ss;
            Option<DateParam> x$4 = inputData.dateParam();
            None$ x$5 = None$.MODULE$;
            boolean x$6 = failOnMissing;
            List<DataLoaderHandler> x$7 = dataLoaderHandlers;
            Seq<String> pathList = this.getPathList(x$1, x$2, x$3, x$4, x$7, (Option<String>)x$5, x$6);
            if (ss.sparkContext().isLocal()) {
                try {
                    dataset = this.loadAsUnionDataFrame(ss, pathList, dataLoaderHandlers);
                }
                catch (Throwable throwable) {
                    dataset = (Dataset)this.loadSeparateJsonFileAsAvroToDF(ss, inputData.inputPath()).get();
                }
            } else {
                dataset = this.loadAsUnionDataFrame(ss, pathList, dataLoaderHandlers);
            }
            object = dataset;
        } else {
            String string4 = FileFormat$.MODULE$.JDBC();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                object = JdbcUtils$.MODULE$.loadDataFrame(ss, inputData.inputPath());
            } else {
                String string6 = FileFormat$.MODULE$.SNOWFLAKE();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    object = SnowflakeUtils$.MODULE$.loadDataFrame(ss, inputData.inputPath());
                } else {
                    String string8 = FileFormat$.MODULE$.CSV();
                    String string9 = string;
                    object = !(string8 != null ? !string8.equals(string9) : string9 != null) ? ss.read().format("csv").option("header", "true").option("delimiter", csvDelimiterOption).load(inputData.inputPath()) : this.loadAsDataFrame(ss, new SimplePath(inputData.inputPath()), dataLoaderHandlers);
                }
            }
        }
        return object;
    }

    public boolean loadObservationAsDF$default$5() {
        return true;
    }

    public String getLocalPath(String path) {
        return this.getClass().getClassLoader().getResource(path).getPath();
    }

    public <T> Tuple2<RDD<?>, Schema> parseJsonAsAvroRDD(SparkSession ss, String dataArrayAsJson, String schemaAsString, ClassTag<T> tag) {
        SparkContext sc = ss.sparkContext();
        ObjectMapper jackson = new ObjectMapper((JsonFactory)new HoconFactory());
        Schema schema = Schema.parse((String)schemaAsString);
        JsonNode jsonDataArray = jackson.readTree(new StringBuilder(9).append("{ data:").append(dataArrayAsJson).append(" }").toString()).get("data");
        Iterable records = (Iterable)JavaConversions$.MODULE$.iterableAsScalaIterable((java.lang.Iterable)jsonDataArray).map((Function1 & Serializable & scala.Serializable)jsonNode -> {
            Object object;
            ByteArrayInputStream input = new ByteArrayInputStream(jsonNode.toString().getBytes());
            DataInputStream din = new DataInputStream(input);
            JsonDecoder decoder = DecoderFactory.get().jsonDecoder(schema, (InputStream)din);
            if (!SpecificRecordBase.class.isAssignableFrom(package$.MODULE$.classTag(tag).runtimeClass())) {
                GenericDatumReader reader = new GenericDatumReader(schema);
                object = reader.read(null, (Decoder)decoder);
            } else {
                SpecificDatumReader reader = new SpecificDatumReader(package$.MODULE$.classTag(tag).runtimeClass());
                object = reader.read(null, (Decoder)decoder);
            }
            return object;
        }, Iterable$.MODULE$.canBuildFrom());
        return new Tuple2((Object)sc.parallelize(records.toSeq(), sc.parallelize$default$2(), ClassTag$.MODULE$.Any()), (Object)schema);
    }

    public <T> Option<Tuple2<RDD<?>, Schema>> loadSeparateJsonFileAsAvroToRDD(SparkSession ss, String path, ClassTag<T> tag) {
        None$ none$;
        try {
            String dataPath = new StringBuilder(14).append(path).append("/mockData.json").toString();
            String dataAsString = this.readLocalConfFileAsString(dataPath);
            String schemaPath = new StringBuilder(12).append(path).append("/schema.avsc").toString();
            String schemaAsString = this.readLocalConfFileAsString(schemaPath);
            none$ = new Some(this.parseJsonAsAvroRDD(ss, dataAsString, schemaAsString, tag));
        }
        catch (Exception e) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<Dataset<Row>> loadSeparateJsonFileAsAvroToDF(SparkSession ss, String path) {
        return this.loadSeparateJsonFileAsAvroToRDD(ss, path, ClassTag$.MODULE$.Nothing()).map((Function1 & Serializable & scala.Serializable)res -> {
            Schema schema = (Schema)res._2();
            StructType sqlType = (StructType)SchemaConverters$.MODULE$.toSqlType(schema).dataType();
            Function1<Object, Object> converter = SchemaConverterUtils$.MODULE$.converterSql(schema, (DataType)sqlType);
            RDD rowRdd = ((RDD)res._1()).flatMap((Function1 & Serializable & scala.Serializable)record -> Option$.MODULE$.option2Iterable(Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Row)converter.apply(record)).toOption()), ClassTag$.MODULE$.apply(Row.class));
            return ss.createDataFrame(rowRdd, sqlType);
        });
    }

    public String getArbitraryRecordName(Object x) {
        return new StringBuilder(11).append("AnonRecord_").append(Integer.toHexString(x.hashCode())).toString();
    }

    public Object coerceToAvro(Schema schema, Object obj) {
        Object object;
        Schema.Type type = schema.getType();
        if (Schema.Type.RECORD.equals(type)) {
            GenericData.Record record = new GenericData.Record(schema);
            JavaConversions$.MODULE$.iterableAsScalaIterable((java.lang.Iterable)schema.getFields()).foreach((Function1 & Serializable & scala.Serializable)field -> {
                record.put(field.name(), SourceUtils$.MODULE$.coerceToAvro(field.schema(), ((Map)obj).get(field.name())));
                return BoxedUnit.UNIT;
            });
            object = record;
        } else if (Schema.Type.ARRAY.equals(type)) {
            java.util.List list = (java.util.List)obj;
            GenericData.Array array = new GenericData.Array(list.size(), schema.getElementType());
            ((IterableLike)JavaConversions$.MODULE$.iterableAsScalaIterable((java.lang.Iterable)list).map((Function1 & Serializable & scala.Serializable)x$5 -> MODULE$.coerceToAvro(schema.getElementType(), x$5), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)array.add(x$1)));
            object = array;
        } else {
            object = Schema.Type.STRING.equals(type) ? new Utf8((String)obj) : obj;
        }
        return object;
    }

    public RDD<?> loadJsonTextFile(SparkSession ss, String path) {
        SparkContext sc = ss.sparkContext();
        Predef$.MODULE$.require(sc.isLocal());
        Predef$.MODULE$.require(path.endsWith(".json"));
        String contents = Source$.MODULE$.fromFile(this.getClass().getClassLoader().getResource(path).toURI(), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        return sc.parallelize(this.doLoadJsonDocument(contents), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Object.class));
    }

    public Seq<?> doLoadJsonDocument(String contents) {
        String hackedContents = new StringBuilder(9).append("{root:[").append(contents).append("]}").toString();
        ObjectMapper jackson = new ObjectMapper((JsonFactory)new HoconFactory());
        return JavaConversions$.MODULE$.iterableAsScalaIterable((java.lang.Iterable)((Collection)((Map)jackson.readValue(hackedContents, Map.class)).get("root"))).toSeq();
    }

    public <T> Option<Tuple2<RDD<?>, Schema>> loadJsonFileAsAvroToRDD(SparkSession ss, String path, ClassTag<T> tag) {
        None$ none$;
        SparkContext sc = ss.sparkContext();
        Predef$.MODULE$.require(sc.isLocal());
        Predef$.MODULE$.require(path.endsWith(".avro.json"));
        URL absolutePath = this.getClass().getClassLoader().getResource(path);
        if (absolutePath != null) {
            String contents = Source$.MODULE$.fromFile(absolutePath.toURI(), Codec$.MODULE$.fallbackSystemCodec()).mkString();
            ObjectMapper jackson = new ObjectMapper((JsonFactory)new HoconFactory());
            JsonNode tree = jackson.readTree(contents);
            Schema schema = Schema.parse((String)tree.get("schema").toString());
            JsonNode jsonDataArray = tree.get("data");
            Iterable records = (Iterable)JavaConversions$.MODULE$.iterableAsScalaIterable((java.lang.Iterable)jsonDataArray).map((Function1 & Serializable & scala.Serializable)jsonNode -> {
                Object object;
                ByteArrayInputStream input = new ByteArrayInputStream(jsonNode.toString().getBytes());
                DataInputStream din = new DataInputStream(input);
                JsonDecoder decoder = DecoderFactory.get().jsonDecoder(schema, (InputStream)din);
                if (!SpecificRecordBase.class.isAssignableFrom(package$.MODULE$.classTag(tag).runtimeClass())) {
                    GenericDatumReader reader = new GenericDatumReader(schema);
                    object = reader.read(null, (Decoder)decoder);
                } else {
                    SpecificDatumReader reader = new SpecificDatumReader(package$.MODULE$.classTag(tag).runtimeClass());
                    object = reader.read(null, (Decoder)decoder);
                }
                return object;
            }, Iterable$.MODULE$.canBuildFrom());
            none$ = new Some((Object)new Tuple2((Object)sc.parallelize(records.toSeq(), sc.parallelize$default$2(), ClassTag$.MODULE$.Any()), (Object)schema));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<Dataset<Row>> loadJsonFileAsAvroToDF(SparkSession ss, String path) {
        Option<Dataset<Row>> option;
        Some some;
        Tuple2 tuple2;
        Option<Tuple2<RDD<?>, Schema>> option2 = this.loadJsonFileAsAvroToRDD(ss, path, ClassTag$.MODULE$.Nothing());
        if (option2 instanceof Some && (tuple2 = (Tuple2)(some = (Some)option2).value()) != null) {
            RDD rdd = (RDD)tuple2._1();
            Schema schema = (Schema)tuple2._2();
            option = this.convertRddToDataFrame(ss, (RDD<GenericRecord>)rdd, schema);
        } else if (None$.MODULE$.equals(option2)) {
            option = None$.MODULE$;
        } else {
            throw new MatchError(option2);
        }
        return option;
    }

    public Option<Dataset<Row>> convertRddToDataFrame(SparkSession ss, RDD<GenericRecord> rdd, Schema schema) {
        StructType sqlType = (StructType)SchemaConverters$.MODULE$.toSqlType(schema).dataType();
        Function1<Object, Object> converter = SchemaConverterUtils$.MODULE$.converterSql(schema, (DataType)sqlType);
        Row[] rows = (Row[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd.collect())).flatMap((Function1 & Serializable & scala.Serializable)record -> Option$.MODULE$.option2Iterable(Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Row)converter.apply(record)).toOption()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)));
        return new Some((Object)ss.createDataFrame(Arrays.asList((Object[])rows), sqlType));
    }

    public boolean isFilePath(String sourceIdentifier) {
        return sourceIdentifier.contains("/") || sourceIdentifier.contains(".csv") || sourceIdentifier.contains(".json") || sourceIdentifier.contains(".orc");
    }

    public String generateFilterKeyString(Seq<String> keys) {
        return keys.count((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)SourceUtils$.$anonfun$generateFilterKeyString$1(x$6))) == keys.size() ? (String)keys.reduce((Function2 & Serializable & scala.Serializable)(x$7, x$8) -> new StringBuilder(1).append((String)x$7).append("#").append((String)x$8).toString()) : null;
    }

    public Seq<Tuple2<Dataset<Row>, Interval>> loadTimeSeriesAvroJson(SparkSession ss, Seq<String> paths, String basePath, boolean isSeparateAvroJson) {
        if (!ss.sparkContext().isLocal() || ((String)paths.head()).startsWith(this.HDFS_PREFIX())) {
            throw new FeathrInputDataException(ErrorLabel.FEATHR_ERROR, new StringBuilder(212).append("Trying to load a time series dataset.").append("Cannot load time series avro json data from ").append(basePath).append(", Currently, ").append("this test API only runs locally and source path has to start with ").append(this.HDFS_PREFIX()).append("Please do not use this API in non-local environment.").toString());
        }
        return (Seq)((TraversableLike)paths.map((Function1 & Serializable & scala.Serializable)path -> {
            Option<Dataset<Row>> df = isSeparateAvroJson ? MODULE$.loadSeparateJsonFileAsAvroToDF(ss, (String)path) : MODULE$.loadJsonFileAsAvroToDF(ss, new StringBuilder(15).append((String)path).append("/data.avro.json").toString());
            String timeStr = path.substring(basePath.length());
            Interval interval = !timeStr.equals("") ? MODULE$.createTimeInterval((Option<String>)new Some((Object)timeStr), (Option<String>)new Some((Object)timeStr), "yyyy/MM/dd", MODULE$.createTimeInterval$default$4()) : MODULE$.createTimeInterval((Option<String>)new Some((Object)"000/01/01"), (Option<String>)new Some((Object)"9999/12/31"), "yyyy/MM/dd", MODULE$.createTimeInterval$default$4());
            return new Tuple2(df, (Object)interval);
        }, Seq$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Option<Dataset<Row>>, Interval>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    Some some;
                    Dataset df;
                    Option option = (Option)A1._1();
                    Interval interval = (Interval)A1._2();
                    if (option instanceof Some && (df = (Dataset)(some = (Some)option).value()) != null) {
                        Dataset dataset = df;
                        if (interval != null) {
                            Interval interval2 = interval;
                            object = new Tuple2((Object)dataset, (Object)interval2);
                            return (B1)object;
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<Option<Dataset<Row>>, Interval> x1) {
                Tuple2<Option<Dataset<Row>>, Interval> tuple2 = x1;
                if (tuple2 == null) return false;
                Option option = (Option)tuple2._1();
                Interval interval = (Interval)tuple2._2();
                if (!(option instanceof Some)) return false;
                Some some = (Some)option;
                Dataset df = (Dataset)some.value();
                if (df == null) return false;
                if (interval == null) return false;
                return true;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public boolean loadTimeSeriesAvroJson$default$4() {
        return false;
    }

    public LocalDateTime jodaDateTimeToPSTPDTLocalTime(DateTime jodaDateTime) {
        DateTime time = jodaDateTime.withZone(DateTimeZone.forID((String)"America/Los_Angeles"));
        return LocalDateTime.of(time.getYear(), time.getMonthOfYear(), time.getDayOfMonth(), 0, 0);
    }

    public LocalDateTime toDailyLocalTime(LocalDateTime localDateTime) {
        return LocalDateTime.of(localDateTime.getYear(), localDateTime.getMonth(), localDateTime.getDayOfMonth(), 0, 0);
    }

    public String readLocalConfFileAsString(String paths) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])paths.split(","))).map((Function1 & Serializable & scala.Serializable)path -> {
            void var2_2;
            BufferedSource bufferedSource = Source$.MODULE$.fromFile(path, Codec$.MODULE$.fallbackSystemCodec());
            String content = bufferedSource.mkString();
            bufferedSource.close();
            return var2_2;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("\n");
    }

    public Seq<String> getFileNamesInSubFolder(String basePath, Seq<String> includeSuffixList, Configuration conf) {
        FileSystem fs = FileSystem.get((Configuration)conf);
        Seq filesNames = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(new Path(basePath)))).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.isFile())))).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.getPath().getName(), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        Seq filteredFilenames = (Seq)filesNames.filter((Function1 & Serializable & scala.Serializable)dirName -> BoxesRunTime.boxToBoolean((boolean)SourceUtils$.$anonfun$getFileNamesInSubFolder$3(includeSuffixList, dirName)));
        return filesNames;
    }

    public Seq<String> getFileNamesInSubFolder$default$2() {
        return Nil$.MODULE$;
    }

    public Configuration getFileNamesInSubFolder$default$3() {
        return this.conf();
    }

    public Option<String> getFeathrConfFromFeatureRepo() {
        None$ none$;
        block3: {
            try {
                Seq featureMPDefConfigPaths = (Seq)this.getFileNamesInSubFolder(this.FEATURE_MP_DEF_CONFIG_BASE_PATH(), (Seq<String>)((Seq)new .colon.colon((Object)this.FEATURE_MP_DEF_CONFIG_SUFFIX(), (List)Nil$.MODULE$)), this.getFileNamesInSubFolder$default$3()).map((Function1 & Serializable & scala.Serializable)fileName -> new StringBuilder(1).append(MODULE$.FEATURE_MP_DEF_CONFIG_BASE_PATH()).append("/").append((String)fileName).toString(), Seq$.MODULE$.canBuildFrom());
                if (featureMPDefConfigPaths.nonEmpty()) {
                    none$ = new Some((Object)this.readLocalConfFileAsString(featureMPDefConfigPaths.mkString(",")));
                    break block3;
                }
                none$ = None$.MODULE$;
            }
            catch (Exception exception) {
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    public void printDataFramePartitionInfo(Seq<Tuple2<String, Dataset<Row>>> dfNamePairs) {
        this.log().info((Object)new StringBuilder(17).append("Printing info of ").append(dfNamePairs.map((Function1 & Serializable & scala.Serializable)pr -> new StringBuilder(0).append((String)pr._1()).append(':').append(pr._2()).append(';').toString(), Seq$.MODULE$.canBuildFrom())).toString());
        dfNamePairs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SourceUtils$.$anonfun$printDataFramePartitionInfo$2(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getExpectDatumType$1(Class x$1) {
        return SpecificRecord.class.isAssignableFrom(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$getExpectDatumType$2(Class x$1) {
        return SpecificRecord.class.isAssignableFrom(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$getExpectDatumType$4(Class x$1) {
        return GenericRecord.class.isAssignableFrom(x$1);
    }

    public static final /* synthetic */ String $anonfun$generateHDFSTimeBasedPaths$2(String hourlyFilePath$1, Interval timeInterval$1, String dailyHourlyFormat$1, int curHour) {
        return new StringBuilder(0).append(hourlyFilePath$1).append(timeInterval$1.getStart().plusHours(curHour).toString(dailyHourlyFormat$1)).toString();
    }

    public static final /* synthetic */ String $anonfun$generateHDFSTimeBasedPaths$3(String dailyFilePath$1, Interval timeInterval$1, String dailyFormat$1, int curDays) {
        return new StringBuilder(0).append(dailyFilePath$1).append(timeInterval$1.getStart().plusDays(curDays).toString(dailyFormat$1)).toString();
    }

    public static final /* synthetic */ String $anonfun$generateHDFSTimeBasedPaths$4(String dailyPartitionFilePath$1, Interval timeInterval$1, String dailyPartitionFormat$1, int curDays) {
        return new StringBuilder(0).append(dailyPartitionFilePath$1).append(timeInterval$1.getStart().plusDays(curDays).toString(dailyPartitionFormat$1)).toString();
    }

    public static final /* synthetic */ boolean $anonfun$generateHDFSTimeBasedPaths$5(Try fileSystem$1, String curPath) {
        return ((FileSystem)fileSystem$1.get()).exists(new Path(curPath));
    }

    public static final /* synthetic */ boolean $anonfun$generateFilterKeyString$1(String x$6) {
        return x$6 != null;
    }

    public static final /* synthetic */ boolean $anonfun$getFileNamesInSubFolder$3(Seq includeSuffixList$1, String dirName) {
        return includeSuffixList$1.isEmpty() || includeSuffixList$1.exists((Function1 & Serializable & scala.Serializable)suffix -> BoxesRunTime.boxToBoolean((boolean)dirName.endsWith(suffix)));
    }

    private static final Encoder single$1(ClassTag c) {
        return Encoders$.MODULE$.kryo(c);
    }

    public static final /* synthetic */ void $anonfun$printDataFramePartitionInfo$4(Integer num) {
        MODULE$.log().info((Object)num);
    }

    public static final /* synthetic */ void $anonfun$printDataFramePartitionInfo$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Dataset df = (Dataset)tuple2._2();
        Dataset res = df.mapPartitions((Function1 & Serializable & scala.Serializable)x -> ((IterableLike)new .colon.colon((Object)new Integer(x.size()), (List)Nil$.MODULE$)).toIterator(), SourceUtils$.single$1(ClassTag$.MODULE$.apply(Integer.class)));
        res.foreach((Function1 & Serializable & scala.Serializable)num -> {
            SourceUtils$.$anonfun$printDataFramePartitionInfo$4(num);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private SourceUtils$() {
        MODULE$ = this;
        this.HDFS_PREFIX = "/";
        this.conf = new Configuration();
        this.log = Logger.getLogger(this.getClass());
        this.FEATURE_MP_DEF_CONFIG_BASE_PATH = "feathr-feature-configs/config/offline";
        this.FEATURE_MP_DEF_CONFIG_SUFFIX = ".conf";
        this.firstRecordName = "topLevelRecord";
    }
}

