/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.swj.transformer;

import com.linkedin.feathr.swj.FactData;
import com.linkedin.feathr.swj.SlidingWindowFeature;
import com.linkedin.feathr.swj.aggregate.AggregationSpec;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;

public final class FeatureTransformer$ {
    public static FeatureTransformer$ MODULE$;
    private SparkSession spark;
    private final String GROUP_COL_NAME;
    private final String DF_VIEW_NAME;
    private final String JOIN_KEY_COL_NAME;
    private final String TIMESTAMP_COL_NAME;
    private volatile boolean bitmap$0;

    static {
        new FeatureTransformer$();
    }

    private SparkSession spark$lzycompute() {
        FeatureTransformer$ featureTransformer$ = this;
        synchronized (featureTransformer$) {
            if (!this.bitmap$0) {
                this.spark = SparkSession$.MODULE$.builder().getOrCreate();
                this.bitmap$0 = true;
            }
        }
        return this.spark;
    }

    public SparkSession spark() {
        return !this.bitmap$0 ? this.spark$lzycompute() : this.spark;
    }

    public String GROUP_COL_NAME() {
        return this.GROUP_COL_NAME;
    }

    public String DF_VIEW_NAME() {
        return this.DF_VIEW_NAME;
    }

    public String JOIN_KEY_COL_NAME() {
        return this.JOIN_KEY_COL_NAME;
    }

    public String TIMESTAMP_COL_NAME() {
        return this.TIMESTAMP_COL_NAME;
    }

    private Tuple2<String, String> featureColumnSqlString(SlidingWindowFeature feature) {
        boolean hasFilter = feature.filterCondition().isDefined();
        String filter = (String)feature.filterCondition().getOrElse((Function0 & java.io.Serializable & Serializable)() -> "");
        boolean hasGroupBy = feature.groupBy().isDefined();
        String groupCol = (String)feature.groupBy().map((Function1 & java.io.Serializable & Serializable)x$1 -> x$1.groupByCol()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> "");
        AggregationSpec agg = feature.agg();
        String partOne = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(43).append("\n         |struct(").append(feature.name()).append("_").append(agg.metricName()).append("\n         |").append((Object)(hasGroupBy ? new StringBuilder(3).append(", ").append(feature.name()).append("_").append(this.GROUP_COL_NAME()).toString() : "")).append(") AS ").append(feature.name()).append("\n       ").toString())).stripMargin();
        String partTwo = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(35).append("\n         |").append((Object)(hasFilter ? new StringBuilder(31).append(" CASE WHEN ").append(filter).append(" THEN ").append(agg.metricCol()).append(" ELSE null END").toString() : new StringBuilder(1).append(" ").append(agg.metricCol()).toString())).append(" AS ").append(feature.name()).append("_").append(agg.metricName()).append("\n         |").append((Object)(hasGroupBy ? new StringBuilder(7).append(", ").append(groupCol).append(" AS ").append(feature.name()).append("_").append(this.GROUP_COL_NAME()).toString() : "")).append("\n       ").toString())).stripMargin();
        return new Tuple2((Object)partOne, (Object)partTwo);
    }

    private String getLateraViewSqlString(SlidingWindowFeature feature) {
        return (String)feature.lateralView().map((Function1 & java.io.Serializable & Serializable)param -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(57).append("\n           |LATERAL VIEW ").append(param.lateralViewDef()).append("\n           |").append(param.lateralViewItemAlias()).append("\n           |").append(param.lateralViewFilter().map((Function1 & java.io.Serializable & Serializable)x$2 -> new StringBuilder(6).append("WHERE ").append((String)x$2).toString()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> "")).append("\n    ").toString())).stripMargin()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> "");
    }

    public Dataset<Row> transformFactData(FactData factData) {
        Dataset<Row> df = factData.dataSource();
        df.createOrReplaceTempView(this.DF_VIEW_NAME());
        List featureColsSql = (List)factData.aggFeatures().map((Function1 & java.io.Serializable & Serializable)feature -> MODULE$.featureColumnSqlString((SlidingWindowFeature)feature), List$.MODULE$.canBuildFrom());
        Predef$.MODULE$.require(((SeqLike)((SeqLike)factData.aggFeatures().map((Function1 & java.io.Serializable & Serializable)x$3 -> x$3.lateralView(), List$.MODULE$.canBuildFrom())).distinct()).size() <= 1, (Function0 & java.io.Serializable & Serializable)() -> "SWA features share same fact data should have same lateral view, or no lateral view");
        String lateralViewSql = this.getLateraViewSqlString((SlidingWindowFeature)factData.aggFeatures().head());
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(216).append("\n                 |SELECT ").append(((TraversableOnce)featureColsSql.map((Function1 & java.io.Serializable & Serializable)x$4 -> (String)x$4._1(), List$.MODULE$.canBuildFrom())).mkString(",")).append(",\n                 |").append(this.JOIN_KEY_COL_NAME()).append(", ").append(this.TIMESTAMP_COL_NAME()).append(" FROM\n                 |(SELECT\n                 |").append((Object)(factData.joinKey().size() > 1 ? new StringBuilder(8).append("struct(").append(factData.joinKey().mkString(",")).append(")").toString() : String.valueOf(factData.joinKey().head()))).append(" AS ").append(this.JOIN_KEY_COL_NAME()).append(",\n                 |").append(factData.timestampCol()).append(" AS ").append(this.TIMESTAMP_COL_NAME()).append(",\n                 |").append(((TraversableOnce)featureColsSql.map((Function1 & java.io.Serializable & Serializable)x$5 -> (String)x$5._2(), List$.MODULE$.canBuildFrom())).mkString(",")).append(" FROM\n                 |").append(this.DF_VIEW_NAME()).append("\n                 |").append(lateralViewSql).append("\n                 )\n       ").toString())).stripMargin();
        Predef$.MODULE$.println((Object)new StringBuilder(25).append("Generated SQL Statement: ").append(sql).toString());
        return this.spark().sql(sql);
    }

    private FeatureTransformer$() {
        MODULE$ = this;
        this.GROUP_COL_NAME = "group_col";
        this.DF_VIEW_NAME = "fact_data";
        this.JOIN_KEY_COL_NAME = "join_key_swj";
        this.TIMESTAMP_COL_NAME = "timestamp_col_swj";
    }
}

