/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common;

import com.linkedin.feathr.common.tensor.Primitive;
import com.linkedin.feathr.common.tensor.Representable;
import com.linkedin.feathr.common.tensor.TensorData;
import com.linkedin.feathr.common.tensor.TensorIterator;

public class CoercingTensorData
implements TensorData {
    private final TensorData _inner;

    public CoercingTensorData(TensorData inner) {
        this._inner = inner;
    }

    @Override
    public Representable[] getTypes() {
        return this._inner.getTypes();
    }

    @Override
    public int estimatedCardinality() {
        return this._inner.estimatedCardinality();
    }

    @Override
    public int cardinality() {
        return this._inner.cardinality();
    }

    @Override
    public TensorIterator iterator() {
        return new MyTensorIterator(this._inner.iterator());
    }

    @Override
    public long[] getShape() {
        return this._inner.getShape();
    }

    public TensorData getInner() {
        return this._inner;
    }

    private final class MyTensorIterator
    implements TensorIterator {
        private final TensorIterator _innerIterator;

        private MyTensorIterator(TensorIterator innerIterator) {
            this._innerIterator = innerIterator;
        }

        @Override
        public TensorData getTensorData() {
            return CoercingTensorData.this;
        }

        @Override
        public void start() {
            this._innerIterator.start();
        }

        @Override
        public boolean isValid() {
            return this._innerIterator.isValid();
        }

        @Override
        public Object getValue(int index) {
            return this._innerIterator.getValue(index);
        }

        private Primitive getRepresentation(int index) {
            return CoercingTensorData.this.getTypes()[index].getRepresentation();
        }

        @Override
        public int getInt(int index) {
            return this.getRepresentation(index).toInt(this._innerIterator, index);
        }

        @Override
        public long getLong(int index) {
            return this.getRepresentation(index).toLong(this._innerIterator, index);
        }

        @Override
        public float getFloat(int index) {
            return this.getRepresentation(index).toFloat(this._innerIterator, index);
        }

        @Override
        public double getDouble(int index) {
            return this.getRepresentation(index).toDouble(this._innerIterator, index);
        }

        @Override
        public String getString(int index) {
            return this.getRepresentation(index).toString(this._innerIterator, index);
        }

        @Override
        public boolean getBoolean(int index) {
            return this.getRepresentation(index).toBoolean(this._innerIterator, index);
        }

        @Override
        public byte[] getBytes(int index) {
            return this.getRepresentation(index).toBytes(this._innerIterator, index);
        }

        @Override
        public void next() {
            this._innerIterator.next();
        }

        @Override
        public TensorIterator getCopy() {
            return new MyTensorIterator(this._innerIterator.getCopy());
        }
    }
}

