/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common;

import com.linkedin.feathr.common.tensor.Primitive;
import com.linkedin.feathr.common.tensor.Representable;
import java.util.Objects;

public class ColumnUtils {
    public final int[] _columnIndex;
    public int _intArity;
    public int _longArity;
    public int _stringArity;
    public int _floatArity;
    public int _doubleArity;
    public int _booleanArity;
    public int _bytesArity;
    public final Representable[] _columnTypes;

    public ColumnUtils(Representable ... columnTypes) {
        this._columnTypes = Objects.requireNonNull(columnTypes, "columnTypes should not be null in UniversalTensorBuilder.");
        this._columnIndex = new int[columnTypes.length];
        block9: for (int i = 0; i < columnTypes.length; ++i) {
            switch (columnTypes[i].getRepresentation()) {
                case INT: {
                    this._columnIndex[i] = this._intArity++;
                    continue block9;
                }
                case LONG: {
                    this._columnIndex[i] = this._longArity++;
                    continue block9;
                }
                case FLOAT: {
                    this._columnIndex[i] = this._floatArity++;
                    continue block9;
                }
                case STRING: {
                    this._columnIndex[i] = this._stringArity++;
                    continue block9;
                }
                case DOUBLE: {
                    this._columnIndex[i] = this._doubleArity++;
                    continue block9;
                }
                case BOOLEAN: {
                    this._columnIndex[i] = this._booleanArity++;
                    continue block9;
                }
                case BYTES: {
                    this._columnIndex[i] = this._bytesArity++;
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported column type: " + columnTypes[i].getRepresentation());
                }
            }
        }
    }

    public int[] getColumnIndex() {
        return this._columnIndex;
    }

    public int getIntArity() {
        return this._intArity;
    }

    public int getLongArity() {
        return this._longArity;
    }

    public int getStringArity() {
        return this._stringArity;
    }

    public int getFloatArity() {
        return this._floatArity;
    }

    public int getDoubleArity() {
        return this._doubleArity;
    }

    public int getBooleanArity() {
        return this._booleanArity;
    }

    public int getBytesArity() {
        return this._bytesArity;
    }

    public Representable[] getColumnTypes() {
        return this._columnTypes;
    }

    public static int getDimArity(Representable[] types) {
        int i;
        Primitive p = types[types.length - 1].getRepresentation();
        if (p.getRepresentation() != Primitive.FLOAT && p.getRepresentation() != Primitive.DOUBLE) {
            return types.length - 1;
        }
        for (i = types.length; i > 0 && ((p = types[i - 1].getRepresentation()) == Primitive.FLOAT || p == Primitive.DOUBLE); --i) {
        }
        return i;
    }
}

