/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common;

import com.linkedin.feathr.common.GenericTypedTensor;
import com.linkedin.feathr.common.TypedTensor;
import com.linkedin.feathr.common.tensor.Primitive;
import com.linkedin.feathr.common.tensor.TensorData;
import com.linkedin.feathr.common.tensor.TensorIterator;
import com.linkedin.feathr.common.tensor.TensorType;
import com.linkedin.feathr.common.types.FeatureType;
import com.linkedin.feathr.common.types.TensorFeatureType;
import com.linkedin.feathr.common.value.BooleanFeatureValue;
import com.linkedin.feathr.common.value.CategoricalFeatureValue;
import com.linkedin.feathr.common.value.FeatureFormatMapper;
import com.linkedin.feathr.common.value.FeatureValue;
import com.linkedin.feathr.common.value.NumericFeatureValue;
import com.linkedin.feathr.common.value.QuinceFeatureFormatMapper;
import com.linkedin.feathr.common.value.QuinceFeatureTypeMapper;
import com.linkedin.feathr.common.value.TensorFeatureValue;
import com.linkedin.feathr.common.value.TermVectorFeatureValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class CompatibilityUtils {
    private static final String EMPTY_TERM = "";
    private static final float UNIT = 1.0f;
    private static final Map<String, Float> NTV_BOOLEAN_TRUE = Collections.singletonMap("", Float.valueOf(1.0f));

    private CompatibilityUtils() {
    }

    static boolean getBoolean(FeatureValue featureValue) {
        TensorData tensor;
        if (featureValue instanceof BooleanFeatureValue) {
            return ((BooleanFeatureValue)featureValue).getBooleanValue();
        }
        if (featureValue instanceof TermVectorFeatureValue) {
            Map<String, Float> tv = ((TermVectorFeatureValue)featureValue).getTermVector();
            if (tv.isEmpty()) {
                return false;
            }
            if (tv.equals(NTV_BOOLEAN_TRUE)) {
                return true;
            }
        } else if (featureValue instanceof TensorFeatureValue && (tensor = ((TensorFeatureValue)featureValue).getAsTensor()).getTypes().length == 1 && tensor.getTypes()[0].getRepresentation() == Primitive.BOOLEAN) {
            return tensor.iterator().getBoolean(0);
        }
        throw new IllegalArgumentException("Couldn't convert " + featureValue + " to boolean");
    }

    static float getNumeric(FeatureValue featureValue) {
        TensorData tensor;
        if (featureValue instanceof NumericFeatureValue) {
            return ((NumericFeatureValue)featureValue).getFloatValue();
        }
        if (featureValue instanceof TermVectorFeatureValue) {
            Float floatValue;
            Map<String, Float> tv = ((TermVectorFeatureValue)featureValue).getTermVector();
            if (tv.size() == 1 && (floatValue = tv.get(EMPTY_TERM)) != null) {
                return floatValue.floatValue();
            }
        } else if (featureValue instanceof TensorFeatureValue && (tensor = ((TensorFeatureValue)featureValue).getAsTensor()).getTypes().length == 1) {
            return tensor.getTypes()[0].getRepresentation().toFloat(tensor.iterator(), 0);
        }
        throw new IllegalArgumentException("Couldn't convert " + featureValue + " to numeric");
    }

    static String getCategoricalString(FeatureValue featureValue) {
        if (featureValue instanceof CategoricalFeatureValue) {
            return ((CategoricalFeatureValue)featureValue).getStringValue();
        }
        if (featureValue instanceof TermVectorFeatureValue) {
            Map.Entry<String, Float> onlyEntry;
            Map<String, Float> tv = ((TermVectorFeatureValue)featureValue).getTermVector();
            Iterator<Map.Entry<String, Float>> iterator = tv.entrySet().iterator();
            if (iterator.hasNext() && (onlyEntry = iterator.next()).getValue().floatValue() == 1.0f && !iterator.hasNext()) {
                return onlyEntry.getKey();
            }
        } else if (featureValue instanceof TensorFeatureValue) {
            TensorData tensorData = ((TensorFeatureValue)featureValue).getAsTensor();
            if (tensorData.cardinality() == 1 && tensorData.getArity() == 2 && tensorData.getTypes()[0].getRepresentation().equals(Primitive.STRING)) {
                TensorIterator iter = tensorData.iterator();
                if (tensorData.getTypes()[1].getRepresentation().toFloat(iter, 1) == 1.0f) {
                    return iter.getString(0);
                }
            } else if (tensorData.getArity() == 1 && tensorData.getTypes()[0].getRepresentation().equals(Primitive.STRING)) {
                return tensorData.iterator().getString(0);
            }
        }
        throw new IllegalArgumentException("Couldn't convert " + featureValue + " to categorical string");
    }

    private static <K, V> HashMap<K, V> ensureMutable(Map<K, V> map) {
        if (map instanceof HashMap) {
            return (HashMap)map;
        }
        return new HashMap<K, V>(map);
    }

    static class TypedTensorFormatMapper
    implements FeatureFormatMapper<TypedTensor> {
        static final TypedTensorFormatMapper INSTANCE = new TypedTensorFormatMapper();

        private TypedTensorFormatMapper() {
        }

        @Override
        public TypedTensor fromFeatureValue(FeatureValue featureValue) {
            if (featureValue instanceof TensorFeatureValue) {
                return ((TensorFeatureValue)featureValue).getAsTypedTensor();
            }
            TensorData tensorData = (TensorData)QuinceFeatureFormatMapper.INSTANCE.fromFeatureValue(featureValue);
            TensorType tensorType = QuinceFeatureTypeMapper.INSTANCE.fromFeatureType(featureValue.getFeatureType());
            return new GenericTypedTensor(tensorData, tensorType);
        }

        @Override
        public FeatureValue toFeatureValue(FeatureType featureType, TypedTensor typedTensor) {
            if (featureType instanceof TensorFeatureType) {
                if (((TensorFeatureType)featureType).getTensorType().equals(typedTensor.getType())) {
                    throw new IllegalArgumentException("Tensor " + typedTensor + " type did not match type " + featureType);
                }
                return TensorFeatureValue.fromTypedTensor(typedTensor);
            }
            return QuinceFeatureFormatMapper.INSTANCE.toFeatureValue(featureType, typedTensor.getData());
        }
    }

    static class MutableTermVectorFeatureValue
    extends TermVectorFeatureValue {
        MutableTermVectorFeatureValue(Map<String, Float> termVector) {
            super(CompatibilityUtils.ensureMutable(termVector));
        }

        Map<String, Float> getMutableView() {
            return this._termVector;
        }

        @Override
        public String toString() {
            return "MutableTermVectorFeatureValue{_termVector=" + this._termVector + '}';
        }
    }
}

