/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common;

import com.linkedin.feathr.common.ColumnUtils;
import com.linkedin.feathr.common.tensor.ReadableTuple;
import com.linkedin.feathr.common.tensor.Representable;
import com.linkedin.feathr.common.tensor.TensorData;
import com.linkedin.feathr.common.tensor.TensorIterator;

public class Equal {
    public static final Equal INSTANCE = new Equal();

    public boolean apply(TensorData leftData, TensorData rightData) {
        return this.apply(leftData, rightData, false);
    }

    public boolean apply(TensorData leftData, TensorData rightData, boolean dimOnly) {
        Representable[] rightTypes;
        if (leftData == null && rightData == null) {
            return true;
        }
        if (leftData == null || rightData == null) {
            return false;
        }
        if (leftData.isEmpty() && rightData.isEmpty()) {
            return true;
        }
        if (leftData.isEmpty() || rightData.isEmpty()) {
            return false;
        }
        Representable[] leftTypes = leftData.getTypes();
        if (leftTypes.length != (rightTypes = rightData.getTypes()).length) {
            return false;
        }
        int len = leftTypes.length;
        for (int i = 0; i < len; ++i) {
            if (leftTypes[i].getRepresentation() == rightTypes[i].getRepresentation()) continue;
            return false;
        }
        int numColumnsToCompare = dimOnly ? ColumnUtils.getDimArity(leftTypes) : leftTypes.length;
        TensorIterator left = leftData.iterator();
        TensorIterator right = rightData.iterator();
        while (left.isValid() && right.isValid()) {
            if (!Equal.tupleEquals(left, right, leftTypes, numColumnsToCompare)) {
                return false;
            }
            left.next();
            right.next();
        }
        return !left.isValid() && !right.isValid();
    }

    public static boolean tupleEquals(ReadableTuple left, ReadableTuple right, Representable[] featureTypes, int numColumnsToCompare) {
        for (int i = 0; i < numColumnsToCompare; ++i) {
            if (featureTypes[i].getRepresentation().equals(left, i, right, i)) continue;
            return false;
        }
        return true;
    }
}

