/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common;

import com.linkedin.feathr.common.FeatureRef;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ErasedEntityTaggedFeature
implements Serializable {
    private final List<Integer> _binding;
    private final FeatureRef _featureRef;

    public ErasedEntityTaggedFeature(List<Integer> binding, String featureName) {
        this(binding, new FeatureRef(featureName));
    }

    public ErasedEntityTaggedFeature(List<Integer> binding, FeatureRef featureRef) {
        this._binding = binding;
        this._featureRef = featureRef;
    }

    public List<Integer> getBinding() {
        return this._binding;
    }

    public String getFeatureName() {
        return this._featureRef.getName();
    }

    public String getErasedTagFeatureName() {
        return this._binding.toString() + ":" + this._featureRef.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErasedEntityTaggedFeature that = (ErasedEntityTaggedFeature)o;
        return this._binding.equals(that._binding) && this._featureRef.equals(that._featureRef);
    }

    public int hashCode() {
        return Objects.hash(this._binding, this._featureRef);
    }

    public String toString() {
        return "(" + this._binding.stream().map(Object::toString).collect(Collectors.joining(",")) + "):" + this._featureRef;
    }
}

