/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common;

import java.io.Serializable;
import java.util.Objects;

public class FeatureRef
implements Serializable {
    private final String _namespace;
    private final String _name;
    private final int _major;
    private final int _minor;
    private String _str;
    public static final String DELIM = "-";

    public FeatureRef(String namespace, String name, int major, int minor) {
        this._namespace = namespace != null ? namespace : null;
        this._name = name;
        this._major = major;
        this._minor = minor;
    }

    public FeatureRef(String featureRefString) {
        this._namespace = null;
        this._name = featureRefString;
        this._major = 0;
        this._minor = 0;
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        if (this._str == null) {
            StringBuilder bldr = new StringBuilder();
            if (this._namespace != null) {
                bldr.append(this._namespace).append(DELIM);
            }
            bldr.append(this._name);
            this._str = bldr.toString();
        }
        return this._str;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureRef typedRef = (FeatureRef)o;
        return Objects.equals(this._namespace, typedRef._namespace) && Objects.equals(this._name, typedRef._name) && Objects.equals(this._minor, typedRef._minor) && Objects.equals(this._major, typedRef._major);
    }

    public int hashCode() {
        return Objects.hash(this._namespace, this._name, this._major, this._minor);
    }
}

