/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common.featurizeddataset;

import com.linkedin.feathr.common.tensor.TensorIterator;

public abstract class BaseDenseTensorIterator
implements TensorIterator {
    private final int _rank;
    private final int[] _indices;
    private boolean _valid;
    private int _flatIndex;

    protected BaseDenseTensorIterator(int rank) {
        if (rank < 1) {
            throw new IllegalArgumentException("Only supports rank >= 1, was: " + rank);
        }
        this._rank = rank;
        this._indices = new int[this._rank];
    }

    protected BaseDenseTensorIterator(BaseDenseTensorIterator original) {
        this._rank = original._rank;
        this._indices = (int[])original._indices.clone();
        this._valid = original._valid;
        this._flatIndex = original._flatIndex;
    }

    protected final int getRank() {
        return this._rank;
    }

    public final int getFlatIndex() {
        return this._flatIndex;
    }

    protected final int getIndex(int dimension) {
        return this._indices[dimension];
    }

    protected abstract boolean cache(int var1, int var2);

    protected abstract void cacheRoot();

    @Override
    public void start() {
        int i;
        for (i = 0; i < this.getRank(); ++i) {
            this._indices[i] = 0;
        }
        this._valid = true;
        for (i = 0; i <= this.getRank(); ++i) {
            while (!this.access(i)) {
                this.increment(i - 1);
                if (this._valid) continue;
                return;
            }
        }
    }

    private boolean access(int level) {
        if (level == 0) {
            this.cacheRoot();
            return true;
        }
        return this.cache(level, this._indices[level - 1]);
    }

    @Override
    public boolean isValid() {
        return this._valid;
    }

    @Override
    public void next() {
        ++this._flatIndex;
        this.increment(this.getRank() - 1);
    }

    private void increment(int i) {
        if (i < 0) {
            this._valid = false;
            return;
        }
        int n = i;
        this._indices[n] = this._indices[n] + 1;
        while (!this.access(i + 1)) {
            this._indices[i] = 0;
            this.increment(i - 1);
        }
    }
}

