/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common.tensor;

import com.linkedin.feathr.common.tensor.Representable;
import com.linkedin.feathr.common.tensor.TensorData;
import com.linkedin.feathr.common.tensor.TensorIterator;
import com.linkedin.feathr.common.tensorbuilder.BufferUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class LOLTensorData
implements TensorData {
    private final Representable[] _columnTypes;
    private final List<List<?>> _dimensions;
    private List<?> _values;

    public LOLTensorData(Representable[] columnTypes, List<List<?>> dimensions, List<?> values, boolean sort) {
        if (columnTypes.length != dimensions.size() + 1) {
            throw new IllegalArgumentException("There must be a column type for every dimension and value.");
        }
        this._columnTypes = columnTypes;
        this._dimensions = dimensions;
        this._values = values;
        if (sort && !dimensions.isEmpty()) {
            this.sort();
        }
    }

    public LOLTensorData(Representable[] columnTypes, List<List<?>> dimensions, List<?> values) {
        this(columnTypes, dimensions, values, true);
    }

    @Override
    public Representable[] getTypes() {
        return this._columnTypes;
    }

    @Override
    public int estimatedCardinality() {
        return this.cardinality();
    }

    @Override
    public int cardinality() {
        return this._values.size();
    }

    @Override
    public boolean isEmpty() {
        return this._values.isEmpty();
    }

    @Override
    public TensorIterator iterator() {
        return new LOLTensorIterator();
    }

    public List<List<?>> getDimensions() {
        return this._dimensions;
    }

    public List<?> getValues() {
        return this._values;
    }

    private Comparator<Integer> getComparatorFor(int column) {
        switch (this._columnTypes[column].getRepresentation()) {
            case INT: {
                return Comparator.comparing(i -> (Integer)this._dimensions.get(column).get((int)i));
            }
            case LONG: {
                return Comparator.comparing(i -> (Long)this._dimensions.get(column).get((int)i));
            }
            case FLOAT: {
                return Comparator.comparing(i -> (Float)this._dimensions.get(column).get((int)i));
            }
            case STRING: {
                return Comparator.comparing(i -> (String)this._dimensions.get(column).get((int)i));
            }
            case BOOLEAN: {
                return Comparator.comparing(i -> (Boolean)this._dimensions.get(column).get((int)i));
            }
            case BYTES: {
                return (Comparator & Serializable)(l, r) -> BufferUtils.compareBytes((byte[])this._dimensions.get(column).get((int)l), (byte[])this._dimensions.get(column).get((int)r));
            }
        }
        throw new IllegalArgumentException("Cannot get comparator for column: " + column);
    }

    private void sort() {
        switch (this._values.size()) {
            case 0: 
            case 1: {
                return;
            }
        }
        Comparator<Integer> comparator = this.getComparatorFor(0);
        for (int i2 = 1; i2 < this._columnTypes.length - 1; ++i2) {
            comparator = comparator.thenComparing(this.getComparatorFor(i2));
        }
        Integer[] indexes = new Integer[this._dimensions.get(0).size()];
        Arrays.setAll(indexes, i -> i);
        Arrays.sort(indexes, comparator);
        this.reorderLists(indexes);
    }

    private void reorderLists(Integer[] order) {
        int[] invOrder = new int[order.length];
        for (int i = 0; i < order.length; ++i) {
            invOrder[order[i].intValue()] = i;
        }
        for (int dest = 0; dest < order.length; ++dest) {
            int src = order[dest];
            if (src == dest) continue;
            for (List<?> dimension : this._dimensions) {
                Collections.swap(dimension, src, dest);
            }
            Collections.swap(this._values, src, dest);
            int whereDestHadToGo = invOrder[dest];
            order[whereDestHadToGo] = src;
            invOrder[src] = whereDestHadToGo;
        }
    }

    class LOLTensorIterator
    implements TensorIterator {
        private int _position;

        LOLTensorIterator() {
        }

        LOLTensorIterator(int position) {
            this._position = position;
        }

        public int getPosition() {
            return this._position;
        }

        public void setPosition(int position) {
            this._position = position;
        }

        @Override
        public TensorData getTensorData() {
            return LOLTensorData.this;
        }

        @Override
        public void start() {
            this._position = 0;
        }

        @Override
        public boolean isValid() {
            return this._position < LOLTensorData.this.cardinality();
        }

        @Override
        public Object getValue(int index) {
            List dimension;
            if (index == LOLTensorData.this._dimensions.size()) {
                return LOLTensorData.this._values.get(this._position);
            }
            try {
                dimension = (List)LOLTensorData.this._dimensions.get(index);
            }
            catch (IndexOutOfBoundsException e) {
                throw new RuntimeException("Trying to access dimension " + index + " in tensor with column types " + Arrays.asList(LOLTensorData.this._columnTypes), e);
            }
            try {
                return dimension.get(this._position);
            }
            catch (IndexOutOfBoundsException e) {
                throw new RuntimeException("Length of values is " + LOLTensorData.this._values.size() + " but of dimension " + index + " is " + dimension.size(), e);
            }
        }

        @Override
        public int getInt(int index) {
            return (Integer)this.getValue(index);
        }

        @Override
        public long getLong(int index) {
            return (Long)this.getValue(index);
        }

        @Override
        public float getFloat(int index) {
            return ((Float)this.getValue(index)).floatValue();
        }

        @Override
        public String getString(int index) {
            return (String)this.getValue(index);
        }

        @Override
        public double getDouble(int index) {
            return (Double)this.getValue(index);
        }

        @Override
        public boolean getBoolean(int index) {
            return (Boolean)this.getValue(index);
        }

        @Override
        public byte[] getBytes(int index) {
            return (byte[])this.getValue(index);
        }

        @Override
        public void next() {
            ++this._position;
        }

        @Override
        public TensorIterator getCopy() {
            return new LOLTensorIterator(this._position);
        }
    }
}

