/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common.tensor;

import com.linkedin.feathr.common.tensor.ReadableTuple;
import com.linkedin.feathr.common.tensor.Representable;
import com.linkedin.feathr.common.tensor.WriteableTuple;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public enum Primitive implements Serializable,
Representable
{
    INT{

        @Override
        public int toInt(ReadableTuple tuple, int column) {
            return tuple.getInt(column);
        }

        @Override
        public long toLong(ReadableTuple tuple, int column) {
            return tuple.getInt(column);
        }

        @Override
        public float toFloat(ReadableTuple tuple, int column) {
            return tuple.getInt(column);
        }

        @Override
        public double toDouble(ReadableTuple tuple, int column) {
            return tuple.getInt(column);
        }

        @Override
        public boolean toBoolean(ReadableTuple tuple, int column) {
            return tuple.getInt(column) != 0;
        }

        @Override
        public String toString(ReadableTuple tuple, int column) {
            return String.valueOf(tuple.getInt(column));
        }

        @Override
        public Object toObject(ReadableTuple tuple, int column) {
            return tuple.getInt(column);
        }

        @Override
        public byte[] toBytes(ReadableTuple tuple, int column) {
            return ByteBuffer.allocate(4).putInt(tuple.getInt(column)).array();
        }

        @Override
        public void from(Number value, WriteableTuple tuple, int column) {
            tuple.setInt(column, value.intValue());
        }

        @Override
        public void from(int value, WriteableTuple tuple, int column) {
            tuple.setInt(column, value);
        }

        @Override
        public void from(long value, WriteableTuple tuple, int column) {
            tuple.setInt(column, (int)value);
        }

        @Override
        public void from(float value, WriteableTuple tuple, int column) {
            tuple.setInt(column, (int)value);
        }

        @Override
        public void from(double value, WriteableTuple tuple, int column) {
            tuple.setInt(column, (int)value);
        }

        @Override
        public void from(boolean value, WriteableTuple tuple, int column) {
            tuple.setInt(column, value ? 1 : 0);
        }

        @Override
        public void from(String value, WriteableTuple tuple, int column) {
            tuple.setInt(column, Integer.parseInt(value));
        }

        @Override
        public void from(byte[] value, WriteableTuple tuple, int column) {
            tuple.setInt(column, ByteBuffer.wrap(value).getInt());
        }

        @Override
        public void copy(ReadableTuple fromTuple, int fromColumn, WriteableTuple toTuple, int toColumn) {
            toTuple.setInt(toColumn, fromTuple.getInt(fromColumn));
        }

        @Override
        public boolean equals(ReadableTuple leftTuple, int leftColumn, ReadableTuple rightTuple, int rightColumn) {
            return leftTuple.getInt(leftColumn) == rightTuple.getInt(rightColumn);
        }

        @Override
        public int compare(ReadableTuple leftTuple, int leftColumn, ReadableTuple rightTuple, int rightColumn) {
            return Integer.compare(leftTuple.getInt(leftColumn), rightTuple.getInt(rightColumn));
        }

        @Override
        public boolean canBeDenseDimension() {
            return true;
        }

        @Override
        public boolean canBeValue() {
            return true;
        }

        @Override
        public boolean isInstance(Object obj) {
            return obj instanceof Integer;
        }
    }
    ,
    LONG{

        @Override
        public int toInt(ReadableTuple tuple, int column) {
            return (int)tuple.getLong(column);
        }

        @Override
        public long toLong(ReadableTuple tuple, int column) {
            return tuple.getLong(column);
        }

        @Override
        public float toFloat(ReadableTuple tuple, int column) {
            return tuple.getLong(column);
        }

        @Override
        public double toDouble(ReadableTuple tuple, int column) {
            return tuple.getLong(column);
        }

        @Override
        public boolean toBoolean(ReadableTuple tuple, int column) {
            return tuple.getLong(column) != 0L;
        }

        @Override
        public String toString(ReadableTuple tuple, int column) {
            return String.valueOf(tuple.getLong(column));
        }

        @Override
        public Object toObject(ReadableTuple tuple, int column) {
            return tuple.getLong(column);
        }

        @Override
        public byte[] toBytes(ReadableTuple tuple, int column) {
            return ByteBuffer.allocate(8).putLong(tuple.getLong(column)).array();
        }

        @Override
        public void from(Number value, WriteableTuple tuple, int column) {
            tuple.setLong(column, value.longValue());
        }

        @Override
        public void from(int value, WriteableTuple tuple, int column) {
            tuple.setLong(column, value);
        }

        @Override
        public void from(long value, WriteableTuple tuple, int column) {
            tuple.setLong(column, value);
        }

        @Override
        public void from(float value, WriteableTuple tuple, int column) {
            tuple.setLong(column, (long)value);
        }

        @Override
        public void from(double value, WriteableTuple tuple, int column) {
            tuple.setLong(column, (long)value);
        }

        @Override
        public void from(boolean value, WriteableTuple tuple, int column) {
            tuple.setLong(column, value ? 1L : 0L);
        }

        @Override
        public void from(String value, WriteableTuple tuple, int column) {
            tuple.setLong(column, Long.parseLong(value));
        }

        @Override
        public void from(byte[] value, WriteableTuple tuple, int column) {
            tuple.setLong(column, ByteBuffer.wrap(value).getLong());
        }

        @Override
        public void copy(ReadableTuple fromTuple, int fromColumn, WriteableTuple toTuple, int toColumn) {
            toTuple.setLong(toColumn, fromTuple.getLong(fromColumn));
        }

        @Override
        public boolean equals(ReadableTuple leftTuple, int leftColumn, ReadableTuple rightTuple, int rightColumn) {
            return leftTuple.getLong(leftColumn) == rightTuple.getLong(rightColumn);
        }

        @Override
        public int compare(ReadableTuple leftTuple, int leftColumn, ReadableTuple rightTuple, int rightColumn) {
            return Long.compare(leftTuple.getLong(leftColumn), rightTuple.getLong(rightColumn));
        }

        @Override
        public boolean canBeDenseDimension() {
            return true;
        }

        @Override
        public boolean canBeValue() {
            return true;
        }

        @Override
        public boolean isInstance(Object obj) {
            return obj instanceof Long;
        }
    }
    ,
    FLOAT{

        @Override
        public int toInt(ReadableTuple tuple, int column) {
            return (int)tuple.getFloat(column);
        }

        @Override
        public long toLong(ReadableTuple tuple, int column) {
            return (long)tuple.getFloat(column);
        }

        @Override
        public float toFloat(ReadableTuple tuple, int column) {
            return tuple.getFloat(column);
        }

        @Override
        public double toDouble(ReadableTuple tuple, int column) {
            return tuple.getFloat(column);
        }

        @Override
        public boolean toBoolean(ReadableTuple tuple, int column) {
            return tuple.getFloat(column) != 0.0f;
        }

        @Override
        public String toString(ReadableTuple tuple, int column) {
            return String.valueOf(tuple.getFloat(column));
        }

        @Override
        public Object toObject(ReadableTuple tuple, int column) {
            return Float.valueOf(tuple.getFloat(column));
        }

        @Override
        public byte[] toBytes(ReadableTuple tuple, int column) {
            return ByteBuffer.allocate(4).putFloat(tuple.getFloat(column)).array();
        }

        @Override
        public void from(Number value, WriteableTuple tuple, int column) {
            tuple.setFloat(column, value.floatValue());
        }

        @Override
        public void from(int value, WriteableTuple tuple, int column) {
            tuple.setFloat(column, value);
        }

        @Override
        public void from(long value, WriteableTuple tuple, int column) {
            tuple.setFloat(column, value);
        }

        @Override
        public void from(float value, WriteableTuple tuple, int column) {
            tuple.setFloat(column, value);
        }

        @Override
        public void from(double value, WriteableTuple tuple, int column) {
            tuple.setFloat(column, (float)value);
        }

        @Override
        public void from(boolean value, WriteableTuple tuple, int column) {
            tuple.setFloat(column, value ? 1.0f : 0.0f);
        }

        @Override
        public void from(String value, WriteableTuple tuple, int column) {
            tuple.setFloat(column, Float.parseFloat(value));
        }

        @Override
        public void from(byte[] value, WriteableTuple tuple, int column) {
            tuple.setFloat(column, ByteBuffer.wrap(value).getFloat());
        }

        @Override
        public void copy(ReadableTuple fromTuple, int fromColumn, WriteableTuple toTuple, int toColumn) {
            toTuple.setFloat(toColumn, fromTuple.getFloat(fromColumn));
        }

        @Override
        public boolean equals(ReadableTuple leftTuple, int leftColumn, ReadableTuple rightTuple, int rightColumn) {
            return leftTuple.getFloat(leftColumn) == rightTuple.getFloat(rightColumn);
        }

        @Override
        public int compare(ReadableTuple leftTuple, int leftColumn, ReadableTuple rightTuple, int rightColumn) {
            return Float.compare(leftTuple.getFloat(leftColumn), rightTuple.getFloat(rightColumn));
        }

        @Override
        public boolean canBeDenseDimension() {
            return false;
        }

        @Override
        public boolean canBeValue() {
            return true;
        }

        @Override
        public boolean isInstance(Object obj) {
            return obj instanceof Float;
        }
    }
    ,
    DOUBLE{

        @Override
        public int toInt(ReadableTuple tuple, int column) {
            return (int)tuple.getDouble(column);
        }

        @Override
        public long toLong(ReadableTuple tuple, int column) {
            return (long)tuple.getDouble(column);
        }

        @Override
        public float toFloat(ReadableTuple tuple, int column) {
            return (float)tuple.getDouble(column);
        }

        @Override
        public double toDouble(ReadableTuple tuple, int column) {
            return tuple.getDouble(column);
        }

        @Override
        public boolean toBoolean(ReadableTuple tuple, int column) {
            return tuple.getDouble(column) != 0.0;
        }

        @Override
        public String toString(ReadableTuple tuple, int column) {
            return String.valueOf(tuple.getDouble(column));
        }

        @Override
        public Object toObject(ReadableTuple tuple, int column) {
            return tuple.getDouble(column);
        }

        @Override
        public byte[] toBytes(ReadableTuple tuple, int column) {
            return ByteBuffer.allocate(8).putDouble(tuple.getDouble(column)).array();
        }

        @Override
        public void from(Number value, WriteableTuple tuple, int column) {
            tuple.setDouble(column, value.doubleValue());
        }

        @Override
        public void from(int value, WriteableTuple tuple, int column) {
            tuple.setDouble(column, value);
        }

        @Override
        public void from(long value, WriteableTuple tuple, int column) {
            tuple.setDouble(column, value);
        }

        @Override
        public void from(float value, WriteableTuple tuple, int column) {
            tuple.setDouble(column, value);
        }

        @Override
        public void from(double value, WriteableTuple tuple, int column) {
            tuple.setDouble(column, value);
        }

        @Override
        public void from(boolean value, WriteableTuple tuple, int column) {
            tuple.setDouble(column, value ? 1.0 : 0.0);
        }

        @Override
        public void from(String value, WriteableTuple tuple, int column) {
            tuple.setDouble(column, Double.parseDouble(value));
        }

        @Override
        public void from(byte[] value, WriteableTuple tuple, int column) {
            tuple.setDouble(column, ByteBuffer.wrap(value).getDouble());
        }

        @Override
        public void copy(ReadableTuple fromTuple, int fromColumn, WriteableTuple toTuple, int toColumn) {
            toTuple.setDouble(toColumn, fromTuple.getDouble(fromColumn));
        }

        @Override
        public boolean equals(ReadableTuple leftTuple, int leftColumn, ReadableTuple rightTuple, int rightColumn) {
            return leftTuple.getDouble(leftColumn) == rightTuple.getDouble(rightColumn);
        }

        @Override
        public int compare(ReadableTuple leftTuple, int leftColumn, ReadableTuple rightTuple, int rightColumn) {
            return Double.compare(leftTuple.getDouble(leftColumn), rightTuple.getDouble(rightColumn));
        }

        @Override
        public boolean canBeDenseDimension() {
            return false;
        }

        @Override
        public boolean canBeValue() {
            return true;
        }

        @Override
        public boolean isInstance(Object obj) {
            return obj instanceof Double;
        }
    }
    ,
    BOOLEAN{

        @Override
        public int toInt(ReadableTuple tuple, int column) {
            return tuple.getBoolean(column) ? 1 : 0;
        }

        @Override
        public long toLong(ReadableTuple tuple, int column) {
            return tuple.getBoolean(column) ? 1L : 0L;
        }

        @Override
        public float toFloat(ReadableTuple tuple, int column) {
            return tuple.getBoolean(column) ? 1.0f : 0.0f;
        }

        @Override
        public double toDouble(ReadableTuple tuple, int column) {
            return tuple.getBoolean(column) ? 1.0 : 0.0;
        }

        @Override
        public String toString(ReadableTuple tuple, int column) {
            return String.valueOf(tuple.getBoolean(column));
        }

        @Override
        public boolean toBoolean(ReadableTuple tuple, int column) {
            return tuple.getBoolean(column);
        }

        @Override
        public Object toObject(ReadableTuple tuple, int column) {
            return tuple.getBoolean(column);
        }

        @Override
        public byte[] toBytes(ReadableTuple tuple, int column) {
            return ByteBuffer.allocate(1).put((byte)(tuple.getBoolean(column) ? 1 : 0)).array();
        }

        @Override
        public void from(Number value, WriteableTuple tuple, int column) {
            tuple.setBoolean(column, value.intValue() != 0);
        }

        @Override
        public void from(int value, WriteableTuple tuple, int column) {
            tuple.setBoolean(column, value != 0);
        }

        @Override
        public void from(long value, WriteableTuple tuple, int column) {
            tuple.setBoolean(column, value != 0L);
        }

        @Override
        public void from(float value, WriteableTuple tuple, int column) {
            tuple.setBoolean(column, value != 0.0f);
        }

        @Override
        public void from(double value, WriteableTuple tuple, int column) {
            tuple.setBoolean(column, value != 0.0);
        }

        @Override
        public void from(boolean value, WriteableTuple tuple, int column) {
            tuple.setBoolean(column, value);
        }

        @Override
        public void from(String value, WriteableTuple tuple, int column) {
            tuple.setBoolean(column, Boolean.parseBoolean(value));
        }

        @Override
        public void from(byte[] value, WriteableTuple tuple, int column) {
            tuple.setBoolean(column, ByteBuffer.wrap(value).get() != 0);
        }

        @Override
        public void copy(ReadableTuple fromTuple, int fromColumn, WriteableTuple toTuple, int toColumn) {
            toTuple.setBoolean(toColumn, fromTuple.getBoolean(fromColumn));
        }

        @Override
        public boolean equals(ReadableTuple leftTuple, int leftColumn, ReadableTuple rightTuple, int rightColumn) {
            return leftTuple.getBoolean(leftColumn) == rightTuple.getBoolean(rightColumn);
        }

        @Override
        public int compare(ReadableTuple leftTuple, int leftColumn, ReadableTuple rightTuple, int rightColumn) {
            return Boolean.compare(leftTuple.getBoolean(leftColumn), rightTuple.getBoolean(rightColumn));
        }

        @Override
        public boolean canBeDenseDimension() {
            return true;
        }

        @Override
        public boolean canBeValue() {
            return true;
        }

        @Override
        public boolean isInstance(Object obj) {
            return obj instanceof Boolean;
        }
    }
    ,
    STRING{

        @Override
        public int toInt(ReadableTuple tuple, int column) {
            return Integer.parseInt(tuple.getString(column));
        }

        @Override
        public long toLong(ReadableTuple tuple, int column) {
            return Long.parseLong(tuple.getString(column));
        }

        @Override
        public float toFloat(ReadableTuple tuple, int column) {
            return Float.parseFloat(tuple.getString(column));
        }

        @Override
        public double toDouble(ReadableTuple tuple, int column) {
            return Double.parseDouble(tuple.getString(column));
        }

        @Override
        public boolean toBoolean(ReadableTuple tuple, int column) {
            return Boolean.parseBoolean(tuple.getString(column));
        }

        @Override
        public String toString(ReadableTuple tuple, int column) {
            return tuple.getString(column);
        }

        @Override
        public Object toObject(ReadableTuple tuple, int column) {
            return tuple.getString(column);
        }

        @Override
        public byte[] toBytes(ReadableTuple tuple, int column) {
            try {
                return tuple.getString(column).getBytes(Primitive.DEFAULT_CHARSET);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Encoding UTF-8 is not supported in Primitive.String", e);
            }
        }

        @Override
        public void from(Number value, WriteableTuple tuple, int column) {
            tuple.setString(column, value.toString());
        }

        @Override
        public void from(int value, WriteableTuple tuple, int column) {
            tuple.setString(column, String.valueOf(value));
        }

        @Override
        public void from(long value, WriteableTuple tuple, int column) {
            tuple.setString(column, String.valueOf(value));
        }

        @Override
        public void from(float value, WriteableTuple tuple, int column) {
            tuple.setString(column, String.valueOf(value));
        }

        @Override
        public void from(double value, WriteableTuple tuple, int column) {
            tuple.setString(column, String.valueOf(value));
        }

        @Override
        public void from(boolean value, WriteableTuple tuple, int column) {
            tuple.setString(column, String.valueOf(value));
        }

        @Override
        public void from(String value, WriteableTuple tuple, int column) {
            tuple.setString(column, value);
        }

        @Override
        public void from(byte[] value, WriteableTuple tuple, int column) {
            try {
                tuple.setString(column, new String(value, Primitive.DEFAULT_CHARSET));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Encoding UTF-8 is not supported in Primitive.String", e);
            }
        }

        @Override
        public void copy(ReadableTuple fromTuple, int fromColumn, WriteableTuple toTuple, int toColumn) {
            toTuple.setString(toColumn, fromTuple.getString(fromColumn));
        }

        @Override
        public boolean equals(ReadableTuple leftTuple, int leftColumn, ReadableTuple rightTuple, int rightColumn) {
            return leftTuple.getString(leftColumn).equals(rightTuple.getString(rightColumn));
        }

        @Override
        public int compare(ReadableTuple leftTuple, int leftColumn, ReadableTuple rightTuple, int rightColumn) {
            return leftTuple.getString(leftColumn).compareTo(rightTuple.getString(rightColumn));
        }

        @Override
        public boolean canBeDenseDimension() {
            return false;
        }

        @Override
        public boolean canBeValue() {
            return true;
        }

        @Override
        public boolean isInstance(Object obj) {
            return obj instanceof String;
        }
    }
    ,
    BYTES{

        @Override
        public int toInt(ReadableTuple tuple, int column) {
            return ByteBuffer.wrap(tuple.getBytes(column)).getInt();
        }

        @Override
        public long toLong(ReadableTuple tuple, int column) {
            return ByteBuffer.wrap(tuple.getBytes(column)).getLong();
        }

        @Override
        public float toFloat(ReadableTuple tuple, int column) {
            return ByteBuffer.wrap(tuple.getBytes(column)).getFloat();
        }

        @Override
        public double toDouble(ReadableTuple tuple, int column) {
            return ByteBuffer.wrap(tuple.getBytes(column)).getDouble();
        }

        @Override
        public boolean toBoolean(ReadableTuple tuple, int column) {
            return ByteBuffer.wrap(tuple.getBytes(column)).get() != 0;
        }

        @Override
        public String toString(ReadableTuple tuple, int column) {
            try {
                return new String(tuple.getBytes(column), Primitive.DEFAULT_CHARSET);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Encoding UTF-8 is not supported in Primitive.String", e);
            }
        }

        @Override
        public Object toObject(ReadableTuple tuple, int column) {
            return tuple.getBytes(column);
        }

        @Override
        public byte[] toBytes(ReadableTuple tuple, int column) {
            return tuple.getBytes(column);
        }

        @Override
        public void from(Number value, WriteableTuple tuple, int column) {
            tuple.setBytes(column, ByteBuffer.allocate(8).putDouble(value.doubleValue()).array());
        }

        @Override
        public void from(int value, WriteableTuple tuple, int column) {
            tuple.setBytes(column, ByteBuffer.allocate(4).putInt(value).array());
        }

        @Override
        public void from(long value, WriteableTuple tuple, int column) {
            tuple.setBytes(column, ByteBuffer.allocate(8).putLong(value).array());
        }

        @Override
        public void from(float value, WriteableTuple tuple, int column) {
            tuple.setBytes(column, ByteBuffer.allocate(4).putFloat(value).array());
        }

        @Override
        public void from(double value, WriteableTuple tuple, int column) {
            tuple.setBytes(column, ByteBuffer.allocate(8).putDouble(value).array());
        }

        @Override
        public void from(boolean value, WriteableTuple tuple, int column) {
            tuple.setBytes(column, new byte[]{(byte)(value ? 1 : 0)});
        }

        @Override
        public void from(String value, WriteableTuple tuple, int column) {
            try {
                tuple.setBytes(column, value.getBytes(Primitive.DEFAULT_CHARSET));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Encoding UTF-8 is not supported in Primitive.String", e);
            }
        }

        @Override
        public void from(byte[] value, WriteableTuple tuple, int column) {
            tuple.setBytes(column, value);
        }

        @Override
        public void copy(ReadableTuple fromTuple, int fromColumn, WriteableTuple toTuple, int toColumn) {
            toTuple.setBytes(toColumn, fromTuple.getBytes(fromColumn));
        }

        @Override
        public boolean equals(ReadableTuple leftTuple, int leftColumn, ReadableTuple rightTuple, int rightColumn) {
            return Arrays.equals(leftTuple.getBytes(leftColumn), rightTuple.getBytes(rightColumn));
        }

        @Override
        public int compare(ReadableTuple leftTuple, int leftColumn, ReadableTuple rightTuple, int rightColumn) {
            int j;
            byte[] l = leftTuple.getBytes(leftColumn);
            byte[] r = rightTuple.getBytes(rightColumn);
            int i = 0;
            for (j = 0; i < l.length && j < r.length; ++i, ++j) {
                if (l[i] == r[j]) continue;
                return Byte.compare(l[i], r[j]);
            }
            if (i == l.length && j == r.length) {
                return 0;
            }
            if (j == r.length) {
                return 1;
            }
            return -1;
        }

        @Override
        public boolean canBeDenseDimension() {
            return false;
        }

        @Override
        public boolean canBeValue() {
            return true;
        }

        @Override
        public boolean isInstance(Object obj) {
            return obj instanceof byte[];
        }
    };

    private static final String DEFAULT_CHARSET = "UTF-8";

    @Override
    public Primitive getRepresentation() {
        return this;
    }

    public abstract int toInt(ReadableTuple var1, int var2);

    public abstract long toLong(ReadableTuple var1, int var2);

    public abstract float toFloat(ReadableTuple var1, int var2);

    public abstract double toDouble(ReadableTuple var1, int var2);

    public abstract boolean toBoolean(ReadableTuple var1, int var2);

    public abstract String toString(ReadableTuple var1, int var2);

    public abstract byte[] toBytes(ReadableTuple var1, int var2);

    public abstract Object toObject(ReadableTuple var1, int var2);

    public void from(Object value, WriteableTuple tuple, int column) {
        if (value instanceof Number) {
            this.from((Number)value, tuple, column);
        } else if (value instanceof String) {
            this.from((String)value, tuple, column);
        } else if (value instanceof Boolean) {
            this.from((Boolean)value, tuple, column);
        } else if (value instanceof byte[]) {
            this.from((byte[])value, tuple, column);
        } else {
            throw new IllegalArgumentException("Unsupported value class: " + value);
        }
    }

    public abstract void from(Number var1, WriteableTuple var2, int var3);

    public abstract void from(int var1, WriteableTuple var2, int var3);

    public abstract void from(long var1, WriteableTuple var3, int var4);

    public abstract void from(float var1, WriteableTuple var2, int var3);

    public abstract void from(double var1, WriteableTuple var3, int var4);

    public abstract void from(boolean var1, WriteableTuple var2, int var3);

    public abstract void from(String var1, WriteableTuple var2, int var3);

    public abstract void from(byte[] var1, WriteableTuple var2, int var3);

    public abstract void copy(ReadableTuple var1, int var2, WriteableTuple var3, int var4);

    public abstract boolean equals(ReadableTuple var1, int var2, ReadableTuple var3, int var4);

    public abstract int compare(ReadableTuple var1, int var2, ReadableTuple var3, int var4);

    public abstract boolean canBeDenseDimension();

    public abstract boolean canBeValue();

    public abstract boolean isInstance(Object var1);
}

