/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common.tensor;

import com.linkedin.feathr.common.tensor.DimensionType;
import com.linkedin.feathr.common.tensor.Primitive;
import com.linkedin.feathr.common.tensor.WriteableTuple;
import java.util.Objects;

public final class PrimitiveDimensionType
extends DimensionType {
    public static final PrimitiveDimensionType LONG = new PrimitiveDimensionType(Primitive.LONG);
    public static final PrimitiveDimensionType INT = new PrimitiveDimensionType(Primitive.INT);
    public static final PrimitiveDimensionType STRING = new PrimitiveDimensionType(Primitive.STRING);
    public static final PrimitiveDimensionType BOOLEAN = new PrimitiveDimensionType(Primitive.BOOLEAN, 2);
    public static final PrimitiveDimensionType BYTES = new PrimitiveDimensionType(Primitive.BYTES);
    private final Primitive _primitive;
    private final int _shape;

    public PrimitiveDimensionType(Primitive primitive, int shape) {
        if (shape != -1 && !primitive.canBeDenseDimension()) {
            throw new IllegalArgumentException("The type " + primitive + " can not be dense so cannot have a shape.");
        }
        this._primitive = primitive;
        this._shape = shape;
    }

    public PrimitiveDimensionType(Primitive primitive) {
        this(primitive, -1);
    }

    public PrimitiveDimensionType withShape(int shape) {
        return new PrimitiveDimensionType(this._primitive, shape);
    }

    @Override
    public int getShape() {
        return this._shape;
    }

    @Override
    public Primitive getRepresentation() {
        return this._primitive;
    }

    @Override
    public String getName() {
        if (this._shape == -1 || this._primitive == Primitive.BOOLEAN) {
            return this._primitive.name();
        }
        return this._primitive.name() + "(" + this._shape + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrimitiveDimensionType that = (PrimitiveDimensionType)o;
        return this._shape == that._shape && this._primitive == that._primitive;
    }

    public int hashCode() {
        return Objects.hash(this._primitive, this._shape);
    }

    @Override
    public void setDimensionValue(WriteableTuple target, int column, Object dimensionValue) {
        int index;
        if (this._shape != -1 && dimensionValue instanceof Number && ((index = ((Number)dimensionValue).intValue()) < 0 || index >= this._shape)) {
            throw new IllegalArgumentException("The passed value " + dimensionValue + " is out of bound for [0, " + this._shape + ").");
        }
        super.setDimensionValue(target, column, dimensionValue);
    }

    public String toString() {
        return this.getRepresentation() + (this.getShape() == -1 ? "" : "(" + this.getShape() + ")");
    }
}

