/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common.tensor;

import com.linkedin.feathr.common.ColumnUtils;
import com.linkedin.feathr.common.tensor.ReadableTuple;
import com.linkedin.feathr.common.tensor.Representable;
import com.linkedin.feathr.common.tensor.WriteableTuple;
import java.util.Arrays;

public class SimpleWriteableTuple<T extends WriteableTuple<T>>
extends ColumnUtils
implements WriteableTuple<T>,
ReadableTuple {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    private static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    private static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Object[] EMPTY_BYTE_ARRAY = new Object[0];
    private final int[] _intArray;
    private final long[] _longArray;
    private final float[] _floatArray;
    private final double[] _doubleArray;
    private final boolean[] _booleanArray;
    private final String[] _stringArray;
    private final Object[] _bytesArray;

    public SimpleWriteableTuple(Representable[] types) {
        super(types);
        this._intArray = this._intArity == 0 ? EMPTY_INT_ARRAY : new int[this._intArity];
        this._longArray = this._longArity == 0 ? EMPTY_LONG_ARRAY : new long[this._longArity];
        this._stringArray = this._stringArity == 0 ? EMPTY_STRING_ARRAY : new String[this._stringArity];
        this._floatArray = this._floatArity == 0 ? EMPTY_FLOAT_ARRAY : new float[this._floatArity];
        this._doubleArray = this._doubleArity == 0 ? EMPTY_DOUBLE_ARRAY : new double[this._doubleArity];
        this._booleanArray = this._booleanArity == 0 ? EMPTY_BOOLEAN_ARRAY : new boolean[this._booleanArity];
        this._bytesArray = this._bytesArity == 0 ? EMPTY_BYTE_ARRAY : new Object[this._bytesArity];
    }

    SimpleWriteableTuple(SimpleWriteableTuple other) {
        super(other._columnTypes);
        this._intArray = other._intArray == EMPTY_INT_ARRAY ? EMPTY_INT_ARRAY : (int[])other._intArray.clone();
        this._longArray = other._longArray == EMPTY_LONG_ARRAY ? EMPTY_LONG_ARRAY : (long[])other._longArray.clone();
        this._floatArray = other._floatArray == EMPTY_FLOAT_ARRAY ? EMPTY_FLOAT_ARRAY : (float[])other._floatArray.clone();
        this._doubleArray = other._doubleArray == EMPTY_DOUBLE_ARRAY ? EMPTY_DOUBLE_ARRAY : (double[])other._doubleArray.clone();
        this._stringArray = other._stringArray == EMPTY_STRING_ARRAY ? EMPTY_STRING_ARRAY : (String[])other._stringArray.clone();
        this._booleanArray = other._booleanArray == EMPTY_BOOLEAN_ARRAY ? EMPTY_BOOLEAN_ARRAY : (boolean[])other._booleanArray.clone();
        this._bytesArray = other._bytesArray == EMPTY_BYTE_ARRAY ? EMPTY_BYTE_ARRAY : (Object[])other._bytesArray.clone();
    }

    @Override
    public Representable[] getTypes() {
        return this._columnTypes;
    }

    @Override
    public int getInt(int column) {
        return this._intArray[this._columnIndex[column]];
    }

    @Override
    public long getLong(int column) {
        return this._longArray[this._columnIndex[column]];
    }

    @Override
    public float getFloat(int column) {
        return this._floatArray[this._columnIndex[column]];
    }

    @Override
    public double getDouble(int column) {
        return this._doubleArray[this._columnIndex[column]];
    }

    @Override
    public boolean getBoolean(int column) {
        return this._booleanArray[this._columnIndex[column]];
    }

    @Override
    public String getString(int column) {
        return this._stringArray[this._columnIndex[column]];
    }

    @Override
    public byte[] getBytes(int column) {
        return (byte[])this._bytesArray[this._columnIndex[column]];
    }

    @Override
    public ReadableTuple getCopy() {
        return new SimpleWriteableTuple<T>(this);
    }

    @Override
    public T setInt(int column, int value) {
        this._intArray[this._columnIndex[column]] = value;
        return (T)this;
    }

    @Override
    public T setLong(int column, long value) {
        this._longArray[this._columnIndex[column]] = value;
        return (T)this;
    }

    @Override
    public T setFloat(int column, float value) {
        this._floatArray[this._columnIndex[column]] = value;
        return (T)this;
    }

    @Override
    public T setDouble(int column, double value) {
        this._doubleArray[this._columnIndex[column]] = value;
        return (T)this;
    }

    @Override
    public T setBoolean(int column, boolean value) {
        this._booleanArray[this._columnIndex[column]] = value;
        return (T)this;
    }

    @Override
    public T setString(int column, String value) {
        this._stringArray[this._columnIndex[column]] = value;
        return (T)this;
    }

    @Override
    public T setBytes(int column, byte[] value) {
        this._bytesArray[this._columnIndex[column]] = value;
        return (T)this;
    }

    public void resetColumns() {
        Arrays.fill(this._intArray, 0);
        Arrays.fill(this._longArray, 0L);
        Arrays.fill(this._floatArray, 0.0f);
        Arrays.fill(this._doubleArray, 0.0);
        Arrays.fill(this._booleanArray, false);
        Arrays.fill(this._stringArray, null);
        Arrays.fill(this._bytesArray, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleWriteableTuple that = (SimpleWriteableTuple)o;
        return Arrays.equals(this._intArray, that._intArray) && Arrays.equals(this._longArray, that._longArray) && Arrays.equals(this._floatArray, that._floatArray) && Arrays.equals(this._doubleArray, that._doubleArray) && Arrays.equals(this._stringArray, that._stringArray) && Arrays.equals(this._booleanArray, that._booleanArray) && Arrays.equals(this._bytesArray, that._bytesArray);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this._intArray);
        result = 31 * result + Arrays.hashCode(this._longArray);
        result = 31 * result + Arrays.hashCode(this._floatArray);
        result = 31 * result + Arrays.hashCode(this._doubleArray);
        result = 31 * result + Arrays.hashCode(this._stringArray);
        result = 31 * result + Arrays.hashCode(this._booleanArray);
        result = 31 * result + Arrays.hashCode(this._bytesArray);
        return result;
    }
}

