/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common.tensor;

import com.linkedin.feathr.common.ColumnUtils;
import com.linkedin.feathr.common.Equal;
import com.linkedin.feathr.common.Hasher;
import com.linkedin.feathr.common.tensor.ReadableTuple;
import com.linkedin.feathr.common.tensor.Representable;
import java.util.Arrays;

public class StandaloneReadableTuple
implements ReadableTuple {
    private final Representable[] _columnTypes;
    private final int[] _columnIndex;
    private final int[] _ints;
    private final long[] _longs;
    private final String[] _strings;
    private final float[] _floats;
    private final boolean[] _booleans;
    private final Object[] _byteArrays;
    private int _hash = 0;

    public StandaloneReadableTuple(StandaloneReadableTuple standaloneReadableTuple) {
        this._columnTypes = standaloneReadableTuple._columnTypes;
        this._columnIndex = standaloneReadableTuple._columnIndex;
        this._ints = standaloneReadableTuple._ints;
        this._longs = standaloneReadableTuple._longs;
        this._strings = standaloneReadableTuple._strings;
        this._floats = standaloneReadableTuple._floats;
        this._booleans = standaloneReadableTuple._booleans;
        this._byteArrays = standaloneReadableTuple._byteArrays;
        this._hash = standaloneReadableTuple._hash;
    }

    public StandaloneReadableTuple(ReadableTuple readableTuple) {
        this(readableTuple, false);
    }

    public StandaloneReadableTuple(ReadableTuple readableTuple, boolean dimOnly) {
        ColumnUtils columnUtils = new ColumnUtils(readableTuple.getTypes());
        Representable[] columnTypes = columnUtils.getColumnTypes();
        int[] columnIndex = columnUtils.getColumnIndex();
        int numColumnsToCopy = dimOnly ? ColumnUtils.getDimArity(columnTypes) : columnTypes.length;
        this._columnTypes = columnTypes.length == numColumnsToCopy ? columnTypes : Arrays.copyOf(columnTypes, numColumnsToCopy);
        this._columnIndex = columnTypes.length == numColumnsToCopy ? columnIndex : Arrays.copyOf(columnIndex, numColumnsToCopy);
        this._ints = new int[columnUtils.getIntArity()];
        this._longs = new long[columnUtils.getLongArity()];
        this._strings = new String[columnUtils.getStringArity()];
        this._floats = new float[columnUtils.getFloatArity()];
        this._booleans = new boolean[columnUtils.getBooleanArity()];
        this._byteArrays = new Object[columnUtils.getBytesArity()];
        this.copyData(readableTuple, numColumnsToCopy);
    }

    private void copyData(ReadableTuple readableTuple, int dimArity) {
        int intCount = 0;
        int longCount = 0;
        int stringCount = 0;
        int floatCount = 0;
        int booleanCount = 0;
        int byteArrayCount = 0;
        block8: for (int j = 0; j < dimArity; ++j) {
            switch (this._columnTypes[j].getRepresentation()) {
                case INT: {
                    this._ints[intCount] = readableTuple.getInt(j);
                    ++intCount;
                    continue block8;
                }
                case LONG: {
                    this._longs[longCount] = readableTuple.getLong(j);
                    ++longCount;
                    continue block8;
                }
                case STRING: {
                    this._strings[stringCount] = readableTuple.getString(j);
                    ++stringCount;
                    continue block8;
                }
                case FLOAT: {
                    this._floats[floatCount] = readableTuple.getFloat(j);
                    ++floatCount;
                    continue block8;
                }
                case BOOLEAN: {
                    this._booleans[booleanCount] = readableTuple.getBoolean(j);
                    ++booleanCount;
                    continue block8;
                }
                case BYTES: {
                    this._byteArrays[byteArrayCount] = readableTuple.getBytes(j);
                    ++byteArrayCount;
                    continue block8;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported column type:" + this._columnTypes[j].getRepresentation());
                }
            }
        }
    }

    @Override
    public Representable[] getTypes() {
        return this._columnTypes;
    }

    @Override
    public int getInt(int column) {
        return this._ints[this._columnIndex[column]];
    }

    @Override
    public long getLong(int column) {
        return this._longs[this._columnIndex[column]];
    }

    @Override
    public float getFloat(int column) {
        return this._floats[this._columnIndex[column]];
    }

    @Override
    public double getDouble(int column) {
        throw new UnsupportedOperationException("StandaloneReadableTuple doesn't support doubles");
    }

    @Override
    public boolean getBoolean(int column) {
        return this._booleans[this._columnIndex[column]];
    }

    @Override
    public String getString(int column) {
        return this._strings[this._columnIndex[column]];
    }

    @Override
    public byte[] getBytes(int column) {
        return (byte[])this._byteArrays[this._columnIndex[column]];
    }

    @Override
    public ReadableTuple getCopy() {
        return new StandaloneReadableTuple(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReadableTuple)) {
            return false;
        }
        if (o instanceof StandaloneReadableTuple) {
            StandaloneReadableTuple that = (StandaloneReadableTuple)o;
            return Arrays.equals(this._columnTypes, that._columnTypes) && Arrays.equals(this._columnIndex, that._columnIndex) && Arrays.equals(this._ints, that._ints) && Arrays.equals(this._longs, that._longs) && Arrays.equals(this._strings, that._strings) && Arrays.equals(this._floats, that._floats) && Arrays.equals(this._booleans, that._booleans);
        }
        ReadableTuple readableTuple = (ReadableTuple)o;
        return Arrays.equals(this._columnTypes, readableTuple.getTypes()) && Equal.tupleEquals(this, readableTuple, this._columnTypes, this._columnTypes.length);
    }

    public int hashCode() {
        if (this._hash == 0) {
            this._hash = Hasher.getHash(this, this._columnTypes.length);
        }
        return this._hash;
    }
}

