/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common.tensor.dense;

import com.linkedin.feathr.common.tensor.DenseTensor;
import com.linkedin.feathr.common.tensor.Primitive;
import com.linkedin.feathr.common.tensor.Representable;
import com.linkedin.feathr.common.tensor.TensorData;
import com.linkedin.feathr.common.tensor.TensorIterator;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;

public abstract class ByteBufferDenseTensor
extends DenseTensor {
    protected final ByteBuffer _byteBuffer;
    protected final int _start;
    protected final int _limit;
    protected final long[] _shape;
    protected final int _cardinality;
    protected final Representable[] _types;
    private final int _elementSize;

    public ByteBufferDenseTensor(ByteBuffer byteBuffer, long[] shape, Primitive type, int bytes) {
        this(byteBuffer, shape, ByteBufferDenseTensor.genRepresentables(type, shape.length), ByteBufferDenseTensor.getCardinality(shape), bytes);
    }

    ByteBufferDenseTensor(ByteBuffer byteBuffer, long[] shape, Representable[] types, int cardinality, int bytes) {
        this._shape = Objects.requireNonNull(shape);
        this._elementSize = bytes;
        this._cardinality = cardinality;
        this._types = types;
        this._byteBuffer = byteBuffer.asReadOnlyBuffer().order(byteBuffer.order());
        this._start = this._byteBuffer.position();
        this._limit = this._byteBuffer.limit();
    }

    public ByteBuffer getByteBuffer() {
        return this.getByteBuffer(true);
    }

    public ByteBuffer getByteBuffer(boolean makeCopy) {
        return makeCopy ? this._byteBuffer.duplicate().order(this._byteBuffer.order()) : this._byteBuffer;
    }

    @Override
    public long[] getShape() {
        return this._shape;
    }

    @Override
    public Representable[] getTypes() {
        return this._types;
    }

    @Override
    public int estimatedCardinality() {
        return this.cardinality();
    }

    @Override
    public int cardinality() {
        return this._cardinality;
    }

    private static int getCardinality(long[] shape) {
        int cardinality = 1;
        for (long n : shape) {
            cardinality = (int)((long)cardinality * n);
        }
        return cardinality;
    }

    private static Representable[] genRepresentables(Primitive valueType, int numDims) {
        Representable[] types = new Representable[numDims + 1];
        for (int i = 0; i < numDims; ++i) {
            types[i] = Primitive.INT;
        }
        types[numDims] = valueType;
        return types;
    }

    abstract class ByteBufferDenseTensorIterator
    implements TensorIterator {
        protected final int[] _indices;
        protected int _position;

        ByteBufferDenseTensorIterator(ByteBufferDenseTensorIterator other) {
            this._position = other._position;
            this._indices = Arrays.copyOf(other._indices, ByteBufferDenseTensor.this._shape.length);
        }

        ByteBufferDenseTensorIterator() {
            this._position = ByteBufferDenseTensor.this._start;
            this._indices = new int[ByteBufferDenseTensor.this._shape.length];
        }

        @Override
        public TensorData getTensorData() {
            return ByteBufferDenseTensor.this;
        }

        @Override
        public void start() {
            this._position = ByteBufferDenseTensor.this._start;
            Arrays.fill(this._indices, 0);
        }

        @Override
        public boolean isValid() {
            return this._position < ByteBufferDenseTensor.this._limit;
        }

        @Override
        public Object getValue(int index) {
            if (index < 0 || index > this._indices.length) {
                throw new IndexOutOfBoundsException("The index " + index + " is out of the expected range 0 <= index <= " + this._indices.length + ".");
            }
            if (index < this._indices.length) {
                return this.getInt(index);
            }
            return this.getValue();
        }

        protected abstract Object getValue();

        @Override
        public int getInt(int index) {
            if (index >= 0 && index < this._indices.length) {
                return this._indices[index];
            }
            throw new IndexOutOfBoundsException("The index " + index + " is out of the expected range 0 <= index < " + this._indices.length + ".");
        }

        @Override
        public long getLong(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public float getFloat(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getBoolean(int column) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] getBytes(int column) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void next() {
            for (int currDim = ByteBufferDenseTensor.this._shape.length - 1; currDim >= 0; --currDim) {
                int n = currDim;
                this._indices[n] = this._indices[n] + 1;
                if (this._indices[currDim] < (int)ByteBufferDenseTensor.this._shape[currDim]) break;
                this._indices[currDim] = 0;
            }
            this._position += ByteBufferDenseTensor.this._elementSize;
        }

        @Override
        public TensorIterator getCopy() {
            throw new UnsupportedOperationException();
        }
    }
}

