/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common.tensor.dense;

import com.linkedin.feathr.common.tensor.Primitive;
import com.linkedin.feathr.common.tensor.Representable;
import com.linkedin.feathr.common.tensor.TensorIterator;
import com.linkedin.feathr.common.tensor.dense.ByteBufferDenseTensor;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class DenseBooleanTensor
extends ByteBufferDenseTensor {
    public DenseBooleanTensor(ByteBuffer byteBuffer, long[] shape) {
        super(byteBuffer, shape, Primitive.BOOLEAN, 1);
    }

    public DenseBooleanTensor(ByteBuffer byteBuffer, long[] shape, Representable[] types, int cardinality) {
        super(byteBuffer, shape, types, cardinality, 1);
    }

    @Override
    public TensorIterator iterator() {
        return new MyIterator();
    }

    @Override
    public List<?> asList() {
        ByteBuffer buffer = this._byteBuffer.asReadOnlyBuffer();
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        ArrayList<Boolean> booleanList = new ArrayList<Boolean>(bytes.length);
        for (byte aByte : bytes) {
            booleanList.add(aByte != 0);
        }
        return booleanList;
    }

    private class MyIterator
    extends ByteBufferDenseTensor.ByteBufferDenseTensorIterator {
        MyIterator() {
            super(DenseBooleanTensor.this);
        }

        MyIterator(ByteBufferDenseTensor.ByteBufferDenseTensorIterator other) {
            super(DenseBooleanTensor.this, other);
        }

        @Override
        public Object getValue() {
            return this.getBoolean(this._indices.length);
        }

        @Override
        public boolean getBoolean(int index) {
            return DenseBooleanTensor.this._byteBuffer.get(this._position) != 0;
        }

        @Override
        public TensorIterator getCopy() {
            return new MyIterator((ByteBufferDenseTensor.ByteBufferDenseTensorIterator)this);
        }
    }
}

