/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common.tensor.dense;

import com.google.common.primitives.Longs;
import com.linkedin.feathr.common.tensor.Primitive;
import com.linkedin.feathr.common.tensor.Representable;
import com.linkedin.feathr.common.tensor.TensorIterator;
import com.linkedin.feathr.common.tensor.dense.ByteBufferDenseTensor;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.util.List;

public class DenseLongTensor
extends ByteBufferDenseTensor {
    public DenseLongTensor(ByteBuffer byteBuffer, long[] shape) {
        super(byteBuffer, shape, Primitive.LONG, 8);
    }

    public DenseLongTensor(ByteBuffer byteBuffer, long[] shape, Representable[] types, int cardinality) {
        super(byteBuffer, shape, types, cardinality, 8);
    }

    @Override
    public TensorIterator iterator() {
        return new MyIterator();
    }

    @Override
    public List<?> asList() {
        LongBuffer longBuffer = this._byteBuffer.asLongBuffer();
        long[] longArray = new long[longBuffer.remaining()];
        longBuffer.get(longArray);
        return Longs.asList((long[])longArray);
    }

    private class MyIterator
    extends ByteBufferDenseTensor.ByteBufferDenseTensorIterator {
        MyIterator() {
            super(DenseLongTensor.this);
        }

        MyIterator(ByteBufferDenseTensor.ByteBufferDenseTensorIterator other) {
            super(DenseLongTensor.this, other);
        }

        @Override
        public Object getValue() {
            return this.getLong(this._indices.length);
        }

        @Override
        public long getLong(int index) {
            return DenseLongTensor.this._byteBuffer.getLong(this._position);
        }

        @Override
        public TensorIterator getCopy() {
            return new MyIterator((ByteBufferDenseTensor.ByteBufferDenseTensorIterator)this);
        }
    }
}

