/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common.tensorbuilder;

import com.linkedin.feathr.common.tensor.Primitive;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class BufferUtils {
    private static final Charset CHARSET = StandardCharsets.UTF_8;

    private BufferUtils() {
    }

    public static ByteBuffer encodeString(String string) {
        return CHARSET.encode(string);
    }

    public static String decodeString(byte[] bytes) {
        return new String(bytes, CHARSET);
    }

    public static String decodeString(ByteBuffer buffer) {
        return CHARSET.decode(buffer).toString();
    }

    public static int compareBytes(byte[] left, byte[] right) {
        int j;
        int i = 0;
        for (j = 0; i < left.length && j < right.length; ++i, ++j) {
            if (left[i] == right[j]) continue;
            return Byte.compare(left[i], right[j]);
        }
        if (i == left.length && j == right.length) {
            return 0;
        }
        if (j == right.length) {
            return 1;
        }
        return -1;
    }

    public static int primitiveSize(Primitive valueType) {
        switch (valueType) {
            case INT: {
                return 4;
            }
            case DOUBLE: {
                return 8;
            }
            case LONG: {
                return 8;
            }
            case FLOAT: {
                return 4;
            }
            case BOOLEAN: {
                return 1;
            }
        }
        throw new IllegalArgumentException("Cannot create ByteBuffer with value type: " + valueType);
    }

    public static ByteBuffer createByteBuffer(List<?> values, Primitive valueType) {
        int count = values.size();
        boolean hasVariableSize = valueType == Primitive.STRING || valueType == Primitive.BYTES;
        ByteBuffer byteBuffer = hasVariableSize ? null : ByteBuffer.allocate(count * BufferUtils.primitiveSize(valueType));
        switch (valueType) {
            case INT: {
                for (Number number : values) {
                    byteBuffer.putInt(number.intValue());
                }
                break;
            }
            case DOUBLE: {
                for (Number number : values) {
                    byteBuffer.putDouble(number.doubleValue());
                }
                break;
            }
            case LONG: {
                for (Number number : values) {
                    byteBuffer.putLong(number.longValue());
                }
                break;
            }
            case FLOAT: {
                for (Number number : values) {
                    byteBuffer.putFloat(number.floatValue());
                }
                break;
            }
            case BOOLEAN: {
                for (ByteBuffer byteBuffer2 : values) {
                    boolean aBoolean;
                    if (byteBuffer2 instanceof Boolean) {
                        aBoolean = (Boolean)((Object)byteBuffer2);
                    } else if (byteBuffer2 instanceof Number) {
                        aBoolean = ((Number)((Object)byteBuffer2)).doubleValue() != 0.0;
                    } else {
                        throw new IllegalArgumentException("Cannot create BOOLEAN buffer from value element type " + byteBuffer2.getClass());
                    }
                    byteBuffer.put(aBoolean ? (byte)1 : 0);
                }
                break;
            }
            case STRING: {
                if (count == 0) {
                    byteBuffer = ByteBuffer.allocate(0);
                    break;
                }
                ByteBuffer first = values.get(0);
                if (first instanceof ByteBuffer) {
                    byteBuffer = BufferUtils.combineByteBuffers(values);
                    break;
                }
                if (first instanceof String) {
                    List<ByteBuffer> list = values;
                    ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(count);
                    for (int i = 0; i < count; ++i) {
                        buffers.add(BufferUtils.encodeString((String)((Object)list.get(i))));
                    }
                    byteBuffer = BufferUtils.combineByteBuffers(buffers);
                    break;
                }
                throw new IllegalArgumentException("Cannot create ByteBuffer from value class: " + first.getClass());
            }
            case BYTES: {
                if (count == 0) {
                    byteBuffer = ByteBuffer.allocate(0);
                    break;
                }
                ByteBuffer first = values.get(0);
                if (first instanceof ByteBuffer) {
                    byteBuffer = BufferUtils.combineByteBuffers(values);
                    break;
                }
                if (first instanceof byte[]) {
                    List<ByteBuffer> list = values;
                    ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(count);
                    for (int i = 0; i < count; ++i) {
                        buffers.add(ByteBuffer.wrap((byte[])list.get(i)));
                    }
                    byteBuffer = BufferUtils.combineByteBuffers(buffers);
                    break;
                }
                throw new IllegalArgumentException("Cannot create ByteBuffer from value class: " + first.getClass());
            }
            default: {
                throw new IllegalArgumentException("Cannot create ByteBuffer with value type: " + valueType);
            }
        }
        return byteBuffer;
    }

    public static ByteBuffer createByteBuffer(float[] floats, Primitive valueType) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(floats.length * BufferUtils.primitiveSize(valueType));
        switch (valueType) {
            case INT: {
                for (float aFloat : floats) {
                    byteBuffer.putInt((int)aFloat);
                }
                break;
            }
            case DOUBLE: {
                for (float aFloat : floats) {
                    byteBuffer.putDouble(aFloat);
                }
                break;
            }
            case LONG: {
                for (float aFloat : floats) {
                    byteBuffer.putLong((long)aFloat);
                }
                break;
            }
            case FLOAT: {
                byteBuffer.asFloatBuffer().put(floats);
                break;
            }
            case BOOLEAN: {
                for (float aFloat : floats) {
                    byteBuffer.put(aFloat == 0.0f ? (byte)0 : 1);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot create ByteBuffer with value type: " + valueType);
            }
        }
        return byteBuffer;
    }

    public static ByteBuffer createByteBuffer(long[] longs, Primitive valueType) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(longs.length * BufferUtils.primitiveSize(valueType));
        switch (valueType) {
            case INT: {
                for (long aLong : longs) {
                    byteBuffer.putInt((int)aLong);
                }
                break;
            }
            case DOUBLE: {
                for (long aLong : longs) {
                    byteBuffer.putDouble(aLong);
                }
                break;
            }
            case LONG: {
                byteBuffer.asLongBuffer().put(longs);
                break;
            }
            case FLOAT: {
                for (long aLong : longs) {
                    byteBuffer.putFloat(aLong);
                }
                break;
            }
            case BOOLEAN: {
                for (long aLong : longs) {
                    byteBuffer.put(aLong == 0L ? (byte)0 : 1);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot create ByteBuffer with value type: " + valueType);
            }
        }
        return byteBuffer;
    }

    public static ByteBuffer createByteBuffer(int[] ints, Primitive valueType) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(ints.length * BufferUtils.primitiveSize(valueType));
        switch (valueType) {
            case INT: {
                byteBuffer.asIntBuffer().put(ints);
                break;
            }
            case DOUBLE: {
                for (int anInt : ints) {
                    byteBuffer.putDouble(anInt);
                }
                break;
            }
            case LONG: {
                for (int anInt : ints) {
                    byteBuffer.putLong(anInt);
                }
                break;
            }
            case FLOAT: {
                for (int anInt : ints) {
                    byteBuffer.putFloat(anInt);
                }
                break;
            }
            case BOOLEAN: {
                int[] nArray = ints;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    float anInt = nArray[i];
                    byteBuffer.put(anInt == 0.0f ? (byte)0 : 1);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot create ByteBuffer with value type: " + valueType);
            }
        }
        return byteBuffer;
    }

    public static ByteBuffer createByteBuffer(double[] doubles, Primitive valueType) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(doubles.length * BufferUtils.primitiveSize(valueType));
        switch (valueType) {
            case INT: {
                for (double aDouble : doubles) {
                    byteBuffer.putInt((int)aDouble);
                }
                break;
            }
            case DOUBLE: {
                byteBuffer.asDoubleBuffer().put(doubles);
                break;
            }
            case LONG: {
                for (double aDouble : doubles) {
                    byteBuffer.putLong((long)aDouble);
                }
                break;
            }
            case FLOAT: {
                for (double aDouble : doubles) {
                    byteBuffer.putFloat((float)aDouble);
                }
                break;
            }
            case BOOLEAN: {
                for (double aDouble : doubles) {
                    byteBuffer.put(aDouble == 0.0 ? (byte)0 : 1);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot create ByteBuffer with value type: " + valueType);
            }
        }
        return byteBuffer;
    }

    public static ByteBuffer createByteBuffer(boolean[] booleans, Primitive valueType) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(booleans.length * BufferUtils.primitiveSize(valueType));
        switch (valueType) {
            case INT: {
                for (boolean aBoolean : booleans) {
                    byteBuffer.putInt(aBoolean ? 1 : 0);
                }
                break;
            }
            case LONG: {
                for (boolean aBoolean : booleans) {
                    byteBuffer.putLong(aBoolean ? 1L : 0L);
                }
                break;
            }
            case FLOAT: {
                for (boolean aBoolean : booleans) {
                    byteBuffer.putFloat(aBoolean ? 1.0f : 0.0f);
                }
                break;
            }
            case DOUBLE: {
                for (boolean aBoolean : booleans) {
                    byteBuffer.putDouble(aBoolean ? 1.0 : 0.0);
                }
                break;
            }
            case BOOLEAN: {
                for (boolean aBoolean : booleans) {
                    byteBuffer.put(aBoolean ? (byte)1 : 0);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot create ByteBuffer for boolean[] coercing to value type " + valueType);
            }
        }
        return byteBuffer;
    }

    private static ByteBuffer combineByteBuffers(List<ByteBuffer> sources) {
        int length;
        ByteBuffer source;
        int i;
        int count = sources.size();
        int size = 8 * count;
        for (int i2 = 0; i2 < count; ++i2) {
            int length2 = sources.get(i2).remaining();
            size += BufferUtils.varintLength(length2);
            size += length2;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(size);
        int offset = 8 * count;
        for (i = 0; i < count; ++i) {
            byteBuffer.putLong(offset);
            source = sources.get(i);
            length = source.remaining();
            offset += BufferUtils.varintLength(length);
            offset += length;
        }
        for (i = 0; i < count; ++i) {
            source = sources.get(i);
            length = source.remaining();
            BufferUtils.encodeVarint(byteBuffer, length);
            ByteBuffer view = source.asReadOnlyBuffer();
            byteBuffer.put(view);
        }
        return byteBuffer;
    }

    public static int varintLength(int value) {
        int len = 1;
        int v = value;
        while (v >= 128) {
            v >>= 7;
            ++len;
        }
        return len;
    }

    public static int encodeVarint(ByteBuffer buffer, int value) {
        int len = 1;
        int v = value;
        while (v >= 128) {
            buffer.put((byte)(v & 0x7F | 0x80));
            v >>= 7;
            ++len;
        }
        buffer.put((byte)v);
        return len;
    }

    public static int decodeVarint(ByteBuffer buffer) {
        int v = 0;
        int shift = 0;
        while (true) {
            byte b = buffer.get();
            v |= (b & 0x7F) << shift;
            if ((b & 0x80) == 0) {
                return v;
            }
            shift += 7;
        }
    }
}

