/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common.tensorbuilder;

import com.linkedin.feathr.common.tensor.TensorData;
import com.linkedin.feathr.common.tensor.TensorIterator;
import com.linkedin.feathr.common.tensor.WriteableTuple;
import com.linkedin.feathr.common.tensorbuilder.TypedOperator;

public interface TensorBuilder<T extends TensorBuilder<T>>
extends TypedOperator,
WriteableTuple<T> {
    default public TensorData build() {
        return this.build(false);
    }

    public TensorData build(boolean var1);

    @Override
    default public T setDouble(int index, double value) {
        throw new UnsupportedOperationException("No implementation by default, please implement. ");
    }

    @Override
    default public T setString(int index, String value) {
        throw new UnsupportedOperationException("No implementation by default, please implement. ");
    }

    @Override
    default public T setBoolean(int index, boolean value) {
        throw new UnsupportedOperationException("No implementation by default, please implement.");
    }

    public T append();

    public T start(int var1);

    default public T start() {
        return this.start(0);
    }

    default public T copyColumn(TensorIterator source, int sourceColumn, int destinationColumn) {
        this.getTypes()[destinationColumn].getRepresentation().copy(source, sourceColumn, this, destinationColumn);
        return (T)this;
    }

    default public T copyColumns(TensorIterator source, int[] sourceColumns) {
        for (int i = 0; i < sourceColumns.length; ++i) {
            this.copyColumn(source, sourceColumns[i], i);
        }
        return (T)this;
    }

    default public T copyColumns(TensorIterator left, TensorIterator right, int[] sourceColumns) {
        return this.copyColumns(left, right, sourceColumns, left.getTensorData().getArity());
    }

    default public T copyColumns(TensorIterator left, TensorIterator right, int[] sourceColumns, int leftArity) {
        for (int i = 0; i < sourceColumns.length; ++i) {
            int idx = sourceColumns[i];
            if (idx < leftArity) {
                this.copyColumn(left, idx, i);
                continue;
            }
            this.copyColumn(right, idx - leftArity, i);
        }
        return (T)this;
    }

    default public T copyLeftColumns(TensorIterator source, int count) {
        for (int i = 0; i < count; ++i) {
            this.copyColumn(source, i, i);
        }
        return (T)this;
    }
}

