/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common.tensorbuilder;

import com.linkedin.feathr.common.ColumnUtils;
import com.linkedin.feathr.common.TensorUtils;
import com.linkedin.feathr.common.tensor.Primitive;
import com.linkedin.feathr.common.tensor.Representable;
import com.linkedin.feathr.common.tensor.TensorData;
import com.linkedin.feathr.common.tensor.TensorIterator;
import com.linkedin.feathr.common.tensorbuilder.SortUtils;
import java.util.Comparator;
import java.util.Objects;

public class UniversalTensor
implements TensorData {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    private static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    private static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    private static final Object[] EMPTY_BYTES_ARRAY = new Object[0];
    private final int[] _columnIndex;
    private final Representable[] _columnTypes;
    private final int[] _intArray;
    private final int _intArity;
    private final long[] _longArray;
    private final int _longArity;
    private final String[] _stringArray;
    private final int _stringArity;
    private final float[] _floatArray;
    private final int _floatArity;
    private final double[] _doubleArray;
    private final int _doubleArity;
    private final boolean[] _booleanArray;
    private final int _booleanArity;
    private final int _size;
    private final Object[] _bytesArray;
    private final int _bytesArity;
    private final Primitive _valueType;
    private final int _valueArity;

    @Deprecated
    public UniversalTensor(int intArity, int longArity, int floatArity, int[] intArray, long[] longArray, float[] floatArray, Representable[] columnTypes, int ... columnIndex) {
        this(intArity, longArity, floatArity, intArray, longArray, floatArray, columnTypes, false, columnIndex);
    }

    @Deprecated
    public UniversalTensor(int intArity, int longArity, int floatArity, int[] intArray, long[] longArray, float[] floatArray, Representable[] columnTypes, int size, boolean sort, int ... columnIndex) {
        this(intArity, longArity, 0, floatArity, 0, intArray, longArray, EMPTY_STRING_ARRAY, floatArray, EMPTY_DOUBLE_ARRAY, columnTypes, size, sort, columnIndex);
    }

    @Deprecated
    public UniversalTensor(int intArity, int longArity, int floatArity, int[] intArray, long[] longArray, float[] floatArray, Representable[] columnTypes, boolean sort, int ... columnIndex) {
        this(intArity, longArity, 0, floatArity, intArray, longArray, EMPTY_STRING_ARRAY, floatArray, columnTypes, sort, columnIndex);
    }

    @Deprecated
    public UniversalTensor(int intArity, int longArity, int stringArity, int floatArity, int[] intArray, long[] longArray, String[] stringArray, float[] floatArray, Representable[] columnTypes, int ... columnIndex) {
        this(intArity, longArity, stringArity, floatArity, intArray, longArray, stringArray, floatArray, columnTypes, false, columnIndex);
    }

    @Deprecated
    public UniversalTensor(int intArity, int longArity, int stringArity, int floatArity, int[] intArray, long[] longArray, String[] stringArray, float[] floatArray, Representable[] columnTypes, boolean sort, int ... columnIndex) {
        this(intArity, longArity, stringArity, floatArity, 0, intArray, longArray, stringArray, floatArray, EMPTY_DOUBLE_ARRAY, columnTypes, sort, columnIndex);
    }

    @Deprecated
    public UniversalTensor(int intArity, int longArity, int stringArity, int floatArity, int doubleArity, int[] intArray, long[] longArray, String[] stringArray, float[] floatArray, double[] doubleArray, Representable[] columnTypes, boolean sort, int ... columnIndex) {
        this(intArity, longArity, stringArity, floatArity, doubleArity, intArray, longArray, stringArray, floatArray, doubleArray, columnTypes, TensorUtils.safeRatio(floatArray.length + doubleArray.length + intArray.length + longArray.length + stringArray.length, floatArity + doubleArity + intArity + longArity + stringArity), sort, columnIndex);
    }

    @Deprecated
    public UniversalTensor(int[] intArray, long[] longArray, float[] floatArray, Representable[] columnTypes) {
        this(intArray, longArray, EMPTY_STRING_ARRAY, floatArray, columnTypes);
    }

    @Deprecated
    public UniversalTensor(int[] intArray, long[] longArray, String[] stringArray, float[] floatArray, Representable[] columnTypes) {
        this(intArray, longArray, stringArray, floatArray, EMPTY_DOUBLE_ARRAY, columnTypes);
    }

    @Deprecated
    public UniversalTensor(int[] intArray, long[] longArray, String[] stringArray, double[] doubleArray, Representable[] columnTypes) {
        this(intArray, longArray, stringArray, EMPTY_FLOAT_ARRAY, doubleArray, columnTypes);
    }

    @Deprecated
    public UniversalTensor(int[] intArray, long[] longArray, String[] stringArray, float[] floatArray, double[] doubleArray, Representable[] columnTypes) {
        this(intArray, longArray, stringArray, floatArray, doubleArray, new ColumnUtils(columnTypes));
    }

    @Deprecated
    public UniversalTensor(int[] intArray, long[] longArray, String[] stringArray, float[] floatArray, double[] doubleArray, ColumnUtils utils) {
        this(utils._intArity, utils._longArity, utils._stringArity, utils._floatArity, utils._doubleArity, intArray, longArray, stringArray, floatArray, doubleArray, utils._columnTypes, true, utils._columnIndex);
    }

    @Deprecated
    public UniversalTensor(int[] intArray, long[] longArray, String[] stringArray, float[] floatArray, double[] doubleArray, Object[] bytesArray, ColumnUtils utils) {
        this(utils._intArity, utils._longArity, utils._stringArity, utils._floatArity, utils._doubleArity, 0, utils._bytesArity, utils._floatArity + utils._doubleArity, intArray, longArray, stringArray, floatArray, doubleArray, EMPTY_BOOLEAN_ARRAY, bytesArray, utils._columnTypes, TensorUtils.safeRatio(floatArray.length + doubleArray.length + intArray.length + longArray.length + stringArray.length + bytesArray.length, utils._intArity + utils._longArity + utils._stringArity + utils._floatArity + utils._doubleArity + utils._bytesArity), true, utils._columnIndex);
    }

    @Deprecated
    public UniversalTensor(int intArity, int longArity, int stringArity, int floatArity, int doubleArity, int[] intArray, long[] longArray, String[] stringArray, float[] floatArray, double[] doubleArray, Representable[] columnTypes, int size, boolean sort, int ... columnIndex) {
        this(intArity, longArity, stringArity, floatArity, doubleArity, 0, 0, floatArity + doubleArity, intArray, longArray, stringArray, floatArray, doubleArray, EMPTY_BOOLEAN_ARRAY, EMPTY_BYTES_ARRAY, columnTypes, size, sort, columnIndex);
    }

    public UniversalTensor(int intArity, int longArity, int stringArity, int floatArity, int doubleArity, int booleanArity, int valueArity, int[] intArray, long[] longArray, String[] stringArray, float[] floatArray, double[] doubleArray, boolean[] booleanArray, Representable[] columnTypes, int size, boolean sort, int ... columnIndex) {
        this(intArity, longArity, stringArity, floatArity, doubleArity, booleanArity, 0, valueArity, intArray, longArray, stringArray, floatArray, doubleArray, booleanArray, EMPTY_BYTES_ARRAY, columnTypes, size, sort, columnIndex);
    }

    public UniversalTensor(int intArity, int longArity, int stringArity, int floatArity, int doubleArity, int booleanArity, int bytesArity, int valueArity, int[] intArray, long[] longArray, String[] stringArray, float[] floatArray, double[] doubleArray, boolean[] booleanArray, Object[] bytesArray, Representable[] columnTypes, int size, boolean sort, int ... columnIndex) {
        Primitive representation;
        int i;
        if (floatArity > 0 && doubleArity > 0) {
            throw new IllegalArgumentException("Cannot have both float values and double values.");
        }
        int arity = intArity + longArity + stringArity + floatArity + doubleArity + booleanArity + bytesArity;
        if (arity != columnIndex.length) {
            throw new IllegalArgumentException("Arities conflict with columnIndex");
        }
        if (columnTypes.length != columnIndex.length) {
            throw new IllegalArgumentException("ColumnTypes conflict with columnIndex");
        }
        if (columnTypes.length == 0) {
            throw new IllegalArgumentException("ColumnTypes length cannot be 0");
        }
        Primitive valueType = columnTypes[columnTypes.length - 1].getRepresentation();
        if (!valueType.canBeValue()) {
            throw new IllegalArgumentException("Cannot support value column of type: " + valueType.getRepresentation());
        }
        this._valueType = valueType;
        for (i = 1; i <= floatArity + doubleArity; ++i) {
            representation = columnTypes[arity - i].getRepresentation();
            if (representation == Primitive.FLOAT || representation == Primitive.DOUBLE) continue;
            throw new IllegalArgumentException("FLOAT/DOUBLE dimensions should be at the right-most columns.");
        }
        for (i = arity - 1; i > arity - valueArity; --i) {
            representation = columnTypes[i].getRepresentation();
            if (representation == this._valueType.getRepresentation()) continue;
            throw new IllegalArgumentException(String.format("Value dimensions should all be the same time.Expected: %s but found: %s", this._valueType.getRepresentation(), representation));
        }
        this._intArity = intArity;
        this._longArity = longArity;
        this._floatArity = floatArity;
        this._stringArity = stringArity;
        this._doubleArity = doubleArity;
        this._booleanArity = booleanArity;
        this._bytesArity = bytesArity;
        this._valueArity = valueArity;
        this._intArray = Objects.requireNonNull(intArray, "intArray cannot be null in UniversalTensor");
        this._longArray = Objects.requireNonNull(longArray, "longArray cannot be null in UniversalTensor");
        this._stringArray = Objects.requireNonNull(stringArray, "stringArray cannot be null in UniversalTensor.");
        this._floatArray = Objects.requireNonNull(floatArray, "floatArray cannot be null in UniversalTensor.");
        this._doubleArray = Objects.requireNonNull(doubleArray, "doubleArray cannot be null in UniversalTensor.");
        this._booleanArray = Objects.requireNonNull(booleanArray, "booleanArray cannot be null in the UniversalTensor.");
        this._bytesArray = Objects.requireNonNull(bytesArray, "bytesArray cannot be null in the UniversalTensor.");
        this._columnTypes = Objects.requireNonNull(columnTypes, "columnTypes cannot be null in UniversalTensor.");
        this._columnIndex = Objects.requireNonNull(columnIndex, "columnIndex cannot be null in UniversalTensor.");
        this._size = size;
        int stringSize = size * stringArity;
        for (int i2 = 0; i2 < stringSize; ++i2) {
            if (this._stringArray[i2] != null) continue;
            throw new IllegalArgumentException("String index is null at position: " + i2);
        }
        if (sort && this.cardinality() > 1) {
            throw new IllegalArgumentException("Tensor sorting is not supported.");
        }
    }

    @Override
    public int getArity() {
        return this._intArity + this._longArity + this._stringArity + this._floatArity + this._doubleArity + this._booleanArity + this._bytesArity;
    }

    @Override
    public Representable[] getTypes() {
        return this._columnTypes;
    }

    @Override
    public int estimatedCardinality() {
        return this.cardinality();
    }

    @Override
    public int cardinality() {
        return this._size;
    }

    @Override
    public boolean isEmpty() {
        return this._size == 0;
    }

    @Override
    public TensorIterator iterator() {
        return new MyIterator();
    }

    public int[] getIntArray() {
        return this._intArray;
    }

    public int getIntArity() {
        return this._intArity;
    }

    public long[] getLongArray() {
        return this._longArray;
    }

    public int getLongArity() {
        return this._longArity;
    }

    public String[] getStringArray() {
        return this._stringArray;
    }

    public int getStringArity() {
        return this._stringArity;
    }

    public float[] getFloatArray() {
        return this._floatArray;
    }

    public int getFloatArity() {
        return this._floatArity;
    }

    public double[] getDoubleArray() {
        return this._doubleArray;
    }

    public int getDoubleArity() {
        return this._doubleArity;
    }

    public boolean[] getBooleanArray() {
        return this._booleanArray;
    }

    public int getBooleanArity() {
        return this._booleanArity;
    }

    public Object[] getBytesArray() {
        return this._bytesArray;
    }

    public int getBytesArity() {
        return this._bytesArity;
    }

    public int getValueArity() {
        return this._valueArity;
    }

    public int[] getColumnIndex() {
        return this._columnIndex;
    }

    private void reorderArrays(Integer[] order) {
        int[] invOrder = new int[this.cardinality()];
        for (int i = 0; i < order.length; ++i) {
            invOrder[order[i].intValue()] = i;
        }
        int[] tmpInts = new int[this._intArity];
        long[] tmpLongs = new long[this._longArity];
        boolean[] tmpBooleans = new boolean[this._booleanArity];
        String[] tmpStrings = new String[this._stringArity];
        float[] floatBuffer = new float[this._floatArity];
        double[] doubleBuffer = new double[this._doubleArity];
        for (int dest = 0; dest < order.length; ++dest) {
            int tmp;
            int src = order[dest];
            if (src == dest) continue;
            switch (this._intArity) {
                case 0: {
                    break;
                }
                case 1: {
                    tmp = this._intArray[dest];
                    this._intArray[dest] = this._intArray[src];
                    this._intArray[src] = tmp;
                    break;
                }
                default: {
                    System.arraycopy(this._intArray, dest * this._intArity, tmpInts, 0, this._intArity);
                    System.arraycopy(this._intArray, src * this._intArity, this._intArray, dest * this._intArity, this._intArity);
                    System.arraycopy(tmpInts, 0, this._intArray, src * this._intArity, this._intArity);
                }
            }
            switch (this._longArity) {
                case 0: {
                    break;
                }
                case 1: {
                    long tmp2 = this._longArray[dest];
                    this._longArray[dest] = this._longArray[src];
                    this._longArray[src] = tmp2;
                    break;
                }
                default: {
                    System.arraycopy(this._longArray, dest * this._longArity, tmpLongs, 0, this._longArity);
                    System.arraycopy(this._longArray, src * this._longArity, this._longArray, dest * this._longArity, this._longArity);
                    System.arraycopy(tmpLongs, 0, this._longArray, src * this._longArity, this._longArity);
                }
            }
            switch (this._stringArity) {
                case 0: {
                    break;
                }
                case 1: {
                    String tmp3 = this._stringArray[dest];
                    this._stringArray[dest] = this._stringArray[src];
                    this._stringArray[src] = tmp3;
                    break;
                }
                default: {
                    System.arraycopy(this._stringArray, dest * this._stringArity, tmpStrings, 0, this._stringArity);
                    System.arraycopy(this._stringArray, src * this._stringArity, this._stringArray, dest * this._stringArity, this._stringArity);
                    System.arraycopy(tmpStrings, 0, this._stringArray, src * this._stringArity, this._stringArity);
                }
            }
            switch (this._booleanArity) {
                case 0: {
                    break;
                }
                case 1: {
                    tmp = this._booleanArray[dest];
                    this._booleanArray[dest] = this._booleanArray[src];
                    this._booleanArray[src] = tmp;
                    break;
                }
                default: {
                    System.arraycopy(this._booleanArray, dest * this._booleanArity, tmpBooleans, 0, this._booleanArity);
                    System.arraycopy(this._booleanArray, src * this._booleanArity, this._booleanArray, dest * this._booleanArity, this._booleanArity);
                    System.arraycopy(tmpBooleans, 0, this._booleanArray, src * this._booleanArity, this._booleanArity);
                }
            }
            if (this._valueType == Primitive.FLOAT) {
                SortUtils.swapFloat(this._floatArity, this._floatArray, src, dest, floatBuffer);
            } else {
                SortUtils.swapDouble(this._doubleArity, this._doubleArray, src, dest, doubleBuffer);
            }
            int whereDestHadToGo = invOrder[dest];
            order[whereDestHadToGo] = src;
            invOrder[src] = whereDestHadToGo;
        }
    }

    class TensorIndexComparator
    implements Comparator<Integer> {
        private final MyIterator _leftIter;
        private final MyIterator _rightIter;
        private final Primitive[] _primitiveTypes;

        TensorIndexComparator() {
            this._leftIter = new MyIterator();
            this._rightIter = new MyIterator();
            this._primitiveTypes = new Primitive[UniversalTensor.this._columnTypes.length];
            for (int c = 0; c < UniversalTensor.this._columnTypes.length; ++c) {
                this._primitiveTypes[c] = UniversalTensor.this._columnTypes[c].getRepresentation();
            }
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            this._leftIter.setIndex(o1);
            this._rightIter.setIndex(o2);
            int maxColLen = this._primitiveTypes.length - UniversalTensor.this._valueArity;
            for (int c = 0; c < maxColLen; ++c) {
                int result = this._primitiveTypes[c].compare(this._leftIter, c, this._rightIter, c);
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
    }

    class MyIterator
    implements TensorIterator {
        private int _rowIndex;
        private int _intPosition;
        private int _longPosition;
        private int _stringPosition;
        private int _floatPosition;
        private int _doublePosition;
        private int _booleanPosition;
        private int _bytesPosition;

        MyIterator(MyIterator other) {
            this._rowIndex = other._rowIndex;
            this._intPosition = other._intPosition;
            this._longPosition = other._longPosition;
            this._stringPosition = other._stringPosition;
            this._floatPosition = other._floatPosition;
            this._doublePosition = other._doublePosition;
            this._booleanPosition = other._booleanPosition;
            this._bytesPosition = other._bytesPosition;
        }

        MyIterator() {
        }

        void setIndex(int index) {
            this._rowIndex = index;
            this._intPosition = index * UniversalTensor.this._intArity;
            this._longPosition = index * UniversalTensor.this._longArity;
            this._stringPosition = index * UniversalTensor.this._stringArity;
            this._floatPosition = index * UniversalTensor.this._floatArity;
            this._doublePosition = index * UniversalTensor.this._doubleArity;
            this._booleanPosition = index * UniversalTensor.this._booleanArity;
            this._bytesPosition = index * this._bytesPosition;
        }

        int getIndex() {
            return this._rowIndex;
        }

        @Override
        public TensorData getTensorData() {
            return UniversalTensor.this;
        }

        @Override
        public void start() {
            this._rowIndex = 0;
            this._intPosition = 0;
            this._longPosition = 0;
            this._stringPosition = 0;
            this._floatPosition = 0;
            this._doublePosition = 0;
            this._booleanPosition = 0;
            this._bytesPosition = 0;
        }

        @Override
        public boolean isValid() {
            return this._rowIndex < UniversalTensor.this._size;
        }

        @Override
        public Object getValue(int index) {
            int i = UniversalTensor.this._columnIndex[index];
            switch (UniversalTensor.this._columnTypes[index].getRepresentation()) {
                case INT: {
                    return UniversalTensor.this._intArray[this._intPosition + i];
                }
                case LONG: {
                    return UniversalTensor.this._longArray[this._longPosition + i];
                }
                case FLOAT: {
                    return Float.valueOf(UniversalTensor.this._floatArray[this._floatPosition + i]);
                }
                case STRING: {
                    return UniversalTensor.this._stringArray[this._stringPosition + i];
                }
                case DOUBLE: {
                    return UniversalTensor.this._doubleArray[this._doublePosition + i];
                }
                case BOOLEAN: {
                    return UniversalTensor.this._booleanArray[this._booleanPosition + i];
                }
                case BYTES: {
                    return UniversalTensor.this._bytesArray[this._bytesPosition + i];
                }
            }
            throw new IllegalArgumentException("Cannot get value for unknown column type" + UniversalTensor.this._columnTypes[index]);
        }

        @Override
        public int getInt(int index) {
            return UniversalTensor.this._intArray[this._intPosition + UniversalTensor.this._columnIndex[index]];
        }

        @Override
        public long getLong(int index) {
            return UniversalTensor.this._longArray[this._longPosition + UniversalTensor.this._columnIndex[index]];
        }

        @Override
        public String getString(int index) {
            return UniversalTensor.this._stringArray[this._stringPosition + UniversalTensor.this._columnIndex[index]];
        }

        @Override
        public float getFloat(int index) {
            return UniversalTensor.this._floatArray[this._floatPosition + UniversalTensor.this._columnIndex[index]];
        }

        @Override
        public double getDouble(int index) {
            return UniversalTensor.this._doubleArray[this._doublePosition + UniversalTensor.this._columnIndex[index]];
        }

        @Override
        public boolean getBoolean(int index) {
            return UniversalTensor.this._booleanArray[this._booleanPosition + UniversalTensor.this._columnIndex[index]];
        }

        @Override
        public byte[] getBytes(int index) {
            return (byte[])UniversalTensor.this._bytesArray[this._bytesPosition + UniversalTensor.this._columnIndex[index]];
        }

        @Override
        public void next() {
            ++this._rowIndex;
            this._intPosition += UniversalTensor.this._intArity;
            this._longPosition += UniversalTensor.this._longArity;
            this._stringPosition += UniversalTensor.this._stringArity;
            this._floatPosition += UniversalTensor.this._floatArity;
            this._doublePosition += UniversalTensor.this._doubleArity;
            this._booleanPosition += UniversalTensor.this._booleanArity;
            this._bytesPosition += UniversalTensor.this._bytesArity;
        }

        @Override
        public TensorIterator getCopy() {
            return new MyIterator(this);
        }
    }
}

