/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common.types;

import com.linkedin.feathr.common.types.FeatureType;
import java.util.Objects;

public class DenseVectorFeatureType
extends FeatureType {
    public static final int UNKNOWN_SIZE = -1;
    private static final DenseVectorFeatureType UNKNOWN_SIZE_INSTANCE = new DenseVectorFeatureType(-1);
    private final int _size;

    private DenseVectorFeatureType(int size) {
        super(FeatureType.BasicType.DENSE_VECTOR);
        this._size = size;
    }

    public static DenseVectorFeatureType withSize(int size) {
        return size == -1 ? UNKNOWN_SIZE_INSTANCE : new DenseVectorFeatureType(size);
    }

    public static DenseVectorFeatureType withUnknownSize() {
        return UNKNOWN_SIZE_INSTANCE;
    }

    public int getSize() {
        return this._size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DenseVectorFeatureType)) {
            return false;
        }
        DenseVectorFeatureType that = (DenseVectorFeatureType)o;
        return this._size == that._size;
    }

    public int hashCode() {
        return Objects.hash(this._size);
    }

    public String toString() {
        return "DenseVectorType{_size=" + this._size + '}';
    }
}

