/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common.value;

import com.linkedin.feathr.common.types.BooleanFeatureType;
import com.linkedin.feathr.common.types.CategoricalFeatureType;
import com.linkedin.feathr.common.types.CategoricalSetFeatureType;
import com.linkedin.feathr.common.types.DenseVectorFeatureType;
import com.linkedin.feathr.common.types.FeatureType;
import com.linkedin.feathr.common.types.NumericFeatureType;
import com.linkedin.feathr.common.types.TensorFeatureType;
import com.linkedin.feathr.common.types.TermVectorFeatureType;
import com.linkedin.feathr.common.value.BooleanFeatureValue;
import com.linkedin.feathr.common.value.CategoricalFeatureValue;
import com.linkedin.feathr.common.value.CategoricalSetFeatureValue;
import com.linkedin.feathr.common.value.DenseVectorFeatureValue;
import com.linkedin.feathr.common.value.FeatureFormatMapper;
import com.linkedin.feathr.common.value.FeatureValue;
import com.linkedin.feathr.common.value.NumericFeatureValue;
import com.linkedin.feathr.common.value.TensorFeatureValue;
import com.linkedin.feathr.common.value.TermVectorFeatureValue;

public abstract class AbstractFeatureFormatMapper<T>
implements FeatureFormatMapper<T> {
    @Override
    public T fromFeatureValue(FeatureValue featureValue) {
        switch (featureValue.getFeatureType().getBasicType()) {
            case BOOLEAN: {
                return this.fromBooleanFeatureValue((BooleanFeatureValue)featureValue);
            }
            case NUMERIC: {
                return this.fromNumericFeatureValue((NumericFeatureValue)featureValue);
            }
            case CATEGORICAL: {
                return this.fromCategoricalFeatureValue((CategoricalFeatureValue)featureValue);
            }
            case CATEGORICAL_SET: {
                return this.fromCategoricalSetFeatureValue((CategoricalSetFeatureValue)featureValue);
            }
            case TERM_VECTOR: {
                return this.fromTermVectorFeatureValue((TermVectorFeatureValue)featureValue);
            }
            case DENSE_VECTOR: {
                return this.fromDenseVectorFeatureValue((DenseVectorFeatureValue)featureValue);
            }
            case TENSOR: {
                return this.fromTensorFeatureValue((TensorFeatureValue)featureValue);
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)featureValue.getFeatureType().getBasicType()));
    }

    protected abstract T fromNumericFeatureValue(NumericFeatureValue var1);

    protected abstract T fromBooleanFeatureValue(BooleanFeatureValue var1);

    protected abstract T fromCategoricalFeatureValue(CategoricalFeatureValue var1);

    protected abstract T fromCategoricalSetFeatureValue(CategoricalSetFeatureValue var1);

    protected abstract T fromTermVectorFeatureValue(TermVectorFeatureValue var1);

    protected abstract T fromDenseVectorFeatureValue(DenseVectorFeatureValue var1);

    protected abstract T fromTensorFeatureValue(TensorFeatureValue var1);

    @Override
    public FeatureValue toFeatureValue(FeatureType featureType, T externalValue) {
        switch (featureType.getBasicType()) {
            case BOOLEAN: {
                return this.toBooleanFeatureValue((BooleanFeatureType)featureType, externalValue);
            }
            case NUMERIC: {
                return this.toNumericFeatureValue((NumericFeatureType)featureType, externalValue);
            }
            case CATEGORICAL: {
                return this.toCategoricalFeatureValue((CategoricalFeatureType)featureType, externalValue);
            }
            case CATEGORICAL_SET: {
                return this.toCategoricalSetFeatureValue((CategoricalSetFeatureType)featureType, externalValue);
            }
            case TERM_VECTOR: {
                return this.toTermVectorFeatureValue((TermVectorFeatureType)featureType, externalValue);
            }
            case DENSE_VECTOR: {
                return this.toDenseVectorFeatureValue((DenseVectorFeatureType)featureType, externalValue);
            }
            case TENSOR: {
                return this.toTensorFeatureValue((TensorFeatureType)featureType, externalValue);
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)featureType.getBasicType()));
    }

    protected abstract NumericFeatureValue toNumericFeatureValue(NumericFeatureType var1, T var2);

    protected abstract BooleanFeatureValue toBooleanFeatureValue(BooleanFeatureType var1, T var2);

    protected abstract CategoricalFeatureValue toCategoricalFeatureValue(CategoricalFeatureType var1, T var2);

    protected abstract CategoricalSetFeatureValue toCategoricalSetFeatureValue(CategoricalSetFeatureType var1, T var2);

    protected abstract TermVectorFeatureValue toTermVectorFeatureValue(TermVectorFeatureType var1, T var2);

    protected abstract DenseVectorFeatureValue toDenseVectorFeatureValue(DenseVectorFeatureType var1, T var2);

    protected abstract TensorFeatureValue toTensorFeatureValue(TensorFeatureType var1, T var2);

    protected RuntimeException cannotConvertToFeatureValue(FeatureType featureType, T externalValue, Exception cause) {
        return new RuntimeException("Can't convert " + externalValue + " to feature value of type " + featureType, cause);
    }

    protected RuntimeException cannotConvertToFeatureValue(FeatureType featureType, T externalValue) {
        return this.cannotConvertToFeatureValue(featureType, externalValue, null);
    }
}

