/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common.value;

import com.linkedin.feathr.common.types.CategoricalSetFeatureType;
import com.linkedin.feathr.common.types.FeatureType;
import com.linkedin.feathr.common.value.FeatureValue;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class CategoricalSetFeatureValue
implements FeatureValue {
    private static final FeatureType TYPE = CategoricalSetFeatureType.INSTANCE;
    private final Set<String> _stringSet;

    private CategoricalSetFeatureValue(Set<String> stringSet) {
        this._stringSet = Objects.requireNonNull(stringSet);
    }

    private CategoricalSetFeatureValue(Collection<String> strings) {
        this((Set<String>)new HashSet<String>(Objects.requireNonNull(strings)));
    }

    public static CategoricalSetFeatureValue fromStrings(Collection<String> strings) {
        return new CategoricalSetFeatureValue(strings);
    }

    public static CategoricalSetFeatureValue fromStringSet(Set<String> stringSet) {
        return new CategoricalSetFeatureValue(stringSet);
    }

    public Set<String> getStringSet() {
        return this._stringSet;
    }

    @Override
    public FeatureType getFeatureType() {
        return TYPE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CategoricalSetFeatureValue that = (CategoricalSetFeatureValue)o;
        return this._stringSet.equals(that._stringSet);
    }

    public int hashCode() {
        return Objects.hash(this._stringSet);
    }

    public String toString() {
        return "CategoricalSetFeatureValue{_stringSet=" + this._stringSet + '}';
    }
}

