/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common.value;

import com.google.common.collect.ImmutableMap;
import com.linkedin.feathr.common.tensor.TensorData;
import com.linkedin.feathr.common.types.BooleanFeatureType;
import com.linkedin.feathr.common.types.CategoricalFeatureType;
import com.linkedin.feathr.common.types.CategoricalSetFeatureType;
import com.linkedin.feathr.common.types.DenseVectorFeatureType;
import com.linkedin.feathr.common.types.NumericFeatureType;
import com.linkedin.feathr.common.types.TermVectorFeatureType;
import com.linkedin.feathr.common.value.BooleanFeatureValue;
import com.linkedin.feathr.common.value.CategoricalFeatureValue;
import com.linkedin.feathr.common.value.CategoricalSetFeatureValue;
import com.linkedin.feathr.common.value.DenseVectorFeatureValue;
import com.linkedin.feathr.common.value.NumericFeatureValue;
import com.linkedin.feathr.common.value.QuinceFeatureFormatMapper;
import com.linkedin.feathr.common.value.TermVectorFeatureValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class FeatureValues {
    private FeatureValues() {
    }

    public static NumericFeatureValue numeric(float floatValue) {
        return NumericFeatureValue.fromFloat(floatValue);
    }

    public static NumericFeatureValue numeric(TensorData tensor) {
        return QuinceFeatureFormatMapper.INSTANCE.toNumericFeatureValue(NumericFeatureType.INSTANCE, tensor);
    }

    public static BooleanFeatureValue bool(boolean booleanValue) {
        return BooleanFeatureValue.fromBoolean(booleanValue);
    }

    public static BooleanFeatureValue bool(TensorData tensor) {
        return QuinceFeatureFormatMapper.INSTANCE.toBooleanFeatureValue(BooleanFeatureType.INSTANCE, tensor);
    }

    public static CategoricalFeatureValue categorical(String stringValue) {
        return CategoricalFeatureValue.fromString(stringValue);
    }

    public static CategoricalFeatureValue categorical(TensorData tensor) {
        return QuinceFeatureFormatMapper.INSTANCE.toCategoricalFeatureValue(CategoricalFeatureType.INSTANCE, tensor);
    }

    public static CategoricalSetFeatureValue categoricalSet(Collection<String> strings) {
        return CategoricalSetFeatureValue.fromStrings(strings);
    }

    public static CategoricalSetFeatureValue categoricalSet(Set<String> strings) {
        return CategoricalSetFeatureValue.fromStringSet(strings);
    }

    public static CategoricalSetFeatureValue categoricalSet(String ... strings) {
        return FeatureValues.categoricalSet(Arrays.asList(strings));
    }

    public static CategoricalSetFeatureValue emptyCategoricalSet() {
        return FeatureValues.categoricalSet(Collections.emptyList());
    }

    public static CategoricalSetFeatureValue categoricalSet(TensorData tensorData) {
        return QuinceFeatureFormatMapper.INSTANCE.toCategoricalSetFeatureValue(CategoricalSetFeatureType.INSTANCE, tensorData);
    }

    public static DenseVectorFeatureValue denseVectorDynamicSize(float ... floatArray) {
        return DenseVectorFeatureValue.fromFloatArray(floatArray);
    }

    public static DenseVectorFeatureValue denseVector(TensorData tensorData) {
        return QuinceFeatureFormatMapper.INSTANCE.toDenseVectorFeatureValue(DenseVectorFeatureType.withUnknownSize(), tensorData);
    }

    public static TermVectorFeatureValue termVector(Map<String, Float> termVector) {
        return TermVectorFeatureValue.fromMap(termVector);
    }

    public static TermVectorFeatureValue termVector(TensorData tensorData) {
        return QuinceFeatureFormatMapper.INSTANCE.toTermVectorFeatureValue(TermVectorFeatureType.INSTANCE, tensorData);
    }

    public static TermVectorFeatureValue termVector(String t0, float v0) {
        return FeatureValues.termVector((Map<String, Float>)ImmutableMap.of((Object)t0, (Object)Float.valueOf(v0)));
    }

    public static TermVectorFeatureValue termVector(String t0, float v0, String t1, float v1) {
        return FeatureValues.termVector((Map<String, Float>)ImmutableMap.of((Object)t0, (Object)Float.valueOf(v0), (Object)t1, (Object)Float.valueOf(v1)));
    }

    public static TermVectorFeatureValue termVector(String t0, float v0, String t1, float v1, String t2, float v2) {
        return FeatureValues.termVector((Map<String, Float>)ImmutableMap.of((Object)t0, (Object)Float.valueOf(v0), (Object)t1, (Object)Float.valueOf(v1), (Object)t2, (Object)Float.valueOf(v2)));
    }

    public static TermVectorFeatureValue emptyTermVector() {
        return FeatureValues.termVector((Map<String, Float>)ImmutableMap.of());
    }
}

